/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class Truss3dResultPanel
extends DekorPanel {
    JEditorPane jEditorPane = new JEditorPane();
    public static int nElem;
    public static int np;
    public static int nGeo;
    public static int nLast;
    public static int MAXM;
    public static int MAXP;
    public static int MAXE;
    public static final int MAXK = 2;
    public static int nGes;
    public static int[][] knoten;
    public static int[] materialNr;
    public static int[] stabNr;
    public static int[] rbn;
    public static int[] rbt;
    public static int[] lastk;
    public static double[] lastx;
    public static double[] lasty;
    public static double[] lastz;
    public static double[] AE;
    public static double[][] Cges;
    public static double[] u;
    public static double[] disp;
    public static double[][] stabKraftTrans;
    public static double[] stabKraft;
    public static double[][] lagerZeile;
    public static double[] lagerLast;
    public static int calcErr;
    static String currFile;
    static Truss3dResultPanel self;

    Truss3dResultPanel() {
        super(new Truss3dGrafikPanel(), 224);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setBorder(BorderFactory.createEtchedBorder(0));
        JScrollPane jScrollPane = new JScrollPane(this.jEditorPane, 20, 30);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.jEditorPane.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:#000; font-family:times; margin: 4px;}");
        styleSheet.addRule("h4 {color: #eeeeee; background-color:#505050; font-size: 11px;}");
        styleSheet.addRule("pre {font-family: \"courier new\", courier, monospace; font-size: 11px;}");
        Document document = hTMLEditorKit.createDefaultDocument();
        this.jEditorPane.setDocument(document);
        jScrollPane.setPreferredSize(new Dimension(266, 120));
        this.remove(this.fieldPane);
        this.add((Component)jScrollPane, "East");
        self = this;
    }

    static void speichern(String string) {
        currFile = string;
        try {
            String string2;
            String string3;
            String string4;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            Truss3dResultPanel.datenVonMaske(false);
            for (n = 0; n < MAXP; ++n) {
                string4 = NumEdit.stripBlanks(Truss3dPunktePanel.tfx[n].getText());
                string3 = NumEdit.stripBlanks(Truss3dPunktePanel.tfy[n].getText());
                string2 = NumEdit.stripBlanks(Truss3dPunktePanel.tfz[n].getText());
                if (string4.length() == 0 && string3.length() == 0 && string2.length() == 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                fileWriter.write("P " + string4 + " " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < MAXE; ++n) {
                string4 = Truss3dKoerperPanel.nodeNumbers[n].getText().replace(',', ' ');
                string3 = Truss3dKoerperPanel.materialNumbers[n].getText();
                string4.trim();
                if (string4.length() == 0) continue;
                fileWriter.write("E " + string4 + " " + string3 + "\n");
            }
            for (n = 0; n < MAXP; ++n) {
                string4 = NumEdit.stripBlanks(Truss3dLoadPanel.tfx[n].getText());
                string3 = NumEdit.stripBlanks(Truss3dLoadPanel.tfy[n].getText());
                string2 = NumEdit.stripBlanks(Truss3dLoadPanel.tfz[n].getText());
                if (string4.length() == 0 && string3.length() == 0 && string2.length() == 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                fileWriter.write("L " + (n + 1) + " " + string4 + " " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < MAXM; ++n) {
                string4 = NumEdit.stripBlanks(Truss3dMaterialPanel.tfA[n].getText());
                string3 = NumEdit.stripBlanks(Truss3dMaterialPanel.tfE[n].getText());
                if (string4.length() == 0 && string3.length() == 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("M " + (n + 1) + " " + string4 + " " + string3 + "\n");
            }
            for (n = 0; n < nGeo; ++n) {
                fileWriter.write("R " + rbn[n] + " " + rbt[n] + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        Truss3dResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("t3d", self);
    }

    public static void speichern() {
        if (currFile != null) {
            Truss3dResultPanel.speichern(currFile);
        } else {
            Truss3dResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = Truss3dPunktePanel.tfx.length;
        while (--n >= 0) {
            Truss3dPunktePanel.tfx[n].setText("");
            Truss3dPunktePanel.tfy[n].setText("");
            Truss3dPunktePanel.tfz[n].setText("");
        }
        n = Truss3dLoadPanel.tfx.length;
        while (--n >= 0) {
            Truss3dLoadPanel.tfx[n].setText("");
            Truss3dLoadPanel.tfy[n].setText("");
            Truss3dLoadPanel.tfz[n].setText("");
        }
        n = Truss3dLagerPanel.cx.length;
        while (--n >= 0) {
            Truss3dLagerPanel.cx[n].setSelected(false);
            Truss3dLagerPanel.cy[n].setSelected(false);
            Truss3dLagerPanel.cz[n].setSelected(false);
        }
        n = MAXE;
        while (--n >= 0) {
            Truss3dKoerperPanel.nodeNumbers[n].setText("");
            Truss3dKoerperPanel.materialNumbers[n].setText("");
        }
        n = MAXM;
        while (--n >= 0) {
            Truss3dMaterialPanel.tfA[n].setText("");
            Truss3dMaterialPanel.tfE[n].setText("");
        }
        np = 0;
        nElem = 0;
        Truss3dPunktePanel.auslesen();
        Truss3dLoadPanel.auslesen();
    }

    static void stringToFields(String object) {
        String[] stringArray = NumEdit.split((String)object);
        if (stringArray != null && stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    Truss3dPunktePanel.tfx[np].setText(stringArray[1]);
                    Truss3dPunktePanel.tfy[np].setText(stringArray[2]);
                    Truss3dPunktePanel.tfz[np].setText(stringArray[3]);
                    ++np;
                    break;
                }
                case 'L': {
                    int n = Integer.parseInt(stringArray[1]);
                    Truss3dLoadPanel.tfx[n - 1].setText(stringArray[2]);
                    Truss3dLoadPanel.tfy[n - 1].setText(stringArray[3]);
                    Truss3dLoadPanel.tfz[n - 1].setText(stringArray[4]);
                    ++np;
                    break;
                }
                case 'R': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    Truss3dLagerPanel.cx[n - 1].setSelected((n2 & 1) != 0);
                    Truss3dLagerPanel.cy[n - 1].setSelected((n2 & 2) != 0);
                    Truss3dLagerPanel.cz[n - 1].setSelected((n2 & 4) != 0);
                    break;
                }
                case 'M': {
                    int n = Integer.parseInt(stringArray[1]);
                    Truss3dMaterialPanel.tfA[n - 1].setText(stringArray[2]);
                    Truss3dMaterialPanel.tfE[n - 1].setText(stringArray[3]);
                    break;
                }
                case 'E': {
                    object = "";
                    int n = stringArray.length;
                    if (n > 3) {
                        n = 3;
                        Truss3dKoerperPanel.materialNumbers[nElem].setText(stringArray[n]);
                    }
                    for (int i = 1; i < n; ++i) {
                        object = (String)object + stringArray[i] + " ";
                    }
                    Truss3dKoerperPanel.nodeNumbers[nElem].setText((String)object);
                    ++nElem;
                }
            }
        }
    }

    public static void beforeFileOperations() {
        Truss3dResultPanel.maskenLoeschen();
        Truss3dResultPanel.self.jEditorPane.setText("");
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        Truss3dResultPanel.datenVonMaske(false);
    }

    public static void eachLineFileOperations(String string) {
        Truss3dResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("t3d", self);
    }

    String bl(int n) {
        return (n < 10 ? " " : "") + n;
    }

    String doubleFormat(double d, int n) {
        Object object = d == 0.0 ? "0." : NumEdit.toPrecision(d, 3);
        int n2 = ((String)object).length() - n;
        while (n2++ < 0) {
            object = " " + (String)object;
        }
        return object;
    }

    public void showSolution() {
        double d;
        int n;
        String string = "<br>";
        String string2 = "<h4>" + myLocale.getString("Stabkraefte") + "</h4><pre>";
        VectorSet.vsclear(u, 1.0E-8);
        VectorSet.vsclear(disp, 1.0E-10);
        for (n = 0; n < nElem; ++n) {
            d = u[n];
            string2 = string2 + myLocale.getString("Stab") + " " + this.bl(stabNr[n]);
            string2 = string2 + "   : " + NumEdit.toPrecision(d, 4) + string;
        }
        string2 = string2 + "</pre><h4>" + myLocale.getString("Lagerkraefte") + "</h4><pre>";
        for (int i = 0; i < nGeo; ++i) {
            if ((rbt[i] & 1) != 0) {
                d = u[n++];
                string2 = string2 + myLocale.getString("Lager1") + " " + this.bl(rbn[i]) + " Fx: " + NumEdit.toPrecision(d, 4) + "\n";
            }
            if ((rbt[i] & 2) != 0) {
                d = u[n++];
                string2 = string2 + myLocale.getString("Lager1") + " " + this.bl(rbn[i]) + " Fy: " + NumEdit.toPrecision(d, 4) + "\n";
            }
            if ((rbt[i] & 4) == 0) continue;
            d = u[n++];
            string2 = string2 + myLocale.getString("Lager1") + " " + this.bl(rbn[i]) + " Fz: " + NumEdit.toPrecision(d, 4) + "\n";
        }
        string2 = string2 + "</pre><h4>" + myLocale.getString("Verschiebungen") + "</h4><pre>";
        n = 0;
        while (3 * n + 2 < nGes) {
            string2 = string2 + this.bl(n + 1) + " ";
            string2 = string2 + this.doubleFormat(disp[3 * n], 8) + " ";
            string2 = string2 + this.doubleFormat(disp[3 * n + 1], 8) + " ";
            string2 = string2 + this.doubleFormat(disp[3 * n + 2], 8) + " ";
            string2 = string2 + string;
            ++n;
        }
        string2 = string2 + "</pre>";
        this.jEditorPane.setText(string2);
        this.jEditorPane.setCaretPosition(0);
    }

    static void knotenInitialisieren() {
        int n = MAXE;
        while (--n >= 0) {
            int n2 = 2;
            while (--n2 >= 0) {
                Truss3dResultPanel.knoten[n][n2] = 0;
            }
        }
    }

    static void zeroArray(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = 0;
        }
    }

    static int koerperTesten() {
        int[] nArray = new int[2];
        for (int i = 0; i < nElem; ++i) {
            if (knoten[i][0] > knoten[i][1]) {
                int n = knoten[i][0];
                Truss3dResultPanel.knoten[i][0] = knoten[i][1];
                Truss3dResultPanel.knoten[i][1] = n;
            }
            for (int j = 0; j < i; ++j) {
                boolean bl = false;
                for (int k = 0; k < 2; ++k) {
                    if (knoten[i][k] == knoten[j][k]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                self.errorMsg(myLocale.getString("DoppeleintraegeBeiKoerpern") + "(" + (j + 1) + "," + (i + 1) + ") " + myLocale.getString("sindNichtErlaubt"));
                return -1;
            }
        }
        return 0;
    }

    static boolean isNode(int n) {
        for (int i = 0; i < MAXE; ++i) {
            if (knoten[i][0] != n && knoten[i][1] != n) continue;
            return true;
        }
        return false;
    }

    static int datenVonMaske(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        Truss3dResultPanel.knotenInitialisieren();
        for (n3 = 0; n3 < MAXP; ++n3) {
            Truss3dResultPanel.lastx[n3] = 0.0;
            Truss3dResultPanel.lasty[n3] = 0.0;
            Truss3dResultPanel.lastz[n3] = 0.0;
        }
        Truss3dResultPanel.zeroArray(rbt);
        Truss3dResultPanel.zeroArray(rbn);
        nGes = 0;
        nElem = 0;
        for (n2 = 0; n2 < MAXE; ++n2) {
            String string = Truss3dKoerperPanel.nodeNumbers[n2].getText().replace(',', ' ');
            int[] nArray = NumEdit.getList(string);
            if (nArray == null || nArray.length == 0) continue;
            int n6 = 0;
            for (n3 = 0; n3 < nArray.length && n3 < 2; ++n3) {
                n = nArray[n3];
                if (Truss3dResultPanel.suche(n, knoten[nElem]) >= 0) continue;
                Truss3dResultPanel.knoten[Truss3dResultPanel.nElem][n6++] = n;
            }
            Truss3dResultPanel.stabNr[Truss3dResultPanel.nElem] = n2 + 1;
            Truss3dResultPanel.materialNr[Truss3dResultPanel.nElem] = Truss3dKoerperPanel.materialNumbers[n2].getInt();
            ++nElem;
        }
        Truss3dPunktePanel.auslesen();
        n = 0;
        for (np = 0; np < MAXP; ++np) {
            if (Truss3dResultPanel.isNode(np + 1)) {
                ++n4;
                if (n <= 0) continue;
                n4 += n;
                n = 0;
                continue;
            }
            if (!Truss3dPunktePanel.isNode[np]) continue;
            ++n;
        }
        if (nElem <= 0) {
            self.errorMsg(myLocale.getString("EsIstNochKeinFachwerkDefiniert"));
            if (bl) {
                return -1;
            }
        }
        if (bl && Truss3dResultPanel.koerperTesten() < 0) {
            return -2;
        }
        nGeo = 0;
        for (n2 = 0; n2 < np; ++n2) {
            boolean bl2 = Truss3dLagerPanel.cx[n2].isSelected();
            boolean bl3 = Truss3dLagerPanel.cy[n2].isSelected();
            boolean bl4 = Truss3dLagerPanel.cz[n2].isSelected();
            if (!bl2 && !bl3 && !bl4 || Truss3dResultPanel.getElem(n2 + 1) == -1) continue;
            Truss3dResultPanel.rbn[Truss3dResultPanel.nGeo] = n2 + 1;
            if (bl2) {
                Truss3dResultPanel.rbt[Truss3dResultPanel.nGeo] = 1;
                ++n5;
            }
            if (bl3) {
                int n7 = nGeo;
                rbt[n7] = rbt[n7] | 2;
                ++n5;
            }
            if (bl4) {
                int n8 = nGeo;
                rbt[n8] = rbt[n8] | 4;
                ++n5;
            }
            ++nGeo;
        }
        Truss3dLoadPanel.auslesen();
        n3 = 3 * n4 - nElem - n5;
        nGes = 3 * n4;
        Truss3dMaterialPanel.auslesen();
        return 0;
    }

    static int suche(int n, int[] nArray, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (nArray[n3] != n) continue;
            return n3;
        }
        return -1;
    }

    static int suche(int n, int[] nArray) {
        return Truss3dResultPanel.suche(n, nArray, nArray.length);
    }

    static int getElem(int n) {
        int n2 = -1;
        block0: for (int i = 0; i < nElem; ++i) {
            for (int j = 0; j < 2; ++j) {
                if (knoten[i][j] != n) continue;
                if (n2 >= 0) {
                    return -2;
                }
                n2 = i;
                continue block0;
            }
        }
        return n2;
    }

    static void stab3dElem(WPoint3d wPoint3d, WPoint3d wPoint3d2, double d, double[][] dArray, double[] dArray2) {
        WPoint3d wPoint3d3 = WPoint3d.minus(wPoint3d2, wPoint3d);
        double d2 = wPoint3d3.betrag();
        wPoint3d3.normiere();
        double[] dArray3 = new double[]{wPoint3d3.x, wPoint3d3.y, wPoint3d3.z};
        d /= d2;
        for (int i = 0; i < 3; ++i) {
            double d3 = dArray3[i] * d;
            dArray2[i] = -d3;
            dArray2[i + 3] = d3;
            for (int j = 0; j < 3; ++j) {
                dArray[i][j] = d3 * dArray3[j];
                dArray[i + 3][j + 3] = dArray[i][j];
                dArray[i][j + 3] = -dArray[i][j];
                dArray[j + 3][i] = -dArray[i][j];
            }
        }
    }

    static void gesamtMatrix() {
        double d = 0.0;
        WPoint3d[] wPoint3dArray = Truss3dPunktePanel.pp;
        Cges = new double[nGes][nGes];
        double[][] dArray = new double[6][6];
        stabKraftTrans = new double[nElem][6];
        for (int i = 0; i < nElem; ++i) {
            int n = knoten[i][0] - 1;
            int n2 = knoten[i][1] - 1;
            int n3 = materialNr[i] - 1;
            if (n3 < 0) {
                n3 = 0;
            }
            if ((d = AE[n3]) == 0.0) {
                d = 1.0;
            }
            Truss3dResultPanel.stab3dElem(wPoint3dArray[n], wPoint3dArray[n2], d, dArray, stabKraftTrans[i]);
            n *= 3;
            n2 *= 3;
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray2 = Cges[n + j];
                    int n4 = n + k;
                    dArray2[n4] = dArray2[n4] + dArray[j][k];
                    double[] dArray3 = Cges[n + j];
                    int n5 = n2 + k;
                    dArray3[n5] = dArray3[n5] + dArray[j][k + 3];
                    double[] dArray4 = Cges[n2 + j];
                    int n6 = n + k;
                    dArray4[n6] = dArray4[n6] + dArray[j + 3][k];
                    double[] dArray5 = Cges[n2 + j];
                    int n7 = n2 + k;
                    dArray5[n7] = dArray5[n7] + dArray[j + 3][k + 3];
                }
            }
        }
    }

    static int randbedingungen() {
        int n;
        for (n = 0; n < nGes; ++n) {
            Truss3dResultPanel.u[n] = 0.0;
        }
        for (n = 0; n < nLast; ++n) {
            int n2 = lastk[n];
            int n3 = 3 * (n2 - 1);
            Truss3dResultPanel.u[n3] = lastx[n];
            Truss3dResultPanel.u[n3 + 1] = lasty[n];
            Truss3dResultPanel.u[n3 + 2] = lastz[n];
        }
        int n4 = 0;
        lagerZeile = new double[nGeo * 3][];
        lagerLast = new double[nGeo * 3];
        double d = 0.0;
        for (n = 0; n < nGes; ++n) {
            if (!(Math.abs(Cges[n][n]) > d)) continue;
            d = Math.abs(Cges[n][n]);
        }
        for (n = 0; n < nGeo; ++n) {
            int n5 = rbn[n] - 1;
            if (n5 < 0) continue;
            int n6 = n5 * 3;
            for (int i = rbt[n]; i != 0; i >>= 1) {
                if ((i & 1) != 0) {
                    Truss3dResultPanel.lagerLast[n4] = u[n6];
                    Truss3dResultPanel.lagerZeile[n4++] = Cges[n6];
                    Truss3dResultPanel.Cges[n6] = new double[nGes];
                    for (int j = 0; j < nGes; ++j) {
                        Truss3dResultPanel.Cges[j][n6] = 0.0;
                    }
                    Truss3dResultPanel.Cges[n6][n6] = d;
                    Truss3dResultPanel.u[n6] = 0.0;
                }
                ++n6;
            }
        }
        return 0;
    }

    int rechne() {
        int n;
        int n2;
        this.statusMsg("");
        u = new double[3 * MAXP];
        if (Truss3dResultPanel.datenVonMaske(true) < 0) {
            this.jEditorPane.setText("");
            disp = null;
            return -1;
        }
        Truss3dResultPanel.gesamtMatrix();
        int n3 = Truss3dResultPanel.randbedingungen();
        if (n3 == 0) {
            n3 = Truss3dResultPanel.loesen();
        }
        if (n3 != 0) {
            this.jEditorPane.setText("");
            return n3;
        }
        stabKraft = new double[nElem + 3 * nGeo];
        for (n2 = 0; n2 < nElem; ++n2) {
            int n4;
            double[] dArray = stabKraftTrans[n2];
            n = (knoten[n2][0] - 1) * 3;
            int n5 = (knoten[n2][1] - 1) * 3;
            Truss3dResultPanel.stabKraft[n2] = 0.0;
            for (n4 = 0; n4 < 3; ++n4) {
                int n6 = n2;
                stabKraft[n6] = stabKraft[n6] + dArray[n4] * u[n + n4];
            }
            for (n4 = 0; n4 < 3; ++n4) {
                int n7 = n2;
                stabKraft[n7] = stabKraft[n7] + dArray[n4 + 3] * u[n5 + n4];
            }
        }
        for (int i = 0; i < lagerZeile.length && lagerZeile[i] != null; ++i) {
            for (n = 0; n < nGes; ++n) {
                int n8 = n2;
                stabKraft[n8] = stabKraft[n8] + lagerZeile[i][n] * u[n];
            }
            int n9 = n2++;
            stabKraft[n9] = stabKraft[n9] - lagerLast[i];
        }
        disp = u;
        u = stabKraft;
        return n3;
    }

    static int loesen() {
        calcErr = Gauss.fullPivoting(Cges, u, nGes);
        if (calcErr < 0) {
            self.errorMsg(myLocale.getString("DieMatrixDesGleichungssystemsIstSingulaerRangabfall") + " " + Gauss.rangDef + myLocale.getString("KeinGleichgewichtMoeglichFuerDieGegebeneBelastung"));
            return -1;
        }
        if (calcErr > 0) {
            self.statusMsg(myLocale.getString("DasModellHatNoch") + " " + Gauss.rangDef + " " + myLocale.getString("BewegungsfreiheitsgradeGleichgewichtIstJedochFuerDieGegebeneBelastungGegeben"));
            calcErr = 0;
        }
        return 0;
    }

    static {
        MAXM = 10;
        MAXP = 80;
        MAXE = 3 * MAXP - 6;
        knoten = new int[MAXE][2];
        materialNr = new int[MAXE];
        stabNr = new int[MAXE];
        rbn = new int[MAXP];
        rbt = new int[MAXP];
        lastk = new int[MAXP];
        lastx = new double[MAXP];
        lasty = new double[MAXP];
        lastz = new double[MAXP];
        AE = new double[MAXM];
        u = new double[3 * MAXP];
        disp = null;
        calcErr = 0;
        currFile = null;
    }
}

