/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;

class TribokSimulation
extends GrPanel
implements Runnable {
    MyRuKu rk = null;
    static double[] yarr = null;
    Thread simuThread = null;
    boolean isRunning = false;
    static double g = 9.81;
    static double la = 8.0;
    static double lb = 2.0;
    static double l1 = 7.0;
    static double l2 = 3.0;
    static double rg = 0.7;
    static double l3;
    static double ls;
    static double phi1;
    static double phi2;
    static double phi3;
    static double m1;
    static double m2;
    static double m3;
    static double hook;
    static double xm;
    static double ym;
    static double vx;
    static double vy;
    static double xpos;
    static double ypos;
    static double potE;
    static double NN;
    static double t;
    static double dt;
    static double epsd;
    static boolean released;
    static boolean rrr;
    static boolean firstperiod;
    static ArrayList<Double> xlist;
    static ArrayList<Double> ylist;
    static ArrayList<Double> polyG1;
    static ArrayList<Double> polyG2;
    static ArrayList<Double> polyG;
    static ArrayList<Double> polyT;

    double sqr(double d) {
        return d * d;
    }

    TribokSimulation() {
        this.addMouseMotionListener(this);
    }

    public void init() {
        if (TribokSimulation.initData()) {
            this.simuThread = new Thread(this);
            this.simuThread.start();
        } else {
            ((TribokPanel)this.getParent()).statusMsg("Parameterkombination nicht zul\u00e4ssig");
        }
    }

    static boolean initData() {
        t = 0.0;
        dt = 0.01;
        l1 = TribokPanel.datField[0].getDouble();
        m1 = TribokPanel.datField[1].getDouble();
        l2 = TribokPanel.datField[2].getDouble();
        m2 = TribokPanel.datField[3].getDouble();
        la = TribokPanel.datField[4].getDouble();
        lb = TribokPanel.datField[5].getDouble();
        m3 = TribokPanel.datField[6].getDouble();
        hook = TribokPanel.datField[7].getDouble() * Math.PI / 180.0;
        ls = (la - lb) / 2.0;
        double d = la + lb;
        double d2 = m3 * (d * d / 12.0 + ls * ls);
        l3 = Math.sqrt(d2 / m3);
        xm = 0.0;
        ym = l2 + lb + rg;
        if (la <= ym || m1 < 0.0 || m2 <= 0.0 || m3 <= 0.0 || la < lb || la > 20.0 || l1 < 0.5 || l2 < 0.5 || m1 >= m2 || l1 > lb + la || m1 > lb / la * m2 || hook > 0.7 || hook < -0.7) {
            return false;
        }
        phi1 = -1.5707963267948966;
        phi2 = 0.0;
        phi3 = -Math.PI + Math.acos(ym / la);
        vx = 0.0;
        xlist = new ArrayList();
        ylist = new ArrayList();
        polyT = new ArrayList();
        polyG = new ArrayList();
        polyG1 = new ArrayList();
        polyG2 = new ArrayList();
        yarr = new double[7];
        TribokSimulation.yarr[0] = t;
        TribokSimulation.yarr[1] = 0.0;
        TribokSimulation.yarr[2] = phi1;
        TribokSimulation.yarr[3] = 0.0;
        TribokSimulation.yarr[4] = phi2;
        TribokSimulation.yarr[5] = 0.0;
        TribokSimulation.yarr[6] = phi3;
        rrr = false;
        released = false;
        firstperiod = true;
        if (m1 == 0.0) {
            firstperiod = false;
        }
        potE = -ls * (1.0 + Math.cos(phi3 + Math.PI)) * m3 * g + lb * (1.0 + Math.cos(phi3 + Math.PI)) * m2 * g;
        NN = 0.0;
        NN = (potE - TribokSimulation.Etribok(yarr)) / (m2 + m3) / g;
        return true;
    }

    static double Etribok(double[] dArray) {
        double d = 0.0;
        double d2 = dArray[2];
        double d3 = dArray[4];
        double d4 = dArray[6];
        double d5 = NN - lb * Math.cos(d4) - l2 * Math.cos(d3);
        double d6 = dArray[5] * lb * Math.cos(d4) + dArray[3] * l2 * Math.cos(d3);
        double d7 = dArray[5] * lb * Math.sin(d4) + dArray[3] * l2 * Math.sin(d3);
        d += 0.5 * m2 * (d6 * d6 + d7 * d7) + m2 * g * d5;
        return d += 0.5 * m3 * dArray[5] * dArray[5] * l3 * l3 + m3 * g * (NN + ls * Math.cos(d4));
    }

    double Egeschoss(double[] dArray, boolean bl) {
        double d;
        if (released) {
            d = 0.5 * m1 * (vx * vx + vy * vy);
            if (bl) {
                d += m1 * g * ypos;
            }
        } else {
            double d2 = dArray[2];
            double d3 = dArray[4];
            double d4 = dArray[6];
            double d5 = ym + la * Math.cos(d4) - l1 * Math.cos(d2);
            double d6 = -dArray[5] * la * Math.cos(d4) + dArray[1] * l1 * Math.cos(d2);
            double d7 = -dArray[5] * la * Math.sin(d4) + dArray[1] * l1 * Math.sin(d2);
            d = 0.5 * m1 * (d6 * d6 + d7 * d7);
            if (bl) {
                d += m1 * g * d5;
            }
        }
        return d;
    }

    void timer() {
        double d;
        if (this.rk == null) {
            this.rk = new MyRuKu();
            this.rk.init(7);
        }
        polyT.add(t);
        double d2 = TribokSimulation.Etribok(yarr) * 0.001;
        double d3 = this.Egeschoss(yarr, true) * 0.001;
        polyG1.add(d2);
        polyG2.add(d3);
        polyG.add(d2 + d3);
        this.rk.timeAutoStep(yarr, dt);
        if (firstperiod) {
            d = ym - la * Math.cos(yarr[6] - Math.PI);
            if (d < l1 - epsd) {
                TribokSimulation.yarr[2] = -Math.acos(d / l1);
                TribokSimulation.yarr[1] = yarr[5] * la / l1 * Math.sin(yarr[6]) / Math.sin(yarr[2]);
            } else {
                firstperiod = false;
            }
            double d4 = -yarr[5] * la * Math.cos(yarr[6]) + yarr[1] * l1 * Math.sin(yarr[2]);
            double d5 = (vx - d4) / dt;
            vx = d4;
            if (d5 >= g * Math.tan(-phi1)) {
                firstperiod = false;
            }
            if ((ypos = ym + la * Math.cos(yarr[6]) - l1 * Math.cos(yarr[2])) < -epsd / 10.0) {
                ((TribokPanel)this.getParent()).statusMsg("m1 ist zu gross");
                this.isRunning = false;
            }
        }
        t = yarr[0];
        phi1 = yarr[2];
        phi2 = yarr[4];
        phi3 = yarr[6];
        if (!released && (phi3 + Math.PI + hook < phi1 || phi1 < phi3 || rrr)) {
            vx = yarr[1] * l1 * Math.cos(phi1) - yarr[5] * la * Math.cos(phi3);
            vy = yarr[1] * l1 * Math.sin(phi1) - yarr[5] * la * Math.sin(phi3);
            xpos = xm - la * Math.sin(phi3) + l1 * Math.sin(phi1);
            ypos = ym + la * Math.cos(phi3) - l1 * Math.cos(phi1);
            released = true;
        }
        if (released && m1 != 0.0) {
            if (ypos + vy * dt > 0.0) {
                xpos += vx * dt;
                ypos += (vy - g * 0.5 * dt) * dt;
                vy -= g * dt;
            } else {
                d = 0.5 * m1 * (vx * vx + vy * vy);
                xpos += vx * (-ypos / vy);
                ypos = 0.0;
                vy = 0.0;
                vx = 0.0;
                String string = rrr ? " *" : "";
                ((TribokPanel)this.getParent()).statusMsg("Wurfweite = " + NumEdit.toFixed(Math.abs(xpos), 1) + " m    Aufschlag-Energie = " + NumEdit.toFixed(d / 1000.0, 1) + " kJ   potentielle Start-Energie =" + NumEdit.toFixed(potE / 1000.0, 1) + " kJ   Wirkungsgrad = " + NumEdit.toFixed(d / potE, 2) + string);
                this.isRunning = false;
                PlaySound.play("Tribok.wav");
            }
        }
    }

    @Override
    public void run() {
        int n;
        this.isRunning = true;
        this.repaint();
        try {
            n = 500;
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        TribokPanel.b1.setText("Stop");
        while (this.isRunning) {
            try {
                long l = System.currentTimeMillis();
                this.timer();
                this.repaint();
                long l2 = System.currentTimeMillis();
                n = (int)(dt * 1000.0 - (double)(l2 - l));
                if (n <= 0) continue;
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
        TribokPanel.b1.setText("Start");
    }

    public void stop() {
        this.isRunning = false;
    }

    @Override
    public void paint(Graphics graphics) {
        Double[] doubleArray = xlist.toArray(new Double[0]);
        Double[] doubleArray2 = ylist.toArray(new Double[0]);
        double d = rg;
        double d2 = d * Math.pow(m1 / m2, 0.33);
        this.myg = graphics;
        this.setMinMax(-115.0, 0.0, 5.0, 50.0);
        this.myg.setColor(TribokSimulation.newColor(111, 125, 137));
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        double d3 = xm - la * Math.sin(phi3);
        double d4 = ym + la * Math.cos(phi3);
        double d5 = xm + lb * Math.sin(phi3);
        double d6 = ym - lb * Math.cos(phi3);
        double d7 = d3 + l1 * Math.sin(phi1);
        double d8 = d4 - l1 * Math.cos(phi1);
        double d9 = d5 + l2 * Math.sin(phi2);
        double d10 = d6 - l2 * Math.cos(phi2);
        if (this.isRunning && m1 != 0.0) {
            if (!released) {
                xlist.add(d7);
                ylist.add(d8);
            } else {
                xlist.add(xpos);
                ylist.add(ypos);
            }
        }
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.myg.setColor(Color.black);
        this.wMoveTo(xm - 300.0, 0.0);
        this.wLineTo(xm + 30.0, 0.0);
        this.wMoveTo(xm, ym);
        this.wLineTo2(xm, 0.0);
        this.wMoveTo(xm - ym / 2.0, 0.0);
        this.wLineTo2(xm + ym / 2.0, 0.0);
        this.wLineTo2(xm, ym);
        this.wLineTo2(xm - ym / 2.0, 0.0);
        this.myg.setColor(Color.yellow);
        int n = doubleArray.length;
        if (n > 0) {
            this.wMoveTo(doubleArray[0], doubleArray2[0]);
        }
        for (int i = 1; i < n; ++i) {
            this.wLineTo(doubleArray[i], doubleArray2[i]);
        }
        this.myg.setColor(Color.white);
        this.wMoveTo(d5, d6);
        this.wLineTo(d9, d10);
        if (!released && m1 != 0.0) {
            this.wMoveTo(d3, d4);
            this.wLineTo(d7, d8);
        }
        this.myg.setColor(Color.red);
        this.wMoveTo(d3, d4);
        this.wLineTo2(d5, d6);
        if (!released) {
            this.fillCircle(d7, d8, d2);
        } else {
            this.fillCircle(xpos, ypos, d2);
        }
        this.fillCircle(d9, d10, d);
        this.myg.setColor(Color.white);
        this.drawCircle(xm, ym, 1);
    }

    static {
        m1 = 70.0;
        m2 = 2000.0;
        m3 = 200.0;
        hook = -0.20943951023931953;
        epsd = 0.005 * l1;
        released = false;
        rrr = false;
        xlist = null;
        ylist = null;
        polyG1 = null;
        polyG2 = null;
        polyG = null;
        polyT = null;
    }

    class MyRuKu
    extends RungeKutta {
        MyRuKu() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        void funk(double[] var1_1, double[] var2_2) {
            var27_3 = false;
            var3_4 = TribokSimulation.released != false ? 0.0 : TribokSimulation.m1;
            if (!TribokSimulation.firstperiod) ** GOTO lbl-1000
            var5_5 = TribokSimulation.ym - TribokSimulation.la * Math.cos(var2_2[6] + 3.141592653589793);
            if (v0 < TribokSimulation.l1 - TribokSimulation.epsd) {
                var27_3 = true;
                TribokSimulation.phi1 = -Math.acos(var5_5 / TribokSimulation.l1);
                var28_6 = Math.sin(var2_2[6]);
                var30_8 = Math.cos(var2_2[6]);
                var32_10 = Math.cos(TribokSimulation.phi1);
                var34_11 = Math.sin(TribokSimulation.phi1);
                var36_12 = var28_6 / var34_11 * TribokSimulation.la / TribokSimulation.l1;
                var38_13 = var2_2[5];
                var40_14 = var36_12 * var2_2[5];
                var42_15 = TribokSimulation.la / TribokSimulation.l1 * (var30_8 * var34_11 - var32_10 * var28_6 * var36_12) * TribokSimulation.this.sqr(var38_13 / var34_11);
                var7_16 = var3_4 * TribokSimulation.l1 * TribokSimulation.l1;
                var9_17 = -var3_4 * TribokSimulation.la * TribokSimulation.l1 * Math.cos(var2_2[6] - TribokSimulation.phi1);
                var13_18 = TribokSimulation.m2 * TribokSimulation.lb * TribokSimulation.l2 * Math.cos(var2_2[6] - var2_2[4]);
                var11_19 = TribokSimulation.m2 * TribokSimulation.l2 * TribokSimulation.l2;
                var19_20 = TribokSimulation.m3 * TribokSimulation.l3 * TribokSimulation.l3 + TribokSimulation.m2 * TribokSimulation.lb * TribokSimulation.lb + var3_4 * TribokSimulation.la * TribokSimulation.la;
                var15_21 = var9_17;
                var17_22 = var13_18;
                var21_23 = -var3_4 * TribokSimulation.l1 * (TribokSimulation.g * Math.sin(TribokSimulation.phi1) + TribokSimulation.la * Math.sin(var2_2[6] - TribokSimulation.phi1) * var2_2[5] * var2_2[5]);
                var23_24 = -TribokSimulation.m2 * TribokSimulation.l2 * (TribokSimulation.g * Math.sin(var2_2[4]) + TribokSimulation.lb * Math.sin(var2_2[4] - var2_2[6]) * var2_2[5] * var2_2[5]);
                var25_25 = TribokSimulation.g * (TribokSimulation.m3 * TribokSimulation.ls + var3_4 * TribokSimulation.la - TribokSimulation.m2 * TribokSimulation.lb) * Math.sin(var2_2[6]) - TribokSimulation.m2 * TribokSimulation.l2 * TribokSimulation.lb * Math.sin(var2_2[6] - var2_2[4]) * var2_2[3] * var2_2[3] - var3_4 * TribokSimulation.l1 * TribokSimulation.la * Math.sin(TribokSimulation.phi1 - var2_2[6]) * var40_14 * var40_14;
                var19_20 += var36_12 * (var36_12 * var7_16 + 2.0 * var9_17);
                var25_25 += var36_12 * var21_23 - (var36_12 * var7_16 + var9_17) * var42_15;
                var7_16 = 0.0;
                var9_17 = 0.0;
                var15_21 = 0.0;
                var21_23 = 0.0;
            } else lbl-1000:
            // 2 sources

            {
                var7_16 = var3_4 * TribokSimulation.l1 * TribokSimulation.l1;
                var9_17 = -var3_4 * TribokSimulation.la * TribokSimulation.l1 * Math.cos(var2_2[6] - var2_2[2]);
                var13_18 = TribokSimulation.m2 * TribokSimulation.lb * TribokSimulation.l2 * Math.cos(var2_2[6] - var2_2[4]);
                var11_19 = TribokSimulation.m2 * TribokSimulation.l2 * TribokSimulation.l2;
                var19_20 = TribokSimulation.m3 * TribokSimulation.l3 * TribokSimulation.l3 + TribokSimulation.m2 * TribokSimulation.lb * TribokSimulation.lb + var3_4 * TribokSimulation.la * TribokSimulation.la;
                var15_21 = var9_17;
                var17_22 = var13_18;
                var21_23 = -var3_4 * TribokSimulation.l1 * (TribokSimulation.g * Math.sin(var2_2[2]) + TribokSimulation.la * Math.sin(var2_2[6] - var2_2[2]) * var2_2[5] * var2_2[5]);
                var23_24 = -TribokSimulation.m2 * TribokSimulation.l2 * (TribokSimulation.g * Math.sin(var2_2[4]) + TribokSimulation.lb * Math.sin(var2_2[4] - var2_2[6]) * var2_2[5] * var2_2[5]);
                var25_25 = TribokSimulation.g * (TribokSimulation.m3 * TribokSimulation.ls + var3_4 * TribokSimulation.la - TribokSimulation.m2 * TribokSimulation.lb) * Math.sin(var2_2[6]) - TribokSimulation.m2 * TribokSimulation.l2 * TribokSimulation.lb * Math.sin(var2_2[6] - var2_2[4]) * var2_2[3] * var2_2[3] - var3_4 * TribokSimulation.l1 * TribokSimulation.la * Math.sin(var2_2[2] - var2_2[6]) * var2_2[1] * var2_2[1];
                if (!TribokSimulation.released) {
                    var28_7 = TribokSimulation.l1 * Math.sin(var2_2[2] - var2_2[6]) * var2_2[1] * var2_2[1] - TribokSimulation.la * TribokSimulation.g * Math.sin(var2_2[6]);
                    var30_9 = var2_2[6] + 3.141592653589793 - var2_2[2];
                    if (Math.abs(var30_9) > 0.13962634015954636 && var30_9 * var28_7 < 0.0) {
                        TribokSimulation.rrr = true;
                    }
                }
            }
            if (var7_16 != 0.0) {
                var19_20 -= var15_21 * (var9_17 /= var7_16);
                var25_25 -= var15_21 * (var21_23 /= var7_16);
            }
            var25_25 -= var17_22 * (var23_24 /= var11_19);
            var1_1[0] = 1.0;
            var1_1[1] = var21_23 -= var9_17 * var25_25;
            var1_1[2] = var2_2[1];
            var1_1[3] = var23_24 -= var13_18 * (var25_25 /= (var19_20 -= var17_22 * (var13_18 /= var11_19)));
            var1_1[4] = var2_2[3];
            var1_1[5] = var25_25;
            var1_1[6] = var2_2[5];
            if (TribokSimulation.firstperiod && var27_3) {
                var1_1[2] = 0.0;
            }
            if (TribokSimulation.released) {
                var1_1[1] = 0.0;
                var1_1[2] = 0.0;
            }
        }
    }
}

