/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class TrajectorySimuPanel
extends GrPanel
implements Runnable {
    Thread simuThread = null;
    boolean isRunning = false;
    TrajectoryPanel main = null;
    double currT;
    double xmin;
    double ymin;
    double xmax;
    double ymax;
    double afak;
    double vfak;
    Ftree xt;
    Ftree yt;
    Ftree xprev = null;
    Ftree yprev = null;
    double tStart = 0.0;
    double tend;
    double tfak = 1.0;
    double[] xarr = null;
    double[] yarr = null;

    TrajectorySimuPanel() {
        this.addMouseMotionListener(this);
    }

    public void init() {
        this.fit();
    }

    void start() {
        this.simuThread = new Thread(this);
        this.simuThread.start();
    }

    void getVMinMax() {
        double d;
        if (this.xt == this.xprev && this.yt == this.yprev) {
            this.setMinMax(this.xmin, this.ymin, this.xmax, this.ymax);
            return;
        }
        this.xprev = this.xt;
        this.yprev = this.yt;
        double d2 = 0.02;
        double[] dArray = new double[2];
        this.xmin = this.xmax = this.xt.evaluate(this.tend);
        this.ymin = this.ymax = this.yt.evaluate(this.tend);
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        int n2 = (int)((this.tend - this.tStart) / d2 + 0.5);
        d2 = (this.tend - this.tStart) / (double)n2;
        this.xarr = new double[++n2];
        this.yarr = new double[n2];
        double d5 = this.tStart;
        n = 0;
        while (n < n2) {
            double d6 = this.xt.evaluate(d5);
            if (d6 > this.xmax) {
                this.xmax = d6;
            } else if (d6 < this.xmin) {
                this.xmin = d6;
            }
            double d7 = this.yt.evaluate(d5);
            if (d7 > this.ymax) {
                this.ymax = d7;
            } else if (d7 < this.ymin) {
                this.ymin = d7;
            }
            this.aVektor(d5, dArray);
            d = dArray[0] * dArray[0] + dArray[1] * dArray[1];
            if (d > d3) {
                d3 = d;
            }
            this.vVektor(d5, dArray);
            double d8 = dArray[0] * dArray[0] + dArray[1] * dArray[1];
            if (d8 > d4) {
                d4 = d8;
            }
            this.xarr[n] = d6;
            this.yarr[n] = d7;
            ++n;
            d5 += d2;
        }
        d4 = Math.sqrt(d4);
        d3 = Math.sqrt(d3);
        this.setMinMax(this.xmin, this.ymin, this.xmax, this.ymax);
        d = this.getwmaxx() - this.getwminx();
        this.afak = d3 > 1.0E-4 ? d / 7.0 / d3 : 0.0;
        this.vfak = d4 > 1.0E-4 ? d / 7.0 / d4 : 0.0;
    }

    @Override
    public void run() {
        double d = 0.05;
        this.currT = this.main.getTstart();
        this.isRunning = true;
        this.main.b1.setText("Stop");
        while (this.isRunning) {
            try {
                if (this.currT < this.main.getTend()) {
                    this.currT += d * this.tfak;
                    Thread.sleep((long)(d * 1000.0));
                } else {
                    this.currT = this.main.getTend();
                    this.isRunning = false;
                }
                this.repaint();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.main.b1.setText("Start");
    }

    public void stop() {
        this.isRunning = false;
    }

    void aVektor(double d, double[] dArray) {
        double d2 = 1.0E-4;
        double d3 = d - d2;
        double d4 = d + d2;
        dArray[0] = (this.xt.evaluate(d4) + this.xt.evaluate(d3) - 2.0 * this.xt.evaluate(d)) / (d2 * d2);
        dArray[1] = (this.yt.evaluate(d4) + this.yt.evaluate(d3) - 2.0 * this.yt.evaluate(d)) / (d2 * d2);
    }

    void vVektor(double d, double[] dArray) {
        double d2 = 1.0E-4;
        double d3 = d - 0.5 * d2;
        double d4 = d + 0.5 * d2;
        dArray[0] = (this.xt.evaluate(d4) - this.xt.evaluate(d3)) / d2;
        dArray[1] = (this.yt.evaluate(d4) - this.yt.evaluate(d3)) / d2;
    }

    double betrag(double[] dArray) {
        return Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1]);
    }

    void avVektor(double d, double d2) {
        double[] dArray = new double[2];
        this.myg.setColor(Color.red);
        this.vVektor(this.currT, dArray);
        this.arrow(d, d2, dArray[0] * this.vfak, dArray[1] * this.vfak);
        this.main.vfield.setText(NumEdit.toPrecision(this.betrag(dArray), 3));
        this.aVektor(this.currT, dArray);
        this.myg.setColor(Color.blue);
        this.arrow(d, d2, dArray[0] * this.afak, dArray[1] * this.afak);
        this.main.afield.setText(NumEdit.toPrecision(this.betrag(dArray), 3));
        this.main.ctfield.setText(NumEdit.toPrecision(this.currT, 3));
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        this.myg = graphics;
        this.myg.setColor(TrajectorySimuPanel.newColor(111, 125, 137));
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.xt = this.main.getxt();
        this.yt = this.main.getyt();
        this.tend = this.main.getTend();
        this.tStart = this.main.getTstart();
        if (this.xt == null) {
            this.setMinMax(-1.0, -1.0, 1.0, 1.0);
        } else {
            this.getVMinMax();
        }
        this.myg.setColor(TrajectorySimuPanel.newColor(145, 145, 145));
        this.grid();
        this.myg.setColor(TrajectorySimuPanel.newColor(195, 195, 195));
        this.axes();
        if (this.xt == null) {
            return;
        }
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.myg.setColor(Color.yellow);
        this.wMoveTo(this.xarr[0], this.yarr[0]);
        for (n = 0; n < this.xarr.length; ++n) {
            this.wLineTo(this.xarr[n], this.yarr[n]);
        }
        if (this.isRunning) {
            n = 2;
            double d = this.xt.evaluate(this.currT);
            double d2 = this.yt.evaluate(this.currT);
            this.myg.setColor(Color.red);
            this.myg.fillArc(this.screenx(d) - n, this.screeny(d2) - n, 2 * n, 2 * n, 0, 360);
            this.avVektor(d, d2);
        }
    }

    void setRoot(TrajectoryPanel trajectoryPanel) {
        this.main = trajectoryPanel;
    }
}

