/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class TrajectoryPanel
extends DekorPanel
implements ActionListener,
ItemListener,
ChangeListener {
    TrajectorySimuPanel simuPanel;
    JButton b1 = null;
    JSlider slider = new JSlider(0, 1, 10, 5);
    static NumEdit xfield;
    static NumEdit yfield;
    NumEdit t1field;
    NumEdit t2field;
    JTextField ctfield = new JTextField(5);
    JTextField afield = new JTextField(5);
    JTextField vfield = new JTextField(5);
    JLabel[] labels = new JLabel[]{new JLabel("t"), new JLabel("|a(t)|"), new JLabel("|v(t)|")};
    Ftree fx = null;
    Ftree fy = null;
    double tStart = 0.0;
    double tend = 6.28;
    JComboBox<String> choiceExamples = new JComboBox();
    String[][] examples = new String[][]{{"Kreisbahn beschleunigt", "cos(t*t)", "sin(t*t)", "0", "3"}, {"Ellipsenbahn bei konstanter Winkelgeschwindigkeit", "cos(t)", "sin(t+1)", "0", "2*PI"}, {"Spirale bei konstanter Winkelgeschwindigkeit", "0.3*t*cos(5*t)", "0.3*t*sin(5*t)", "0", "4"}, {"Zykloide (Aussenpunkt eines abrollenden Rades)", "R*t+(R=3)*sin(t)", "R+R*cos(t)", "0", "4*PI"}, {"Aussenpunkt eines auf einer Kreisbahn abrollenden Rades", "(0.9+R=0.1)*sin(t)+R*sin(t/R)", "(0.9+R)*cos(t)+R*cos(t/R)", "0", "2*PI"}, {"gerade Bahn parallel zur x-Achse, konstant verz\u00f6gerte Bewegung", "12*t-3*t*t", "1", "0", "4"}, {"S-Kurve", "t", "tanh(t-3)", "0", "6"}, {"Wurfparabel", "15*t", "15*t - 5*t*t", "0", "3"}};

    TrajectoryPanel() {
        super(new TrajectorySimuPanel(), 170);
        this.simuPanel = (TrajectorySimuPanel)this.grafikPanel;
        xfield = new NumEdit(14, false);
        yfield = new NumEdit(14, false);
        this.t1field = new NumEdit(14, false);
        this.t2field = new NumEdit(14, false);
        xfield.addActionListener(this);
        yfield.addActionListener(this);
        this.t1field.addActionListener(this);
        this.t2field.addActionListener(this);
        this.t1field.setText("" + this.tStart);
        this.t2field.setText("" + this.tend);
        this.slider.addChangeListener(this);
        this.slider.setPreferredSize(new Dimension(80, 30));
        this.b1 = new JButton("Start");
        this.b1.addActionListener(this);
        this.fpAdd(this.b1, 0, 0, 2, 1);
        ++this.gbc.gridy;
        JLabel jLabel = new JLabel("x(t)");
        this.fpAdd(jLabel, 0, 1, 2, 1);
        this.fpAdd(xfield, 0, 2, 2, 1);
        jLabel = new JLabel("y(t)");
        this.fpAdd(jLabel, 0, 3, 2, 1);
        this.fpAdd(yfield, 0, 4, 2, 1);
        jLabel = new JLabel("t0");
        this.fpAdd(jLabel, 0, 5, 2, 1);
        this.fpAdd(this.t1field, 0, 6, 2, 1);
        jLabel = new JLabel("tmax");
        this.fpAdd(jLabel, 0, 7, 2, 1);
        this.fpAdd(this.t2field, 0, 8, 2, 1);
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 9, 2, 1);
        jLabel = new JLabel("Beispiele");
        this.fpAdd(jLabel, 0, 10, 2, 1);
        this.fpAdd(this.choiceExamples, 0, 11, 2, 1);
        this.choiceExamples.addItemListener(this);
        this.choiceExamples.addItem("");
        for (int i = 1; i <= this.examples.length; ++i) {
            this.choiceExamples.addItem("Beispiel " + i);
        }
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 12, 2, 1);
        jLabel = new JLabel("langsamer - schneller");
        this.fpAdd(jLabel, 0, 13, 2, 1);
        this.fpAdd(this.slider, 0, 14, 2, 1);
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 15, 2, 1);
        this.fpAdd(this.labels[0], 0, 16, 1, 1);
        this.fpAdd(this.ctfield, 1, 16, 1, 1);
        this.fpAdd(this.labels[1], 0, 17, 1, 1);
        this.fpAdd(this.afield, 1, 17, 1, 1);
        this.fpAdd(this.labels[2], 0, 18, 1, 1);
        this.fpAdd(this.vfield, 1, 18, 1, 1);
        this.vfield.setEditable(false);
        this.afield.setEditable(false);
        this.ctfield.setEditable(false);
        this.simuPanel.setRoot(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent != null && actionEvent.getSource() == this.b1) {
            if (this.simuPanel.isRunning) {
                this.simuPanel.stop();
                return;
            }
            if (xfield.getText().length() == 0 || yfield.getText().length() == 0) {
                this.errorMsg("x(t) bzw. y(t) sind nicht definiert!");
                return;
            }
            this.simuPanel.start();
        }
        if (actionEvent != null && actionEvent.getSource() != this.b1) {
            this.statusMsg("");
            this.choiceExamples.setSelectedIndex(0);
        }
        if (xfield.getText().length() == 0 || yfield.getText().length() == 0) {
            this.fy = null;
            this.fx = null;
            return;
        }
        Ftree.delAllVars();
        String string = this.t1field.getText();
        Ftree.resetStatus();
        if (string.length() > 0) {
            double d;
            this.tStart = d = Ftree.evaluate(string);
            Ftree.setVar("t0", this.tStart);
        }
        Ftree.setVar("t", this.tStart);
        String string2 = this.t2field.getText();
        Ftree.resetStatus();
        if (string2.length() > 0) {
            double d;
            this.tend = d = Ftree.evaluate(string2);
            Ftree.setVar("tmax", this.tend);
        }
        this.fx = new Ftree(xfield.getText());
        this.fy = new Ftree(yfield.getText());
        Ftree.setStdVar("t");
        Ftree.setStdVar("t");
        if (Ftree.getStatus() != 0) {
            this.errorMsg("fehlerhafte Formel");
            return;
        }
        String string3 = Ftree.notInitializedVars();
        if (string3.length() > 0) {
            this.errorMsg(string3 + " - nicht definierte Variable(n)!");
            return;
        }
        this.simuPanel.init();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.choiceExamples.getSelectedIndex();
        Object var4_3 = null;
        if (this.simuPanel.isRunning) {
            this.simuPanel.stop();
        }
        if (1 <= n && n <= this.examples.length) {
            this.statusMsg(this.examples[--n][0]);
            xfield.setText(this.examples[n][1]);
            yfield.setText(this.examples[n][2]);
            this.t1field.setText(this.examples[n][3]);
            this.t2field.setText(this.examples[n][4]);
        }
        this.actionPerformed(null);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int n = this.slider.getMinimum();
        int n2 = this.slider.getMaximum();
        double d = (double)(n + n2) * 0.5;
        double d2 = 0.95 / (d - (double)n);
        this.simuPanel.tfak = ((double)this.slider.getValue() - d) * d2 + 1.0;
    }

    Ftree getxt() {
        return this.fx;
    }

    Ftree getyt() {
        return this.fy;
    }

    double getTend() {
        return this.tend;
    }

    double getTstart() {
        return this.tStart;
    }
}

