/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class SummenPanel
extends DekorPanel
implements ActionListener {
    String[] headings = new String[]{"", " Fx ", " Fy "};
    JLabel[] lbs = new JLabel[this.headings.length];
    static String[] vnames = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "R"};
    static NumEdit[] tfx = new NumEdit[vnames.length];
    static NumEdit[] tfy = new NumEdit[vnames.length];
    static double[] x = new double[vnames.length];
    static double[] y = new double[vnames.length];
    ButtonGroup cbg = new ButtonGroup();
    JRadioButton c1 = new JRadioButton("kartesische Koordinaten", true);
    JRadioButton c2 = new JRadioButton("Polarkoordinaten", false);
    static int state = 1;

    SummenPanel() {
        super(new SummenGrafikPanel(), 250);
        int n;
        this.cbg.add(this.c1);
        this.cbg.add(this.c2);
        this.c1.addItemListener(this);
        this.c2.addItemListener(this);
        this.gbc.anchor = 18;
        this.fpAdd(this.c1, 1, 0, 2, 1);
        this.fpAdd(this.c2, 1, 1, 2, 1);
        JLabel jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 1, 1, 1);
        this.gbc.anchor = 10;
        for (n = 0; n < this.headings.length; ++n) {
            this.lbs[n] = new JLabel(this.headings[n]);
            this.fpAdd(this.lbs[n], n, 2, 1, 1);
        }
        for (n = 0; n < tfx.length; ++n) {
            jLabel = new JLabel(vnames[n]);
            SummenPanel.tfx[n] = new NumEdit(7);
            SummenPanel.tfy[n] = new NumEdit(7);
            this.fpAdd(jLabel, 0, 3 + n, 1, 1);
            this.fpAdd(tfx[n], 1, 3 + n, 1, 1);
            this.fpAdd(tfy[n], 2, 3 + n, 1, 1);
            if (n < tfx.length - 1) {
                tfx[n].addActionListener(this);
                tfy[n].addActionListener(this);
                continue;
            }
            tfx[n].setEditable(false);
            tfy[n].setEditable(false);
            jLabel.setForeground(Color.red);
        }
    }

    double noSmallNumber(double d) {
        return -1.0E-10 < d && d < 1.0E-10 ? 0.0 : d;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = vnames.length - 1;
        if (state != 2 && itemEvent.getSource() == this.c2) {
            state = 2;
            this.lbs[1].setText("|F|");
            this.lbs[2].setText("\u03c6 in \u00b0");
            for (int i = 0; i < n; ++i) {
                double d = ZKSPanel.betrag(x[i], y[i]);
                if (!(d > 0.0)) continue;
                tfx[i].setValueP(d, 7);
                tfy[i].setValueP(GrPanel.winkel(x[i], y[i]) * 180.0 / Math.PI, 7);
            }
        } else if (state != 1 && itemEvent.getSource() == this.c1) {
            this.lbs[1].setText("Fx");
            this.lbs[2].setText("Fy");
            state = 1;
            for (int i = 0; i < n; ++i) {
                if (x[i] == 0.0 && y[i] == 0.0) continue;
                tfx[i].setValueP(this.noSmallNumber(x[i]), 6);
                tfy[i].setValueP(this.noSmallNumber(y[i]), 6);
            }
        }
        this.actionPerformed(null);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = vnames.length - 1;
        double d = 0.0;
        double d2 = 0.0;
        this.errorMsg("");
        if (state == 1) {
            for (int i = 0; i < n; ++i) {
                try {
                    SummenPanel.x[i] = tfx[i].getDouble();
                    SummenPanel.y[i] = tfy[i].getDouble();
                }
                catch (Exception exception) {
                    this.errorMsg("" + exception);
                }
                d += x[i];
                d2 += y[i];
            }
            tfx[n].setValue(d);
            tfy[n].setValue(d2);
        } else {
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = Math.PI / 180;
            for (int i = 0; i < n; ++i) {
                try {
                    d3 = tfx[i].getDouble();
                    d4 = d5 * tfy[i].getDouble();
                }
                catch (Exception exception) {
                    this.errorMsg("" + exception);
                }
                SummenPanel.x[i] = d3 * Math.cos(d4);
                SummenPanel.y[i] = d3 * Math.sin(d4);
                d += x[i];
                d2 += y[i];
            }
            tfx[n].setValue(ZKSPanel.betrag(d, d2));
            tfy[n].setValue(GrPanel.winkel(d, d2) / d5);
        }
        this.grafikPanel.repaint();
    }
}

