/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class SpringMassResultPanel
extends DekorPanel
implements ComponentListener {
    public static int nElem;
    public static int nMasse;
    public static int np;
    public static final int MAXP = 16;
    public static final int MAXE = 30;
    static String currFile;
    static boolean mitVorlast;
    static SpringMassResultPanel self;
    NumEdit nrtf;
    NumEdit ewtf;
    JButton upJButton;
    JButton downJButton;
    JPanel buttpan = new JPanel();
    SpringMassGrafikPanel currGrPan = (SpringMassGrafikPanel)this.grafikPanel;
    JTextArea txarea;
    static double[] masse;
    static double[] steif;
    static double sMax;
    static int[][] federIndizes;
    static int[] randbdg;
    static double[][] massMatrix;
    static double[][] steifMatrix;
    static boolean[] aktiv;
    static int formAnz;
    static double[][] ev;
    static double[] ew;
    static double[] dx;
    static double[] dy;
    static double ekfr;
    static double[][] uNachF;

    SpringMassResultPanel() {
        super(new SpringMassGrafikPanel(), 211);
        self = this;
        JLabel jLabel = SpringMass.labelStore.newLabel("EigenformNr");
        this.fpAdd(jLabel, 0, 0, 1, 1);
        this.nrtf = new NumEdit(3);
        this.nrtf.setNumOnly();
        this.nrtf.addActionListener(this);
        this.fpAdd(this.nrtf, 0, 1, 1, 1);
        this.downJButton = new JButton("<");
        this.downJButton.setMargin(new Insets(0, 5, 0, 5));
        this.downJButton.addActionListener(this);
        this.buttpan.add(this.downJButton);
        this.upJButton = new JButton(">");
        this.upJButton.setMargin(new Insets(0, 5, 0, 5));
        this.upJButton.addActionListener(this);
        this.buttpan.add(this.upJButton);
        ++this.gbc.gridy;
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.fpAdd(this.buttpan, 0, 2, 1, 1);
        jLabel = SpringMass.labelStore.newLabel("Eigenfrequenz");
        this.fpAdd(jLabel, 0, 3, 1, 1);
        this.ewtf = new NumEdit(5, true);
        this.ewtf.setEditable(false);
        this.ewtf.setFont(new Font("Dialog", 1, 13));
        this.fpAdd(this.ewtf, 0, 4, 1, 1);
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 5, 1, 1);
        jLabel = SpringMass.labelStore.newLabel("Eigenvektor");
        this.fpAdd(jLabel, 0, 6, 1, 1);
        this.txarea = new JTextArea("", 15, 22);
        this.txarea.setFont(new Font("MonoSpaced", 0, 13));
        this.txarea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txarea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.txarea, 20, 31);
        this.fpAdd(jScrollPane, 0, 7, 1, 1);
        this.addComponentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.downJButton) {
            int n = this.nrtf.getInt();
            if (n > 0) {
                this.nrtf.setText("" + --n);
                SpringMassGrafikPanel.initData();
            }
        } else if (actionEvent.getSource() == this.upJButton) {
            int n = this.nrtf.getInt();
            this.nrtf.setText("" + ++n);
            SpringMassGrafikPanel.initData();
        }
        int n = 0;
        SpringMassGrafikPanel cfr_ignored_0 = (SpringMassGrafikPanel)this.grafikPanel;
        if (!SpringMassGrafikPanel.isRunning && (n = this.gesamtMatrizen()) == 0) {
            ((SpringMassGrafikPanel)this.grafikPanel).init();
        }
        if (n == 0) {
            this.showEigenform();
        }
    }

    static void speichern(String string) {
        currFile = string;
        try {
            String string2;
            String string3;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            for (n = 0; n < 16; ++n) {
                string3 = NumEdit.stripBlanks(SpringMassPunktePanel.tfx[n].getText());
                string2 = NumEdit.stripBlanks(SpringMassPunktePanel.tfy[n].getText());
                if (string3.length() <= 0 && string2.length() <= 0) continue;
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                fileWriter.write("P " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 30; ++n) {
                string3 = SpringMassFederPanel.nodeNumbers[n].getTrimText().replace(',', ' ');
                string2 = SpringMassFederPanel.stiffness[n].getTrimText();
                if (string3.length() <= 0 || string2.length() <= 0) continue;
                String string4 = "E " + string3 + " " + string2 + "\n";
                fileWriter.write(string4);
            }
            for (n = 0; n < 16; ++n) {
                string3 = NumEdit.stripBlanks(SpringMassMassePanel.nodeNumbers[n].getText());
                string2 = NumEdit.stripBlanks(SpringMassMassePanel.masse[n].getText());
                if (string3.length() <= 0 || string2.length() <= 0) continue;
                fileWriter.write("M " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 16; ++n) {
                boolean bl = SpringMassLagerPanel.cx[n].isSelected();
                boolean bl2 = SpringMassLagerPanel.cy[n].isSelected();
                if (!bl && !bl2) continue;
                int n2 = (bl ? 1 : 0) | (bl2 ? 2 : 0);
                fileWriter.write("R " + (n + 1) + " " + n2);
                fileWriter.write(10);
            }
            fileWriter.write("G " + (SpringMassFederPanel.cb.isSelected() ? 1 : 0) + "\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        SpringMassResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("smf", self);
    }

    static void speichern() {
        if (currFile != null) {
            SpringMassResultPanel.speichern(currFile);
        } else {
            SpringMassResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n;
        for (n = 0; n < SpringMassPunktePanel.tfx.length; ++n) {
            SpringMassPunktePanel.tfx[n].setText("");
            SpringMassPunktePanel.tfy[n].setText("");
        }
        for (n = 0; n < 30; ++n) {
            SpringMassFederPanel.nodeNumbers[n].setText("");
            SpringMassFederPanel.stiffness[n].setText("");
        }
        SpringMassFederPanel.cb.setSelected(false);
        for (n = 0; n < 16; ++n) {
            SpringMassMassePanel.nodeNumbers[n].setText("");
            SpringMassMassePanel.masse[n].setText("");
        }
        for (n = 0; n < SpringMassLagerPanel.cx.length; ++n) {
            SpringMassLagerPanel.cx[n].setSelected(false);
            SpringMassLagerPanel.cy[n].setSelected(false);
        }
        np = 0;
        nElem = 0;
        nMasse = 0;
        SpringMassPunktePanel.auslesen();
        SpringMassFederPanel.auslesen();
        SpringMassMassePanel.auslesen();
    }

    static void stringToFields(String object) {
        String[] stringArray = NumEdit.split((String)object);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    SpringMassPunktePanel.tfx[np].setText(stringArray[1]);
                    SpringMassPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'E': {
                    object = stringArray[1] + " " + stringArray[2];
                    SpringMassFederPanel.nodeNumbers[nElem].setText((String)object);
                    SpringMassFederPanel.stiffness[nElem].setText(stringArray[3]);
                    ++nElem;
                    break;
                }
                case 'M': {
                    SpringMassMassePanel.nodeNumbers[nMasse].setText(stringArray[1]);
                    SpringMassMassePanel.masse[nMasse].setText(stringArray[2]);
                    ++nMasse;
                    break;
                }
                case 'R': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    SpringMassLagerPanel.cx[n - 1].setSelected((n2 & 1) != 0);
                    SpringMassLagerPanel.cy[n - 1].setSelected((n2 & 2) != 0);
                    ++np;
                    break;
                }
                case 'G': {
                    int n = Integer.parseInt(stringArray[1]);
                    SpringMassFederPanel.cb.setSelected(n != 0);
                }
            }
        }
    }

    public static void beforeFileOperations() {
        SpringMassResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        SpringMassPunktePanel.auslesen();
        SpringMassFederPanel.auslesen();
        SpringMassMassePanel.auslesen();
        np = SpringMassPunktePanel.np;
    }

    public static void eachLineFileOperations(String string) {
        SpringMassResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("smf", self);
    }

    static int getSmax() {
        int n;
        double d = 1000000.0;
        double d2 = 1000000.0;
        int n2 = 0;
        for (n = 0; n < 30; ++n) {
            if (!(steif[n] > 0.0) || !(steif[n] < d)) continue;
            d = steif[n];
        }
        sMax = d * d2;
        for (n = 0; n < 30; ++n) {
            if (!(steif[n] >= sMax)) continue;
            SpringMassResultPanel.steif[n] = sMax;
            ++n2;
        }
        return n2;
    }

    static void federElemMatrix(WPoint wPoint, WPoint wPoint2, double d, double[][] dArray, double d2, double[] dArray2) {
        WPoint wPoint3 = new WPoint(wPoint2.x - wPoint.x, wPoint2.y - wPoint.y);
        double d3 = Math.sqrt(wPoint3.x * wPoint3.x + wPoint3.y * wPoint3.y);
        double d4 = 0.0;
        wPoint3.normiere();
        double[] dArray3 = new double[]{wPoint3.x, wPoint3.y};
        double[] dArray4 = new double[]{wPoint3.y, -wPoint3.x};
        for (int i = 0; i < 2; ++i) {
            double d5 = dArray3[i] * d;
            if (d3 != 0.0) {
                d4 = dArray4[i] * d2 / d3;
            }
            for (int j = 0; j < 2; ++j) {
                dArray[i][j] = d5 * dArray3[j] + d4 * dArray4[j];
                dArray[i + 2][j + 2] = dArray[i][j];
                dArray[i][j + 2] = -dArray[i][j];
                dArray[j + 2][i] = -dArray[i][j];
            }
        }
        if (dArray2 != null) {
            dArray2[0] = -wPoint3.x * d;
            dArray2[1] = -wPoint3.y * d;
            dArray2[2] = wPoint3.x * d;
            dArray2[3] = wPoint3.y * d;
        }
    }

    double federKraft(int n, double[] dArray) {
        double[] dArray2 = uNachF[n];
        int n2 = federIndizes[n][0] * 2;
        int n3 = federIndizes[n][1] * 2;
        return dArray2[0] * dArray[n2] + dArray2[1] * dArray[n2 + 1] + dArray2[2] * dArray[n3] + dArray2[3] * dArray[n3 + 1];
    }

    static void maskenAuslesen() {
        SpringMassPunktePanel.auslesen();
        np = SpringMassPunktePanel.np;
        SpringMassMassePanel.auslesen();
        SpringMassFederPanel.auslesen();
        for (int i = 0; i < np; ++i) {
            boolean bl = SpringMassLagerPanel.cx[i].isSelected();
            boolean bl2 = SpringMassLagerPanel.cy[i].isSelected();
            SpringMassResultPanel.randbdg[i] = bl ? 1 : 0;
            int n = i;
            randbdg[n] = randbdg[n] | (bl2 ? 2 : 0);
        }
    }

    int vorlastEinfluss(double[][] dArray, double[][] dArray2, double[] dArray3, int n, int n2) {
        int n3;
        int n4;
        double[][] dArray4 = new double[n2][n2];
        double d = 9.81;
        for (n4 = 0; n4 < n2; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                dArray4[n4][n3] = dArray[n4][n3];
            }
        }
        for (n4 = 1; n4 < n; n4 += 2) {
            dArray3[n4 - 1] = 0.0;
            dArray3[n4] = -dArray2[n4][n4] * d;
        }
        if (n2 != n) {
            Kondensation.vectorTransform(dArray3, n2, n);
        }
        if (Gauss.fullPivoting(dArray4, dArray3, n2) < 0) {
            return -1;
        }
        n3 = 0;
        for (n4 = 0; n4 < n2; ++n4) {
            if (dArray3[n4] == 0.0) continue;
            ++n3;
        }
        if (n3 == 0) {
            return -2;
        }
        if (n2 != n) {
            Kondensation.vectorBackTransform(dArray3, n2, n);
        }
        return 0;
    }

    int matrizenAufbau(boolean bl, double[] dArray, int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 2 * np;
        double[][] dArray2 = new double[4][4];
        WPoint[] wPointArray = SpringMassPunktePanel.pp;
        massMatrix = new double[n5][n5];
        steifMatrix = new double[n5][n5];
        int n6 = 0;
        for (n4 = 0; n4 < np; ++n4) {
            n3 = 2 * n4;
            double d = masse[n4];
            SpringMassResultPanel.massMatrix[n3 + 1][n3 + 1] = d;
            SpringMassResultPanel.massMatrix[n3][n3] = d;
        }
        for (n4 = 0; n4 < nElem; ++n4) {
            int n7 = federIndizes[n4][0];
            n3 = federIndizes[n4][1];
            if (n7 >= np || n3 >= np) {
                this.errorMsg(myLocale.getString("unzulaessigeFederEndnummer") + " " + (n7 > n3 ? n7 + 1 : n3 + 1));
                return -2;
            }
            n2 = n7 * 2;
            int n8 = n3 * 2;
            WPoint wPoint = wPointArray[n7];
            WPoint wPoint2 = wPointArray[n3];
            double d = bl ? this.federKraft(n4, dArray) : 0.0;
            SpringMassResultPanel.federElemMatrix(wPoint, wPoint2, steif[n4], dArray2, d, bl ? null : uNachF[n4]);
            for (int i = 0; i < 2; ++i) {
                for (n = 0; n < 2; ++n) {
                    double[] dArray3 = steifMatrix[n2 + i];
                    int n9 = n2 + n;
                    dArray3[n9] = dArray3[n9] + dArray2[i][n];
                    double[] dArray4 = steifMatrix[n8 + i];
                    int n10 = n8 + n;
                    dArray4[n10] = dArray4[n10] + dArray2[i][n];
                    double[] dArray5 = steifMatrix[n2 + i];
                    int n11 = n8 + n;
                    dArray5[n11] = dArray5[n11] + dArray2[i][n + 2];
                    double[] dArray6 = steifMatrix[n8 + i];
                    int n12 = n2 + n;
                    dArray6[n12] = dArray6[n12] + dArray2[i + 2][n];
                }
            }
        }
        for (n4 = 0; n4 < aktiv.length; ++n4) {
            SpringMassResultPanel.aktiv[n4] = true;
        }
        for (n4 = 0; n4 < np; ++n4) {
            n3 = 2 * n4;
            for (n2 = 1; n2 <= 2; n2 <<= 1) {
                if (massMatrix[n3][n3] == 0.0 || (randbdg[n4] & n2) != 0) {
                    nArray[n6++] = n3;
                }
                if ((randbdg[n4] & n2) != 0) {
                    for (n = 0; n < n5; ++n) {
                        SpringMassResultPanel.steifMatrix[n3][n] = 0.0;
                        SpringMassResultPanel.steifMatrix[n][n3] = 0.0;
                    }
                    SpringMassResultPanel.steifMatrix[n3][n3] = 1.0;
                    SpringMassResultPanel.aktiv[n3] = false;
                }
                ++n3;
            }
        }
        if (n6 == n5) {
            this.clearFields();
            this.errorMsg(myLocale.getString("keineBeweglicheMasseImSystem"));
            return -3;
        }
        return n6;
    }

    int gesamtMatrizen() {
        int n;
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        double[][] dArray = new double[4][4];
        try {
            SpringMassResultPanel.maskenAuslesen();
        }
        catch (Exception exception) {
            this.errorMsg("" + exception);
            return -4;
        }
        SpringMassResultPanel.getSmax();
        if (np == 0) {
            return -1;
        }
        int n4 = 2 * np;
        int[] nArray = new int[n4];
        n3 = this.matrizenAufbau(false, null, nArray);
        if (n3 < 0) {
            return -2;
        }
        n2 = n4 - n3;
        if (n3 != 0 && Kondensation.execute(steifMatrix, massMatrix, nArray, n3) != 0) {
            this.clearFields();
            this.errorMsg(myLocale.getString("ungefesselteFedernImSystem"));
            return -4;
        }
        ev = new double[n2][n2];
        ew = new double[n2];
        if (mitVorlast) {
            object2 = new double[n4];
            object = steifMatrix;
            double[][] dArray2 = massMatrix;
            if (this.vorlastEinfluss(steifMatrix, massMatrix, (double[])object2, n4, n2) == 0) {
                n3 = this.matrizenAufbau(true, (double[])object2, nArray);
                if (n3 != 0) {
                    n2 = n4 - n3;
                    if (Kondensation.execute(steifMatrix, massMatrix, nArray, n3) != 0) {
                        this.errorMsg(myLocale.getString("ungefesselteFedernImSystem"));
                        return -4;
                    }
                }
                Jacobi.allgEWP(steifMatrix, massMatrix, ew, ev);
                if (ew[ew.length - 1] < -1.0E-4) {
                    this.errorMsg(myLocale.getString("beiBeruecksichtigungVonEigengewichtIstDasSystemInstabil"));
                    steifMatrix = object;
                    massMatrix = dArray2;
                } else {
                    this.errorMsg("");
                    bl = true;
                }
            } else {
                this.errorMsg(myLocale.getString("EigengewichtKannInDerAktuellenLageNichtBeruecksichtigtWerden"));
            }
        }
        if (!bl) {
            Jacobi.allgEWP(steifMatrix, massMatrix, ew, ev);
        }
        formAnz = n2;
        if (n3 != 0) {
            object2 = ev;
            ev = new double[n4][n2];
            object = new double[n4];
            for (int i = 0; i < n2; ++i) {
                for (n = 0; n < n2; ++n) {
                    object[n] = object2[n][i];
                }
                Kondensation.vectorBackTransform((double[])object, n2, n4);
                VectorSet.vsnorm((double[])object);
                if (this.isRigidEigenVector((double[])object)) {
                    --formAnz;
                }
                for (n = 0; n < n4; ++n) {
                    SpringMassResultPanel.ev[n][i] = (double)object[n];
                }
            }
        }
        if (formAnz < 1) {
            this.clearFields();
            this.errorMsg(myLocale.getString("EsGibtKeineBewegungsmoeglichkeit"));
            return -5;
        }
        n = ew.length;
        while (--n >= 0) {
            if (Math.abs(ew[n]) < 1.0E-4) {
                SpringMassResultPanel.ew[n] = 0.0;
            }
            if (!(ew[n] > 0.0)) continue;
            SpringMassResultPanel.ew[n] = Math.sqrt(ew[n]) / (Math.PI * 2);
        }
        return 0;
    }

    WPoint getDirection(WPoint wPoint, WPoint wPoint2) {
        WPoint wPoint3 = WPoint.minus(wPoint2, wPoint);
        wPoint3.normiere();
        return wPoint3;
    }

    boolean isRigidEigenVector(double[] dArray) {
        WPoint[] wPointArray = SpringMassPunktePanel.pp;
        for (int i = 0; i < nElem; ++i) {
            if (!(steif[i] >= sMax)) continue;
            int n = federIndizes[i][0];
            int n2 = federIndizes[i][1];
            WPoint wPoint = this.getDirection(wPointArray[n], wPointArray[n2]);
            double d = dArray[2 * n] * wPoint.x + dArray[2 * n + 1] * wPoint.y - dArray[2 * n2] * wPoint.x - dArray[2 * n2 + 1] * wPoint.y;
            if (!(Math.abs(d) > 0.1)) continue;
            return true;
        }
        return false;
    }

    int showEigenform() {
        int n;
        int n2 = ev[0].length - 1;
        int n3 = this.nrtf.getInt();
        if (n3 > formAnz) {
            n3 = formAnz;
            this.nrtf.setText("" + formAnz);
        }
        if (--n3 < 0) {
            n3 = 0;
            this.nrtf.setText("1");
        }
        dx = new double[np];
        dy = new double[np];
        int n4 = n2 - n3;
        for (n = 0; n < np; ++n) {
            SpringMassResultPanel.dx[n] = ev[2 * n][n4];
            SpringMassResultPanel.dy[n] = ev[2 * n + 1][n4];
        }
        if (Math.abs(ew[n4]) < 1.0E-5) {
            SpringMassResultPanel.ew[n4] = 0.0;
        }
        ekfr = ew[n4];
        this.ewtf.setText(NumEdit.toPrecision(ew[n4], 3));
        Object object = "";
        for (n = 0; n < ev.length; ++n) {
            if (!aktiv[n]) continue;
            if (Math.abs(ev[n][n4]) < 1.0E-5) {
                SpringMassResultPanel.ev[n][n4] = 0.0;
            }
            String string = (n % 2 == 0 ? "u" : "v") + (n / 2 + 1) + " : ";
            object = (String)object + string + this.formatiere(ev[n][n4]) + "\n";
        }
        this.txarea.setText((String)object);
        this.txarea.setCaretPosition(0);
        return 0;
    }

    String formatiere(double d) {
        String string = NumEdit.toPrecision(d, 3);
        return d < 0.0 ? string : " " + string;
    }

    void clearFields() {
        this.errorMsg("");
        this.txarea.setText("");
        this.nrtf.setText("");
        this.ewtf.setText("");
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.currGrPan.stop();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        int n = 0;
        SpringMassGrafikPanel cfr_ignored_0 = (SpringMassGrafikPanel)this.grafikPanel;
        if (!SpringMassGrafikPanel.isRunning && (n = this.gesamtMatrizen()) == 0) {
            ((SpringMassGrafikPanel)this.grafikPanel).init();
            this.nrtf.setText("1");
            this.showEigenform();
        }
    }

    static {
        currFile = null;
        mitVorlast = true;
        masse = new double[16];
        steif = new double[30];
        sMax = 0.0;
        federIndizes = new int[30][2];
        randbdg = new int[16];
        aktiv = new boolean[32];
        uNachF = new double[30][4];
    }
}

