/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class SpringMass
extends JPanel
implements ActionListener {
    String[] lbs = new String[]{"Punkte", "Federn", "Massen", "Lager", "Eigenformen", "Beispiele", "Neu"};
    JButton[] bts = new JButton[this.lbs.length];
    DekorPanel[] pan = new DekorPanel[this.bts.length];
    JPanel buttpan = new JPanel();
    CardLayout c = new CardLayout();
    JPanel mainpan = new JPanel();
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileNew;
    private JMenuItem fileQuit;
    static JMenuBar mb;
    static LabelStore labelStore;
    static int currpan;
    static DontExitFrame f;
    static String title;

    public static void main(String[] stringArray) {
        if (DontExitFrame.exists(title)) {
            return;
        }
        f = new DontExitFrame();
        SpringMass springMass = new SpringMass();
        springMass.init();
        f.setContentPane(springMass);
        f.pack();
        SpringMass.setTitle();
        f.setSize(800, 600);
        f.setJMenuBar(mb);
        if (stringArray.length > 1) {
            Point point = new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            f.setLocation(point);
        }
        f.setVisible(true);
    }

    static void setTitle() {
        String string = SpringMassResultPanel.currFile;
        f.setTitle((String)(string == null ? title : title + " " + string));
    }

    public void init() {
        currpan = 0;
        mb = new JMenuBar();
        JMenu jMenu = labelStore.newMenu("Datei");
        this.fileNew = labelStore.newMenuItem("Neu");
        jMenu.add(this.fileNew);
        this.fileOpen = labelStore.newMenuItem("Oeffnen");
        jMenu.add(this.fileOpen);
        this.fileSave = labelStore.newMenuItem("Speichern");
        jMenu.add(this.fileSave);
        this.fileSaveAs = labelStore.newMenuItem("SpeichernUnter");
        jMenu.add(this.fileSaveAs);
        jMenu.addSeparator();
        this.fileQuit = labelStore.newMenuItem("Ende");
        jMenu.add(this.fileQuit);
        this.fileSaveAs.addActionListener(this);
        this.fileSave.addActionListener(this);
        this.fileOpen.addActionListener(this);
        this.fileQuit.addActionListener(this);
        this.fileNew.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.add((Component)this.buttpan, "North");
        this.mainpan.setLayout(this.c);
        this.add((Component)this.mainpan, "Center");
        for (int i = 0; i < this.bts.length; ++i) {
            this.bts[i] = labelStore.newButton(this.lbs[i]);
            this.bts[i].addActionListener(this);
            this.bts[i].setFont(new Font("Dialog", 0, 12));
            this.buttpan.add(this.bts[i]);
            switch (i) {
                case 0: {
                    this.pan[i] = new SpringMassPunktePanel();
                    break;
                }
                case 1: {
                    this.pan[i] = new SpringMassFederPanel();
                    break;
                }
                case 2: {
                    this.pan[i] = new SpringMassMassePanel();
                    break;
                }
                case 3: {
                    this.pan[i] = new SpringMassLagerPanel();
                    break;
                }
                case 4: {
                    this.pan[i] = new SpringMassResultPanel();
                    break;
                }
                case 5: {
                    this.pan[i] = new SpringMassExamplePanel();
                }
            }
            if (this.pan[i] == null) continue;
            this.mainpan.add(this.lbs[i], this.pan[i]);
        }
        SpringMassResultPanel.maskenLoeschen();
        mb.add(jMenu);
        mb.add(f.lookMenu());
        mb.add(f.languageMenu(labelStore));
        mb.add(f.helpMenu(labelStore, "SpringMass"));
        this.setVisible(true);
        this.changePanel(0);
    }

    void changePanel(int n) {
        this.c.show(this.mainpan, this.lbs[n]);
        ((SpringMassExamplePanel)this.pan[5]).clear();
        this.pan[4].statusMsg("");
        currpan = n;
    }

    void clearStatusFields() {
        int n = this.pan.length - 1;
        while (--n >= 0) {
            this.pan[n].statusMsg("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.fileOpen) {
            SpringMassResultPanel.laden();
            this.changePanel(0);
            this.clearStatusFields();
            this.pan[0].grafikPanel.fit();
            this.bts[0].requestFocus();
            SpringMass.setTitle();
        } else if (object == this.fileSave) {
            SpringMassResultPanel.speichern();
            SpringMass.setTitle();
        } else if (object == this.fileNew || object == this.bts[6]) {
            SpringMassResultPanel.maskenLoeschen();
            SpringMassResultPanel.currFile = null;
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            SpringMass.setTitle();
        } else if (object == this.fileSaveAs) {
            SpringMassResultPanel.speichernAls();
            SpringMass.setTitle();
        } else if (object == this.fileQuit) {
            f.exit(0);
        } else {
            int n = this.bts.length;
            while (--n >= 0) {
                if (object != this.bts[n]) continue;
                this.changePanel(n);
            }
        }
    }

    static {
        labelStore = new LabelStore();
        currpan = 0;
        f = null;
        title = "Spring Mass Systems 2.02 (2017)";
    }
}

