/*
 * Decompiled with CFR 0.152.
 */
class Scales {
    double smin;
    double smax;
    double dTic;
    double dLabel;

    Scales(double d, double d2) {
        double d3;
        if (d > d2) {
            d3 = d;
            d = d2;
            d2 = d3;
        }
        this.smin = d;
        this.smax = d2;
        double d4 = d2 - d;
        d3 = Math.log10(d4);
        int n = (int)d3;
        if (d3 < 0.0) {
            --n;
        }
        double d5 = d4 / Math.pow(10.0, n);
        this.dTic = Math.pow(10.0, n);
        if (d5 < 5.0) {
            this.dTic *= 0.1;
        }
        this.dLabel = 5.0 * this.dTic;
        if (d4 / this.dLabel < 2.0) {
            this.dLabel *= 0.2;
        }
        if (d4 / this.dTic > 40.0) {
            this.dTic *= 5.0;
        }
    }

    static double fmod(double d, double d2) {
        int n = (int)(d / d2);
        return d - (double)n * d2;
    }

    double[] getTics() {
        int n = 100;
        double[] dArray = new double[n];
        double d = this.smin < 0.0 || Scales.fmod(this.smin, this.dTic) == 0.0 ? Math.floor(this.smin / this.dTic) * this.dTic : Math.floor(this.smin / this.dTic + 1.0) * this.dTic;
        if (d < this.smin) {
            d += this.dTic;
        }
        int n2 = 0;
        dArray[n2] = d;
        while (n2 + 1 < n && dArray[n2] <= this.smax) {
            dArray[++n2] = dArray[n2 - 1] + this.dTic;
        }
        int n3 = n2;
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        return dArray2;
    }

    double[] getLabels() {
        int n = 25;
        double[] dArray = new double[n];
        double d = this.smin < 0.0 || Scales.fmod(this.smin, this.dTic) == 0.0 ? Math.floor(this.smin / this.dLabel) * this.dLabel : Math.floor(this.smin / this.dLabel + 1.0) * this.dLabel;
        if (d < this.smin) {
            d += this.dLabel;
        }
        int n2 = 0;
        dArray[n2] = d;
        while (n2 + 1 < n && dArray[n2] <= this.smax) {
            dArray[++n2] = dArray[n2 - 1] + this.dLabel;
        }
        int n3 = n2;
        double[] dArray2 = new double[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            dArray2[n2] = dArray[n2];
        }
        return dArray2;
    }
}

