/*
 * Decompiled with CFR 0.152.
 */
public abstract class RungeKutta {
    double[] k1 = null;
    double[] k2 = null;
    double[] k3 = null;
    double[] k4 = null;
    double[] k5 = null;
    int nRS;

    void init(int n) {
        this.nRS = n;
        this.k1 = new double[n];
        this.k2 = new double[n];
        this.k3 = new double[n];
        this.k4 = new double[n];
        this.k5 = new double[n];
    }

    abstract void funk(double[] var1, double[] var2);

    double norm(double[] dArray) {
        double d = 0.0;
        int n = dArray.length;
        while (--n >= 0) {
            d += dArray[n] * dArray[n];
        }
        return Math.sqrt(d);
    }

    void timeAutoStep(double[] dArray, double d) {
        double d2 = 1.0E-4;
        double d3 = d * 0.001;
        double d4 = dArray[0] + d;
        double[] dArray2 = new double[this.nRS];
        double[] dArray3 = new double[this.nRS];
        while (true) {
            this.adaptive4(dArray, d, dArray2, dArray3);
            double d5 = this.norm(dArray3);
            if (d * d2 < d5 && d > d3) {
                if (!((d = Math.min(d * 0.5, Math.pow(d2 / d5 * Math.pow(d, 5.0), 0.25))) < d3)) continue;
                d = d3;
                continue;
            }
            double d6 = dArray2[0];
            int n = this.nRS;
            while (--n >= 0) {
                dArray[n] = dArray2[n];
            }
            if (Math.abs(d6 - d4) < 1.0E-7) break;
            if (!(d6 + d > d4)) continue;
            d = d4 - d6;
        }
    }

    void adaptive4(double[] dArray, double d, double[] dArray2, double[] dArray3) {
        int n = this.nRS;
        double d2 = d * 0.5;
        this.funk(this.k1, dArray);
        int n2 = n;
        while (--n2 >= 0) {
            dArray2[n2] = dArray[n2] + this.k1[n2] * d2;
        }
        this.funk(this.k2, dArray2);
        n2 = n;
        while (--n2 >= 0) {
            dArray2[n2] = dArray[n2] + this.k2[n2] * d2;
        }
        this.funk(this.k3, dArray2);
        n2 = n;
        while (--n2 >= 0) {
            dArray2[n2] = dArray[n2] + this.k3[n2] * d;
        }
        this.funk(this.k4, dArray2);
        d /= 6.0;
        n2 = n;
        while (--n2 >= 0) {
            dArray2[n2] = dArray[n2] + (this.k1[n2] + 2.0 * (this.k2[n2] + this.k3[n2]) + this.k4[n2]) * d;
        }
        this.funk(this.k5, dArray2);
        n2 = n;
        while (--n2 >= 0) {
            dArray3[n2] = (this.k4[n2] - this.k5[n2]) * d;
        }
    }
}

