/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class RigidBodiesResultPanel
extends DekorPanel {
    public static int nElem;
    public static int np;
    public static int nGeo;
    public static int nLast;
    public static final int MAXE = 37;
    public static final int MAXP = 20;
    public static int nGes;
    public static int nRea;
    public static final int MAXK = 16;
    public static WPoint[] pp;
    public static int[][] knoten;
    public static boolean[] pendelStab;
    public static double[] stabKraft;
    public static int[] Alle;
    public static int[] AllePos;
    public static int[] AlleKrp;
    public static int[] rbn;
    public static int[] rbt;
    public static double[] rbw;
    public static int[] lastk;
    public static double[] lastx;
    public static double[] lasty;
    public static double[] lastm;
    public static double[][] Cges;
    public static double[] u;
    public static int calcErr;
    static String currFile;
    static RigidBodiesResultPanel self;
    public static int[] stabNr;
    JEditorPane jEditorPane = new JEditorPane();

    RigidBodiesResultPanel() {
        super(new RigidBodiesGrafikPanel(), 225);
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setBorder(BorderFactory.createEtchedBorder(0));
        JScrollPane jScrollPane = new JScrollPane(this.jEditorPane, 20, 30);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.jEditorPane.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:#000; font-family:times; margin: 4px;}");
        styleSheet.addRule("h4 {color: #eeeeee; background-color:#505050; font-size: 11px;}");
        styleSheet.addRule("pre {font-family: \"courier new\", courier, monospace; font-size: 11px;}");
        Document document = hTMLEditorKit.createDefaultDocument();
        this.jEditorPane.setDocument(document);
        jScrollPane.setPreferredSize(new Dimension(232, 120));
        this.remove(this.fieldPane);
        this.add((Component)jScrollPane, "East");
        self = this;
    }

    String doubleFormat(double d, int n) {
        Object object = d == 0.0 ? "0." : NumEdit.toPrecision(d, 4);
        int n2 = ((String)object).length() - n;
        while (n2++ < 0) {
            object = " " + (String)object;
        }
        return object;
    }

    public void showSolution() {
        int n = -1;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Object object = "";
        String string = "<br>";
        VectorSet.vsclear(u, 1.0E-8);
        if (RigidBodiesResultPanel.isFachwerk()) {
            object = (String)object + "<h4>" + myLocale.getString("Stabkraefte") + "</h4>";
            object = (String)object + "<pre>";
            for (int i = 0; i < nRea / 2; ++i) {
                double d;
                int n5 = AllePos[i];
                int n6 = AlleKrp[i];
                double d2 = u[2 * i];
                double d3 = u[2 * i + 1];
                if (n6 == 0) {
                    if (n4 == 0) {
                        object = (String)object + string + "</pre><h4>" + myLocale.getString("Lagerkraefte") + "</h4><pre>";
                    }
                    object = (String)object + "F<sub>" + n5 + ((n5 = rbn[n4++]) < 10 ? "x </sub>=" : "x</sub>=") + this.doubleFormat(d2, 7) + "  F<sub>" + n5 + (n5 < 10 ? "y </sub>=" : "y</sub>=") + this.doubleFormat(d3, 7) + string;
                    continue;
                }
                n2 = knoten[n6 - 1][0];
                n3 = knoten[n6 - 1][1];
                if (n5 == n2) {
                    n2 = n3;
                    n3 = n5;
                }
                WPoint wPoint = WPoint.minus(pp[n3 - 1], pp[n2 - 1]);
                RigidBodiesResultPanel.stabKraft[n6 - 1] = d = (wPoint.x * d2 + wPoint.y * d3) / Math.sqrt(wPoint.x * wPoint.x + wPoint.y * wPoint.y);
                object = (String)object + "F<sub>S" + n6 + ((n6 = stabNr[n6 - 1]) < 10 ? " </sub>=" : "</sub>=") + this.doubleFormat(d, 7) + string;
                if (n6 != AlleKrp[i + 1]) continue;
                ++i;
            }
            object = (String)object + "</pre>";
            this.jEditorPane.setText((String)object);
            this.jEditorPane.setCaretPosition(0);
            return;
        }
        object = (String)object + "<h4>" + myLocale.getString("Gelenkkraefte") + "</h4>";
        object = (String)object + "<pre>";
        for (int i = 0; i < nRea / 2; ++i) {
            boolean bl;
            int n7 = AlleKrp[i];
            int n8 = AllePos[i];
            double d = u[2 * i];
            double d4 = u[2 * i + 1];
            boolean bl2 = bl = n7 >= 1 && pendelStab[n7 - 1];
            if (n7 == 0) {
                if (n4 == 0) {
                    object = (String)object + string + "</pre><h4>" + myLocale.getString("Lagerkraefte") + "</h4><pre>";
                }
                n8 = rbn[n4++];
            } else if (n7 != n) {
                object = (String)object + "<b>" + myLocale.getString(bl ? "Stab" : "Koerper1");
                object = (String)object + " " + stabNr[n7 - 1] + "</b>" + string;
                n = n7;
            }
            if (bl) {
                double d5;
                n2 = knoten[n7 - 1][0];
                n3 = knoten[n7 - 1][1];
                if (n8 == n2) {
                    n2 = n3;
                    n3 = n8;
                }
                WPoint wPoint = WPoint.minus(pp[n3 - 1], pp[n2 - 1]);
                RigidBodiesResultPanel.stabKraft[n7 - 1] = d5 = (wPoint.x * d + wPoint.y * d4) / Math.sqrt(wPoint.x * wPoint.x + wPoint.y * wPoint.y);
                object = (String)object + " F   =" + this.doubleFormat(d5, 7) + string;
                if (n7 != AlleKrp[i + 1]) continue;
                ++i;
                continue;
            }
            double d6 = Math.sqrt(d * d + d4 * d4);
            object = (String)object + " F<sub>" + n8 + (n8 < 10 ? "x " : "x") + "</sub>=" + this.doubleFormat(d, 7) + "  F<sub>" + n8 + (n8 < 10 ? "y " : "y") + "</sub>=" + this.doubleFormat(d4, 7) + "  |F<sub>" + n8 + (n8 < 10 ? " " : "") + "</sub>|=" + this.doubleFormat(d6, 7) + string;
        }
        object = (String)object + "</pre>";
        this.jEditorPane.setText((String)object);
        this.jEditorPane.setCaretPosition(0);
    }

    static void speichern(String string) {
        currFile = string;
        try {
            String string2;
            String string3;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            RigidBodiesResultPanel.datenVonMaske(false);
            for (n = 0; n < 20; ++n) {
                string3 = NumEdit.stripBlanks(RigidBodiesPunktePanel.tfx[n].getText());
                string2 = NumEdit.stripBlanks(RigidBodiesPunktePanel.tfy[n].getText());
                if (string3.length() == 0 && string2.length() == 0) continue;
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                fileWriter.write("P " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 37; ++n) {
                string3 = RigidBodiesKoerperPanel.nodeNumbers[n].getText().replace(',', ' ');
                string3.trim();
                if (string3.length() == 0) continue;
                fileWriter.write("E " + string3 + "\n");
            }
            for (n = 0; n < 20; ++n) {
                string3 = NumEdit.stripBlanks(RigidBodiesLoadPanel.tfx[n].getText());
                string2 = NumEdit.stripBlanks(RigidBodiesLoadPanel.tfy[n].getText());
                String string4 = NumEdit.stripBlanks(RigidBodiesLoadPanel.tfm[n].getText());
                if (string3.length() == 0 && string2.length() == 0 && string4.length() == 0) continue;
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                if (string4.length() == 0) {
                    string4 = "0";
                }
                fileWriter.write("L " + (n + 1) + " " + string3 + " " + string2 + " " + string4 + "\n");
            }
            for (n = 0; n < nGeo; ++n) {
                if (rbw[n] == 0.0) {
                    fileWriter.write("R " + rbn[n] + " " + rbt[n] + "\n");
                    continue;
                }
                fileWriter.write("R " + rbn[n] + " " + rbt[n] + " " + rbw[n] + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        RigidBodiesResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("s2d", self);
    }

    public static void speichern() {
        if (currFile != null) {
            RigidBodiesResultPanel.speichern(currFile);
        } else {
            RigidBodiesResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = RigidBodiesPunktePanel.tfx.length;
        while (--n >= 0) {
            RigidBodiesPunktePanel.tfx[n].setText("");
            RigidBodiesPunktePanel.tfy[n].setText("");
        }
        n = RigidBodiesLoadPanel.tfx.length;
        while (--n >= 0) {
            RigidBodiesLoadPanel.tfx[n].setText("");
            RigidBodiesLoadPanel.tfy[n].setText("");
            RigidBodiesLoadPanel.tfm[n].setText("");
        }
        n = RigidBodiesLagerPanel.cx.length;
        while (--n >= 0) {
            RigidBodiesLagerPanel.cx[n].setSelected(false);
            RigidBodiesLagerPanel.cy[n].setSelected(false);
            RigidBodiesLagerPanel.tfw[n].setText("");
        }
        for (n = 0; n < 37; ++n) {
            RigidBodiesKoerperPanel.nodeNumbers[n].setText("");
        }
        nElem = 0;
        np = 0;
        RigidBodiesPunktePanel.auslesen();
        RigidBodiesLoadPanel.auslesen();
    }

    static void stringToFields(String object) {
        String[] stringArray = NumEdit.split((String)object);
        if (stringArray != null && stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    RigidBodiesPunktePanel.tfx[np].setText(stringArray[1]);
                    RigidBodiesPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'L': {
                    int n = Integer.parseInt(stringArray[1]);
                    RigidBodiesLoadPanel.tfx[n - 1].setText(stringArray[2]);
                    RigidBodiesLoadPanel.tfy[n - 1].setText(stringArray[3]);
                    if (stringArray.length > 4) {
                        RigidBodiesLoadPanel.tfm[n - 1].setText(stringArray[4]);
                    }
                    ++np;
                    break;
                }
                case 'R': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    RigidBodiesLagerPanel.cx[n - 1].setSelected((n2 & 1) != 0);
                    RigidBodiesLagerPanel.cy[n - 1].setSelected((n2 & 2) != 0);
                    if (stringArray.length <= 3) break;
                    RigidBodiesLagerPanel.tfw[n - 1].setText(stringArray[3]);
                    break;
                }
                case 'E': {
                    object = "";
                    for (int i = 1; i < stringArray.length; ++i) {
                        object = (String)object + stringArray[i] + " ";
                    }
                    RigidBodiesKoerperPanel.nodeNumbers[nElem].setText((String)object);
                    ++nElem;
                }
            }
        }
    }

    public static void beforeFileOperations() {
        RigidBodiesResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        RigidBodiesResultPanel.datenVonMaske(false);
    }

    public static void eachLineFileOperations(String string) {
        RigidBodiesResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("s2d", self);
    }

    static void knotenInitialisieren() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 37; ++j) {
                RigidBodiesResultPanel.knoten[j][i] = 0;
            }
        }
    }

    static int koerperTesten() {
        int[] nArray = new int[16];
        for (int i = 0; i < nElem; ++i) {
            if (knoten[i][0] > knoten[i][1]) {
                int n = knoten[i][0];
                RigidBodiesResultPanel.knoten[i][0] = knoten[i][1];
                RigidBodiesResultPanel.knoten[i][1] = n;
            }
            for (int j = 0; j < i; ++j) {
                boolean bl = false;
                for (int k = 0; k < 16; ++k) {
                    if (knoten[i][k] == knoten[j][k]) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                self.errorMsg("Doppeleintr\u00e4ge bei K\u00f6rpern(" + (j + 1) + "," + (i + 1) + ") sind nicht erlaubt!");
                return -1;
            }
        }
        return 0;
    }

    static void zeroArray(int[] nArray) {
        int n = nArray.length;
        while (--n >= 0) {
            nArray[n] = 0;
        }
    }

    static int datenVonMaske(boolean bl) {
        int n;
        int n2;
        int n3;
        RigidBodiesResultPanel.knotenInitialisieren();
        for (n3 = 0; n3 < 20; ++n3) {
            RigidBodiesResultPanel.lastx[n3] = 0.0;
            RigidBodiesResultPanel.lasty[n3] = 0.0;
            RigidBodiesResultPanel.lastm[n3] = 0.0;
        }
        RigidBodiesResultPanel.zeroArray(rbt);
        RigidBodiesResultPanel.zeroArray(rbn);
        RigidBodiesPunktePanel.auslesen();
        np = RigidBodiesPunktePanel.np;
        nGes = 0;
        int n4 = RigidBodiesKoerperPanel.nodeNumbers.length;
        nElem = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            String string = RigidBodiesKoerperPanel.nodeNumbers[n2].getText().replace(',', ' ');
            int[] nArray = NumEdit.getList(string);
            if (nArray == null) continue;
            int n5 = 0;
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n = nArray[n3];
                if (n > 20) {
                    self.errorMsg(myLocale.getString("unzulaessigeKnotenNummer") + " " + nArray[n3]);
                    return -4;
                }
                if (RigidBodiesResultPanel.suche(n, knoten[nElem], 16) >= 0) continue;
                RigidBodiesResultPanel.knoten[RigidBodiesResultPanel.nElem][n5++] = n;
            }
            RigidBodiesResultPanel.pendelStab[RigidBodiesResultPanel.nElem] = n3 == 2;
            RigidBodiesResultPanel.stabNr[RigidBodiesResultPanel.nElem] = n2 + 1;
            ++nElem;
        }
        if (nElem <= 0) {
            self.errorMsg(myLocale.getString("EsIstNochKeinKoerperDefiniert"));
            if (bl) {
                return -1;
            }
        }
        if (bl && RigidBodiesResultPanel.koerperTesten() < 0) {
            return -2;
        }
        nGeo = 0;
        for (n2 = 0; n2 < np; ++n2) {
            n = RigidBodiesLagerPanel.cx[n2].isSelected();
            boolean bl2 = RigidBodiesLagerPanel.cy[n2].isSelected();
            if (n == 0 && !bl2 || RigidBodiesResultPanel.getElem(n2 + 1) == -1) continue;
            RigidBodiesResultPanel.rbn[RigidBodiesResultPanel.nGeo] = n2 + 1;
            if (n != 0) {
                RigidBodiesResultPanel.rbt[RigidBodiesResultPanel.nGeo] = 1;
            }
            if (bl2) {
                int n6 = nGeo;
                rbt[n6] = rbt[n6] | 2;
            }
            RigidBodiesResultPanel.rbw[RigidBodiesResultPanel.nGeo] = RigidBodiesLagerPanel.tfw[n2].getDouble();
            ++nGeo;
        }
        RigidBodiesLoadPanel.auslesen();
        for (n2 = 0; n2 < np; ++n2) {
            if (lastx[n2] == 0.0 && lasty[n2] == 0.0 && lastm[n2] == 0.0) continue;
            n = RigidBodiesResultPanel.getElem(n2 + 1);
            if (n == -1) {
                self.errorMsg(myLocale.getString("Last") + " " + (n2 + 1) + " " + myLocale.getString("ist keinen Koerper zugeordnet"));
            }
            if (lastm[n2] == 0.0 || n < 0) continue;
            RigidBodiesResultPanel.pendelStab[n] = false;
        }
        n2 = RigidBodiesResultPanel.knotenZaehlen();
        if (n2 < 0) {
            self.errorMsg(myLocale.getString("DasSystemIst") + " " + -n2 + myLocale.getString("fachStatischUnbestimmt"));
            calcErr = -1;
            if (bl) {
                return -1;
            }
        }
        return 0;
    }

    static int suche(int n, int[] nArray, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            if (nArray[n3] != n) continue;
            return n3;
        }
        return -1;
    }

    static int suche(int n, int[] nArray) {
        return RigidBodiesResultPanel.suche(n, nArray, nArray.length);
    }

    static int knotenZaehlen() {
        int n;
        int n2;
        int n3;
        int[] nArray = new int[20];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        RigidBodiesResultPanel.zeroArray(Alle);
        for (n3 = 0; n3 < nElem; ++n3) {
            for (n2 = 0; n2 < 16 && (n = knoten[n3][n2]) != 0; ++n2) {
                if (RigidBodiesResultPanel.suche(n, Alle, n5) < 0) {
                    RigidBodiesResultPanel.Alle[n5] = n;
                    ++n5;
                    continue;
                }
                if (RigidBodiesResultPanel.suche(n, rbn, nGeo) >= 0) continue;
                if (RigidBodiesResultPanel.suche(n, nArray, n4) < 0) {
                    nArray[n4] = n;
                    ++n4;
                }
                n6 += 2;
            }
        }
        RigidBodiesResultPanel.zeroArray(Alle);
        for (n3 = 0; n3 < n4; ++n3) {
            RigidBodiesResultPanel.Alle[n3] = nArray[n3];
        }
        int[] nArray2 = rbn;
        n5 = n4;
        for (n3 = 0; n3 < nGeo; ++n3) {
            RigidBodiesResultPanel.Alle[n5++] = nArray2[n3];
        }
        for (n3 = 0; n3 < nElem; ++n3) {
            for (n2 = 0; n2 < 16 && (n = knoten[n3][n2]) != 0; ++n2) {
                if (RigidBodiesResultPanel.suche(n, nArray2, n5) < 0) continue;
                n6 += 2;
            }
        }
        int n7 = 0;
        for (n3 = 0; n3 < nGeo; ++n3) {
            if (rbt[n3] == 3) continue;
            ++n7;
        }
        nGes = 3 * nElem + 2 * n5 + n7;
        nRea = n6 + 2 * n5;
        return nGes - nRea;
    }

    static int getElem(int n) {
        int n2 = -1;
        block0: for (int i = 0; i < nElem; ++i) {
            for (int j = 0; j < 16 && knoten[i][j] != 0; ++j) {
                if (knoten[i][j] != n) continue;
                if (n2 >= 0) {
                    return -2;
                }
                n2 = i;
                continue block0;
            }
        }
        return n2;
    }

    static int getPos(int n) {
        for (int i = 0; i < np; ++i) {
            if (n != Alle[i]) continue;
            return i;
        }
        return -1;
    }

    static void gesamtMatrix() {
        Cges = new double[nGes][nGes];
        RigidBodiesResultPanel.zeroArray(AllePos);
        RigidBodiesResultPanel.zeroArray(AlleKrp);
        int n = 0;
        int n2 = nElem * 3;
        int n3 = 0;
        for (int i = 0; i < nElem; ++i) {
            int n4;
            int n5 = i * 3;
            for (int j = 0; j < 16 && (n4 = knoten[i][j]) != 0; ++j) {
                if (RigidBodiesResultPanel.suche(n4, Alle, np) < 0) continue;
                RigidBodiesResultPanel.AllePos[n3] = n4;
                RigidBodiesResultPanel.AlleKrp[n3] = i + 1;
                ++n3;
                int n6 = n2 + 2 * RigidBodiesResultPanel.getPos(n4);
                RigidBodiesResultPanel.Cges[n5][n] = 1.0;
                RigidBodiesResultPanel.Cges[n5 + 1][n + 1] = 1.0;
                RigidBodiesResultPanel.Cges[n5 + 2][n + 1] = RigidBodiesResultPanel.pp[n4 - 1].x;
                RigidBodiesResultPanel.Cges[n5 + 2][n] = -RigidBodiesResultPanel.pp[n4 - 1].y;
                RigidBodiesResultPanel.Cges[n6][n] = 1.0;
                RigidBodiesResultPanel.Cges[n6 + 1][n + 1] = 1.0;
                n += 2;
            }
        }
    }

    static int randbedingungen() {
        int n;
        int n2;
        int n3 = nRea - nGeo * 2;
        int n4 = nElem * 3;
        for (n2 = 0; n2 < nGes; ++n2) {
            RigidBodiesResultPanel.u[n2] = 0.0;
        }
        int n5 = n3 + 1;
        int n6 = nGes;
        for (n2 = 0; n2 < nGeo; ++n2) {
            double d;
            int n7 = RigidBodiesResultPanel.getPos(rbn[n2]);
            if (n7 < 0) continue;
            n = n4 + 2 * n7;
            RigidBodiesResultPanel.Cges[n][n5 - 1] = -1.0;
            RigidBodiesResultPanel.Cges[n + 1][n5] = -1.0;
            if ((rbt[n2] & 1) == 0) {
                if (rbw[n2] == 0.0) {
                    RigidBodiesResultPanel.Cges[--n6][n5 - 1] = 1.0;
                } else {
                    d = rbw[n2] * Math.PI / 180.0;
                    RigidBodiesResultPanel.Cges[--n6][n5] = Math.sin(d);
                    RigidBodiesResultPanel.Cges[n6][n5 - 1] = Math.cos(d);
                }
            }
            if ((rbt[n2] & 2) == 0) {
                if (rbw[n2] == 0.0) {
                    RigidBodiesResultPanel.Cges[--n6][n5] = 1.0;
                } else {
                    d = rbw[n2] * Math.PI / 180.0;
                    RigidBodiesResultPanel.Cges[--n6][n5] = Math.cos(d);
                    RigidBodiesResultPanel.Cges[n6][n5 - 1] = -Math.sin(d);
                }
            }
            n5 += 2;
        }
        for (n2 = 0; n2 < nLast; ++n2) {
            int n8;
            int n9 = lastk[n2];
            int n10 = n9 - 1;
            if (RigidBodiesResultPanel.suche(n9, Alle, np) >= 0) {
                int n11 = n = n4 + 2 * RigidBodiesResultPanel.getPos(n9);
                u[n11] = u[n11] + lastx[n10];
                int n12 = n + 1;
                u[n12] = u[n12] + lasty[n10];
            } else {
                n8 = RigidBodiesResultPanel.getElem(lastk[n2]);
                if (n8 != -1) {
                    int n13 = n = n8 * 3;
                    u[n13] = u[n13] - lastx[n10];
                    int n14 = n + 1;
                    u[n14] = u[n14] - lasty[n10];
                    int n15 = n + 2;
                    u[n15] = u[n15] + (-lasty[n10] * RigidBodiesResultPanel.pp[n9 - 1].x + lastx[n10] * RigidBodiesResultPanel.pp[n9 - 1].y);
                }
            }
            if (lastm[n10] == 0.0) continue;
            n8 = RigidBodiesResultPanel.getElem(lastk[n2]);
            if (n8 == -2) {
                self.errorMsg(myLocale.getString("DerPunktDerMomenteneinleitungIstMehrerenKoerpernZugeordnet"));
                return -1;
            }
            if (n8 == -1) {
                self.errorMsg(myLocale.getString("DerPunktDerMomenteneinleitungIstKeinemKoerperZugeordnet"));
                return -2;
            }
            int n16 = n = n8 * 3 + 2;
            u[n16] = u[n16] - lastm[n10];
        }
        return 0;
    }

    int rechne() {
        this.statusMsg("");
        this.jEditorPane.setText("");
        if (RigidBodiesResultPanel.datenVonMaske(true) < 0) {
            return -1;
        }
        RigidBodiesResultPanel.gesamtMatrix();
        int n = RigidBodiesResultPanel.randbedingungen();
        if (n != 0) {
            return n;
        }
        return RigidBodiesResultPanel.loesen();
    }

    static int loesen() {
        int n = nGes - nRea;
        calcErr = Gauss.fullPivoting(Cges, u, nGes);
        if (calcErr > 0) {
            block0: for (int i = 0; i < nGes; ++i) {
                if (!(Math.abs(u[i]) > 1.0E-7)) continue;
                for (int j = 0; j < calcErr; ++j) {
                    if (!(Math.abs(Gauss.homLsg[j][i]) > 1.0E-7)) continue;
                    calcErr = -99;
                    continue block0;
                }
            }
        }
        if (calcErr > 0) {
            calcErr = 0;
            if (n == 0) {
                n = 1;
            }
            self.statusMsg(myLocale.getString("DasSystemIstMindestens") + " " + n + myLocale.getString("fachKinematischUnbestimmtGleichgewichtIstJedochMoeglich"));
        }
        if (calcErr < 0) {
            if (n != 0) {
                self.errorMsg(myLocale.getString("DasSystemIstMindestens") + " " + n + myLocale.getString("fachKinematischUnbestimmtDieLagerreaktionenkoennenNichtBestimmtwerden"));
            } else if (calcErr != -99) {
                self.errorMsg(myLocale.getString("DasSystemIstInstabilImKleinenOderNochBeweglich"));
            } else {
                self.errorMsg(myLocale.getString("DasSystemIstStatischUnbestimmtUndNochBeweglich"));
            }
            return -1;
        }
        return 0;
    }

    static boolean isFachwerk() {
        boolean bl = true;
        for (int i = 0; i < nRea / 2; ++i) {
            int n = AlleKrp[i];
            if (n <= 0 || pendelStab[n - 1]) continue;
            bl = false;
        }
        return bl;
    }

    static {
        pp = RigidBodiesPunktePanel.pp;
        knoten = new int[37][16];
        pendelStab = new boolean[37];
        stabKraft = new double[37];
        Alle = new int[20];
        AllePos = new int[151];
        AlleKrp = new int[75];
        rbn = new int[20];
        rbt = new int[20];
        rbw = new double[20];
        lastk = new int[20];
        lastx = new double[20];
        lasty = new double[20];
        lastm = new double[20];
        Cges = null;
        u = new double[151];
        calcErr = 0;
        currFile = null;
        stabNr = new int[37];
    }
}

