/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Cursor;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.io.FileWriter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PlateVibrationResultPanel
extends DekorPanel
implements ComponentListener {
    static int npsoll = 500;
    static int newcalc = 20;
    static PlateVibrationGrafikPanel currGrPan;
    JCheckBox c1 = PlateVibration.labelStore.newCheckBox("Netzdarstellung");
    JCheckBox c3 = PlateVibration.labelStore.newCheckBox("3D-Darstellung");
    NumEdit nrtf;
    NumEdit ewtf;
    JButton upJButton;
    JButton downJButton;
    static JButton startJButton;
    JPanel buttpan = new JPanel();
    static NumEdit emodultf;
    static NumEdit nuetf;
    static NumEdit dichtetf;
    static NumEdit dicketf;
    static NumEdit npsolltf;
    static NumEdit newtf;
    public static int np;
    public static int nt;
    public static int nrb;
    public static int nrand;
    public static final int MAXP = 40;
    public static final int MAXR = 10;
    static String currFile;
    static double[] x;
    static double[] y;
    static Dreieck[] tria;
    static Rand[] rand;
    static double[] T;
    static boolean showElementGrid;
    static boolean showNodeNumbers;
    static boolean is3d;
    static final double markValue = 1.0E-9;
    static double NUE;
    static double EM;
    static double rho;
    static double plattenstaerke;
    static double winkelScaleFactor;
    static boolean dontShow;
    static PlateVibrationResultPanel self;
    int[] randpunktIndizes;
    static int[] permbw;
    static int[] permfw;
    double[][] ev = null;
    double[] lam = null;
    int nmarks;
    int[] marks = null;
    static double[][] i1;
    static double[][] i4;
    static double[][] i3;
    static double[][] i2;
    static double[][] a;
    static double[] gaussPunkteL1;
    static double[] gaussPunkteL2;
    static double[] gaussPunkteW;

    PlateVibrationResultPanel() {
        super(new PlateVibrationGrafikPanel(), 248);
        self = this;
        currGrPan = (PlateVibrationGrafikPanel)this.grafikPanel;
        is3d = false;
        showElementGrid = false;
        emodultf = new NumEdit("" + EM, 5);
        this.fpAdd(emodultf, 0, 0, 1, 1);
        JLabel jLabel = PlateVibration.labelStore.newLabel("E-Modul");
        this.fpAdd(jLabel, 1, 0, 1, 1);
        ++this.gbc.gridy;
        nuetf = new NumEdit("" + NUE, 5);
        this.fpAdd(nuetf, 0, 2, 1, 1);
        jLabel = PlateVibration.labelStore.newLabel("PoissonZahl");
        this.fpAdd(jLabel, 1, 2, 1, 1);
        ++this.gbc.gridy;
        dichtetf = new NumEdit("" + rho, 5);
        this.fpAdd(dichtetf, 0, 3, 1, 1);
        jLabel = PlateVibration.labelStore.newLabel("Dichte");
        this.fpAdd(jLabel, 1, 3, 1, 1);
        ++this.gbc.gridy;
        dicketf = new NumEdit("" + plattenstaerke, 5);
        this.fpAdd(dicketf, 0, 4, 1, 1);
        jLabel = PlateVibration.labelStore.newLabel("Plattenstaerke");
        this.fpAdd(jLabel, 1, 4, 1, 1);
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 5, 1, 1);
        ++this.gbc.gridy;
        npsolltf = new NumEdit("" + npsoll, 5);
        npsolltf.setNumOnly();
        this.fpAdd(npsolltf, 0, 6, 1, 1);
        jLabel = PlateVibration.labelStore.newLabel("Knoten");
        this.fpAdd(jLabel, 1, 6, 1, 1);
        newtf = new NumEdit("" + newcalc, 5);
        newtf.setNumOnly();
        newtf.setName("last");
        ++this.gbc.gridy;
        this.fpAdd(newtf, 0, 7, 1, 1);
        jLabel = PlateVibration.labelStore.newLabel("zuBerechnendeEigenwerte");
        this.fpAdd(jLabel, 1, 7, 1, 1);
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 8, 1, 1);
        this.gbc.anchor = 17;
        ++this.gbc.gridy;
        this.fpAdd(this.c1, 1, 9, 2, 1);
        ++this.gbc.gridy;
        this.fpAdd(this.c3, 1, 10, 2, 1);
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 1, 11, 1, 1);
        ++this.gbc.gridy;
        this.gbc.anchor = 10;
        jLabel = PlateVibration.labelStore.newLabel("EigenformNr");
        this.fpAdd(jLabel, 0, 12, 2, 1);
        this.nrtf = new NumEdit(3);
        this.nrtf.setNumOnly();
        this.nrtf.addActionListener(this);
        ++this.gbc.gridy;
        this.fpAdd(this.nrtf, 0, 13, 2, 1);
        this.downJButton = new JButton("<");
        this.downJButton.setMargin(new Insets(0, 5, 0, 5));
        this.downJButton.addActionListener(this);
        this.buttpan.add(this.downJButton);
        this.upJButton = new JButton(">");
        this.upJButton.setMargin(new Insets(0, 5, 0, 5));
        this.upJButton.addActionListener(this);
        this.buttpan.add(this.upJButton);
        ++this.gbc.gridy;
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.fpAdd(this.buttpan, 0, 14, 2, 1);
        ++this.gbc.gridy;
        jLabel = PlateVibration.labelStore.newLabel("Eigenfrequenz");
        this.fpAdd(jLabel, 0, 15, 2, 1);
        this.ewtf = new NumEdit(4, true);
        this.ewtf.setFont(new Font("System", 0, 18));
        this.ewtf.setEditable(false);
        ++this.gbc.gridy;
        this.fpAdd(this.ewtf, 0, 16, 2, 1);
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 17, 2, 1);
        ++this.gbc.gridy;
        startJButton = PlateVibration.labelStore.newButton("AnimationAn");
        startJButton.addActionListener(this);
        this.fpAdd(startJButton, 0, 18, 2, 1);
        this.c1.addItemListener(this);
        this.c3.addItemListener(this);
        npsolltf.addActionListener(this);
        newtf.addActionListener(this);
        dichtetf.addActionListener(this);
        dicketf.addActionListener(this);
        emodultf.addActionListener(this);
        nuetf.addActionListener(this);
        this.addComponentListener(this);
    }

    static void speichern(String string) {
        currFile = string;
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            fileWriter.write("N " + npsoll + "\n");
            fileWriter.write("E " + newcalc + "\n");
            for (n = 0; n < 40; ++n) {
                String string2 = NumEdit.stripBlanks(PlateVibrationPunktePanel.tfx[n].getText());
                String string3 = NumEdit.stripBlanks(PlateVibrationPunktePanel.tfy[n].getText());
                if (string2.length() == 0 && string3.length() == 0) continue;
                if (string2.length() == 0) {
                    string2 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("P " + string2 + " " + string3 + "\n");
            }
            for (n = 0; n < nrb; ++n) {
                fileWriter.write("W ");
                fileWriter.write(PlateVibrationResultPanel.rand[n].n1 + " " + PlateVibrationResultPanel.rand[n].n2 + " " + PlateVibrationResultPanel.rand[n].mode + "\n");
            }
            fileWriter.write("T " + plattenstaerke + "\n");
            fileWriter.write("R " + rho + "\n");
            fileWriter.write("Q " + NUE + "\n");
            fileWriter.write("M " + EM + "\n");
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        PlateVibrationResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("pev", self);
    }

    static void speichern() {
        if (currFile != null) {
            PlateVibrationResultPanel.speichern(currFile);
        } else {
            PlateVibrationResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = PlateVibrationPunktePanel.tfx.length;
        while (--n >= 0) {
            PlateVibrationPunktePanel.tfx[n].setText("");
            PlateVibrationPunktePanel.tfy[n].setText("");
        }
        n = PlateVibrationRandbdgPanel.tf1.length;
        while (--n >= 0) {
            PlateVibrationRandbdgPanel.tf1[n].setText("");
            PlateVibrationRandbdgPanel.tf2[n].setText("");
            PlateVibrationRandbdgPanel.cb[2 * n].setSelected(false);
            PlateVibrationRandbdgPanel.cb[2 * n + 1].setSelected(false);
        }
        nrb = 0;
        PlateVibrationPunktePanel.auslesen();
    }

    static void stringToFields(String string) {
        String[] stringArray = NumEdit.split(string);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    PlateVibrationPunktePanel.tfx[np].setText(stringArray[1]);
                    PlateVibrationPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'N': {
                    npsoll = Integer.parseInt(stringArray[1]);
                    npsolltf.setText(stringArray[1]);
                    break;
                }
                case 'E': {
                    newcalc = Integer.parseInt(stringArray[1]);
                    newtf.setText(stringArray[1]);
                    break;
                }
                case 'W': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    int n3 = Integer.parseInt(stringArray[3]);
                    PlateVibrationResultPanel.rand[PlateVibrationResultPanel.nrb] = new Rand(n, n2, n3);
                    PlateVibrationRandbdgPanel.tf1[nrb].setText("" + (n + 1));
                    PlateVibrationRandbdgPanel.tf2[nrb].setText("" + (n2 + 1));
                    int n4 = nrb;
                    PlateVibrationRandbdgPanel.cb[2 * n4].setSelected((n3 & 1) != 0);
                    PlateVibrationRandbdgPanel.cb[2 * n4 + 1].setSelected((n3 & 2) != 0);
                    nrb = n4 + 1;
                    break;
                }
                case 'T': {
                    dicketf.setText(stringArray[1]);
                    plattenstaerke = dicketf.getDouble();
                    break;
                }
                case 'R': {
                    dichtetf.setText(stringArray[1]);
                    rho = dichtetf.getDouble();
                    break;
                }
                case 'Q': {
                    nuetf.setText(stringArray[1]);
                    NUE = nuetf.getDouble();
                    break;
                }
                case 'M': {
                    emodultf.setText(stringArray[1]);
                    EM = emodultf.getDouble();
                }
            }
        }
    }

    public static void beforeFileOperations() {
        np = 0;
        nrb = 0;
        PlateVibrationResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        PlateVibrationPunktePanel.auslesen();
    }

    public static void eachLineFileOperations(String string) {
        PlateVibrationResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("pev", self);
    }

    boolean hasMinDist(double d, double d2, double[] dArray, double[] dArray2, int n, double d3) {
        double d4 = d3 * d3;
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            double d5;
            double d6 = d - dArray[n3];
            double d7 = d2 - dArray2[n3];
            if (d6 * d6 + d7 * d7 < d4) {
                return false;
            }
            double d8 = dArray[n2] - dArray[n3];
            double d9 = dArray2[n2] - dArray2[n3];
            double d10 = d8 * d6 + d9 * d7;
            if (d10 > 0.0 && d10 < (d5 = d8 * d8 + d9 * d9) && Math.abs(-d9 * d6 + d8 * d7) < d3 * Math.sqrt(d5)) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    int mehrRandPunkte(double[] dArray, double[] dArray2, int n, double d) {
        int n2;
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        for (n2 = 0; n2 < n; ++n2) {
            dArray3[n2] = dArray[n2];
            dArray4[n2] = dArray2[n2];
        }
        dArray3[n] = dArray3[0];
        dArray4[n] = dArray4[0];
        this.randpunktIndizes = new int[n + 1];
        this.randpunktIndizes[0] = 0;
        int n3 = 0;
        for (n2 = 1; n2 <= n; ++n2) {
            double d2 = dArray3[n2] - dArray3[n2 - 1];
            double d3 = dArray4[n2] - dArray4[n2 - 1];
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray[n3] = dArray3[n2 - 1];
            dArray2[n3] = dArray4[n2 - 1];
            ++n3;
            int n4 = 0;
            if (d4 > d) {
                int n5 = (int)(d4 / d + 0.5);
                d2 /= (double)n5;
                d3 /= (double)n5;
                while (--n5 > 0) {
                    dArray[n3] = dArray[n3 - 1] + d2;
                    dArray2[n3] = dArray2[n3 - 1] + d3;
                    ++n3;
                    ++n4;
                }
            }
            this.randpunktIndizes[n2] = this.randpunktIndizes[n2 - 1] + n4 + 1;
        }
        dArray[n3] = dArray3[0];
        dArray2[n3] = dArray4[0];
        return n3;
    }

    static int toMcKee(int n) {
        if (permfw != null) {
            return permfw[n];
        }
        return n;
    }

    void pointsAndTriangulation() {
        int n;
        double d;
        int n2;
        double[][] dArray = null;
        double[][] dArray2 = null;
        double[] dArray3 = new double[32];
        double[] dArray4 = new double[32];
        int n3 = 0;
        boolean[] blArray = PlateVibrationPunktePanel.isNode;
        WPoint3d[] wPoint3dArray = PlateVibrationPunktePanel.pp;
        int n4 = 2 * npsoll;
        if (n4 < 100) {
            n4 = 100;
        }
        x = new double[n4];
        y = new double[n4];
        double[] dArray5 = null;
        double[] dArray6 = null;
        this.errorMsg("");
        int n5 = 0;
        for (n2 = 0; n2 < 40; ++n2) {
            if (!blArray[n2]) continue;
            dArray3[n5] = PlateVibrationResultPanel.x[n5] = wPoint3dArray[n2].x;
            dArray4[n5] = PlateVibrationResultPanel.y[n5] = wPoint3dArray[n2].y;
            if (n5 > 0 && x[n5] == x[n5 - 1] && y[n5] == y[n5 - 1]) continue;
            ++n5;
        }
        nrand = n5;
        this.ewtf.setText("");
        if (nrand == 0) {
            this.errorMsg(myLocale.getString("EsExistiertNochKeinModell"));
            return;
        }
        double d2 = WPoint3d.flaeche(wPoint3dArray, n5);
        double d3 = VectorSet.vsMin(x, n5);
        double d4 = VectorSet.vsMax(x, n5);
        double d5 = VectorSet.vsMin(y, n5);
        double d6 = VectorSet.vsMax(y, n5);
        if (5.0 * plattenstaerke > d4 - d3 || 5.0 * plattenstaerke > d6 - d5) {
            this.errorMsg(myLocale.getString("PlatteIstZuKleinImVerhaeltnisZurDicke"));
            return;
        }
        if (npsoll <= 1) {
            npsoll = 2;
        }
        double d7 = d = Math.sqrt(d2) / (Math.sqrt(npsoll) - 1.0);
        double d8 = Math.sqrt(0.5 * Math.sqrt(3.0));
        d7 *= d8;
        d /= d8;
        double d9 = WPoint3d.umfang(wPoint3dArray, n5);
        if ((double)n5 > d9 / d7) {
            if ((npsoll = (int)((double)npsoll - 2.0 * ((double)n5 - d9 / d7))) <= 1) {
                npsoll = 2;
            }
            d7 = d = Math.sqrt(d2) / (Math.sqrt(npsoll) - 1.0);
        }
        n5 = this.mehrRandPunkte(x, y, n5, d7);
        d3 += d7;
        d5 += d;
        double d10 = 0.5 * d7;
        winkelScaleFactor = 1.0 / d7;
        n2 = n5;
        int n6 = 0;
        while (d3 < d4) {
            for (double d11 = d5 += n6++ % 2 == 0 ? -0.45 * d : 0.45 * d; d11 < d6; d11 += d) {
                if (!Delaunay.inArea(d3, d11, dArray3, dArray4, nrand) || !this.hasMinDist(d3, d11, x, y, n5, d10)) continue;
                PlateVibrationResultPanel.x[n2] = d3;
                PlateVibrationResultPanel.y[n2] = d11;
                ++n2;
            }
            d3 += d7;
        }
        np = n2;
        tria = new Dreieck[np * 2];
        this.statusMsg(myLocale.getString("BerechnungLaeuft"));
        this.setCursor(new Cursor(3));
        this.grafikPanel.setCursor(new Cursor(3));
        nt = new Delaunay().triangulate(x, y, np, n5, tria);
        Smooth.smooth(x, y, np, n5, tria, nt);
        int[] nArray = new int[np];
        int[][] nArray2 = new int[nt][3];
        for (n2 = 0; n2 < nt; ++n2) {
            nArray2[n2][0] = PlateVibrationResultPanel.tria[n2].a;
            nArray2[n2][1] = PlateVibrationResultPanel.tria[n2].c;
            nArray2[n2][2] = PlateVibrationResultPanel.tria[n2].b;
        }
        this.mckee(x, y, nArray2, nArray, nt, n5);
        int n7 = Mckee.bandbreite(nArray2, nt);
        dArray = new double[3 * np][3 * n7];
        dArray2 = new double[3 * np][3 * n7];
        int[] nArray3 = new int[dArray.length];
        this.marks = new int[dArray.length];
        this.systemMatrizen(dArray, dArray2, x, y, nArray2, nt);
        int n8 = this.randbedingungen(dArray, dArray2, n5);
        this.nmarks = Sviten.removeMarkedLinesUpperBand(dArray, dArray2, this.marks, 1.0E-9);
        if (this.nmarks == 0) {
            this.marks = null;
        }
        if (this.nmarks < 3 || n8 <= 2) {
            n2 = dArray.length;
            while (--n2 >= 0) {
                VectorSet.vslinco(dArray[n2], dArray2[n2], 2.0);
            }
        }
        Cholesky.upperToLower(dArray);
        Cholesky.upperToLower(dArray2);
        int n9 = dArray.length - this.nmarks;
        double d12 = 1.0E-4;
        int n10 = 150;
        int n11 = 7;
        int n12 = newcalc;
        boolean bl = false;
        int n13 = bl ? n12 + 2 : n12 + 16;
        if (n13 > n9) {
            n13 = n9;
        }
        if (n12 > n13) {
            n12 = n13;
        }
        newcalc = n12;
        if (bl) {
            n = Sviten.setupToCompact(dArray, dArray2, nArray3, n9);
            dArray5 = Sviten.bandToCompact(dArray, nArray3, n);
            dArray = null;
            dArray6 = Sviten.bandToCompact(dArray2, nArray3, n);
            dArray2 = null;
        }
        if (bl) {
            if (this.ev == null || this.ev.length != n13 || this.ev[0].length != n9) {
                this.ev = new double[n13][n9];
                this.lam = new double[n12];
            }
        } else if (this.ev == null || this.ev.length != n9 || this.ev[0].length != n13) {
            this.ev = new double[n9][n13];
            this.lam = new double[n12];
        }
        StopWatch.start(1);
        if (bl) {
            n3 = Sviten.solve(n9, dArray5, dArray6, nArray3, n12, n13, n10, n11, d12, this.ev, this.lam);
            dArray6 = null;
            dArray5 = null;
        } else {
            n3 = Lanczos.solveBand(dArray, dArray2, n9, n12, 0.0, n13, this.lam, this.ev);
            n2 = this.lam.length;
            while (--n2 >= 0) {
                this.lam[n2] = 1.0 / this.lam[n2];
            }
            this.ev = VectorSet.transpose(this.ev);
        }
        StopWatch.stop(1);
        if (n3 == 0) {
            this.statusMsg(nt + " " + myLocale.getString("Elemente") + ", " + np + " " + myLocale.getString("Knoten") + ", " + myLocale.getString("Bandbreite") + "=" + n7 * 3 + ", " + myLocale.getString("ZeitFuerEigenwertloeser") + StopWatch.ms(1) + "ms");
        } else if (n3 == -1) {
            this.errorMsg(myLocale.getString("EigenwerteNichtBestimmbarSteifigkeitsmatrixIstPositivIndefinit"));
        } else if (n3 == -2) {
            this.errorMsg(myLocale.getString("EigenwerteNichtBestimmbarMassenmatrixIstPositivIndefinit"));
        }
        n2 = this.lam.length;
        while (--n2 >= 0) {
            if (!(this.lam[n2] > 0.0)) continue;
            if (this.nmarks < 3 || n8 <= 2) {
                int n14 = n2;
                this.lam[n14] = this.lam[n14] - 2.0;
                if (this.lam[n2] < 0.0) {
                    this.lam[n2] = 0.0;
                }
            }
            this.lam[n2] = Math.sqrt(this.lam[n2]);
        }
        VectorSet.vsclear(this.lam, 0.01);
        if (this.lam[0] == 0.0 && this.lam[1] == 0.0 && this.lam[2] == 0.0) {
            n = np * 3;
            n2 = 0;
            while (n2 < n) {
                this.ev[0][n2++] = 1.0;
                this.ev[0][n2++] = 0.0;
                this.ev[0][n2++] = 0.0;
            }
            Gauss.orthoNormalize(this.ev, 3);
        }
        this.backpermute(np, nArray, x, y, nArray2, nt);
        if (n3 < 0) {
            T = null;
        } else {
            T = new double[np];
            this.setCurrentDataArray();
        }
        Graph3d.limitMax = 0.0;
        Graph3d.limitMin = 0.0;
        this.setCursor(Cursor.getDefaultCursor());
        this.grafikPanel.setCursor(Cursor.getDefaultCursor());
        dontShow = false;
        this.grafikPanel.repaint();
    }

    static int dreieckElem(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, double d) {
        int n;
        int n2;
        double d2;
        double d3 = dArray3[1] - dArray3[0];
        double d4 = dArray3[0] - dArray3[2];
        double d5 = dArray3[2] - dArray3[1];
        double d6 = dArray4[1] - dArray4[0];
        double d7 = dArray4[0] - dArray4[2];
        double d8 = dArray4[2] - dArray4[1];
        double d9 = -d7;
        double d10 = -d4;
        double d11 = d3 * d9 - d10 * d6;
        if (d11 < 0.0) {
            return -1;
        }
        double d12 = d10 * d10;
        double d13 = d3 * d3;
        double d14 = d9 * d9;
        double d15 = d6 * d6;
        double d16 = d15 + d13;
        double d17 = d14 + d12;
        double d18 = d8 * d8 + d5 * d5;
        double d19 = d3 / d16;
        double d20 = d5 / d18;
        double d21 = d4 / d17;
        double d22 = d6 / d16;
        double d23 = d8 / d18;
        double d24 = d7 / d17;
        double d25 = (d13 * 0.25 - d15 * 0.5) / d16;
        double d26 = (d5 * d5 * 0.25 - d8 * d8 * 0.5) / d18;
        double d27 = (d12 * 0.25 - d14 * 0.5) / d17;
        double d28 = (d13 * 0.5 - d15 * 0.25) / d16;
        double d29 = (d5 * d5 * 0.5 - d8 * d8 * 0.25) / d18;
        double d30 = (d12 * 0.5 - d14 * 0.25) / d17;
        double d31 = 0.75 * d3 * d6 / d16;
        double d32 = 0.75 * d5 * d8 / d18;
        double d33 = 0.75 * d4 * d7 / d17;
        double[][] dArray5 = new double[12][9];
        double[][] dArray6 = new double[12][9];
        double[][] dArray7 = new double[12][12];
        double[] dArray8 = a[0];
        double[] dArray9 = a[1];
        double[] dArray10 = a[2];
        double[] dArray11 = a[3];
        double[] dArray12 = a[4];
        double[] dArray13 = a[5];
        double d34 = EM * d * d * d / (12.0 * (1.0 - NUE * NUE));
        double d35 = d2 = d34 / d11;
        double d36 = d35 * NUE;
        double d37 = 0.5 * (1.0 - NUE) * d35;
        for (n2 = 0; n2 < 6; ++n2) {
            double[] dArray14 = dArray5[n2 + 6];
            dArray14[0] = 1.5 * (d24 * dArray13[n2] - d22 * dArray11[n2]);
            dArray14[2] = dArray8[n2] + d30 * dArray13[n2] + d28 * dArray11[n2];
            dArray14[1] = -(d33 * dArray13[n2] + d31 * dArray11[n2]);
            dArray14[3] = 1.5 * (d22 * dArray11[n2] - d23 * dArray12[n2]);
            dArray14[5] = dArray9[n2] + d29 * dArray12[n2] + d28 * dArray11[n2];
            dArray14[4] = -(d32 * dArray12[n2] + d31 * dArray11[n2]);
            dArray14[6] = 1.5 * (d23 * dArray12[n2] - d24 * dArray13[n2]);
            dArray14[8] = dArray10[n2] + d29 * dArray12[n2] + d30 * dArray13[n2];
            dArray14[7] = -(d32 * dArray12[n2] + d33 * dArray13[n2]);
            dArray14 = dArray5[n2];
            dArray14[0] = 1.5 * (d19 * dArray11[n2] - d21 * dArray13[n2]);
            dArray14[2] = d33 * dArray13[n2] + d31 * dArray11[n2];
            dArray14[1] = -(dArray8[n2] - d27 * dArray13[n2] - d25 * dArray11[n2]);
            dArray14[3] = 1.5 * (d20 * dArray12[n2] - d19 * dArray11[n2]);
            dArray14[5] = d32 * dArray12[n2] + d31 * dArray11[n2];
            dArray14[4] = -(dArray9[n2] - d26 * dArray12[n2] - d25 * dArray11[n2]);
            dArray14[6] = 1.5 * (d21 * dArray13[n2] - d20 * dArray12[n2]);
            dArray14[8] = d32 * dArray12[n2] + d33 * dArray13[n2];
            dArray14[7] = -(dArray10[n2] - d26 * dArray12[n2] - d27 * dArray13[n2]);
        }
        for (n = 0; n < 6; ++n) {
            double[] dArray15 = dArray7[n];
            double[] dArray16 = i1[n];
            double[] dArray17 = i2[n];
            double[] dArray18 = i3[n];
            double[] dArray19 = i4[n];
            for (n2 = n; n2 < 6; ++n2) {
                dArray15[n2] = (d14 * dArray16[n2] - d9 * d6 * (dArray17[n2] + dArray18[n2]) + d15 * dArray19[n2]) * d35 + (d12 * dArray16[n2] - d10 * d3 * (dArray17[n2] + dArray18[n2]) + d13 * dArray19[n2]) * d37;
            }
            for (n2 = 0; n2 < 6; ++n2) {
                dArray15[n2 + 6] = (d9 * d10 * dArray16[n2] - d9 * d3 * dArray17[n2] - d10 * d6 * dArray18[n2] + d6 * d3 * dArray19[n2]) * d36 + (d10 * d9 * dArray16[n2] - d10 * d6 * dArray17[n2] - d9 * d3 * dArray18[n2] + d3 * d6 * dArray19[n2]) * d37;
            }
            dArray15 = dArray7[n + 6];
            for (n2 = n; n2 < 6; ++n2) {
                dArray15[n2 + 6] = (d12 * dArray16[n2] - d10 * d3 * (dArray17[n2] + dArray18[n2]) + d13 * dArray19[n2]) * d2 + (d14 * dArray16[n2] - d9 * d6 * (dArray17[n2] + dArray18[n2]) + d15 * dArray19[n2]) * d37;
            }
        }
        for (n = 0; n < 12; ++n) {
            for (n2 = 0; n2 < n; ++n2) {
                dArray7[n][n2] = dArray7[n2][n];
            }
        }
        Kondensation.transform(dArray, dArray7, dArray6, dArray5);
        PlateVibrationResultPanel.elemMassMatrix(dArray2, dArray3, dArray4, d);
        return 0;
    }

    static int elemMassMatrix(double[][] dArray, double[] dArray2, double[] dArray3, double d) {
        double d2;
        int n;
        int n2;
        double[] dArray4;
        double d3 = dArray2[1] - dArray2[0];
        double d4 = dArray2[2] - dArray2[1];
        double d5 = dArray2[2] - dArray2[0];
        double d6 = dArray3[1] - dArray3[0];
        double d7 = dArray3[2] - dArray3[1];
        double d8 = dArray3[2] - dArray3[0];
        double d9 = d3 * d3 + d6 * d6;
        double d10 = d5 * d5 + d8 * d8;
        double d11 = d4 * d4 + d7 * d7;
        double[] dArray5 = new double[9];
        double[] dArray6 = dArray4 = new double[9];
        double[] dArray7 = new double[]{3.0 * (d9 - d10) / d11, 3.0 * (d11 - d9) / d10, 3.0 * (d10 - d11) / d9};
        double[][] dArrayArray = new double[][]{{1.0, 0.0, 0.0, -1.0, 0.0, 1.0, 2.0, 0.0, -2.0}, {0.0, 0.0, 0.0, 0.0, 0.0, d5, d3, 0.0, -d5}, {0.0, 0.0, 0.0, 0.0, 0.0, d8, d6, 0.0, -d8}, {0.0, 1.0, 0.0, 1.0, -1.0, 0.0, -2.0, 2.0, 0.0}, {0.0, 0.0, 0.0, -d3, 0.0, 0.0, d3, d4, 0.0}, {0.0, 0.0, 0.0, -d6, 0.0, 0.0, d6, d7, 0.0}, {0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.0, -2.0, 2.0}, {0.0, 0.0, 0.0, 0.0, -d4, 0.0, 0.0, d4, -d5}, {0.0, 0.0, 0.0, 0.0, -d7, 0.0, 0.0, d7, -d8}};
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n <= n2; ++n) {
                dArray[n2][n] = 0.0;
            }
        }
        int n3 = gaussPunkteW.length;
        while (--n3 >= 0) {
            dArray6[0] = gaussPunkteL2[n3];
            dArray6[1] = gaussPunkteL1[n3];
            dArray6[2] = 1.0 - dArray6[0] - dArray6[1];
            double d12 = dArray6[0] * dArray6[1] * dArray6[2] * 0.5;
            dArray4[3] = dArray6[0] * dArray6[1];
            dArray4[4] = dArray6[1] * dArray6[2];
            dArray4[5] = dArray6[2] * dArray6[0];
            dArray4[6] = dArray6[1] * dArray6[0] * dArray6[0] + d12 * ((3.0 - dArray7[2]) * dArray6[0] + (1.0 + dArray7[2]) * (dArray6[2] - dArray6[1]));
            dArray4[7] = dArray6[2] * dArray6[1] * dArray6[1] + d12 * ((3.0 - dArray7[0]) * dArray6[1] - (1.0 + dArray7[0]) * (dArray6[0] - dArray6[2]));
            dArray4[8] = dArray6[0] * dArray6[2] * dArray6[2] + d12 * ((3.0 - dArray7[1]) * dArray6[2] - (1.0 + dArray7[1]) * (dArray6[1] - dArray6[0]));
            for (n2 = 0; n2 < 9; ++n2) {
                dArray5[n2] = VectorSet.vsdot(dArrayArray[n2], dArray4);
            }
            for (n2 = 0; n2 < 9; ++n2) {
                d2 = dArray5[n2] * gaussPunkteW[n3];
                for (n = 0; n <= n2; ++n) {
                    double[] dArray8 = dArray[n2];
                    int n4 = n;
                    dArray8[n4] = dArray8[n4] + dArray5[n] * d2;
                }
            }
        }
        d2 = d * rho * (d3 * d8 - d5 * d6);
        for (n2 = 0; n2 < 9; ++n2) {
            for (n = 0; n <= n2; ++n) {
                double[] dArray9 = dArray[n2];
                int n5 = n;
                dArray9[n5] = dArray9[n5] * d2;
                dArray[n][n2] = dArray[n2][n];
            }
        }
        return 0;
    }

    void winkelAnpassen(double[][] dArray, double[][] dArray2) {
        int n;
        double[] dArray3;
        double[] dArray4;
        int n2;
        int n3 = dArray[0].length;
        int n4 = dArray.length;
        for (n2 = 0; n2 < n4; ++n2) {
            dArray4 = dArray2[n2];
            dArray3 = dArray[n2];
            for (n = 0; n <= n2; ++n) {
                if (n % 3 == 0) continue;
                int n5 = n;
                dArray4[n5] = dArray4[n5] * winkelScaleFactor;
                int n6 = n;
                dArray3[n6] = dArray3[n6] * winkelScaleFactor;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 % 3 == 0) continue;
            dArray4 = dArray2[n2];
            dArray3 = dArray[n2];
            n = 0;
            while (n <= n2) {
                int n7 = n;
                dArray4[n7] = dArray4[n7] * winkelScaleFactor;
                int n8 = n++;
                dArray3[n8] = dArray3[n8] * winkelScaleFactor;
            }
        }
        for (n2 = 0; n2 < n4; ++n2) {
            for (n = 0; n < n2; ++n) {
                dArray2[n][n2] = dArray2[n2][n];
                dArray[n][n2] = dArray[n2][n];
            }
        }
    }

    int systemMatrizen(double[][] dArray, double[][] dArray2, double[] dArray3, double[] dArray4, int[][] nArray, int n) {
        int[] nArray2 = new int[]{0, 3, 6, 1, 4, 7, 2, 5, 8};
        int n2 = 3;
        double[][] dArray5 = new double[9][9];
        double[][] dArray6 = new double[9][9];
        double[] dArray7 = new double[3];
        double[] dArray8 = new double[3];
        double d = plattenstaerke;
        for (int i = 0; i < n; ++i) {
            int[] nArray3 = nArray[i];
            int n3 = nArray3[0];
            int n4 = nArray3[1];
            int n5 = nArray3[2];
            dArray7[0] = dArray3[n3];
            dArray8[0] = dArray4[n3];
            dArray7[1] = dArray3[n4];
            dArray8[1] = dArray4[n4];
            dArray7[2] = dArray3[n5];
            dArray8[2] = dArray4[n5];
            int n6 = PlateVibrationResultPanel.dreieckElem(dArray5, dArray6, dArray7, dArray8, d);
            if (n6 < 0) {
                return 1;
            }
            this.winkelAnpassen(dArray5, dArray6);
            for (int j = 0; j < 9; ++j) {
                int n7 = j % n2;
                int n8 = nArray3[n7] * 3 + j / n2;
                int n9 = nArray2[j];
                double[] dArray9 = dArray5[n9];
                double[] dArray10 = dArray6[n9];
                double[] dArray11 = dArray[n8];
                double[] dArray12 = dArray2[n8];
                for (int k = 0; k < 9; ++k) {
                    int n10 = k % n2;
                    int n11 = nArray3[n10] * 3 + k / n2;
                    int n12 = n11 - n8;
                    if (n12 < 0) continue;
                    int n13 = nArray2[k];
                    int n14 = n12;
                    dArray11[n14] = dArray11[n14] + dArray9[n13];
                    int n15 = n12;
                    dArray12[n15] = dArray12[n15] + dArray10[n13];
                }
            }
        }
        return 0;
    }

    double deltaAngle(double d, double d2) {
        double d3 = d - d2;
        if (d3 > Math.PI) {
            d3 -= Math.PI * 2;
        } else if (d3 < -Math.PI) {
            d3 += Math.PI * 2;
        }
        return d3;
    }

    void eineNeigungZuNull(double[][] dArray, double[][] dArray2, int n, double d, double d2) {
        int n2;
        int n3 = dArray[0].length;
        int n4 = n + 1;
        double d3 = dArray[n][0];
        double d4 = dArray[n][1];
        double d5 = dArray[n4][0];
        double d6 = dArray2[n][0];
        double d7 = dArray2[n][1];
        double d8 = dArray2[n4][0];
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n][n2] = d * dArray[n][n2] + d2 * dArray[n4][n2 - 1];
            dArray2[n][n2] = d * dArray2[n][n2] + d2 * dArray2[n4][n2 - 1];
        }
        n2 = 1;
        while (n2 + 1 < n3 && n - n2 >= 0) {
            int n5 = n - n2;
            dArray[n5][n2] = d * dArray[n5][n2] + d2 * dArray[n5][n2 + 1];
            dArray2[n5][n2] = d * dArray2[n5][n2] + d2 * dArray2[n5][n2 + 1];
            ++n2;
        }
        dArray[n][0] = d * d * d3 + 2.0 * d * d2 * d4 + d2 * d2 * d5;
        dArray2[n][0] = d * d * d6 + 2.0 * d * d2 * d7 + d2 * d2 * d8;
        this.markLine(dArray, dArray2, n4);
    }

    void markLine(double[][] dArray, double[][] dArray2, int n) {
        int n2;
        int n3 = dArray[0].length;
        for (n2 = 1; n2 < n3; ++n2) {
            dArray[n][n2] = 0.0;
            dArray2[n][n2] = 0.0;
        }
        for (n2 = 1; n2 < n3 && n - n2 >= 0; ++n2) {
            dArray[n - n2][n2] = 0.0;
            dArray2[n - n2][n2] = 0.0;
        }
        dArray[n][0] = 1.0;
        dArray2[n][0] = 1.0E-9;
    }

    void meanDirection(double d, double d2, double[] dArray) {
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        dArray[0] = 0.5 * (d3 + d5);
        dArray[1] = 0.5 * (d4 + d6);
    }

    int randbedingungen(double[][] dArray, double[][] dArray2, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        double d = 0.7853981633974483;
        int[] nArray = new int[n];
        double[] dArray3 = new double[n];
        double[] dArray4 = new double[2];
        int n9 = 0;
        for (n8 = 0; n8 < nrb; ++n8) {
            n7 = PlateVibrationResultPanel.rand[n8].mode;
            n6 = this.randpunktIndizes[PlateVibrationResultPanel.rand[n8].n2];
            n5 = this.randpunktIndizes[PlateVibrationResultPanel.rand[n8].n1];
            if (n6 < n5) {
                n6 += n;
            }
            for (n4 = n5; n4 < n6; ++n4) {
                n3 = PlateVibrationResultPanel.toMcKee(n4 % n);
                int n10 = PlateVibrationResultPanel.toMcKee((n4 + 1) % n);
                double d2 = x[n10] - x[n3];
                double d3 = y[n10] - y[n3];
                n2 = (n4 + 1) % n;
                dArray3[n2] = GrPanel.winkel(d2, d3);
                nArray[n2] = n7 << 4;
            }
        }
        for (n5 = 0; n5 < 3; ++n5) {
            for (n8 = 0; n8 < nrb; ++n8) {
                int n11;
                double d4;
                boolean bl;
                int n12;
                int n13;
                n7 = PlateVibrationResultPanel.rand[n8].mode;
                if (n7 == 0 || n5 == 0 && n7 != 3 || n5 == 1 && n7 != 1 || n5 == 2 && n7 != 2) continue;
                int n14 = this.randpunktIndizes[PlateVibrationResultPanel.rand[n8].n2];
                n6 = this.randpunktIndizes[PlateVibrationResultPanel.rand[n8].n1];
                if (n14 < n6) {
                    n14 += n;
                }
                if (n6 == n14) {
                    n3 = PlateVibrationResultPanel.toMcKee(n6 % n);
                    n13 = n3 * 3;
                    if ((n7 & 1) != 0) {
                        this.markLine(dArray, dArray2, n13);
                    }
                    if ((n7 & 2) == 0) continue;
                    this.markLine(dArray, dArray2, n13 + 1);
                    this.markLine(dArray, dArray2, n13 + 2);
                    continue;
                }
                for (n4 = n6; n4 <= n14; ++n4) {
                    n3 = PlateVibrationResultPanel.toMcKee(n4 % n);
                    n13 = n3 * 3;
                    n12 = n4 % n;
                    n2 = (n4 + 1) % n;
                    if ((nArray[n12] & 2) != 0 || (n7 & 1) == 0) continue;
                    bl = false;
                    this.markLine(dArray, dArray2, n13);
                    if ((nArray[n12] & 0x10) == 0) {
                        bl = true;
                        this.meanDirection(dArray3[n2], dArray3[n2], dArray4);
                    } else if ((nArray[n2] & 0x10) == 0) {
                        bl = true;
                        this.meanDirection(dArray3[n12], dArray3[n12], dArray4);
                    } else {
                        this.meanDirection(dArray3[n12], dArray3[n2], dArray4);
                    }
                    d4 = Math.abs(this.deltaAngle(dArray3[n12], dArray3[n2]));
                    if ((d4 < d || bl) && (n7 & 2) == 0) {
                        n11 = n13 + 1;
                        this.eineNeigungZuNull(dArray, dArray2, n11, -dArray4[1], dArray4[0]);
                    } else {
                        this.markLine(dArray, dArray2, n13 + 1);
                        this.markLine(dArray, dArray2, n13 + 2);
                        int n15 = n12;
                        nArray[n15] = nArray[n15] | 4;
                    }
                    int n16 = n12;
                    nArray[n16] = nArray[n16] | 2;
                    if (!(d4 > 0.001)) continue;
                    ++n9;
                }
                for (n4 = n6; n4 <= n14; ++n4) {
                    n3 = PlateVibrationResultPanel.toMcKee(n4 % n);
                    n13 = n3 * 3;
                    n12 = n4 % n;
                    n2 = (n4 + 1) % n;
                    if ((n7 & 2) == 0 || (nArray[n12] & 4) != 0) continue;
                    bl = false;
                    n11 = n13 + 1;
                    d4 = Math.abs(this.deltaAngle(dArray3[n12], dArray3[n2]));
                    if ((nArray[n12] & 2) != 0) {
                        if (!(d4 < 0.9424777960769379) && !(d4 > 2.199114857512855)) continue;
                        this.markLine(dArray, dArray2, n13 + 1);
                        this.markLine(dArray, dArray2, n13 + 2);
                        int n17 = n12;
                        nArray[n17] = nArray[n17] | 4;
                        continue;
                    }
                    if ((nArray[n12] & 0x20) == 0) {
                        bl = true;
                        this.meanDirection(dArray3[n2], dArray3[n2], dArray4);
                    } else if ((nArray[n2] & 0x20) == 0) {
                        bl = true;
                        this.meanDirection(dArray3[n12], dArray3[n12], dArray4);
                    } else {
                        this.meanDirection(dArray3[n12], dArray3[n2], dArray4);
                    }
                    if ((nArray[n12] & 8) != 0) continue;
                    int n18 = n12;
                    nArray[n18] = nArray[n18] | 8;
                    if (d4 < d || bl) {
                        this.eineNeigungZuNull(dArray, dArray2, n11, dArray4[0], dArray4[1]);
                        continue;
                    }
                    this.markLine(dArray, dArray2, n13 + 1);
                    this.markLine(dArray, dArray2, n13 + 2);
                    int n19 = n12;
                    nArray[n19] = nArray[n19] | 4;
                }
            }
        }
        return n9;
    }

    static void permute(int n, int[] nArray, double[] dArray, double[] dArray2) {
        int n2;
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            while (nArray[n2] != n2) {
                int n3 = nArray[n2];
                double d = dArray2[n3];
                dArray2[n3] = dArray2[n2];
                dArray2[n2] = d;
                d = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d;
                int n4 = nArray2[n3];
                nArray2[n3] = nArray2[n2];
                nArray2[n2] = n4;
                nArray[n2] = nArray[n3];
                nArray[n3] = n3;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = nArray2[n2];
        }
    }

    void backpermute(int n, int[] nArray, double[] dArray, double[] dArray2, int[][] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = nArray2[i][j];
                if (n3 < 0) continue;
                nArray2[i][j] = nArray[n3];
            }
        }
        PlateVibrationResultPanel.permute(n, nArray, dArray, dArray2);
    }

    void eigenVectorBackpermute(double[] dArray) {
        if (permbw == null) {
            return;
        }
        int[] nArray = (int[])permbw.clone();
        for (int i = 0; i < np; ++i) {
            while (nArray[i] != i) {
                int n = nArray[i];
                double d = dArray[n];
                dArray[n] = dArray[i];
                dArray[i] = d;
                nArray[i] = nArray[n];
                nArray[n] = n;
            }
        }
    }

    void mckee(double[] dArray, double[] dArray2, int[][] nArray, int[] nArray2, int n, int n2) {
        int n3 = Math.min(np, n2) / 8;
        if (n3 == 0) {
            n3 = 1;
        }
        Mckee.setdata(np, n, -n3, 3, nArray, null, null, nArray2);
        Mckee.findoptimum();
        permfw = (int[])nArray2.clone();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n4 = nArray[i][j];
                if (n4 < 0) continue;
                nArray[i][j] = nArray2[n4];
            }
        }
        PlateVibrationResultPanel.permute(np, nArray2, dArray, dArray2);
        permbw = (int[])nArray2.clone();
    }

    void setCurrentDataArray() {
        double d;
        int n = this.nrtf.getInt();
        double d2 = 0.0;
        if (T == null || this.lam == null) {
            return;
        }
        if (n < 1) {
            n = 1;
            this.nrtf.setText("" + n);
        }
        if (n > this.lam.length) {
            n = this.lam.length;
            this.nrtf.setText("" + n);
        }
        this.ewtf.setText(NumEdit.toPrecision(d, (d = this.lam[--n] / (Math.PI * 2)) < 1000.0 ? 3 : 4));
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = np * 3;
        double[] dArray = this.ev[n];
        for (n4 = 0; n4 < n6; ++n4) {
            if (this.marks != null && n4 == this.marks[n2]) {
                if (n4 % 3 == 0) {
                    PlateVibrationResultPanel.T[n5++] = 0.0;
                }
                ++n2;
                continue;
            }
            if (n4 % 3 == 0) {
                PlateVibrationResultPanel.T[n5] = dArray[n3];
                if (Math.abs(T[n5]) > Math.abs(d2)) {
                    d2 = T[n5];
                }
                ++n5;
            }
            ++n3;
        }
        if (d2 < 0.0) {
            VectorSet.vsscale(T, -1.0);
        }
        this.eigenVectorBackpermute(T);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.c1) {
            showElementGrid = this.c1.isSelected();
        } else if (itemEvent.getSource() == this.c3) {
            is3d = this.c3.isSelected();
        } else {
            this.setCurrentDataArray();
        }
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Graph3d.limitMax = 0.0;
        Graph3d.limitMin = 0.0;
        if (actionEvent.getSource() == this.downJButton) {
            int n = this.nrtf.getInt();
            if (n > 1) {
                this.nrtf.setText("" + --n);
            }
        } else if (actionEvent.getSource() == this.upJButton) {
            int n = this.nrtf.getInt();
            if (n < newcalc) {
                this.nrtf.setText("" + ++n);
            }
        } else if (actionEvent.getSource() == startJButton) {
            if (PlateVibrationGrafikPanel.isRunning) {
                PlateVibration.labelStore.setButtonText(startJButton, "AnimationAn");
                currGrPan.stop();
            } else {
                PlateVibration.labelStore.setButtonText(startJButton, "AnimationAus");
                is3d = true;
                this.c3.setSelected(true);
                currGrPan.init();
            }
        }
        if (actionEvent.getSource() == npsolltf || actionEvent.getSource() == newtf) {
            npsoll = npsolltf.getInt();
            if (npsoll > 1000) {
                npsoll = 1000;
                npsolltf.setText("" + npsoll);
            } else if (npsoll < 12) {
                npsoll = 12;
                npsolltf.setText("" + npsoll);
            }
            newcalc = newtf.getInt();
            if (newcalc * npsoll > 15000) {
                newcalc = 15000 / npsoll;
                newtf.setText("" + newcalc);
            } else if (newcalc < 1) {
                newcalc = 1;
                newtf.setText("" + newcalc);
            }
            this.pointsAndTriangulation();
        } else {
            this.setCurrentDataArray();
        }
        if (actionEvent.getSource() == emodultf) {
            EM = emodultf.getDouble();
            this.pointsAndTriangulation();
        }
        if (actionEvent.getSource() == nuetf) {
            NUE = nuetf.getDouble();
            if (NUE > 0.9) {
                NUE = 0.9;
                nuetf.setText("" + NUE);
            } else if (NUE < 0.0) {
                NUE = 0.0;
                nuetf.setText("" + NUE);
            }
            this.pointsAndTriangulation();
        }
        if (actionEvent.getSource() == dicketf) {
            plattenstaerke = dicketf.getDouble();
            this.pointsAndTriangulation();
        }
        if (actionEvent.getSource() == dichtetf) {
            rho = dichtetf.getDouble();
            this.pointsAndTriangulation();
        }
        super.actionPerformed(actionEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        dontShow = true;
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.pointsAndTriangulation();
    }

    static {
        currFile = null;
        x = null;
        y = null;
        tria = null;
        rand = new Rand[10];
        showElementGrid = false;
        showNodeNumbers = false;
        is3d = false;
        NUE = 0.3;
        EM = 2.1E11;
        rho = 7800.0;
        plattenstaerke = 0.01;
        winkelScaleFactor = 1.0;
        dontShow = true;
        permbw = null;
        permfw = null;
        i1 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.3333333333333333, 0.16666666666666666, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.3333333333333333, 0.0, 0.3333333333333333, 0.08333333333333333, 0.0}, {0.0, 0.16666666666666666, 0.0, 0.08333333333333333, 0.08333333333333333, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        i4 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.5, 0.0, 0.16666666666666666, 0.3333333333333333}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.16666666666666666, 0.0, 0.08333333333333333, 0.08333333333333333}, {0.0, 0.0, 0.3333333333333333, 0.0, 0.08333333333333333, 0.3333333333333333}};
        i3 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.5, 0.0, 0.3333333333333333, 0.16666666666666666, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.16666666666666666, 0.0, 0.16666666666666666, 0.041666666666666664, 0.0}, {0.0, 0.3333333333333333, 0.0, 0.16666666666666666, 0.16666666666666666, 0.0}};
        i2 = new double[][]{{0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.5, 0.0, 0.16666666666666666, 0.3333333333333333}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.3333333333333333, 0.0, 0.16666666666666666, 0.16666666666666666}, {0.0, 0.0, 0.16666666666666666, 0.0, 0.041666666666666664, 0.16666666666666666}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
        a = new double[][]{{1.0, -3.0, -3.0, 2.0, 4.0, 2.0}, {0.0, -1.0, 0.0, 2.0, 0.0, 0.0}, {0.0, 0.0, -1.0, 0.0, 0.0, 2.0}, {0.0, 4.0, 0.0, -4.0, -4.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 4.0, 0.0}, {0.0, 0.0, 4.0, 0.0, -4.0, -4.0}};
        gaussPunkteL1 = new double[]{0.333333333, 0.470142064, 0.059715872, 0.470142064, 0.101286507, 0.797426985, 0.101286507};
        gaussPunkteL2 = new double[]{0.333333333, 0.470142064, 0.470142064, 0.059715872, 0.101286507, 0.101286507, 0.797426985};
        gaussPunkteW = new double[]{0.1125, 0.0661970764, 0.0661970764, 0.0661970764, 0.0629695903, 0.0629695903, 0.0629695903};
    }

    static class Rand {
        int n1;
        int n2;
        int mode;

        Rand(int n, int n2, int n3) {
            this.n1 = n;
            this.n2 = n2;
            this.mode = n3;
        }
    }
}

