/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

class PlateVibrationGrafikPanel
extends Graph3d
implements Runnable {
    static Thread simuThread = null;
    static boolean isRunning = false;
    static double t;
    static double dt;
    int mouseDraggIndex = -1;

    public void init() {
        if (!isRunning) {
            PlateVibrationGrafikPanel.initData();
            simuThread = new Thread(this);
            simuThread.setDaemon(true);
            simuThread.start();
        }
    }

    static void initData() {
        dt = 0.05;
    }

    void timer() {
        t += dt;
    }

    @Override
    public void run() {
        isRunning = true;
        while (isRunning) {
            try {
                this.timer();
                if (PlateVibrationResultPanel.is3d && PlateVibration.currpan == 2) {
                    this.repaint();
                }
                Thread.sleep((int)(dt * 1000.0));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        isRunning = false;
        t = 0.0;
    }

    void allIsolines() {
        this.allIsolines(PlateVibrationResultPanel.T, PlateVibrationResultPanel.x, PlateVibrationResultPanel.y, PlateVibrationResultPanel.tria, PlateVibrationResultPanel.nt, PlateVibrationResultPanel.showElementGrid);
    }

    void d3display(double d, double d2) {
        double[] dArray = PlateVibrationResultPanel.T;
        if (dArray == null) {
            return;
        }
        double[] dArray2 = PlateVibrationResultPanel.x;
        double[] dArray3 = PlateVibrationResultPanel.y;
        double[] dArray4 = new double[dArray.length];
        Dreieck[] dreieckArray = PlateVibrationResultPanel.tria;
        this.setTransform((double)angleX * Math.PI / 180.0, (double)angleZ * Math.PI / 180.0);
        double[] dArray5 = new double[2];
        VectorSet.vsMinMax(dArray2, dArray5);
        double d3 = dArray5[0];
        double d4 = dArray5[1];
        VectorSet.vsMinMax(dArray3, dArray5);
        double d5 = dArray5[0];
        double d6 = dArray5[1];
        VectorSet.vsMinMax(dArray, dArray5);
        double d7 = dArray5[1] - dArray5[0];
        d4 -= d3;
        d6 -= d5;
        if (d6 > d4) {
            d4 = d6;
        }
        double d8 = Math.abs(d7) > 1.0E-10 ? d * d4 / d7 : 1.0;
        VectorSet.vsscale(dArray4, dArray, d8);
        this.w3setMinMax(dArray2, dArray3, dArray4);
        if (d2 != 0.0) {
            VectorSet.vsscale(dArray4, Math.cos(1.5 * d2));
        }
        this.drawTrianglesShaded(dreieckArray, dArray2, dArray3, dArray4, PlateVibrationResultPanel.nt, PlateVibrationResultPanel.showElementGrid);
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        Color color = PlateVibrationGrafikPanel.newColor(75, 75, 75);
        Color color2 = PlateVibrationGrafikPanel.newColor(110, 110, 110);
        Color color3 = PlateVibrationGrafikPanel.newColor(185, 185, 185);
        Color color4 = PlateVibrationGrafikPanel.newColor(145, 145, 145);
        Color color5 = PlateVibrationGrafikPanel.newColor(111, 125, 137);
        boolean bl = PlateVibrationResultPanel.is3d;
        WPoint3d[] wPoint3dArray = PlateVibrationPunktePanel.pp;
        boolean[] blArray = PlateVibrationPunktePanel.isNode;
        this.myg = graphics;
        int n2 = Math.abs(GR_W - this.getSize().width);
        if (n2 > 50) {
            GR_W = this.getSize().width;
        }
        if (!bl || PlateVibration.currpan != 2) {
            this.setTransform(0.0, 0.0);
            if (this.mouseDraggIndex < 0) {
                this.setMinMax(wPoint3dArray);
            }
        }
        this.myg.setColor(color5);
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Polygon polygon = new Polygon();
        this.myg.setColor(color);
        int n3 = 0;
        int n4 = PlateVibrationPunktePanel.tfx.length;
        while (--n4 >= 0) {
            if (!blArray[n4]) continue;
            if (PlateVibration.currpan != 2) {
                polygon.addPoint(this.screenx(wPoint3dArray[n3]), this.screeny(wPoint3dArray[n3]));
            }
            ++n3;
        }
        PlateVibrationResultPanel.nrand = n3;
        if (!bl || PlateVibration.currpan != 2) {
            this.myg.setColor(color2);
            this.myg.fillPolygon(polygon);
            this.myg.setColor(color4);
            this.grid();
            this.myg.setColor(color3);
            this.axes();
            this.myg.setColor(color);
            this.myg.drawPolygon(polygon);
        }
        if (n3 == 0) {
            return;
        }
        if (PlateVibration.currpan == 1 || PlateVibration.currpan == 3) {
            ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            block6: for (n = 0; n < PlateVibrationResultPanel.nrb; ++n) {
                int n5 = PlateVibrationResultPanel.rand[n].n1;
                int n6 = PlateVibrationResultPanel.rand[n].n2;
                switch (PlateVibrationResultPanel.rand[n].mode) {
                    case 1: {
                        this.myg.setColor(Color.blue);
                        break;
                    }
                    case 2: {
                        this.myg.setColor(Color.green);
                        break;
                    }
                    case 3: {
                        this.myg.setColor(Color.cyan);
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                if (n6 < n5) {
                    n6 += n3;
                }
                for (n4 = n5; n4 < n6; ++n4) {
                    int n7 = n4 % n3;
                    int n8 = (n4 + 1) % n3;
                    this.wMoveTo(wPoint3dArray[n7].x, wPoint3dArray[n7].y);
                    this.wLineTo2(wPoint3dArray[n8].x, wPoint3dArray[n8].y);
                }
            }
        }
        if (PlateVibration.currpan == 2 && !bl) {
            if (PlateVibrationResultPanel.dontShow) {
                return;
            }
            if (PlateVibrationResultPanel.T != null) {
                this.allIsolines();
            }
            this.showPallete();
        } else if (PlateVibration.currpan == 2 && bl) {
            this.d3display(0.2, t);
        } else {
            this.myg.setColor(Color.yellow);
            n = wPoint3dArray.length;
            while (--n >= 0) {
                if (!blArray[n]) continue;
                this.myg.fillOval(this.screenx(wPoint3dArray[n]) - 2, this.screeny(wPoint3dArray[n]) - 2, 4, 4);
                this.myg.drawString("" + (n + 1), this.screenx(wPoint3dArray[n]) + 2, this.screeny(wPoint3dArray[n]) - 2);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (PlateVibration.currpan == 0) {
            boolean[] blArray = PlateVibrationPunktePanel.isNode;
            WPoint3d[] wPoint3dArray = PlateVibrationPunktePanel.pp;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.mouseDraggIndex < 0) {
                int n3 = wPoint3dArray.length;
                while (--n3 >= 0) {
                    int n4;
                    if (!blArray[n3] || (n4 = Math.abs(this.screenx(wPoint3dArray[n3].x) - n) + Math.abs(this.screeny(wPoint3dArray[n3].y) - n2)) >= 10) continue;
                    this.mouseDraggIndex = n3;
                    break;
                }
            }
            if (this.mouseDraggIndex >= 0) {
                PlateVibrationPunktePanel.tfx[this.mouseDraggIndex].setValue(this.worldx(n), 2);
                PlateVibrationPunktePanel.tfy[this.mouseDraggIndex].setValue(this.worldy(n2), 2);
                PlateVibrationPunktePanel.auslesen();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDraggIndex >= 0) {
            this.mouseDraggIndex = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (PlateVibration.currpan != 0) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed()) {
            mouseEvent.consume();
            boolean[] blArray = PlateVibrationPunktePanel.isNode;
            WPoint3d[] wPoint3dArray = PlateVibrationPunktePanel.pp;
            for (int i = 0; i < wPoint3dArray.length; ++i) {
                if (blArray[i]) continue;
                wPoint3dArray[i].x = this.worldx(mouseEvent.getX());
                wPoint3dArray[i].y = this.worldy(mouseEvent.getY());
                PlateVibrationPunktePanel.tfx[i].setValue(wPoint3dArray[i].x, 2);
                PlateVibrationPunktePanel.tfy[i].setValue(wPoint3dArray[i].y, 2);
                blArray[i] = true;
                this.repaint();
                break;
            }
        }
    }

    PlateVibrationGrafikPanel() {
        angleX = 290;
        angleZ = 316;
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        isRunning = false;
    }
}

