/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultHighlighter;

class PlaneStressFEMResultPanel
extends DekorPanel {
    static int npsoll = 500;
    JTextArea txarea;
    JCheckBox c1 = PlaneStressFEM.labelStore.newCheckBox("Netzdarstellung");
    JCheckBox c2 = PlaneStressFEM.labelStore.newCheckBox("Knotennummern");
    JCheckBox c3 = PlaneStressFEM.labelStore.newCheckBox("3D-Darstellung");
    ButtonGroup cbg = new ButtonGroup();
    JRadioButton c4 = new JRadioButton("ux", false);
    JRadioButton c5 = new JRadioButton("uy", false);
    JRadioButton c6 = new JRadioButton("|u|", false);
    JRadioButton c7 = new JRadioButton("\u03c3x", false);
    JRadioButton c8 = new JRadioButton("\u03c3y", false);
    JRadioButton c9 = new JRadioButton("\u03c4xy", false);
    JRadioButton c10 = new JRadioButton("\u03c3v von Mises", true);
    JRadioButton[] cAlle = new JRadioButton[]{this.c4, this.c5, this.c6, this.c7, this.c8, this.c9, this.c10};
    static NumEdit tf;
    static NumEdit cpMin;
    static NumEdit cpMax;
    public static int np;
    public static int nt;
    public static int nrb;
    public static int nrand;
    public static final int MAXP = 40;
    public static final int MAXR = 10;
    static String currFile;
    static Dreieck[] tria;
    static Rand[] rand;
    static double[] x;
    static double[] y;
    static double[] T;
    static double[] ux;
    static double[] uy;
    static double[] uabs;
    static double[] sx;
    static double[] sy;
    static double[] sv;
    static double[] tauxy;
    static boolean showElementGrid;
    static boolean showNodeNumbers;
    static boolean is3d;
    static int showResult;
    static PlaneStressFEMResultPanel self;
    double NUE = 0.3;
    double EM = 210000.0;
    Object lastMark = null;
    int[] randpunktIndizes;
    static int[] permfw;
    double[][] K = null;
    int[][] S1 = new int[][]{{1, -1, 0}, {-1, 1, 0}, {0, 0, 0}};
    int[][] S2 = new int[][]{{1, -1, 0}, {0, 0, 0}, {-1, 1, 0}};
    int[][] S3 = new int[][]{{1, 0, -1}, {0, 0, 0}, {-1, 0, 1}};

    PlaneStressFEMResultPanel() {
        super(new PlaneStressFEMGrafikPanel(), 232);
        int n;
        self = this;
        showElementGrid = false;
        showNodeNumbers = false;
        is3d = false;
        this.txarea = new JTextArea("", 15, 20);
        this.txarea.setFont(new Font("MonoSpaced", 0, 13));
        this.txarea.setEditable(false);
        this.txarea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.txarea, 20, 30);
        for (n = 0; n < this.cAlle.length; ++n) {
            this.cbg.add(this.cAlle[n]);
        }
        this.gbc.anchor = 17;
        this.fpAdd(this.c1, 1, 0, 2, 1);
        this.fpAdd(this.c2, 1, 1, 2, 1);
        this.fpAdd(this.c3, 1, 3, 2, 1);
        this.gbc.gridy = 3;
        for (n = 0; n < this.cAlle.length; ++n) {
            ++this.gbc.gridy;
            this.fpAdd(this.cAlle[n], 1, this.gbc.gridy, 2, 1);
            this.cAlle[n].addItemListener(this);
        }
        ++this.gbc.gridy;
        tf = new NumEdit("" + npsoll, 4);
        this.fpAdd(tf, 1, this.gbc.gridy, 1, 1);
        tf.setNumOnly();
        JLabel jLabel = PlaneStressFEM.labelStore.newLabel("Knoten");
        this.gbc.anchor = 17;
        this.fpAdd(jLabel, 2, this.gbc.gridy, 1, 6);
        ++this.gbc.gridy;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        cpMin = new NumEdit("", 4);
        this.gbl.setConstraints(cpMin, this.gbc);
        this.fieldPanel.add(cpMin);
        this.gbc.gridx = 2;
        jLabel = Laplace.labelStore.newLabel(" Min");
        this.gbc.anchor = 17;
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        ++this.gbc.gridy;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        cpMax = new NumEdit("", 4);
        this.gbl.setConstraints(cpMax, this.gbc);
        this.fieldPanel.add(cpMax);
        cpMax.setName("last");
        this.gbc.gridx = 2;
        jLabel = Laplace.labelStore.newLabel(" Max");
        this.gbc.anchor = 17;
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, this.gbc.gridy, 1, 1);
        ++this.gbc.gridy;
        this.fpAdd(jScrollPane, 0, this.gbc.gridy, 3, 1);
        this.c1.addItemListener(this);
        this.c2.addItemListener(this);
        this.c3.addItemListener(this);
        tf.addActionListener(this);
        cpMin.addActionListener(this);
        cpMax.addActionListener(this);
    }

    public void unmark() {
        if (this.lastMark == null) {
            return;
        }
        DefaultHighlighter defaultHighlighter = (DefaultHighlighter)this.txarea.getHighlighter();
        defaultHighlighter.removeHighlight(this.lastMark);
        this.lastMark = null;
    }

    public void mark(int n) {
        DefaultHighlighter defaultHighlighter = (DefaultHighlighter)this.txarea.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.GRAY);
        try {
            this.unmark();
            int n2 = this.txarea.getLineStartOffset(n);
            int n3 = this.txarea.getLineEndOffset(n);
            this.lastMark = defaultHighlighter.addHighlight(n2, n3, defaultHighlightPainter);
            this.txarea.setCaretPosition(this.txarea.getDocument().getDefaultRootElement().getElement(n).getStartOffset());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void showSolution() {
        String string;
        if (T == null) {
            string = myLocale.getString("DieSystemmatrixIstSingulaer");
        } else {
            VectorSet.vsclear(T, 1.0E-9);
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < T.length; ++i) {
                stringBuilder.append(TextPanel.toStr(i + 1));
                stringBuilder.append(' ');
                stringBuilder.append(NumEdit.toPrecision(T[i], 4));
                stringBuilder.append('\n');
            }
            string = stringBuilder.toString();
        }
        this.txarea.setText(string);
        this.txarea.setCaretPosition(0);
    }

    static void speichern(String string) {
        currFile = string;
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            fileWriter.write("N " + npsoll + "\n");
            for (n = 0; n < 40; ++n) {
                String string2 = NumEdit.stripBlanks(PlaneStressFEMPunktePanel.tfx[n].getText());
                String string3 = NumEdit.stripBlanks(PlaneStressFEMPunktePanel.tfy[n].getText());
                if (string2.length() == 0 && string3.length() == 0) continue;
                if (string2.length() == 0) {
                    string2 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("P " + string2 + " " + string3 + "\n");
            }
            for (n = 0; n < nrb; ++n) {
                if (PlaneStressFEMResultPanel.rand[n].dirichlet != 0) {
                    fileWriter.write("U ");
                } else {
                    fileWriter.write("Q ");
                }
                fileWriter.write(PlaneStressFEMResultPanel.rand[n].n1 + " " + PlaneStressFEMResultPanel.rand[n].n2 + " " + PlaneStressFEMResultPanel.rand[n].tx + " " + PlaneStressFEMResultPanel.rand[n].ty + " " + PlaneStressFEMResultPanel.rand[n].dirichlet + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        PlaneStressFEMResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("2ds", self);
    }

    static void speichern() {
        if (currFile != null) {
            PlaneStressFEMResultPanel.speichern(currFile);
        } else {
            PlaneStressFEMResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n;
        for (n = 0; n < PlaneStressFEMPunktePanel.tfx.length; ++n) {
            PlaneStressFEMPunktePanel.tfx[n].setText("");
            PlaneStressFEMPunktePanel.tfy[n].setText("");
        }
        for (n = 0; n < PlaneStressFEMRandbdgPanel.tf1.length; ++n) {
            PlaneStressFEMRandbdgPanel.tf1[n].setText("");
            PlaneStressFEMRandbdgPanel.tf2[n].setText("");
            PlaneStressFEMRandbdgPanel.tfx[n].setText("");
            PlaneStressFEMRandbdgPanel.tfy[n].setText("");
            PlaneStressFEMRandbdgPanel.cb[2 * n].setSelected(true);
        }
        Graph3d.limitMin = 0.0;
        Graph3d.limitMax = 0.0;
        cpMin.setText("");
        cpMax.setText("");
        np = 0;
        nrb = 0;
        PlaneStressFEMPunktePanel.auslesen();
    }

    static String fmt(double d) {
        double d2 = Math.abs(d);
        int n = d2 >= 1000.0 ? 0 : (d2 >= 100.0 ? 1 : 2);
        return NumEdit.toFixed(d, n);
    }

    static void stringToFields(String string) {
        int n = 3;
        String[] stringArray = NumEdit.split(string);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    PlaneStressFEMPunktePanel.tfx[np].setText(stringArray[1]);
                    PlaneStressFEMPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'N': {
                    npsoll = Integer.parseInt(stringArray[1]);
                    tf.setText(stringArray[1]);
                    break;
                }
                case 'Q': {
                    n = 0;
                }
                case 'U': {
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    double d = Ftree.evaluate(stringArray[3]);
                    double d2 = Ftree.evaluate(stringArray[4]);
                    if (stringArray.length >= 6) {
                        n = Integer.parseInt(stringArray[5]);
                    }
                    PlaneStressFEMResultPanel.rand[PlaneStressFEMResultPanel.nrb] = new Rand(n2, n3, d, d2, n);
                    PlaneStressFEMRandbdgPanel.tf1[nrb].setText("" + (n2 + 1));
                    PlaneStressFEMRandbdgPanel.tf2[nrb].setText("" + (n3 + 1));
                    if (n != 2) {
                        PlaneStressFEMRandbdgPanel.tfx[nrb].setText(PlaneStressFEMResultPanel.fmt(d));
                    }
                    if (n != 1) {
                        PlaneStressFEMRandbdgPanel.tfy[nrb].setText(PlaneStressFEMResultPanel.fmt(d2));
                    }
                    n3 = nrb;
                    PlaneStressFEMRandbdgPanel.cb[2 * nrb].setSelected(n != 0);
                    PlaneStressFEMRandbdgPanel.cb[2 * nrb + 1].setSelected(n == 0);
                    nrb = n3 + 1;
                }
            }
        }
    }

    public static void beforeFileOperations() {
        PlaneStressFEMResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        PlaneStressFEMPunktePanel.auslesen();
    }

    public static void eachLineFileOperations(String string) {
        PlaneStressFEMResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("2ds", self);
    }

    boolean hasMinDist(double d, double d2, double[] dArray, double[] dArray2, int n, double d3) {
        double d4 = d3 * d3;
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            double d5;
            double d6 = d - dArray[n3];
            double d7 = d2 - dArray2[n3];
            if (d6 * d6 + d7 * d7 < d4) {
                return false;
            }
            double d8 = dArray[n2] - dArray[n3];
            double d9 = dArray2[n2] - dArray2[n3];
            double d10 = d8 * d6 + d9 * d7;
            if (d10 > 0.0 && d10 < (d5 = d8 * d8 + d9 * d9) && Math.abs(-d9 * d6 + d8 * d7) < d3 * Math.sqrt(d5)) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    int mehrRandPunkte(double[] dArray, double[] dArray2, int n, double d) {
        int n2;
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        for (n2 = 0; n2 < n; ++n2) {
            dArray3[n2] = dArray[n2];
            dArray4[n2] = dArray2[n2];
        }
        dArray3[n] = dArray3[0];
        dArray4[n] = dArray4[0];
        this.randpunktIndizes = new int[n + 1];
        this.randpunktIndizes[0] = 0;
        int n3 = 0;
        for (n2 = 1; n2 <= n; ++n2) {
            double d2 = dArray3[n2] - dArray3[n2 - 1];
            double d3 = dArray4[n2] - dArray4[n2 - 1];
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray[n3] = dArray3[n2 - 1];
            dArray2[n3] = dArray4[n2 - 1];
            ++n3;
            int n4 = 0;
            if (d4 > d) {
                int n5 = (int)(d4 / d + 0.5);
                d2 /= (double)n5;
                d3 /= (double)n5;
                while (--n5 > 0) {
                    dArray[n3] = dArray[n3 - 1] + d2;
                    dArray2[n3] = dArray2[n3 - 1] + d3;
                    ++n3;
                    ++n4;
                }
            }
            this.randpunktIndizes[n2] = this.randpunktIndizes[n2 - 1] + n4 + 1;
        }
        dArray[n3] = dArray3[0];
        dArray2[n3] = dArray4[0];
        return n3;
    }

    static int toMcKee(int n) {
        if (permfw != null) {
            return permfw[n];
        }
        return n;
    }

    void pointsAndTriangulation() {
        double d;
        int n;
        double[] dArray = new double[40];
        double[] dArray2 = new double[40];
        boolean[] blArray = PlaneStressFEMPunktePanel.isNode;
        WPoint3d[] wPoint3dArray = PlaneStressFEMPunktePanel.pp;
        int n2 = 2 * npsoll;
        if (n2 < 100) {
            n2 = 100;
        }
        x = new double[n2];
        y = new double[n2];
        PlaneStressFEMGrafikPanel.hilight = 0;
        int n3 = 0;
        for (n = 0; n < 40; ++n) {
            if (!blArray[n]) continue;
            dArray[n3] = PlaneStressFEMResultPanel.x[n3] = wPoint3dArray[n].x;
            dArray2[n3] = PlaneStressFEMResultPanel.y[n3] = wPoint3dArray[n].y;
            if (n3 > 0 && x[n3] == x[n3 - 1] && y[n3] == y[n3 - 1]) continue;
            ++n3;
        }
        nrand = n3;
        double d2 = WPoint3d.flaeche(wPoint3dArray, n3);
        double d3 = VectorSet.vsMin(x, n3);
        double d4 = VectorSet.vsMax(x, n3);
        double d5 = VectorSet.vsMin(y, n3);
        double d6 = VectorSet.vsMax(y, n3);
        if (npsoll <= 1) {
            npsoll = 2;
        }
        double d7 = WPoint3d.umfang(wPoint3dArray, n3);
        double d8 = d = d7 * 0.25 / (double)npsoll + Math.sqrt(Math.pow(d7 * 0.5 / (double)npsoll, 2.0) + d2 / (double)npsoll);
        n3 = this.mehrRandPunkte(x, y, n3, d8);
        double d9 = Math.sqrt(0.5 * Math.sqrt(3.0));
        d3 += (d8 *= d9);
        d5 += (d /= d9);
        n = n3;
        double d10 = d8 * 0.5;
        int n4 = 0;
        while (d3 < d4) {
            d5 = n4++ % 2 == 0 ? (d5 -= 0.05 * d) : (d5 += 0.05 * d);
            for (double d11 = d5; d11 < d6; d11 += d) {
                if (!Delaunay.inArea(d3, d11, dArray, dArray2, nrand) || !this.hasMinDist(d3, d11, x, y, n3, d10)) continue;
                PlaneStressFEMResultPanel.x[n] = d3;
                PlaneStressFEMResultPanel.y[n] = d11;
                ++n;
            }
            d3 += d8;
        }
        np = n;
        tria = new Dreieck[np * 2];
        StopWatch.start(1);
        nt = new Delaunay().triangulate(x, y, np, n3, tria);
        this.errorMsg("");
        if (nt == 0) {
            this.txarea.setText("");
            return;
        }
        Smooth.smooth(x, y, np, n3, tria, nt);
        StopWatch.stop(1);
        int[] nArray = new int[np];
        int[][] nArray2 = new int[nt][3];
        for (n = 0; n < nt; ++n) {
            nArray2[n][0] = PlaneStressFEMResultPanel.tria[n].a;
            nArray2[n][1] = PlaneStressFEMResultPanel.tria[n].c;
            nArray2[n][2] = PlaneStressFEMResultPanel.tria[n].b;
        }
        StopWatch.start(2);
        this.mckee(x, y, null, nArray2, nArray, nt, n3);
        int n5 = Mckee.bandbreite(nArray2, nt);
        if (this.K == null || this.K.length != 2 * np || this.K[0].length != 2 * n5) {
            this.K = new double[2 * np][2 * n5];
        } else {
            VectorSet.vszero(this.K);
        }
        T = new double[2 * np];
        this.systemMatrix(this.K, x, y, nArray2, nt);
        this.randbedingungen(this.K, T, n3);
        int n6 = Gauss.solveBand(this.K, T, np * 2, n5 * 2);
        StopWatch.stop(2);
        this.statusMsg(nt + " " + myLocale.getString("Elemente") + ", " + np + " " + myLocale.getString("Knoten") + ", " + myLocale.getString("Bandbreite") + ": " + n5 + ", " + myLocale.getString("ZeitFuerTriangulieren") + ": " + StopWatch.ms(1) + "ms, " + myLocale.getString("ZeitFuerLoesen") + ": " + StopWatch.ms(2) + "ms");
        this.backpermute(np, nArray, x, y, T, nArray2, nt);
        if (n6 < 0) {
            T = null;
            sv = null;
            tauxy = null;
            sy = null;
            sx = null;
            uy = null;
            ux = null;
            uabs = null;
        } else {
            ux = new double[np];
            uy = new double[np];
            sx = new double[np];
            sy = new double[np];
            sv = new double[np];
            tauxy = new double[np];
            uabs = new double[np];
            int n7 = 0;
            for (n = 0; n < np; ++n) {
                PlaneStressFEMResultPanel.ux[n] = T[n7++];
                PlaneStressFEMResultPanel.uy[n] = T[n7++];
                PlaneStressFEMResultPanel.uabs[n] = Math.sqrt(ux[n] * ux[n] + uy[n] * uy[n]);
            }
            this.calculateStress(x, y, T, nArray2, sx, sy, tauxy, sv);
            this.setCurrentDataArray();
        }
        this.showSolution();
        this.grafikPanel.repaint();
    }

    int elemmatrix(double[][] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3) {
        int n4;
        int n5;
        double d = 1.0;
        double d2 = (1.0 - this.NUE) * 0.5;
        double d3 = dArray2[n2] - dArray2[n];
        double d4 = dArray3[n3] - dArray3[n];
        double d5 = dArray2[n3] - dArray2[n];
        double d6 = dArray3[n2] - dArray3[n];
        double d7 = d3 * d4 - d5 * d6;
        if (d7 <= 0.0) {
            return -1;
        }
        double d8 = this.EM * d / (1.0 - this.NUE * this.NUE);
        d7 = d8 * 0.5 / d7;
        double d9 = (d2 * d5 * d5 + d4 * d4) * d7;
        double d10 = -(d2 * d3 * d5 + d6 * d4) * d7;
        double d11 = (d2 * d3 * d3 + d6 * d6) * d7;
        double d12 = (d5 * d5 + d2 * d4 * d4) * d7;
        double d13 = -(d3 * d5 + d2 * d6 * d4) * d7;
        double d14 = (d3 * d3 + d2 * d6 * d6) * d7;
        double d15 = -0.5 * (1.0 + this.NUE) * d5 * d4 * d7;
        double d16 = (this.NUE * d3 * d4 + d2 * d5 * d6) * d7;
        double d17 = (this.NUE * d5 * d6 + d2 * d3 * d4) * d7;
        double d18 = -0.5 * (1.0 + this.NUE) * d3 * d6 * d7;
        for (n5 = 0; n5 < 3; ++n5) {
            int n6;
            int n7 = n5 + 3;
            for (n4 = 0; n4 < 3; ++n4) {
                n6 = n4 + 3;
                dArray[n5][n6] = d15 * (double)this.S1[n5][n4] + d17 * (double)this.S2[n5][n4] + d16 * (double)this.S2[n4][n5] + d18 * (double)this.S3[n5][n4];
            }
            for (n4 = n5; n4 < 3; ++n4) {
                n6 = n4 + 3;
                dArray[n5][n4] = d9 * (double)this.S1[n5][n4] + d10 * (double)(this.S2[n5][n4] + this.S2[n4][n5]) + d11 * (double)this.S3[n5][n4];
                dArray[n7][n6] = d12 * (double)this.S1[n5][n4] + d13 * (double)(this.S2[n5][n4] + this.S2[n4][n5]) + d14 * (double)this.S3[n5][n4];
            }
        }
        for (n5 = 0; n5 < 6; ++n5) {
            double[] dArray4 = dArray[n5];
            for (n4 = 0; n4 < n5; ++n4) {
                dArray4[n4] = dArray[n4][n5];
            }
        }
        return 0;
    }

    int systemMatrix(double[][] dArray, double[] dArray2, double[] dArray3, int[][] nArray, int n) {
        int[] nArray2 = new int[]{0, 1, 2, 3, 4, 5};
        int n2 = 3;
        double[][] dArray4 = new double[6][6];
        for (int i = 0; i < n; ++i) {
            int[] nArray3 = nArray[i];
            int n3 = this.elemmatrix(dArray4, dArray2, dArray3, nArray3[0], nArray3[1], nArray3[2]);
            if (n3 < 0) {
                return 1;
            }
            for (int j = 0; j < 6; ++j) {
                int n4 = nArray3[j % n2] * 2 + j / n2;
                int n5 = nArray2[j];
                for (int k = 0; k < 6; ++k) {
                    int n6 = nArray3[k % n2] * 2 + k / n2;
                    int n7 = n6 - n4;
                    if (n7 < 0) continue;
                    int n8 = nArray2[k];
                    double[] dArray5 = dArray[n4];
                    int n9 = n7;
                    dArray5[n9] = dArray5[n9] + dArray4[n5][n8];
                }
            }
        }
        return 0;
    }

    void mittelungVorbereiten() {
        int n;
        for (n = 0; n < nrb; ++n) {
            PlaneStressFEMResultPanel.rand[n].m1 = false;
            PlaneStressFEMResultPanel.rand[n].m2 = false;
        }
        for (n = 0; n < nrb; ++n) {
            for (int i = 0; i < nrb; ++i) {
                if (PlaneStressFEMResultPanel.rand[n].dirichlet == 0 || PlaneStressFEMResultPanel.rand[i].dirichlet == 0 || PlaneStressFEMResultPanel.rand[n].dirichlet != PlaneStressFEMResultPanel.rand[i].dirichlet || PlaneStressFEMResultPanel.rand[n].n1 != PlaneStressFEMResultPanel.rand[i].n2 || n == i) continue;
                PlaneStressFEMResultPanel.rand[n].m1 = true;
                PlaneStressFEMResultPanel.rand[i].m2 = true;
                PlaneStressFEMResultPanel.rand[n].t1x = PlaneStressFEMResultPanel.rand[i].t2x = 0.5 * (PlaneStressFEMResultPanel.rand[n].tx + PlaneStressFEMResultPanel.rand[i].tx);
                PlaneStressFEMResultPanel.rand[n].t1y = PlaneStressFEMResultPanel.rand[i].t2y = 0.5 * (PlaneStressFEMResultPanel.rand[n].ty + PlaneStressFEMResultPanel.rand[i].ty);
            }
        }
    }

    void randbedingungen(double[][] dArray, double[] dArray2, int n) {
        int n2;
        double d;
        double d2;
        double d3;
        int n3;
        int n4;
        int n5;
        int n6 = dArray[0].length;
        int n7 = dArray.length;
        for (n5 = 0; n5 < nrb; ++n5) {
            n4 = this.randpunktIndizes[PlaneStressFEMResultPanel.rand[n5].n2];
            n3 = this.randpunktIndizes[PlaneStressFEMResultPanel.rand[n5].n1];
            if (n4 < n3) {
                n4 += n;
            }
            d3 = PlaneStressFEMResultPanel.rand[n5].tx;
            d2 = PlaneStressFEMResultPanel.rand[n5].ty;
            d = 0.0;
            for (n2 = n3; n2 < n4; ++n2) {
                if (PlaneStressFEMResultPanel.rand[n5].dirichlet != 0) continue;
                int n8 = PlaneStressFEMResultPanel.toMcKee(n2 % n);
                int n9 = PlaneStressFEMResultPanel.toMcKee((n2 + 1) % n);
                d = Math.sqrt(Math.pow(x[n9] - x[n8], 2.0) + Math.pow(y[n9] - y[n8], 2.0));
                int n10 = n8 * 2;
                dArray2[n10] = dArray2[n10] + 0.5 * d3 * d;
                int n11 = n9 * 2;
                dArray2[n11] = dArray2[n11] + 0.5 * d3 * d;
                int n12 = n8 * 2 + 1;
                dArray2[n12] = dArray2[n12] + 0.5 * d2 * d;
                int n13 = n9 * 2 + 1;
                dArray2[n13] = dArray2[n13] + 0.5 * d2 * d;
            }
        }
        this.mittelungVorbereiten();
        for (n5 = 0; n5 < nrb; ++n5) {
            if (PlaneStressFEMResultPanel.rand[n5].dirichlet == 0) continue;
            int n14 = PlaneStressFEMResultPanel.rand[n5].dirichlet;
            n4 = this.randpunktIndizes[PlaneStressFEMResultPanel.rand[n5].n2];
            n3 = this.randpunktIndizes[PlaneStressFEMResultPanel.rand[n5].n1];
            if (n4 < n3) {
                n4 += n;
            }
            d3 = PlaneStressFEMResultPanel.rand[n5].tx;
            d2 = PlaneStressFEMResultPanel.rand[n5].ty;
            for (n2 = n3; n2 <= n4; ++n2) {
                int n15;
                d = d3;
                double d4 = d2;
                if (n2 == n3 && PlaneStressFEMResultPanel.rand[n5].m1) {
                    d = PlaneStressFEMResultPanel.rand[n5].t1x;
                    d4 = PlaneStressFEMResultPanel.rand[n5].t1y;
                }
                if (n2 == n4 && PlaneStressFEMResultPanel.rand[n5].m2) {
                    d = PlaneStressFEMResultPanel.rand[n5].t2x;
                    d4 = PlaneStressFEMResultPanel.rand[n5].t2y;
                }
                int n16 = PlaneStressFEMResultPanel.toMcKee(n2 % n) * 2;
                int n17 = n16 + 1;
                if ((n14 & 1) != 0) {
                    for (n15 = 1; n15 < n6 && n16 - n15 >= 0; ++n15) {
                        int n18 = n16 - n15;
                        dArray2[n18] = dArray2[n18] - dArray[n16 - n15][n15] * d;
                    }
                    for (n15 = 1; n15 < n6 && n16 + n15 < n7; ++n15) {
                        int n19 = n16 + n15;
                        dArray2[n19] = dArray2[n19] - dArray[n16][n15] * d;
                    }
                    for (n15 = 0; n15 < n6; ++n15) {
                        dArray[n16][n15] = 0.0;
                    }
                    for (n15 = 1; n15 < n6 && n16 - n15 >= 0; ++n15) {
                        dArray[n16 - n15][n15] = 0.0;
                    }
                    dArray[n16][0] = 1.0;
                    dArray2[n16] = d;
                }
                if ((n14 & 2) == 0) continue;
                for (n15 = 1; n15 < n6 && n17 - n15 >= 0; ++n15) {
                    int n20 = n17 - n15;
                    dArray2[n20] = dArray2[n20] - dArray[n17 - n15][n15] * d4;
                }
                for (n15 = 1; n15 < n6 && n17 + n15 < n7; ++n15) {
                    int n21 = n17 + n15;
                    dArray2[n21] = dArray2[n21] - dArray[n17][n15] * d4;
                }
                for (n15 = 0; n15 < n6; ++n15) {
                    dArray[n17][n15] = 0.0;
                }
                for (n15 = 1; n15 < n6 && n17 - n15 >= 0; ++n15) {
                    dArray[n17 - n15][n15] = 0.0;
                }
                dArray[n17][0] = 1.0;
                dArray2[n17] = d4;
            }
        }
    }

    static void swap(double[] dArray, int n, int n2, int n3) {
        if (n3 == 1) {
            double d = dArray[n2];
            dArray[n2] = dArray[n];
            dArray[n] = d;
        } else {
            int n4 = 2 * n2;
            int n5 = 2 * n;
            double d = dArray[n4];
            dArray[n4] = dArray[n5];
            dArray[n5] = d;
            d = dArray[++n4];
            dArray[n4] = dArray[++n5];
            dArray[n5] = d;
        }
    }

    static void permute(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        int n3 = dArray3 != null ? dArray3.length / n : 0;
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            while (nArray[n2] != n2) {
                int n4 = nArray[n2];
                double d = dArray2[n4];
                dArray2[n4] = dArray2[n2];
                dArray2[n2] = d;
                d = dArray[n4];
                dArray[n4] = dArray[n2];
                dArray[n2] = d;
                if (dArray3 != null) {
                    PlaneStressFEMResultPanel.swap(dArray3, n2, n4, n3);
                }
                int n5 = nArray2[n4];
                nArray2[n4] = nArray2[n2];
                nArray2[n2] = n5;
                nArray[n2] = nArray[n4];
                nArray[n4] = n4;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = nArray2[n2];
        }
    }

    void backpermute(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = nArray2[i][j];
                if (n3 < 0) continue;
                nArray2[i][j] = nArray[n3];
            }
        }
        PlaneStressFEMResultPanel.permute(n, nArray, dArray, dArray2, dArray3);
    }

    void mckee(double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = 3;
        int n5 = Math.min(np, n2) / 8;
        if (n5 == 0) {
            n5 = 1;
        }
        Mckee.setdata(np, n, -n5, n4, nArray, null, null, nArray2);
        Mckee.findoptimum();
        permfw = new int[np];
        for (n3 = 0; n3 < np; ++n3) {
            PlaneStressFEMResultPanel.permfw[n3] = nArray2[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n4 = 0; n4 < 3; ++n4) {
                int n6 = nArray[n3][n4];
                if (n6 < 0) continue;
                nArray[n3][n4] = nArray2[n6];
            }
        }
        PlaneStressFEMResultPanel.permute(np, nArray2, dArray, dArray2, dArray3);
    }

    void calculateStress(double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7) {
        double[] dArray8 = new double[3];
        double d = this.EM / (1.0 - this.NUE * this.NUE);
        double d2 = 0.5 * this.EM / (1.0 + this.NUE);
        if (dArray4 == null) {
            return;
        }
        for (int i = 0; i < np; ++i) {
            Glatt.geglaetteteVerzerrung(dArray, dArray2, dArray3, i, dArray8, nArray, nt);
            dArray4[i] = d * (dArray8[0] + this.NUE * dArray8[1]);
            dArray5[i] = d * (dArray8[1] + this.NUE * dArray8[0]);
            dArray6[i] = d2 * dArray8[2];
            dArray7[i] = Math.sqrt(dArray4[i] * dArray4[i] + dArray5[i] * dArray5[i] - dArray4[i] * dArray5[i] + 3.0 * dArray6[i] * dArray6[i]);
        }
    }

    void setCurrentDataArray() {
        switch (showResult) {
            case 0: {
                T = ux;
                break;
            }
            case 1: {
                T = uy;
                break;
            }
            case 2: {
                T = uabs;
                break;
            }
            case 3: {
                T = sx;
                break;
            }
            case 4: {
                T = sy;
                break;
            }
            case 5: {
                T = tauxy;
                break;
            }
            case 6: {
                T = sv;
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.c1) {
            showElementGrid = this.c1.isSelected();
        } else if (itemEvent.getSource() == this.c2) {
            showNodeNumbers = this.c2.isSelected();
            PlaneStressFEMGrafikPanel.hilight = 0;
        } else if (itemEvent.getSource() == this.c3) {
            is3d = this.c3.isSelected();
        } else {
            for (int i = 0; i < this.cAlle.length; ++i) {
                if (!this.cAlle[i].isSelected()) continue;
                showResult = i;
                break;
            }
            this.setCurrentDataArray();
            this.showSolution();
        }
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == cpMin || actionEvent.getSource() == cpMax) {
            Graph3d.limitMin = !cpMin.isEmpty() ? cpMin.getDouble() : 0.0;
            Graph3d.limitMax = !cpMax.isEmpty() ? cpMax.getDouble() : 0.0;
        } else if (actionEvent.getSource() == tf) {
            npsoll = tf.getInt();
        }
        if (npsoll > 4000) {
            npsoll = 4000;
            tf.setText("" + npsoll);
        }
        this.pointsAndTriangulation();
        super.actionPerformed(actionEvent);
    }

    static {
        np = 0;
        currFile = null;
        tria = null;
        rand = new Rand[10];
        x = null;
        y = null;
        showElementGrid = false;
        showNodeNumbers = false;
        is3d = false;
        showResult = 6;
        permfw = null;
    }

    static class Rand {
        int n1;
        int n2;
        double t1x;
        double t2x;
        double t1y;
        double t2y;
        boolean m1;
        boolean m2;
        double tx;
        double ty;
        int dirichlet;

        Rand(int n, int n2, double d, double d2, int n3) {
            this.n1 = n;
            this.n2 = n2;
            this.tx = d;
            this.ty = d2;
            this.dirichlet = n3;
        }
    }
}

