/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class PlaneStressFEM
extends JPanel
implements ActionListener {
    String[] lbs = new String[]{"Randpunkte", "Randbedingungen", "Ergebnisse", "Beispiele", "Neu"};
    JButton[] bts = new JButton[this.lbs.length];
    DekorPanel[] pan = new DekorPanel[this.lbs.length];
    CardLayout c = new CardLayout();
    JPanel mainpan = new JPanel();
    JPanel buttpan = new JPanel();
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileNew;
    private JMenuItem fileQuit;
    static JMenuBar mb;
    static LabelStore labelStore;
    static int currpan;
    static String title;
    static DontExitFrame f;

    public static void main(String[] stringArray) {
        if (DontExitFrame.exists(title)) {
            return;
        }
        f = new DontExitFrame();
        PlaneStressFEM planeStressFEM = new PlaneStressFEM();
        planeStressFEM.init();
        f.setContentPane(planeStressFEM);
        f.pack();
        f.setTitle(title);
        f.setSize(880, 660);
        f.setJMenuBar(mb);
        if (stringArray.length > 1) {
            Point point = new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            f.setLocation(point);
        }
        f.setVisible(true);
    }

    public static void setTitle(String string) {
        f.setTitle((String)(string == null ? title : title + " " + string));
    }

    public void init() {
        currpan = 0;
        mb = new JMenuBar();
        JMenu jMenu = labelStore.newMenu("Datei");
        this.fileNew = labelStore.newMenuItem("Neu");
        jMenu.add(this.fileNew);
        this.fileOpen = labelStore.newMenuItem("Oeffnen");
        jMenu.add(this.fileOpen);
        this.fileSave = labelStore.newMenuItem("Speichern");
        jMenu.add(this.fileSave);
        this.fileSaveAs = labelStore.newMenuItem("SpeichernUnter");
        jMenu.add(this.fileSaveAs);
        jMenu.addSeparator();
        this.fileQuit = labelStore.newMenuItem("Ende");
        jMenu.add(this.fileQuit);
        this.fileSaveAs.addActionListener(this);
        this.fileSave.addActionListener(this);
        this.fileOpen.addActionListener(this);
        this.fileQuit.addActionListener(this);
        this.fileNew.addActionListener(this);
        mb.add(jMenu);
        mb.add(f.lookMenu());
        this.setLayout(new BorderLayout());
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.add((Component)this.buttpan, "North");
        this.mainpan.setLayout(this.c);
        this.add((Component)this.mainpan, "Center");
        for (int i = 0; i < this.lbs.length; ++i) {
            this.bts[i] = labelStore.newButton(this.lbs[i]);
            this.bts[i].addActionListener(this);
            this.buttpan.add(this.bts[i]);
            switch (i) {
                case 0: {
                    this.pan[i] = new PlaneStressFEMPunktePanel();
                    break;
                }
                case 1: {
                    this.pan[i] = new PlaneStressFEMRandbdgPanel();
                    break;
                }
                case 2: {
                    this.pan[i] = new PlaneStressFEMResultPanel();
                    break;
                }
                case 3: {
                    this.pan[i] = new PlaneStressFEMExamplePanel();
                }
            }
            if (this.pan[i] == null) continue;
            this.mainpan.add(this.lbs[i], this.pan[i]);
        }
        PlaneStressFEMPunktePanel.auslesen();
        mb.add(f.languageMenu(labelStore));
        mb.add(f.helpMenu(labelStore, "PlaneStressFEM"));
        this.setVisible(true);
        this.changePanel(0);
    }

    void changePanel(int n) {
        this.c.show(this.mainpan, this.lbs[n]);
        ((PlaneStressFEMExamplePanel)this.pan[3]).clear();
        currpan = n;
    }

    void clearStatusFields() {
        int n = this.pan.length - 1;
        while (--n >= 0) {
            this.pan[n].statusMsg("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileOpen) {
            PlaneStressFEMResultPanel.laden();
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            this.bts[0].requestFocus();
            PlaneStressFEM.setTitle(PlaneStressFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileSave) {
            PlaneStressFEMResultPanel.speichern();
            PlaneStressFEM.setTitle(PlaneStressFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileNew || actionEvent.getSource() == this.bts[4]) {
            PlaneStressFEMResultPanel.maskenLoeschen();
            PlaneStressFEMResultPanel.currFile = null;
            PlaneStressFEM.setTitle(null);
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
        } else if (actionEvent.getSource() == this.fileSaveAs) {
            PlaneStressFEMResultPanel.speichernAls();
            PlaneStressFEM.setTitle(PlaneStressFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileQuit) {
            f.exit(0);
        } else {
            int n = this.bts.length;
            while (--n >= 0) {
                if (actionEvent.getSource() != this.bts[n]) continue;
                this.changePanel(n);
                if (n != 2) continue;
                PlaneStressFEMResultPanel planeStressFEMResultPanel = (PlaneStressFEMResultPanel)this.pan[n];
                planeStressFEMResultPanel.pointsAndTriangulation();
            }
        }
    }

    static {
        labelStore = new LabelStore();
        currpan = 0;
        title = "PlaneStressFEM 2.06 (2021)";
        f = null;
    }
}

