/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

class PlaneBeamVibFEMResultPanel
extends DekorPanel
implements ComponentListener {
    public static int nElem;
    public static int nMasse;
    public static int nMaterial;
    public static int np;
    public static final int MAXP = 16;
    public static final int MAXE = 32;
    static String currFile;
    static PlaneBeamVibFEMResultPanel self;
    NumEdit nrtf;
    NumEdit ewtf;
    JButton upButton;
    JButton downButton;
    JPanel buttpan = new JPanel();
    PlaneBeamVibFEMGrafikPanel currGrPan;
    JTextArea txarea;
    static PlaneBeamVibFEMMaterialDaten[] mdata;
    static double[] masse;
    static double[] massentraegheit;
    static int[] matNr;
    static int[][] federIndizes;
    static int[] federEndCode;
    static int[] randbdg;
    static double[][] Mges;
    static double[][] Kges;
    static boolean[] active;
    static int formAnz;
    static double[][] ev;
    static double[] ew;
    static double[] dx;
    static double[] dy;
    static double[] dw;
    static double ekfr;

    PlaneBeamVibFEMResultPanel() {
        super(new PlaneBeamVibFEMGrafikPanel(), 232);
        self = this;
        this.currGrPan = (PlaneBeamVibFEMGrafikPanel)this.grafikPanel;
        this.gbc.gridy = 0;
        JLabel jLabel = PlaneBeamVibFEM.labelStore.newLabel("EigenformNr");
        this.fpAdd(jLabel, 0, 0, 1, 1);
        this.nrtf = new NumEdit(5);
        this.nrtf.setNumOnly();
        this.nrtf.addActionListener(this);
        ++this.gbc.gridy;
        this.fpAdd(this.nrtf, 0, 1, 1, 1);
        this.downButton = new JButton("<");
        this.downButton.setMargin(new Insets(0, 5, 0, 5));
        this.downButton.addActionListener(this);
        this.buttpan.add(this.downButton);
        this.upButton = new JButton(">");
        this.upButton.setMargin(new Insets(0, 5, 0, 5));
        this.upButton.addActionListener(this);
        this.buttpan.add(this.upButton);
        ++this.gbc.gridy;
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.fpAdd(this.buttpan, 0, 2, 1, 1);
        jLabel = new JLabel(" ");
        ++this.gbc.gridy;
        this.fpAdd(jLabel, 0, 3, 1, 1);
        jLabel = PlaneBeamVibFEM.labelStore.newLabel("Eigenfrequenz");
        ++this.gbc.gridy;
        this.fpAdd(jLabel, 0, 4, 1, 1);
        this.ewtf = new NumEdit(5, true);
        this.ewtf.setEditable(false);
        this.ewtf.setFont(new Font("Dialog", 1, 13));
        ++this.gbc.gridy;
        this.fpAdd(this.ewtf, 0, 5, 1, 1);
        jLabel = new JLabel(" ");
        ++this.gbc.gridy;
        this.fpAdd(jLabel, 0, 6, 1, 1);
        jLabel = PlaneBeamVibFEM.labelStore.newLabel("Eigenvektor");
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        this.fpAdd(jLabel, 0, 7, 1, 1);
        ++this.gbc.gridy;
        this.txarea = new JTextArea("", 16, 22);
        this.txarea.setFont(new Font("MonoSpaced", 0, 13));
        this.txarea.setBorder(BorderFactory.createLoweredBevelBorder());
        this.txarea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(this.txarea, 20, 31);
        this.fpAdd(jScrollPane, 0, 8, 1, 1);
        for (int i = 0; i < mdata.length; ++i) {
            PlaneBeamVibFEMResultPanel.mdata[i] = new PlaneBeamVibFEMMaterialDaten(0.0, 0.0, 0.0, 0.0);
        }
        this.addComponentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.downButton) {
            int n = this.nrtf.getInt();
            if (n > 0) {
                this.nrtf.setText("" + --n);
            }
        } else if (actionEvent.getSource() == this.upButton) {
            int n = this.nrtf.getInt();
            this.nrtf.setText("" + ++n);
        }
        int n = 0;
        PlaneBeamVibFEMGrafikPanel cfr_ignored_0 = (PlaneBeamVibFEMGrafikPanel)this.grafikPanel;
        if (!PlaneBeamVibFEMGrafikPanel.isRunning && (n = this.gesamtMatrizen()) == 0) {
            ((PlaneBeamVibFEMGrafikPanel)this.grafikPanel).init();
        }
        if (n == 0) {
            this.showEigenform();
        }
    }

    static void speichern(String string) {
        currFile = string;
        try {
            String string2;
            String string3;
            String string4;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            for (n = 0; n < 16; ++n) {
                string4 = NumEdit.stripBlanks(PlaneBeamVibFEMPunktePanel.tfx[n].getText());
                string3 = NumEdit.stripBlanks(PlaneBeamVibFEMPunktePanel.tfy[n].getText());
                if (string4.length() <= 0 && string3.length() <= 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("P " + string4 + " " + string3 + "\n");
            }
            for (n = 0; n < 32; ++n) {
                string4 = PlaneBeamVibFEMElementPanel.nodeNumbers[n].getTrimText().replace(',', ' ');
                string3 = PlaneBeamVibFEMElementPanel.materialIndex[n].getTrimText();
                string2 = PlaneBeamVibFEMElementPanel.codes[n].getTrimText();
                if (string4.length() <= 0 || string3.length() <= 0) continue;
                fileWriter.write("E " + string4 + " " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 16; ++n) {
                string4 = NumEdit.stripBlanks(PlaneBeamVibFEMMassePanel.nodeNumbers[n].getText());
                string3 = NumEdit.stripBlanks(PlaneBeamVibFEMMassePanel.masse[n].getText());
                string2 = NumEdit.stripBlanks(PlaneBeamVibFEMMassePanel.massentraegheit[n].getText());
                if (string4.length() <= 0 || string3.length() <= 0 && string2.length() <= 0) continue;
                double d = PlaneBeamVibFEMMassePanel.masse[n].getDouble();
                double d2 = PlaneBeamVibFEMMassePanel.massentraegheit[n].getDouble();
                fileWriter.write("M " + string4 + " " + d + " " + d2 + "\n");
            }
            for (n = 0; n < 16; ++n) {
                boolean bl = PlaneBeamVibFEMLagerPanel.cx[n].isSelected();
                boolean bl2 = PlaneBeamVibFEMLagerPanel.cy[n].isSelected();
                boolean bl3 = PlaneBeamVibFEMLagerPanel.cb[n].isSelected();
                if (!bl && !bl2 && !bl3) continue;
                int n2 = (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0);
                fileWriter.write("R " + (n + 1) + " " + n2);
                fileWriter.write("\n");
            }
            for (n = 0; n < mdata.length; ++n) {
                String string5 = NumEdit.stripBlanks(PlaneBeamVibFEMMaterialPanel.flaeche[n].getText());
                if (string5.length() <= 0) continue;
                String string6 = NumEdit.stripBlanks(PlaneBeamVibFEMMaterialPanel.traegheitsmoment[n].getText());
                double d = PlaneBeamVibFEMMaterialPanel.emodul[n].getDouble();
                double d3 = PlaneBeamVibFEMMaterialPanel.rho[n].getDouble();
                fileWriter.write("A " + string5 + " " + string6 + " " + d + " " + d3 + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        PlaneBeamVibFEMResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("bev", self);
    }

    static void speichern() {
        if (currFile != null) {
            PlaneBeamVibFEMResultPanel.speichern(currFile);
        } else {
            PlaneBeamVibFEMResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = PlaneBeamVibFEMPunktePanel.tfx.length;
        while (--n >= 0) {
            PlaneBeamVibFEMPunktePanel.tfx[n].setText("");
            PlaneBeamVibFEMPunktePanel.tfy[n].setText("");
        }
        for (n = 0; n < 32; ++n) {
            PlaneBeamVibFEMElementPanel.nodeNumbers[n].setText("");
            PlaneBeamVibFEMElementPanel.materialIndex[n].setText("");
            PlaneBeamVibFEMElementPanel.codes[n].setText("");
        }
        for (n = 0; n < 16; ++n) {
            PlaneBeamVibFEMMassePanel.nodeNumbers[n].setText("");
            PlaneBeamVibFEMMassePanel.masse[n].setText("");
            PlaneBeamVibFEMMassePanel.massentraegheit[n].setText("");
        }
        n = PlaneBeamVibFEMLagerPanel.cx.length;
        while (--n >= 0) {
            PlaneBeamVibFEMLagerPanel.cx[n].setSelected(false);
            PlaneBeamVibFEMLagerPanel.cy[n].setSelected(false);
            PlaneBeamVibFEMLagerPanel.cb[n].setSelected(false);
        }
        n = PlaneBeamVibFEMMaterialPanel.flaeche.length;
        while (--n >= 0) {
            PlaneBeamVibFEMMaterialPanel.rho[n].setText("");
            PlaneBeamVibFEMMaterialPanel.flaeche[n].setText("");
            PlaneBeamVibFEMMaterialPanel.emodul[n].setText("");
            PlaneBeamVibFEMMaterialPanel.traegheitsmoment[n].setText("");
        }
        np = 0;
        nElem = 0;
        nMasse = 0;
        nMaterial = 0;
        PlaneBeamVibFEMPunktePanel.auslesen();
        PlaneBeamVibFEMMassePanel.auslesen();
    }

    static void stringToFields(String object) {
        String[] stringArray = NumEdit.split((String)object);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    PlaneBeamVibFEMPunktePanel.tfx[np].setText(stringArray[1]);
                    PlaneBeamVibFEMPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'E': {
                    object = stringArray[1] + " " + stringArray[2];
                    PlaneBeamVibFEMElementPanel.nodeNumbers[nElem].setText((String)object);
                    PlaneBeamVibFEMElementPanel.materialIndex[nElem].setText(stringArray[3]);
                    if (stringArray.length > 4) {
                        PlaneBeamVibFEMElementPanel.codes[nElem].setText(stringArray[4]);
                    }
                    ++nElem;
                    break;
                }
                case 'M': {
                    PlaneBeamVibFEMMassePanel.nodeNumbers[nMasse].setText(stringArray[1]);
                    PlaneBeamVibFEMMassePanel.masse[nMasse].setText(stringArray[2]);
                    PlaneBeamVibFEMMassePanel.massentraegheit[nMasse].setText(stringArray[3]);
                    ++nMasse;
                    break;
                }
                case 'A': {
                    PlaneBeamVibFEMMaterialPanel.flaeche[nMaterial].setText(stringArray[1]);
                    PlaneBeamVibFEMMaterialPanel.traegheitsmoment[nMaterial].setText(stringArray[2]);
                    PlaneBeamVibFEMMaterialPanel.emodul[nMaterial].setText(stringArray[3]);
                    PlaneBeamVibFEMMaterialPanel.rho[nMaterial].setText(stringArray[4]);
                    ++nMaterial;
                    break;
                }
                case 'R': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    PlaneBeamVibFEMLagerPanel.cx[n - 1].setSelected((n2 & 1) != 0);
                    PlaneBeamVibFEMLagerPanel.cy[n - 1].setSelected((n2 & 2) != 0);
                    PlaneBeamVibFEMLagerPanel.cb[n - 1].setSelected((n2 & 4) != 0);
                    ++np;
                }
            }
        }
    }

    public static void beforeFileOperations() {
        PlaneBeamVibFEMResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        PlaneBeamVibFEMPunktePanel.auslesen();
        PlaneBeamVibFEMMaterialPanel.auslesen();
        PlaneBeamVibFEMMassePanel.auslesen();
    }

    public static void eachLineFileOperations(String string) {
        PlaneBeamVibFEMResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("bev", self);
    }

    static void getTransform(double[][] dArray, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        if (Math.abs(d2) < 1.0E-6) {
            d2 = 0.0;
        }
        if (Math.abs(d3) < 1.0E-6) {
            d3 = 0.0;
        }
        dArray[0][0] = d2;
        dArray[0][1] = d3;
        dArray[1][1] = d2;
        dArray[1][0] = -d3;
        dArray[2][2] = 1.0;
        dArray[3][3] = d2;
        dArray[3][4] = d3;
        dArray[4][4] = d2;
        dArray[4][3] = -d3;
        dArray[5][5] = 1.0;
    }

    static double getRho(int n) {
        int n2 = PlaneBeamVibFEMElementPanel.materialIndex[n].getInt() - 1;
        return PlaneBeamVibFEMMaterialPanel.rho[n2].getDouble();
    }

    static void elementMatrices(WPoint wPoint, WPoint wPoint2, int n, double[][] dArray, double[][] dArray2, int n2) {
        double d;
        double[][] dArray3 = new double[6][6];
        double[][] dArray4 = new double[6][6];
        WPoint wPoint3 = new WPoint(wPoint.x - wPoint2.x, wPoint.y - wPoint2.y);
        wPoint3.normiere();
        double[] dArray5 = new double[]{wPoint3.x, wPoint3.y};
        double d2 = wPoint2.x - wPoint.x;
        double d3 = wPoint2.y - wPoint.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (d4 == 0.0) {
            return;
        }
        VectorSet.vszero(dArray);
        VectorSet.vszero(dArray2);
        dArray[0][0] = d = PlaneBeamVibFEMResultPanel.mdata[n].E * PlaneBeamVibFEMResultPanel.mdata[n].A / d4;
        dArray[0][3] = -d;
        dArray[3][3] = d;
        double d5 = PlaneBeamVibFEMResultPanel.mdata[n].I;
        double d6 = PlaneBeamVibFEMResultPanel.mdata[n].E * d5;
        d = d6 / (d4 * d4 * d4);
        if (n2 == 0) {
            dArray[1][1] = d * 12.0;
            dArray[1][2] = d * 6.0 * d4;
            dArray[1][4] = -d * 12.0;
            dArray[1][5] = d * 6.0 * d4;
            dArray[2][2] = d * d4 * d4 * 4.0;
            dArray[2][4] = -d * d4 * 6.0;
            dArray[2][5] = d * d4 * d4 * 2.0;
            dArray[4][4] = d * 12.0;
            dArray[4][5] = -d * 6.0 * d4;
            dArray[5][5] = d * d4 * d4 * 4.0;
        } else if (n2 == 1) {
            dArray[1][1] = d * 3.0;
            dArray[1][4] = -d * 3.0;
            dArray[1][5] = d * 3.0 * d4;
            dArray[4][4] = d * 3.0;
            dArray[4][5] = -d * 3.0 * d4;
            dArray[5][5] = d * 3.0 * d4 * d4;
        } else if (n2 == 2) {
            dArray[1][1] = d * 3.0;
            dArray[1][2] = d * 3.0 * d4;
            dArray[1][4] = -d * 3.0;
            dArray[2][2] = d * 3.0 * d4 * d4;
            dArray[2][4] = -d * 3.0 * d4;
            dArray[4][4] = d * 3.0;
        }
        double d7 = PlaneBeamVibFEMResultPanel.mdata[n].rho * PlaneBeamVibFEMResultPanel.mdata[n].A * d4 / 6.0;
        dArray2[0][0] = 2.0 * d7;
        dArray2[0][3] = d7;
        dArray2[3][3] = 2.0 * d7;
        d7 = PlaneBeamVibFEMResultPanel.mdata[n].rho * PlaneBeamVibFEMResultPanel.mdata[n].A * d4 / 420.0;
        if (n2 == 0) {
            dArray2[1][1] = d7 * 156.0;
            dArray2[1][2] = d7 * d4 * 22.0;
            dArray2[1][4] = d7 * 54.0;
            dArray2[1][5] = -d7 * d4 * 13.0;
            dArray2[2][2] = d7 * d4 * d4 * 4.0;
            dArray2[2][4] = d7 * d4 * 13.0;
            dArray2[2][5] = -d7 * d4 * d4 * 3.0;
            dArray2[4][4] = d7 * 156.0;
            dArray2[4][5] = -d7 * d4 * 22.0;
            dArray2[5][5] = d7 * d4 * d4 * 4.0;
        } else if (n2 == 1) {
            dArray2[1][1] = d7 * 99.0;
            dArray2[1][4] = d7 * 58.5;
            dArray2[1][5] = -d7 * d4 * 16.5;
            dArray2[4][4] = d7 * 204.0;
            dArray2[4][5] = -d7 * d4 * 36.0;
            dArray2[5][5] = d7 * d4 * d4 * 8.0;
        } else if (n2 == 2) {
            dArray2[1][1] = d7 * 204.0;
            dArray2[1][2] = d7 * d4 * 36.0;
            dArray2[1][4] = d7 * 58.5;
            dArray2[2][2] = d7 * d4 * d4 * 8.0;
            dArray2[2][4] = d7 * d4 * 16.5;
            dArray2[4][4] = d7 * 99.0;
        } else {
            dArray2[1][1] = dArray2[0][0];
            dArray2[1][4] = dArray2[0][0] * 0.5;
            dArray2[4][4] = dArray2[0][0];
        }
        for (int i = 1; i <= 5; ++i) {
            for (int j = 0; j < i; ++j) {
                dArray[i][j] = dArray[j][i];
                dArray2[i][j] = dArray2[j][i];
            }
        }
        PlaneBeamVibFEMResultPanel.getTransform(dArray3, GrPanel.winkel(d2, d3));
        Kondensation.transform(dArray2, dArray2, dArray4, dArray3);
        Kondensation.transform(dArray, dArray, dArray4, dArray3);
    }

    static void springMatrices(WPoint wPoint, WPoint wPoint2, int n, double[][] dArray, double[][] dArray2) {
        double d;
        double[][] dArray3 = new double[6][6];
        double[][] dArray4 = new double[6][6];
        VectorSet.vszero(dArray);
        VectorSet.vszero(dArray2);
        dArray[0][0] = d = PlaneBeamVibFEMResultPanel.mdata[n].E;
        dArray[0][3] = -d;
        dArray[3][3] = d;
        double d2 = PlaneBeamVibFEMResultPanel.mdata[n].rho / 6.0;
        dArray2[0][0] = 2.0 * d2;
        dArray2[0][3] = d2;
        dArray2[3][3] = 2.0 * d2;
        for (int i = 1; i < 6; ++i) {
            for (int j = 0; j < i; ++j) {
                dArray[i][j] = dArray[j][i];
                dArray2[i][j] = dArray2[j][i];
            }
        }
        double d3 = wPoint2.x - wPoint.x;
        double d4 = wPoint2.y - wPoint.y;
        PlaneBeamVibFEMResultPanel.getTransform(dArray3, GrPanel.winkel(d3, d4));
        Kondensation.transform(dArray2, dArray2, dArray4, dArray3);
        Kondensation.transform(dArray, dArray, dArray4, dArray3);
    }

    static int maskenAuslesen() {
        PlaneBeamVibFEMMaterialPanel.auslesen();
        PlaneBeamVibFEMPunktePanel.auslesen();
        np = PlaneBeamVibFEMPunktePanel.np;
        PlaneBeamVibFEMMassePanel.auslesen();
        PlaneBeamVibFEMElementPanel.auslesen();
        for (int i = 0; i < np; ++i) {
            boolean bl = PlaneBeamVibFEMLagerPanel.cx[i].isSelected();
            boolean bl2 = PlaneBeamVibFEMLagerPanel.cy[i].isSelected();
            boolean bl3 = PlaneBeamVibFEMLagerPanel.cb[i].isSelected();
            PlaneBeamVibFEMResultPanel.randbdg[i] = (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0);
        }
        return 0;
    }

    int gesamtMatrizen() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        double[][] dArray = new double[6][6];
        double[][] dArray2 = new double[6][6];
        WPoint[] wPointArray = PlaneBeamVibFEMPunktePanel.pp;
        this.errorMsg("");
        int n6 = PlaneBeamVibFEMResultPanel.maskenAuslesen();
        if (np == 0) {
            return -1;
        }
        int n7 = 3 * np;
        Mges = new double[n7][n7];
        Kges = new double[n7][n7];
        int[] nArray = new int[n7];
        int n8 = 0;
        for (n4 = 0; n4 < np; ++n4) {
            n3 = 3 * n4;
            double d = masse[n4];
            PlaneBeamVibFEMResultPanel.Mges[n3 + 1][n3 + 1] = d;
            PlaneBeamVibFEMResultPanel.Mges[n3][n3] = d;
            PlaneBeamVibFEMResultPanel.Mges[n3 + 2][n3 + 2] = massentraegheit[n4];
        }
        for (n4 = 0; n4 < nElem; ++n4) {
            int n9 = federIndizes[n4][0];
            int n10 = federIndizes[n4][1];
            int n11 = federEndCode[n4];
            if (n9 >= np || n10 >= np) {
                this.errorMsg(myLocale.getString("unzulaessigeElementEndnummer") + " " + (n9 > n10 ? n9 + 1 : n10 + 1));
                return -2;
            }
            n2 = n9 * 3;
            int n12 = n10 * 3;
            int n13 = matNr[n4];
            if (n13 < 0) {
                this.errorMsg(myLocale.getString("fehlendeMaterialnummerBeiElement") + " " + (n4 + 1));
                return -2;
            }
            WPoint wPoint = wPointArray[n9];
            WPoint wPoint2 = wPointArray[n10];
            if (n11 < 4) {
                PlaneBeamVibFEMResultPanel.elementMatrices(wPoint, wPoint2, matNr[n4], dArray, dArray2, n11);
            } else {
                PlaneBeamVibFEMResultPanel.springMatrices(wPoint, wPoint2, matNr[n4], dArray, dArray2);
            }
            if (PlaneBeamVibFEMResultPanel.mdata[n13].E == 0.0) {
                this.errorMsg(myLocale.getString("FehlenderEModulBeiMaterial") + " " + (n13 + 1));
                return -3;
            }
            if (PlaneBeamVibFEMResultPanel.mdata[n13].I == 0.0 && n11 < 4) {
                this.errorMsg(myLocale.getString("FehlendesFlaechentraegheitsmomentBeiMaterial") + " " + (n13 + 1));
                return -3;
            }
            if (PlaneBeamVibFEMResultPanel.mdata[n13].A == 0.0 && n11 < 4) {
                this.errorMsg(myLocale.getString("FehlendeQuerschnittsflaecheBeiMaterial") + " " + (n13 + 1));
                return -3;
            }
            if (PlaneBeamVibFEMResultPanel.mdata[n13].A != 0.0 && n11 == 4) {
                this.errorMsg(myLocale.getString("Materialdaten") + " " + (n13 + 1) + " " + myLocale.getString("fuerFederungeeignet"));
                return -3;
            }
            for (int i = 0; i < 3; ++i) {
                int n14 = i + 3;
                for (n = 0; n < 3; ++n) {
                    int n15 = n + 3;
                    double[] dArray3 = Kges[n2 + i];
                    int n16 = n2 + n;
                    dArray3[n16] = dArray3[n16] + dArray[i][n];
                    double[] dArray4 = Kges[n12 + i];
                    int n17 = n12 + n;
                    dArray4[n17] = dArray4[n17] + dArray[n14][n15];
                    double[] dArray5 = Kges[n2 + i];
                    int n18 = n12 + n;
                    dArray5[n18] = dArray5[n18] + dArray[i][n15];
                    double[] dArray6 = Kges[n12 + i];
                    int n19 = n2 + n;
                    dArray6[n19] = dArray6[n19] + dArray[n14][n];
                    double[] dArray7 = Mges[n2 + i];
                    int n20 = n2 + n;
                    dArray7[n20] = dArray7[n20] + dArray2[i][n];
                    double[] dArray8 = Mges[n12 + i];
                    int n21 = n12 + n;
                    dArray8[n21] = dArray8[n21] + dArray2[n14][n15];
                    double[] dArray9 = Mges[n2 + i];
                    int n22 = n12 + n;
                    dArray9[n22] = dArray9[n22] + dArray2[i][n15];
                    double[] dArray10 = Mges[n12 + i];
                    int n23 = n2 + n;
                    dArray10[n23] = dArray10[n23] + dArray2[n14][n];
                }
            }
        }
        for (n4 = 0; n4 < active.length; ++n4) {
            PlaneBeamVibFEMResultPanel.active[n4] = true;
        }
        for (n4 = 0; n4 < np; ++n4) {
            n3 = 3 * n4;
            for (n2 = 1; n2 <= 4; n2 <<= 1) {
                if (Mges[n3][n3] == 0.0 || (randbdg[n4] & n2) != 0) {
                    nArray[n8++] = n3;
                }
                if (Mges[n3][n3] == 0.0 && Kges[n3][n3] == 0.0) {
                    PlaneBeamVibFEMResultPanel.Kges[n3][n3] = -1.0;
                    PlaneBeamVibFEMResultPanel.active[n3] = false;
                } else if ((randbdg[n4] & n2) != 0) {
                    for (n = 0; n < n7; ++n) {
                        PlaneBeamVibFEMResultPanel.Kges[n3][n] = 0.0;
                        PlaneBeamVibFEMResultPanel.Kges[n][n3] = 0.0;
                        PlaneBeamVibFEMResultPanel.Mges[n3][n] = 0.0;
                        PlaneBeamVibFEMResultPanel.Mges[n][n3] = 0.0;
                    }
                    PlaneBeamVibFEMResultPanel.Kges[n3][n3] = -1.0;
                    PlaneBeamVibFEMResultPanel.active[n3] = false;
                }
                ++n3;
            }
        }
        if (n8 == n7) {
            this.clearFields();
            this.errorMsg(myLocale.getString("keineBeweglicheMasseImSystem"));
            return -3;
        }
        if (n8 != 0) {
            n5 = n7 - n8;
            n2 = Kondensation.execute(Kges, Mges, nArray, n8);
            if (n2 != 0) {
                this.errorMsg(myLocale.getString("ungefesselteElementeImSystem"));
                return -4;
            }
            ev = new double[n5][n5];
            ew = new double[n5];
        } else {
            ev = new double[n7][n7];
            ew = new double[n7];
        }
        n2 = Jacobi.allgEWP(Kges, Mges, ew, ev);
        for (n4 = 0; n4 < ew.length; ++n4) {
            if (Math.abs(ew[n4]) < 1.0E-4) {
                PlaneBeamVibFEMResultPanel.ew[n4] = 0.0;
            }
            if (!(ew[n4] > 0.0)) continue;
            PlaneBeamVibFEMResultPanel.ew[n4] = Math.sqrt(ew[n4]) / (Math.PI * 2);
        }
        formAnz = n5;
        if (n8 != 0) {
            double[][] dArray11 = ev;
            ev = new double[n7][n5];
            double[] dArray12 = new double[n7];
            for (n = 0; n < n5; ++n) {
                for (n4 = 0; n4 < n5; ++n4) {
                    dArray12[n4] = dArray11[n4][n];
                }
                Kondensation.vectorBackTransform(dArray12, n5, n7);
                VectorSet.vsnorm(dArray12);
                for (n4 = 0; n4 < n7; ++n4) {
                    PlaneBeamVibFEMResultPanel.ev[n4][n] = dArray12[n4];
                }
            }
        }
        return 0;
    }

    int showEigenform() {
        int n;
        dx = new double[np];
        dy = new double[np];
        dw = new double[np];
        int n2 = this.nrtf.getInt();
        if (n2 > formAnz) {
            n2 = formAnz;
            this.nrtf.setText("" + formAnz);
        }
        if (--n2 < 0) {
            n2 = 0;
            this.nrtf.setText("1");
        }
        int n3 = formAnz - 1;
        int n4 = n3 - n2;
        for (n = 0; n < np; ++n) {
            PlaneBeamVibFEMResultPanel.dx[n] = ev[3 * n][n4];
            PlaneBeamVibFEMResultPanel.dy[n] = ev[3 * n + 1][n4];
            PlaneBeamVibFEMResultPanel.dw[n] = ev[3 * n + 2][n4];
        }
        if (Math.abs(ew[n4]) < 1.0E-5) {
            PlaneBeamVibFEMResultPanel.ew[n4] = 0.0;
        }
        ekfr = ew[n4];
        this.ewtf.setText(NumEdit.toPrecision(ew[n4], 4));
        Object object = "";
        String[] stringArray = new String[]{"u", "v", "\u03b2"};
        for (n = 0; n < ev.length; ++n) {
            if (!active[n]) continue;
            if (Math.abs(ev[n][n4]) < 1.0E-4) {
                PlaneBeamVibFEMResultPanel.ev[n][n4] = 0.0;
            }
            String string = stringArray[n % 3] + (n / 3 + 1) + " : ";
            object = (String)object + string + this.formatiere(ev[n][n4]) + "\n";
        }
        this.txarea.setText((String)object);
        this.txarea.setCaretPosition(0);
        return 0;
    }

    String formatiere(double d) {
        String string = NumEdit.toPrecision(d, 3);
        return d < 0.0 ? string : " " + string;
    }

    void clearFields() {
        this.errorMsg("");
        this.txarea.setText("");
        this.nrtf.setText("");
        this.ewtf.setText("");
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.currGrPan.stop();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        int n = 0;
        PlaneBeamVibFEMGrafikPanel cfr_ignored_0 = (PlaneBeamVibFEMGrafikPanel)this.grafikPanel;
        if (!PlaneBeamVibFEMGrafikPanel.isRunning && (n = this.gesamtMatrizen()) == 0) {
            ((PlaneBeamVibFEMGrafikPanel)this.grafikPanel).init();
            this.nrtf.setText("1");
            this.showEigenform();
        }
    }

    static {
        currFile = null;
        mdata = new PlaneBeamVibFEMMaterialDaten[10];
        masse = new double[16];
        massentraegheit = new double[16];
        matNr = new int[32];
        federIndizes = new int[32][2];
        federEndCode = new int[32];
        randbdg = new int[16];
        active = new boolean[48];
    }
}

