/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

class PlaneBeamVibFEMGrafikPanel
extends GrPanel
implements Runnable {
    Thread simuThread = null;
    static boolean isRunning = false;
    static double t;
    static double dt;
    double uskal;
    WPoint[] feder = new WPoint[]{new WPoint(0.0, 0.0), new WPoint(0.0, 25.0), new WPoint(-50.0, 50.0), new WPoint(50.0, 100.0), new WPoint(-50.0, 150.0), new WPoint(50.0, 200.0), new WPoint(-50.0, 250.0), new WPoint(50.0, 300.0), new WPoint(-50.0, 350.0), new WPoint(50.0, 400.0), new WPoint(0.0, 425.0), new WPoint(0.0, 450.0)};
    int a = 6;
    int b = 8;
    int[] lines_fest = new int[]{0, 0, this.a, this.b, 0, 0, -this.a, this.b, this.a + 3, this.b, -this.a - 3, this.b, -this.a - 6, this.b + 3, -this.a - 3, this.b, -this.a - 3, this.b + 3, -this.a, this.b, -this.a, this.b + 3, -this.a + 3, this.b, -this.a + 3, this.b + 3, -this.a + 6, this.b, -this.a + 6, this.b + 3, -this.a + 9, this.b, -this.a + 9, this.b + 3, -this.a + 12, this.b, -this.a + 12, this.b + 3, -this.a + 15, this.b};
    int[] lines_los = new int[]{0, 0, this.a, this.b, this.a, this.b, -this.a, this.b, -this.a, this.b, 0, 0, this.a + 3, this.b + 3, -this.a - 3, this.b + 3};
    int[] lines_einsp = new int[]{-6, 3, -3, 6, -6, 0, 0, 6, -6, -3, 3, 6, -6, -6, 6, 6, -3, -6, 6, 3, 0, -6, 6, 0, 3, -6, 6, -3};
    int[] lines_fuehrung_h = new int[]{-6, -3, 6, -3, -7, 0, 7, 0, -6, 3, 6, 3, -6, -6, -3, -3, -3, -6, 0, -3, 0, -6, 3, -3, 3, -6, 6, -3, -6, 3, -3, 6, -3, 3, 0, 6, 0, 3, 3, 6, 3, 3, 6, 6};
    int[] lines_fuehrung_v = new int[]{-3, -6, -3, 6, 0, -7, 0, 7, 3, -6, 3, 6, -6, -6, -3, -3, -6, -3, -3, 0, -6, 0, -3, 3, -6, 3, -3, 6, 3, -6, 6, -3, 3, -3, 6, 0, 3, 0, 6, 3, 3, 3, 6, 6};
    int a1 = this.a - 1;
    int b1 = this.b - 1;
    int a2 = this.a - 2;
    int b2 = this.b - 2;
    int a3 = this.a - 3;
    int b3 = this.b - 3;
    int[] lines_box = new int[]{-this.a, -this.b, this.a, -this.b, this.a, -this.b, this.a, this.b, this.a, this.b, -this.a, this.b, -this.a, this.b, -this.a, -this.b, -this.a1, -this.b1, this.a1, -this.b1, this.a1, -this.b1, this.a1, this.b1, this.a1, this.b1, -this.a1, this.b1, -this.a1, this.b1, -this.a1, -this.b1, -this.a2, -this.b2, this.a2, -this.b2, this.a2, -this.b2, this.a2, this.b2, this.a2, this.b2, -this.a2, this.b2, -this.a2, this.b2, -this.a2, -this.b2, -this.a3, -this.b3, this.a3, -this.b3, this.a3, -this.b3, this.a3, this.b3, this.a3, this.b3, -this.a3, this.b3, -this.a3, this.b3, -this.a3, -this.b3};
    WPoint[] pp = new WPoint[PlaneBeamVibFEMPunktePanel.pp.length];
    int mouseDraggIndex = -1;
    WPoint dStart = null;
    WPoint dEnd = new WPoint();

    public void init() {
        if (!isRunning) {
            PlaneBeamVibFEMGrafikPanel.initData();
            this.simuThread = new Thread(this);
            this.simuThread.setDaemon(true);
            this.simuThread.start();
        }
    }

    static void initData() {
        t = 0.0;
        dt = 0.05;
    }

    void timer() {
        t += dt;
    }

    @Override
    public void run() {
        isRunning = true;
        while (isRunning) {
            try {
                this.timer();
                this.repaint();
                Thread.sleep((int)(dt * 1000.0));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        isRunning = false;
        t = 0.0;
    }

    PlaneBeamVibFEMGrafikPanel() {
        isRunning = false;
        this.addMouseMotionListener(this);
    }

    void verschiebungsSkalierFaktor() {
        double d = this.getwmaxx() - this.getwminx();
        this.uskal = 0.0;
        for (int i = 0; i < PlaneBeamVibFEMResultPanel.np; ++i) {
            double d2 = PlaneBeamVibFEMResultPanel.dx[i] * PlaneBeamVibFEMResultPanel.dx[i] + PlaneBeamVibFEMResultPanel.dy[i] * PlaneBeamVibFEMResultPanel.dy[i];
            if ((d2 = Math.sqrt(d2)) > this.uskal) {
                this.uskal = d2;
            }
            if (!((d2 = Math.abs(PlaneBeamVibFEMResultPanel.dw[i] * d * 0.05)) > this.uskal)) continue;
            this.uskal = d2;
        }
        this.uskal = this.uskal < 0.001 ? 1.0 : 0.04 * d / this.uskal;
    }

    void zeichneKlotz(int n, WPoint wPoint) {
        double d = 0.0;
        if (PlaneBeamVibFEMResultPanel.dx != null) {
            double d2 = PlaneBeamVibFEMResultPanel.ekfr == 0.0 ? 1.5 : 4.0;
            double d3 = Math.sin(d2 * t);
            d = -Math.atan(this.uskal * PlaneBeamVibFEMResultPanel.dw[n]) * d3;
        }
        this.drawLines(this.lines_box, this.screenx(wPoint), this.screeny(wPoint), d);
    }

    void drawBeam(int n, int n2, WPoint wPoint, WPoint wPoint2, int n3) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        WPoint wPoint3 = new WPoint(0.0, 0.0);
        if (PlaneBeamVibFEMResultPanel.dx != null && PlaneBeamVibFEM.currpan == 5) {
            d8 = PlaneBeamVibFEMResultPanel.ekfr == 0.0 ? 1.5 : 4.0;
            d7 = Math.sin(d8 * t);
            d6 = this.uskal * PlaneBeamVibFEMResultPanel.dx[n] * d7;
            d5 = this.uskal * PlaneBeamVibFEMResultPanel.dy[n] * d7;
            d4 = Math.atan(this.uskal * PlaneBeamVibFEMResultPanel.dw[n]) * d7;
            d3 = this.uskal * PlaneBeamVibFEMResultPanel.dx[n2] * d7;
            d2 = this.uskal * PlaneBeamVibFEMResultPanel.dy[n2] * d7;
            d = Math.atan(this.uskal * PlaneBeamVibFEMResultPanel.dw[n2]) * d7;
        } else {
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            d5 = 0.0;
            d6 = 0.0;
        }
        double d9 = wPoint2.x - wPoint.x;
        double d10 = wPoint2.y - wPoint.y;
        d8 = Math.sqrt(d9 * d9 + d10 * d10);
        d7 = d9 / d8;
        double d11 = d10 / d8;
        int n4 = 9;
        double d12 = 1.0 / (double)n4;
        double d13 = -d11 * d6 + d7 * d5;
        double d14 = d4 * d8;
        double d15 = -d11 * d3 + d7 * d2;
        double d16 = d * d8;
        double d17 = d7 * d6 + d11 * d5;
        d8 += d7 * d3 + d11 * d2 - d17;
        double d18 = wPoint.x + d7 * d17;
        double d19 = wPoint.y + d11 * d17;
        wPoint.x += d6;
        wPoint.y += d5;
        this.wMoveTo(wPoint);
        double d20 = 0.0;
        if (n3 == 0) {
            for (int i = 1; i < n4; ++i) {
                double d21 = (d20 += d12) * d20;
                double d22 = d20 * d21;
                double d23 = d13 * (1.0 - 3.0 * d21 + 2.0 * d22) + d14 * (d20 - 2.0 * d21 + d22) + d15 * (3.0 * d21 - 2.0 * d22) + d16 * (d22 - d21);
                wPoint3.x = d18 + d7 * d8 * d20 - d11 * d23;
                wPoint3.y = d19 + d11 * d8 * d20 + d7 * d23;
                this.wLineTo3(wPoint3.x, wPoint3.y);
            }
        } else if (n3 == 1) {
            for (int i = 1; i < n4; ++i) {
                double d24 = (d20 += d12) * d20;
                double d25 = d20 * d24;
                double d26 = d13 * (1.0 - 1.5 * d20 + 0.5 * d25) + d15 * (-0.5 * d25 + 1.5 * d20) + d16 * (-0.5 * d20 + 0.5 * d25);
                wPoint3.x = d18 + d7 * d8 * d20 - d11 * d26;
                wPoint3.y = d19 + d11 * d8 * d20 + d7 * d26;
                this.wLineTo3(wPoint3.x, wPoint3.y);
            }
        } else if (n3 == 2) {
            for (int i = 1; i < n4; ++i) {
                double d27 = (d20 += d12) * d20;
                double d28 = d20 * d27;
                double d29 = d13 * (1.0 - 1.5 * d27 + 0.5 * d28) + d14 * (d20 - 1.5 * d27 + 0.5 * d28) + d15 * (-0.5 * d28 + 1.5 * d27);
                wPoint3.x = d18 + d7 * d8 * d20 - d11 * d29;
                wPoint3.y = d19 + d11 * d8 * d20 + d7 * d29;
                this.wLineTo3(wPoint3.x, wPoint3.y);
            }
        }
        wPoint2.x += d3;
        wPoint2.y += d2;
        this.wLineTo3(wPoint2.x, wPoint2.y);
    }

    void drawSpring(int n, int n2, WPoint wPoint, WPoint wPoint2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7 = (double)GR_W / this.xfak;
        double d8 = this.feder[3].x - this.feder[2].x;
        double d9 = d7 / d8 * 0.05;
        double d10 = this.feder[11].y - this.feder[0].y;
        if (PlaneBeamVibFEMResultPanel.dx != null && PlaneBeamVibFEM.currpan == 5) {
            d6 = PlaneBeamVibFEMResultPanel.ekfr == 0.0 ? 1.5 : 4.0;
            d5 = Math.sin(d6 * t);
            d4 = this.uskal * PlaneBeamVibFEMResultPanel.dx[n] * d5;
            d3 = this.uskal * PlaneBeamVibFEMResultPanel.dy[n] * d5;
            d2 = this.uskal * PlaneBeamVibFEMResultPanel.dx[n2] * d5;
            d = this.uskal * PlaneBeamVibFEMResultPanel.dy[n2] * d5;
        } else {
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
        }
        wPoint.x += d4;
        wPoint.y += d3;
        wPoint2.x += d2;
        wPoint2.y += d;
        d6 = wPoint2.x - wPoint.x;
        d5 = wPoint2.y - wPoint.y;
        double d11 = Math.sqrt(d6 * d6 + d5 * d5);
        double[][] dArray = Transformation.skalieren(d9, d11 / d10);
        double d12 = PlaneBeamVibFEMGrafikPanel.winkel(d6, d5) - 1.5707963267948966;
        Transformation.drehen(dArray, d12);
        Transformation.verschieben(dArray, wPoint.x, wPoint.y);
        this.zeichnePolygon(this.feder, dArray);
    }

    void zeichnePolygon(WPoint[] wPointArray, double[][] dArray) {
        WPoint wPoint = new WPoint();
        int n = wPointArray.length - 1;
        Transformation.transformiere(wPoint, wPointArray[n], dArray);
        this.wMoveTo(wPoint.x, wPoint.y);
        while (--n >= 0) {
            Transformation.transformiere(wPoint, wPointArray[n], dArray);
            this.wLineTo2(wPoint.x, wPoint.y);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        int n2;
        Color color = PlaneBeamVibFEMGrafikPanel.newColor(90, 90, 90);
        Color color2 = PlaneBeamVibFEMGrafikPanel.newColor(0, 0, 0);
        Color color3 = PlaneBeamVibFEMGrafikPanel.newColor(200, 0, 0);
        Color color4 = PlaneBeamVibFEMGrafikPanel.newColor(185, 185, 185);
        Color color5 = PlaneBeamVibFEMGrafikPanel.newColor(145, 145, 145);
        Color color6 = PlaneBeamVibFEMGrafikPanel.newColor(111, 125, 137);
        boolean[] blArray = PlaneBeamVibFEMPunktePanel.isNode;
        WPoint[] wPointArray = PlaneBeamVibFEMPunktePanel.pp;
        int n3 = PlaneBeamVibFEMPunktePanel.np;
        WPoint wPoint = new WPoint();
        WPoint wPoint2 = new WPoint();
        WPoint wPoint3 = new WPoint();
        this.myg = graphics;
        int n4 = Math.abs(GR_W - this.getSize().width);
        if (n4 > 50) {
            GR_W = this.getSize().width;
        }
        if (this.mouseDraggIndex < 0) {
            this.setMinMax(wPointArray);
        }
        int n5 = this.pp.length;
        while (--n5 >= 0) {
            if (this.pp[n5] == null) {
                this.pp[n5] = new WPoint();
            }
            this.pp[n5].set(wPointArray[n5]);
        }
        if (isRunning && PlaneBeamVibFEMResultPanel.dx != null) {
            this.verschiebungsSkalierFaktor();
        }
        this.myg.setColor(color6);
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.myg.setColor(color5);
        this.grid();
        this.myg.setColor(color4);
        this.axes();
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        PlaneBeamVibFEMResultPanel.nElem = 0;
        for (n5 = 0; n5 < PlaneBeamVibFEMElementPanel.maxFeder; ++n5) {
            String string = PlaneBeamVibFEMElementPanel.nodeNumbers[n5].getText().replace(',', ' ');
            int[] nArray = NumEdit.getList(string);
            if (nArray == null || nArray.length < 2) continue;
            String string2 = PlaneBeamVibFEMElementPanel.materialIndex[n5].getTrimText();
            n2 = PlaneBeamVibFEMElementPanel.codes[n5].getInt();
            ++PlaneBeamVibFEMResultPanel.nElem;
            n = nArray[0] - 1;
            wPoint.set(this.pp[n]);
            int n6 = nArray[1] - 1;
            wPoint2.set(this.pp[n6]);
            if (string2.length() == 0) {
                this.myg.setColor(Color.white);
            } else if (PlaneBeamVibFEMResultPanel.getRho(n5) != 0.0) {
                this.myg.setColor(color3);
            } else {
                this.myg.setColor(color);
            }
            if (n2 == 4) {
                this.drawSpring(n, n6, wPoint, wPoint2);
            } else {
                this.drawBeam(n, n6, wPoint, wPoint2, n2);
            }
            if (n2 != 0) {
                this.myg.setColor(Color.yellow);
                if (n2 == 1 || n2 == 3) {
                    this.myg.drawOval(this.screenx(wPoint) - 3, this.screeny(wPoint) - 3, 6, 6);
                }
                if (n2 == 2 || n2 == 3) {
                    this.myg.drawOval(this.screenx(wPoint2) - 3, this.screeny(wPoint2) - 3, 6, 6);
                }
            }
            wPoint3.x = 0.5 * (wPoint.x + wPoint2.x);
            wPoint3.y = 0.5 * (wPoint.y + wPoint2.y);
            wPoint3.x += 0.05 * (wPoint.x - wPoint2.x);
            wPoint3.y += 0.05 * (wPoint.y - wPoint2.y);
            this.myg.setColor(color2);
            this.myg.drawString("" + (n5 + 1), this.screenx(wPoint3), this.screeny(wPoint3));
        }
        if (isRunning && PlaneBeamVibFEM.currpan == 5) {
            double d = PlaneBeamVibFEMResultPanel.ekfr == 0.0 ? 1.5 : 4.0;
            double d2 = this.uskal * Math.sin(d * t);
            for (n5 = 0; n5 < PlaneBeamVibFEMResultPanel.dx.length; ++n5) {
                if (!blArray[n5]) continue;
                this.pp[n5].x += d2 * PlaneBeamVibFEMResultPanel.dx[n5];
                this.pp[n5].y += d2 * PlaneBeamVibFEMResultPanel.dy[n5];
            }
        }
        this.myg.setColor(color3);
        for (n5 = 0; n5 < PlaneBeamVibFEMMassePanel.masse.length; ++n5) {
            double d = PlaneBeamVibFEMResultPanel.masse[n5];
            double d3 = PlaneBeamVibFEMResultPanel.massentraegheit[n5];
            if (d == 0.0 && d3 == 0.0) continue;
            if (d3 != 0.0) {
                this.zeichneKlotz(n5, this.pp[n5]);
            }
            n = 6;
            this.myg.fillOval(this.screenx(this.pp[n5]) - n, this.screeny(this.pp[n5]) - n, 2 * n, 2 * n);
        }
        this.myg.setColor(Color.white);
        for (n5 = 0; n5 < n3; ++n5) {
            if (!blArray[n5]) continue;
            boolean bl = PlaneBeamVibFEMLagerPanel.cx[n5].isSelected();
            boolean bl2 = PlaneBeamVibFEMLagerPanel.cy[n5].isSelected();
            boolean bl3 = PlaneBeamVibFEMLagerPanel.cb[n5].isSelected();
            if (!bl && !bl2 && !bl3) continue;
            n2 = this.screenx(this.pp[n5].x);
            n = this.screeny(this.pp[n5].y);
            if (bl && bl2 && bl3) {
                this.drawLines(this.lines_einsp, n2, n, 0.0);
                continue;
            }
            if (bl && bl2) {
                this.drawLines(this.lines_fest, n2, n, 0.0);
                continue;
            }
            if (bl && bl3) {
                this.drawLines(this.lines_fuehrung_v, n2, n, 0.0);
                continue;
            }
            if (bl2 && bl3) {
                this.drawLines(this.lines_fuehrung_h, n2, n, 0.0);
                continue;
            }
            if (bl2) {
                this.drawLines(this.lines_los, n2, n, 0.0);
                continue;
            }
            if (!bl) continue;
            double d = this.pp[n5].x > xmit ? -1.5707963267948966 : 1.5707963267948966;
            this.drawLines(this.lines_los, n2, n, d);
        }
        this.myg.setColor(Color.yellow);
        for (n5 = 0; n5 < n3; ++n5) {
            if (!blArray[n5]) continue;
            int n7 = this.screenx(this.pp[n5]);
            int n8 = this.screeny(this.pp[n5]);
            this.myg.fillOval(n7 - 2, n8 - 2, 4, 4);
            this.myg.drawString("" + (n5 + 1), n7 + 4, n8 - 4);
        }
        if (this.dStart != null) {
            this.myg.setColor(new Color(255, 0, 0));
            this.wMoveTo(this.dStart);
            this.wLineTo(this.dEnd);
        }
    }

    int locateNode(int n, int n2) {
        boolean[] blArray = PlaneBeamVibFEMPunktePanel.isNode;
        WPoint[] wPointArray = PlaneBeamVibFEMPunktePanel.pp;
        int n3 = wPointArray.length;
        while (--n3 >= 0) {
            int n4;
            if (!blArray[n3] || (n4 = Math.abs(this.screenx(wPointArray[n3].x) - n) + Math.abs(this.screeny(wPointArray[n3].y) - n2)) >= 10) continue;
            return n3;
        }
        return -1;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        super.mouseDragged(mouseEvent);
        if (PlaneBeamVibFEM.currpan == 0) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            if (this.mouseDraggIndex < 0) {
                this.mouseDraggIndex = this.locateNode(n2, n);
            }
            if (this.mouseDraggIndex >= 0) {
                PlaneBeamVibFEMPunktePanel.tfx[this.mouseDraggIndex].setValue(this.worldx(n2), 2);
                PlaneBeamVibFEMPunktePanel.tfy[this.mouseDraggIndex].setValue(this.worldy(n), 2);
                PlaneBeamVibFEMPunktePanel.auslesen();
                this.repaint();
            }
        }
        if (PlaneBeamVibFEM.currpan == 1) {
            n2 = mouseEvent.getX();
            n = mouseEvent.getY();
            if (this.mouseDraggIndex < 0) {
                this.mouseDraggIndex = this.locateNode(n2, n);
                if (this.mouseDraggIndex >= 0) {
                    this.dStart = this.pp[this.mouseDraggIndex];
                }
            } else {
                this.dEnd.x = this.worldx(n2);
                this.dEnd.y = this.worldy(n);
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDraggIndex >= 0) {
            int n;
            int n2;
            int n3;
            if (PlaneBeamVibFEM.currpan == 1 && (n3 = this.locateNode(n2 = mouseEvent.getX(), n = mouseEvent.getY())) >= 0) {
                int n4 = PlaneBeamVibFEMResultPanel.nElem++;
                PlaneBeamVibFEMElementPanel.nodeNumbers[n4].setText(this.mouseDraggIndex + 1 + " " + (n3 + 1));
                if (n4 > 0) {
                    PlaneBeamVibFEMElementPanel.materialIndex[n4].setText(PlaneBeamVibFEMElementPanel.materialIndex[n4 - 1].getText());
                    PlaneBeamVibFEMElementPanel.codes[n4].setText(PlaneBeamVibFEMElementPanel.codes[n4 - 1].getText());
                }
            }
            this.mouseDraggIndex = -1;
            this.dStart = null;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (PlaneBeamVibFEM.currpan != 0) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed()) {
            mouseEvent.consume();
            boolean[] blArray = PlaneBeamVibFEMPunktePanel.isNode;
            WPoint[] wPointArray = PlaneBeamVibFEMPunktePanel.pp;
            for (int i = 0; i < wPointArray.length; ++i) {
                if (blArray[i]) continue;
                wPointArray[i].x = this.worldx(mouseEvent.getX());
                wPointArray[i].y = this.worldy(mouseEvent.getY());
                PlaneBeamVibFEMPunktePanel.tfx[i].setValue(wPointArray[i].x, 2);
                PlaneBeamVibFEMPunktePanel.tfy[i].setValue(wPointArray[i].y, 2);
                blArray[i] = true;
                this.repaint();
                break;
            }
        }
    }
}

