/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class PlaneBeamVibFEM
extends JPanel
implements ActionListener {
    String[] lbs = new String[]{"Punkte", "Elemente", "Massen", "Lager", "Material", "Modalanalyse", "Beispiele", "Neu"};
    JButton[] bts = new JButton[this.lbs.length];
    DekorPanel[] pan = new DekorPanel[this.lbs.length];
    JPanel buttpan = new JPanel();
    CardLayout c = new CardLayout();
    JPanel mainpan = new JPanel();
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileNew;
    private JMenuItem fileQuit;
    static JMenuBar mb;
    static int currpan;
    static LabelStore labelStore;
    static DontExitFrame f;
    static String title;

    public static void main(String[] stringArray) {
        if (DontExitFrame.exists(title)) {
            return;
        }
        f = new DontExitFrame();
        PlaneBeamVibFEM planeBeamVibFEM = new PlaneBeamVibFEM();
        planeBeamVibFEM.init();
        f.setContentPane(planeBeamVibFEM);
        f.pack();
        f.setTitle(title);
        f.setSize(800, 600);
        f.setJMenuBar(mb);
        if (stringArray.length > 1) {
            Point point = new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            f.setLocation(point);
        }
        f.setVisible(true);
    }

    public void init() {
        currpan = 0;
        mb = new JMenuBar();
        JMenu jMenu = labelStore.newMenu("Datei");
        this.fileNew = labelStore.newMenuItem("Neu");
        jMenu.add(this.fileNew);
        this.fileOpen = labelStore.newMenuItem("Oeffnen");
        jMenu.add(this.fileOpen);
        this.fileSave = labelStore.newMenuItem("Speichern");
        jMenu.add(this.fileSave);
        this.fileSaveAs = labelStore.newMenuItem("SpeichernUnter");
        jMenu.add(this.fileSaveAs);
        jMenu.addSeparator();
        this.fileQuit = labelStore.newMenuItem("Ende");
        jMenu.add(this.fileQuit);
        this.fileSaveAs.addActionListener(this);
        this.fileSave.addActionListener(this);
        this.fileOpen.addActionListener(this);
        this.fileQuit.addActionListener(this);
        this.fileNew.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.add((Component)this.buttpan, "North");
        this.mainpan.setLayout(this.c);
        this.add((Component)this.mainpan, "Center");
        for (int i = 0; i < this.lbs.length; ++i) {
            this.bts[i] = labelStore.newButton(this.lbs[i]);
            this.bts[i].addActionListener(this);
            this.bts[i].setMargin(new Insets(2, 0, 2, 0));
            this.bts[i].setFont(new Font("Dialog", 0, 12));
            this.buttpan.add(this.bts[i]);
            switch (i) {
                case 0: {
                    this.pan[i] = new PlaneBeamVibFEMPunktePanel();
                    break;
                }
                case 1: {
                    this.pan[i] = new PlaneBeamVibFEMElementPanel();
                    break;
                }
                case 2: {
                    this.pan[i] = new PlaneBeamVibFEMMassePanel();
                    break;
                }
                case 3: {
                    this.pan[i] = new PlaneBeamVibFEMLagerPanel();
                    break;
                }
                case 4: {
                    this.pan[i] = new PlaneBeamVibFEMMaterialPanel();
                    break;
                }
                case 5: {
                    this.pan[i] = new PlaneBeamVibFEMResultPanel();
                    break;
                }
                case 6: {
                    this.pan[i] = new PlaneBeamVibFEMExamplePanel();
                }
            }
            if (this.pan[i] == null) continue;
            this.mainpan.add(this.lbs[i], this.pan[i]);
        }
        mb.add(jMenu);
        mb.add(f.lookMenu());
        mb.add(f.languageMenu(labelStore));
        mb.add(f.helpMenu(labelStore, "PlaneBeamVibFEM"));
        PlaneBeamVibFEMResultPanel.maskenLoeschen();
        this.setVisible(true);
        this.changePanel(0);
    }

    void changePanel(int n) {
        this.c.show(this.mainpan, this.lbs[n]);
        ((PlaneBeamVibFEMExamplePanel)this.pan[6]).clear();
        this.pan[5].statusMsg("");
        currpan = n;
    }

    void clearStatusFields() {
        int n = this.pan.length - 1;
        while (--n >= 0) {
            this.pan[n].statusMsg("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileOpen) {
            PlaneBeamVibFEMResultPanel.laden();
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            this.bts[0].requestFocus();
            PlaneBeamVibFEM.setTitle(PlaneBeamVibFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileSave) {
            PlaneBeamVibFEMResultPanel.speichern();
        } else if (actionEvent.getSource() == this.fileNew || actionEvent.getSource() == this.bts[7]) {
            PlaneBeamVibFEMResultPanel.maskenLoeschen();
            PlaneBeamVibFEMResultPanel.currFile = null;
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            PlaneBeamVibFEM.setTitle(null);
        } else if (actionEvent.getSource() == this.fileSaveAs) {
            PlaneBeamVibFEMResultPanel.speichernAls();
            PlaneBeamVibFEM.setTitle(PlaneBeamVibFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileQuit) {
            f.exit(0);
        } else {
            int n = this.bts.length;
            while (--n >= 0) {
                if (actionEvent.getSource() != this.bts[n]) continue;
                this.changePanel(n);
            }
        }
    }

    public static void setTitle(String string) {
        f.setTitle((String)(string == null ? title : title + " " + string));
    }

    static {
        currpan = 0;
        labelStore = new LabelStore();
        f = null;
        title = "Plane Beam Vibration FEM 2.03 (2020)";
    }
}

