/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

class PlaneBeamFEMResultPanel
extends DekorPanel {
    public static int nElem;
    public static int nMaterial;
    public static int np;
    public static final int MAXP = 40;
    public static final int MAXE = 80;
    static String currFile;
    JButton upJButton;
    JButton downJButton;
    JEditorPane jEditorPane;
    static PlaneBeamFEMResultPanel self;
    static PlaneBeamFEMMaterialDaten[] mdata;
    static int[] matNr;
    static int[][] federIndizes;
    static int[] federEndCode;
    static int[] randbdg;
    static double[][] steifMatrix;
    static double[][] lagerzeile;
    static double[] lagerlast;
    static double[] u;
    static double[] dx;
    static double[] dy;
    static double[] dw;
    static double[][][] calcForces;

    PlaneBeamFEMResultPanel() {
        super(new PlaneBeamFEMGrafikPanel(), 248);
        self = this;
        this.jEditorPane = new JEditorPane();
        this.jEditorPane.setContentType("text/html");
        this.jEditorPane.setEditable(false);
        this.jEditorPane.setBorder(BorderFactory.createEtchedBorder(0));
        JScrollPane jScrollPane = new JScrollPane(this.jEditorPane, 20, 30);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        this.jEditorPane.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:#000; font-family:times; margin: 4px;}");
        styleSheet.addRule("h4 {color: #eeeeee; background-color:#505050; font-size: 11px;}");
        styleSheet.addRule("pre {font-family: \"courier new\", courier, monospace; font-size: 11px;}");
        Document document = hTMLEditorKit.createDefaultDocument();
        this.jEditorPane.setDocument(document);
        jScrollPane.setPreferredSize(new Dimension(250, 120));
        this.remove(this.fieldPane);
        this.add((Component)jScrollPane, "East");
        for (int i = 0; i < mdata.length; ++i) {
            PlaneBeamFEMResultPanel.mdata[i] = new PlaneBeamFEMMaterialDaten(0.0, 0.0, 0.0);
        }
    }

    static void speichern(String string) {
        currFile = string;
        try {
            String string2;
            String string3;
            String string4;
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            for (n = 0; n < 40; ++n) {
                string4 = NumEdit.stripBlanks(PlaneBeamFEMPunktePanel.tfx[n].getText());
                string3 = NumEdit.stripBlanks(PlaneBeamFEMPunktePanel.tfy[n].getText());
                if (string4.length() <= 0 && string3.length() <= 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("P " + string4 + " " + string3 + "\n");
            }
            for (n = 0; n < 80; ++n) {
                string4 = PlaneBeamFEMElementPanel.nodeNumbers[n].getTrimText().replace(',', ' ');
                string3 = PlaneBeamFEMElementPanel.materialIndex[n].getTrimText();
                string2 = PlaneBeamFEMElementPanel.codes[n].getTrimText();
                if (string4.length() <= 0 || string3.length() <= 0) continue;
                fileWriter.write("E " + string4 + " " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 40; ++n) {
                string4 = NumEdit.stripBlanks(PlaneBeamFEMLoadPanel.tfx[n].getText());
                string3 = NumEdit.stripBlanks(PlaneBeamFEMLoadPanel.tfy[n].getText());
                string2 = NumEdit.stripBlanks(PlaneBeamFEMLoadPanel.tfm[n].getText());
                if (string4.length() == 0 && string3.length() == 0 && string2.length() == 0) continue;
                if (string4.length() == 0) {
                    string4 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                if (string2.length() == 0) {
                    string2 = "0";
                }
                fileWriter.write("L " + (n + 1) + " " + string4 + " " + string3 + " " + string2 + "\n");
            }
            for (n = 0; n < 40; ++n) {
                boolean bl = PlaneBeamFEMLagerPanel.cx[n].isSelected();
                boolean bl2 = PlaneBeamFEMLagerPanel.cy[n].isSelected();
                boolean bl3 = PlaneBeamFEMLagerPanel.cb[n].isSelected();
                if (!bl && !bl2 && !bl3) continue;
                int n2 = (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0);
                fileWriter.write("R " + (n + 1) + " " + n2);
                fileWriter.write("\n");
            }
            for (n = 0; n < mdata.length; ++n) {
                String string5 = NumEdit.stripBlanks(PlaneBeamFEMMaterialPanel.flaeche[n].getText());
                if (string5.length() <= 0) continue;
                String string6 = NumEdit.stripBlanks(PlaneBeamFEMMaterialPanel.traegheitsmoment[n].getText());
                if (string6.length() == 0) {
                    string6 = "0";
                }
                double d = PlaneBeamFEMMaterialPanel.emodul[n].getDouble();
                fileWriter.write("A " + string5 + " " + string6 + " " + d + "\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        PlaneBeamFEMResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("rst", self);
    }

    static void speichern() {
        if (currFile != null) {
            PlaneBeamFEMResultPanel.speichern(currFile);
        } else {
            PlaneBeamFEMResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = PlaneBeamFEMPunktePanel.tfx.length;
        while (--n >= 0) {
            PlaneBeamFEMPunktePanel.tfx[n].setText("");
            PlaneBeamFEMPunktePanel.tfy[n].setText("");
        }
        for (n = 0; n < 80; ++n) {
            PlaneBeamFEMElementPanel.nodeNumbers[n].setText("");
            PlaneBeamFEMElementPanel.materialIndex[n].setText("");
            PlaneBeamFEMElementPanel.codes[n].setText("");
        }
        for (n = 0; n < 40; ++n) {
            PlaneBeamFEMLoadPanel.tfx[n].setText("");
            PlaneBeamFEMLoadPanel.tfy[n].setText("");
            PlaneBeamFEMLoadPanel.tfm[n].setText("");
        }
        n = PlaneBeamFEMLagerPanel.cx.length;
        while (--n >= 0) {
            PlaneBeamFEMLagerPanel.cx[n].setSelected(false);
            PlaneBeamFEMLagerPanel.cy[n].setSelected(false);
            PlaneBeamFEMLagerPanel.cb[n].setSelected(false);
        }
        n = PlaneBeamFEMMaterialPanel.flaeche.length;
        while (--n >= 0) {
            PlaneBeamFEMMaterialPanel.flaeche[n].setText("");
            PlaneBeamFEMMaterialPanel.emodul[n].setText("");
            PlaneBeamFEMMaterialPanel.traegheitsmoment[n].setText("");
        }
        np = 0;
        nElem = 0;
        nMaterial = 0;
        PlaneBeamFEMPunktePanel.auslesen();
        PlaneBeamFEMLoadPanel.auslesen();
    }

    static void stringToFields(String object) {
        String[] stringArray = NumEdit.split((String)object);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    PlaneBeamFEMPunktePanel.tfx[np].setText(stringArray[1]);
                    PlaneBeamFEMPunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'E': {
                    object = stringArray[1] + " " + stringArray[2];
                    PlaneBeamFEMElementPanel.nodeNumbers[nElem].setText((String)object);
                    PlaneBeamFEMElementPanel.materialIndex[nElem].setText(stringArray[3]);
                    if (stringArray.length > 4) {
                        PlaneBeamFEMElementPanel.codes[nElem].setText(stringArray[4]);
                    }
                    ++nElem;
                    break;
                }
                case 'L': {
                    int n = Integer.parseInt(stringArray[1]);
                    PlaneBeamFEMLoadPanel.tfx[n - 1].setText(stringArray[2]);
                    PlaneBeamFEMLoadPanel.tfy[n - 1].setText(stringArray[3]);
                    if (stringArray.length <= 4) break;
                    PlaneBeamFEMLoadPanel.tfm[n - 1].setText(stringArray[4]);
                    break;
                }
                case 'A': {
                    PlaneBeamFEMMaterialPanel.flaeche[nMaterial].setText(stringArray[1]);
                    PlaneBeamFEMMaterialPanel.traegheitsmoment[nMaterial].setText(stringArray[2]);
                    PlaneBeamFEMMaterialPanel.emodul[nMaterial].setText(stringArray[3]);
                    ++nMaterial;
                    break;
                }
                case 'R': {
                    int n = Integer.parseInt(stringArray[1]);
                    int n2 = Integer.parseInt(stringArray[2]);
                    PlaneBeamFEMLagerPanel.cx[n - 1].setSelected((n2 & 1) != 0);
                    PlaneBeamFEMLagerPanel.cy[n - 1].setSelected((n2 & 2) != 0);
                    PlaneBeamFEMLagerPanel.cb[n - 1].setSelected((n2 & 4) != 0);
                }
            }
        }
    }

    public static void beforeFileOperations() {
        PlaneBeamFEMResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        PlaneBeamFEMPunktePanel.auslesen();
        PlaneBeamFEMLoadPanel.auslesen();
        PlaneBeamFEMMaterialPanel.auslesen();
    }

    public static void eachLineFileOperations(String string) {
        PlaneBeamFEMResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("rst", self);
    }

    static void getTransform(double[][] dArray, double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        if (Math.abs(d2) < 1.0E-6) {
            d2 = 0.0;
        }
        if (Math.abs(d3) < 1.0E-6) {
            d3 = 0.0;
        }
        dArray[0][0] = d2;
        dArray[0][1] = d3;
        dArray[1][1] = d2;
        dArray[1][0] = -d3;
        dArray[2][2] = 1.0;
        dArray[3][3] = d2;
        dArray[3][4] = d3;
        dArray[4][4] = d2;
        dArray[4][3] = -d3;
        dArray[5][5] = 1.0;
    }

    static void stiffnessMatrix(WPoint wPoint, WPoint wPoint2, int n, double[][] dArray, double[][] dArray2, int n2, double d) {
        double d2;
        double[][] dArray3 = new double[6][6];
        double d3 = wPoint2.x - wPoint.x;
        double d4 = wPoint2.y - wPoint.y;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        if (d5 == 0.0) {
            return;
        }
        VectorSet.vszero(dArray);
        dArray[0][0] = d2 = PlaneBeamFEMResultPanel.mdata[n].E * PlaneBeamFEMResultPanel.mdata[n].A / d5;
        dArray[0][3] = -d2;
        dArray[3][3] = d2;
        if (d != 0.0) {
            d2 = d / (d5 * 30.0);
            dArray[1][1] = d2 * 30.0;
            dArray[1][4] = -d2 * 30.0;
            dArray[4][4] = d2 * 30.0;
        }
        double d6 = PlaneBeamFEMResultPanel.mdata[n].I;
        double d7 = PlaneBeamFEMResultPanel.mdata[n].E * d6;
        d2 = d7 / (d5 * d5 * d5);
        if (n2 == 0) {
            dArray[1][1] = d2 * 12.0;
            dArray[1][2] = d2 * 6.0 * d5;
            dArray[1][4] = -d2 * 12.0;
            dArray[1][5] = d2 * 6.0 * d5;
            dArray[2][2] = d2 * d5 * d5 * 4.0;
            dArray[2][4] = -d2 * d5 * 6.0;
            dArray[2][5] = d2 * d5 * d5 * 2.0;
            dArray[4][4] = d2 * 12.0;
            dArray[4][5] = -d2 * 6.0 * d5;
            dArray[5][5] = d2 * d5 * d5 * 4.0;
        } else if (n2 == 1) {
            dArray[1][1] = d2 * 3.0;
            dArray[1][4] = -d2 * 3.0;
            dArray[1][5] = d2 * 3.0 * d5;
            dArray[4][4] = d2 * 3.0;
            dArray[4][5] = -d2 * 3.0 * d5;
            dArray[5][5] = d2 * 3.0 * d5 * d5;
        } else if (n2 == 2) {
            dArray[1][1] = d2 * 3.0;
            dArray[1][2] = d2 * 3.0 * d5;
            dArray[1][4] = -d2 * 3.0;
            dArray[2][2] = d2 * 3.0 * d5 * d5;
            dArray[2][4] = -d2 * 3.0 * d5;
            dArray[4][4] = d2 * 3.0;
        }
        for (int i = 1; i <= 5; ++i) {
            for (int j = 0; j < i; ++j) {
                dArray[i][j] = dArray[j][i];
            }
        }
        PlaneBeamFEMResultPanel.getTransform(dArray3, GrPanel.winkel(d3, d4));
        VectorSet.mamu(dArray2, dArray, dArray3);
        VectorSet.transpose(dArray3, dArray3);
        VectorSet.mamu(dArray, dArray3, dArray2);
    }

    static int maskenAuslesen() {
        int n;
        WPoint[] wPointArray = PlaneBeamFEMPunktePanel.pp;
        PlaneBeamFEMPunktePanel.auslesen();
        PlaneBeamFEMLoadPanel.auslesen();
        PlaneBeamFEMMaterialPanel.auslesen();
        np = PlaneBeamFEMPunktePanel.np;
        PlaneBeamFEMElementPanel.auslesen();
        for (n = 0; n < np; ++n) {
            boolean bl = PlaneBeamFEMLagerPanel.cx[n].isSelected();
            boolean bl2 = PlaneBeamFEMLagerPanel.cy[n].isSelected();
            boolean bl3 = PlaneBeamFEMLagerPanel.cb[n].isSelected();
            PlaneBeamFEMResultPanel.randbdg[n] = (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0);
        }
        u = new double[3 * np];
        for (n = 0; n < np; ++n) {
            PlaneBeamFEMResultPanel.u[3 * n] = PlaneBeamFEMLoadPanel.lastx[n];
            PlaneBeamFEMResultPanel.u[3 * n + 1] = PlaneBeamFEMLoadPanel.lasty[n];
            PlaneBeamFEMResultPanel.u[3 * n + 2] = PlaneBeamFEMLoadPanel.lastm[n];
        }
        return 0;
    }

    int gesamtMatrizen() {
        int n;
        int n2;
        String[] stringArray;
        String[] stringArray2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        boolean bl = false;
        double d = 0.0;
        double[][] dArray = new double[6][6];
        WPoint[] wPointArray = PlaneBeamFEMPunktePanel.pp;
        String string = "<br>";
        this.errorMsg("");
        this.jEditorPane.setText("");
        int n8 = PlaneBeamFEMResultPanel.maskenAuslesen();
        if (np == 0) {
            return -1;
        }
        int n9 = 3 * np;
        steifMatrix = new double[n9][n9];
        calcForces = new double[nElem][][];
        for (n7 = 0; n7 < nElem; ++n7) {
            n6 = federIndizes[n7][0];
            n5 = federIndizes[n7][1];
            n4 = federEndCode[n7];
            if (n6 >= np || n5 >= np) {
                VectorSet.vszero(u);
                this.errorMsg(myLocale.getString("unzulaessigeElementEndnummer") + " " + (n6 > n5 ? n6 + 1 : n5 + 1));
                return -2;
            }
            int n10 = n6 * 3;
            n3 = n5 * 3;
            int n11 = matNr[n7];
            if (n11 < 0) {
                VectorSet.vszero(u);
                this.errorMsg(myLocale.getString("fehlendeMaterialnummerBeiElement") + " " + (n7 + 1));
                return -2;
            }
            stringArray2 = wPointArray[n6];
            stringArray = wPointArray[n5];
            PlaneBeamFEMResultPanel.calcForces[n7] = new double[6][6];
            double d2 = n4 == 3 && PlaneBeamFEMResultPanel.mdata[n11].I < 0.0 ? -PlaneBeamFEMResultPanel.mdata[n11].I : 0.0;
            PlaneBeamFEMResultPanel.stiffnessMatrix((WPoint)stringArray2, (WPoint)stringArray, n11, dArray, calcForces[n7], n4, d2);
            if (PlaneBeamFEMResultPanel.mdata[n11].E == 0.0) {
                this.errorMsg(myLocale.getString("FehlenderEModulBeiMaterial") + " " + (n11 + 1));
                return -3;
            }
            if (PlaneBeamFEMResultPanel.mdata[n11].I == 0.0 && n4 != 3) {
                this.errorMsg(myLocale.getString("FehlendesFlaechentraegheitsmomentBeiMaterial") + " " + (n11 + 1));
                return -3;
            }
            if (PlaneBeamFEMResultPanel.mdata[n11].A == 0.0) {
                this.errorMsg(myLocale.getString("FehlendeQuerschnittsflaecheBeiMaterial") + " " + (n11 + 1));
                return -3;
            }
            for (int i = 0; i < 3; ++i) {
                int n12 = i + 3;
                for (n2 = 0; n2 < 3; ++n2) {
                    int n13 = n2 + 3;
                    double[] dArray2 = steifMatrix[n10 + i];
                    int n14 = n10 + n2;
                    dArray2[n14] = dArray2[n14] + dArray[i][n2];
                    double[] dArray3 = steifMatrix[n3 + i];
                    int n15 = n3 + n2;
                    dArray3[n15] = dArray3[n15] + dArray[n12][n13];
                    double[] dArray4 = steifMatrix[n10 + i];
                    int n16 = n3 + n2;
                    dArray4[n16] = dArray4[n16] + dArray[i][n13];
                    double[] dArray5 = steifMatrix[n3 + i];
                    int n17 = n10 + n2;
                    dArray5[n17] = dArray5[n17] + dArray[n12][n2];
                }
            }
        }
        lagerzeile = new double[n9][];
        lagerlast = new double[n9];
        int[] nArray = new int[n9];
        for (n7 = 0; n7 < np; ++n7) {
            n = 3 * n7;
            for (n3 = 1; n3 <= 4; n3 <<= 1) {
                if ((randbdg[n7] & n3) != 0) {
                    PlaneBeamFEMResultPanel.lagerzeile[n] = steifMatrix[n];
                }
                PlaneBeamFEMResultPanel.lagerlast[n] = u[n];
                ++n;
            }
        }
        for (n7 = 0; n7 < n9; ++n7) {
            if (Math.abs(steifMatrix[n7][n7]) > d) {
                d = Math.abs(steifMatrix[n7][n7]);
            }
            if (VectorSet.vsAbsMax(steifMatrix[n7]) != 0.0) continue;
            if (u[n7] == 0.0) {
                nArray[n7] = 1;
                continue;
            }
            this.errorMsg(myLocale.getString("Die Last am Knoten ") + (n7 / 3 + 1) + myLocale.getString(" kann nicht aufgenommen werden"));
            return -4;
        }
        for (n7 = 0; n7 < np; ++n7) {
            n = 3 * n7;
            for (n3 = 1; n3 <= 4; n3 <<= 1) {
                if ((randbdg[n7] & n3) != 0) {
                    PlaneBeamFEMResultPanel.steifMatrix[n] = new double[n9];
                    for (n2 = 0; n2 < n9; ++n2) {
                        PlaneBeamFEMResultPanel.steifMatrix[n2][n] = 0.0;
                    }
                    PlaneBeamFEMResultPanel.steifMatrix[n][n] = d;
                    PlaneBeamFEMResultPanel.u[n] = 0.0;
                }
                ++n;
            }
        }
        dx = new double[np];
        dy = new double[np];
        dw = new double[np];
        n8 = Gauss.fullPivoting(steifMatrix, u, n9);
        if (n8 < 0) {
            this.errorMsg(myLocale.getString("DieSystemmatrixIstSingulaer"));
            return -1;
        }
        for (n7 = 0; n7 < np; ++n7) {
            PlaneBeamFEMResultPanel.dx[n7] = u[3 * n7];
            PlaneBeamFEMResultPanel.dy[n7] = u[3 * n7 + 1];
            PlaneBeamFEMResultPanel.dw[n7] = u[3 * n7 + 2];
        }
        VectorSet.vsclear(u, 1.0E-12);
        String string2 = "<h4>" + myLocale.getString("Verschiebungen") + "</h4><pre>";
        stringArray2 = new String[]{"u", "v", "\u03b2"};
        for (n7 = 0; n7 < u.length; ++n7) {
            if (nArray[n7] != 0) continue;
            String string3 = stringArray2[n7 % 3] + "<sub>" + (n7 / 3 + 1) + "</sub> : ";
            string2 = string2 + string3 + this.formatiere(u[n7]) + string;
        }
        string2 = string2 + "</pre><h4>" + myLocale.getString("Lagerreaktionen") + "</h4><pre>";
        stringArray = new String[]{"F", "F", "M"};
        String[] stringArray3 = new String[]{"x", "y", "z"};
        for (n7 = 0; n7 < np; ++n7) {
            n = 3 * n7;
            for (n2 = 0; n2 < 3; ++n2) {
                if (lagerzeile[n + n2] == null) continue;
                double d3 = VectorSet.vsdot(lagerzeile[n + n2], u, n9) - lagerlast[n + n2];
                string2 = string2 + stringArray[n2] + "<sub>" + (n7 + 1) + stringArray3[n2] + "</sub> " + NumEdit.toPrecision(d3, 4) + string;
            }
        }
        double[] dArray6 = new double[6];
        double[] dArray7 = new double[6];
        string2 = string2 + "</pre><h4>" + myLocale.getString("Schnittreaktionen") + "</h4><pre>";
        String[] stringArray4 = new String[]{"N ", "Q ", "M<sub>1</sub>", "M<sub>2</sub>"};
        int[] nArray2 = new int[]{3, 4, 2, 5};
        for (n7 = 0; n7 < nElem; ++n7) {
            n4 = federEndCode[n7];
            int n18 = n4 != 3 ? 4 : 1;
            n6 = federIndizes[n7][0];
            n5 = federIndizes[n7][1];
            int n19 = n6 * 3;
            int n20 = n5 * 3;
            for (n2 = 0; n2 < 3; ++n2) {
                dArray6[n2] = u[n19 + n2];
                dArray6[n2 + 3] = u[n20 + n2];
            }
            VectorSet.mamu(dArray7, calcForces[n7], dArray6);
            VectorSet.vsclear(dArray7, 1.0E-9);
            string2 = string2 + "<b>" + myLocale.getString("Element") + " " + (n7 + 1) + "  (" + (n6 + 1) + "->" + (n5 + 1) + ")</b>" + string;
            for (n2 = 0; n2 < n18; ++n2) {
                double d4 = dArray7[nArray2[n2]];
                if (n2 == 2) {
                    d4 = -d4;
                }
                string2 = string2 + stringArray4[n2] + " " + NumEdit.toPrecision(d4, 4) + string;
            }
        }
        string2 = string2 + "</pre>";
        this.jEditorPane.setText(string2);
        this.jEditorPane.setCaretPosition(0);
        return 0;
    }

    String formatiere(double d) {
        String string = NumEdit.toPrecision(d, 3);
        return d < 0.0 ? string : " " + string;
    }

    static {
        currFile = null;
        mdata = new PlaneBeamFEMMaterialDaten[10];
        matNr = new int[80];
        federIndizes = new int[80][2];
        federEndCode = new int[80];
        randbdg = new int[40];
        u = null;
    }
}

