/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

public class PlaneBeamFEM
extends JPanel
implements ActionListener {
    String[] lbs = new String[]{"Punkte", "Elemente", "Material", "Lager", "Lasten", "Ergebnisse", "Beispiele", "Neu"};
    JButton[] bts = new JButton[this.lbs.length];
    DekorPanel[] pan = new DekorPanel[this.lbs.length];
    JPanel buttpan = new JPanel();
    CardLayout c = new CardLayout();
    JPanel mainpan = new JPanel();
    static String title = "Plane Beam Statics 2.05 (2020)";
    private JMenuItem fileOpen;
    private JMenuItem fileSave;
    private JMenuItem fileSaveAs;
    private JMenuItem fileNew;
    private JMenuItem fileQuit;
    static JMenuBar mb;
    static LabelStore labelStore;
    static int currpan;
    static DontExitFrame f;

    public static void main(String[] stringArray) {
        if (DontExitFrame.exists(title)) {
            return;
        }
        f = new DontExitFrame();
        PlaneBeamFEM planeBeamFEM = new PlaneBeamFEM();
        planeBeamFEM.init();
        f.setContentPane(planeBeamFEM);
        f.pack();
        f.setTitle(title);
        f.setSize(800, 600);
        f.setJMenuBar(mb);
        if (stringArray.length > 1) {
            Point point = new Point(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            f.setLocation(point);
        }
        f.setVisible(true);
    }

    public void init() {
        currpan = 0;
        mb = new JMenuBar();
        JMenu jMenu = labelStore.newMenu("Datei");
        this.fileNew = labelStore.newMenuItem("Neu");
        jMenu.add(this.fileNew);
        this.fileOpen = labelStore.newMenuItem("Oeffnen");
        jMenu.add(this.fileOpen);
        this.fileSave = labelStore.newMenuItem("Speichern");
        jMenu.add(this.fileSave);
        this.fileSaveAs = labelStore.newMenuItem("SpeichernUnter");
        jMenu.add(this.fileSaveAs);
        jMenu.addSeparator();
        this.fileQuit = labelStore.newMenuItem("Ende");
        jMenu.add(this.fileQuit);
        this.fileSaveAs.addActionListener(this);
        this.fileSave.addActionListener(this);
        this.fileOpen.addActionListener(this);
        this.fileQuit.addActionListener(this);
        this.fileNew.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.buttpan.setLayout(new GridLayout(1, 0));
        this.add((Component)this.buttpan, "North");
        this.mainpan.setLayout(this.c);
        this.add((Component)this.mainpan, "Center");
        for (int i = 0; i < this.lbs.length; ++i) {
            this.bts[i] = labelStore.newButton(this.lbs[i]);
            this.bts[i].addActionListener(this);
            this.bts[i].setFont(new Font("Dialog", 0, 12));
            this.buttpan.add(this.bts[i]);
            switch (i) {
                case 0: {
                    this.pan[i] = new PlaneBeamFEMPunktePanel();
                    break;
                }
                case 1: {
                    this.pan[i] = new PlaneBeamFEMElementPanel();
                    break;
                }
                case 4: {
                    this.pan[i] = new PlaneBeamFEMLoadPanel();
                    break;
                }
                case 3: {
                    this.pan[i] = new PlaneBeamFEMLagerPanel();
                    break;
                }
                case 2: {
                    this.pan[i] = new PlaneBeamFEMMaterialPanel();
                    break;
                }
                case 5: {
                    this.pan[i] = new PlaneBeamFEMResultPanel();
                    break;
                }
                case 6: {
                    this.pan[i] = new PlaneBeamFEMExamplePanel();
                }
            }
            if (this.pan[i] == null) continue;
            this.mainpan.add(this.lbs[i], this.pan[i]);
        }
        mb.add(jMenu);
        mb.add(f.lookMenu());
        mb.add(f.languageMenu(labelStore));
        mb.add(f.helpMenu(labelStore, "PlaneBeamFEM"));
        PlaneBeamFEMResultPanel.maskenLoeschen();
        this.setVisible(true);
        this.changePanel(0);
    }

    void changePanel(int n) {
        this.c.show(this.mainpan, this.lbs[n]);
        ((PlaneBeamFEMExamplePanel)this.pan[6]).clear();
        currpan = n;
    }

    void clearStatusFields() {
        int n = this.pan.length - 1;
        while (--n >= 0) {
            this.pan[n].statusMsg("");
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fileOpen) {
            PlaneBeamFEMResultPanel.laden();
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            this.bts[0].requestFocus();
            PlaneBeamFEM.setTitle(PlaneBeamFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileSave) {
            PlaneBeamFEMResultPanel.speichern();
        } else if (actionEvent.getSource() == this.fileNew || actionEvent.getSource() == this.bts[7]) {
            PlaneBeamFEMResultPanel.maskenLoeschen();
            PlaneBeamFEMResultPanel.currFile = null;
            this.clearStatusFields();
            this.changePanel(0);
            this.pan[0].grafikPanel.fit();
            PlaneBeamFEM.setTitle(null);
        } else if (actionEvent.getSource() == this.fileSaveAs) {
            PlaneBeamFEMResultPanel.speichernAls();
            PlaneBeamFEM.setTitle(PlaneBeamFEMResultPanel.currFile);
        } else if (actionEvent.getSource() == this.fileQuit) {
            f.exit(0);
        } else {
            int n = this.bts.length;
            while (--n >= 0) {
                if (actionEvent.getSource() != this.bts[n]) continue;
                this.changePanel(n);
            }
            if (actionEvent.getSource() == this.bts[5]) {
                PlaneBeamFEMResultPanel planeBeamFEMResultPanel = (PlaneBeamFEMResultPanel)this.pan[5];
                planeBeamFEMResultPanel.gesamtMatrizen();
            }
        }
    }

    public static void setTitle(String string) {
        if (string == null) {
            f.setTitle(title);
        } else {
            f.setTitle(title + " " + string);
        }
    }

    static {
        labelStore = new LabelStore();
        currpan = 0;
        f = null;
    }
}

