/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BorderFactory;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class NumEdit
extends JTextField
implements KeyListener,
FocusListener {
    char[] allowed = null;
    char[] forbidden = null;
    NumEdit next = null;
    boolean test = true;
    static Border loweredBorder = BorderFactory.createLoweredBevelBorder();
    static Border hilightBorder = BorderFactory.createBevelBorder(1, new Color(0, 120, 160), new Color(40, 90, 120));
    static Border hilightBorder2 = BorderFactory.createBevelBorder(1, new Color(178, 77, 122), new Color(120, 50, 90));
    static Border hilightBorder3 = BorderFactory.createBevelBorder(1, new Color(153, 153, 204), new Color(100, 100, 140));
    static String okStr = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ()^*/+-.= ,";
    static String numokStr = "0123456789+-. eE";
    static String specialChars = ",.;:+-*/=()/&%!?[]{}<>$#'\"";

    NumEdit(String string, int n) {
        super(string, n);
        this.init();
    }

    NumEdit(int n) {
        super(n);
        this.init();
    }

    NumEdit(String string) {
        super(string);
        this.init();
    }

    NumEdit() {
        this.init();
    }

    NumEdit(int n, boolean bl) {
        super(n);
        this.test = bl;
        if (!this.test) {
            this.setFormulaAllowed();
        }
        this.init();
    }

    NumEdit(String string, boolean bl) {
        super(string);
        this.test = bl;
        if (!this.test) {
            this.setFormulaAllowed();
        }
        this.init();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.isEditable()) {
            this.transferFocus();
            return;
        }
        try {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Window window = keyboardFocusManager.getActiveWindow();
            if (((DontExitFrame)window).currStyle == 4) {
                this.setBorder(hilightBorder2);
            } else if (((DontExitFrame)window).currStyle == 2) {
                this.setBorder(hilightBorder3);
            } else {
                this.setBorder(hilightBorder);
            }
        }
        catch (Exception exception) {
            this.setBorder(hilightBorder);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.setBorder(loweredBorder);
    }

    void init() {
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setBorder(loweredBorder);
    }

    void setAllowed(String string) {
        int n = string.length();
        this.test = true;
        this.allowed = new char[n];
        string.getChars(0, n, this.allowed, 0);
        this.forbidden = null;
    }

    void addAllowed(String string) {
        Object object = new String(this.allowed);
        object = (String)object + string;
        this.setAllowed((String)object);
    }

    void setForbidden(String string) {
        int n = string.length();
        this.test = true;
        this.forbidden = new char[n];
        string.getChars(0, n, this.forbidden, 0);
    }

    void setAlNumOnly() {
        this.setForbidden(specialChars);
    }

    void setNumOnly() {
        this.setAllowed("0123456789");
    }

    void setFormulaAllowed() {
        this.setAllowed(okStr);
    }

    void setAllAlowed() {
        this.test = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.test) {
            return;
        }
        if (keyEvent.getKeyCode() == 10) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (c == '\b') {
            return;
        }
        if (c == '\n') {
            return;
        }
        if (this.forbidden != null) {
            int n = this.forbidden.length;
            while (--n >= 0) {
                if (c != this.forbidden[n]) continue;
                keyEvent.consume();
                return;
            }
            return;
        }
        if (this.allowed != null) {
            int n = this.allowed.length;
            while (--n >= 0) {
                if (c != this.allowed[n]) continue;
                return;
            }
        } else {
            int n = numokStr.length();
            while (--n >= 0) {
                if (c != numokStr.charAt(n)) continue;
                return;
            }
        }
        keyEvent.consume();
    }

    public Component getNeighbour(KeyEvent keyEvent) {
        int n = this.getHeight();
        Component component = (Component)keyEvent.getSource();
        Point point = component.getLocation();
        Container container = component.getParent();
        switch (keyEvent.getKeyCode()) {
            case 39: 
            case 227: {
                for (int i = 1; i <= 15; ++i) {
                    Component component2 = container.getComponentAt(point.x + this.getWidth() + 10 * i, point.y);
                    if (component2 == null || !(component2 instanceof NumEdit) || !component2.isEnabled() || !((NumEdit)component2).isEditable()) continue;
                    return component2;
                }
                break;
            }
            case 37: 
            case 226: {
                Component component3;
                for (int i = 1; i <= 15; ++i) {
                    component3 = container.getComponentAt(point.x - 20 * i, point.y);
                    if (component3 == null || !(component3 instanceof NumEdit) || !component3.isEnabled() || !((NumEdit)component3).isEditable()) continue;
                    return component3;
                }
            }
            case 38: 
            case 224: {
                n = -15;
            }
            case 40: 
            case 225: {
                Component component3;
                int[] nArray = new int[]{0, -1, 1, -2, 2};
                for (int i = 0; i < nArray.length; ++i) {
                    for (int j = 1; j <= 19; ++j) {
                        component3 = container.getComponentAt(point.x + nArray[i] * 40, point.y + j * n);
                        if (component3 == null || !(component3 instanceof NumEdit) || !component3.isEnabled() || !((NumEdit)component3).isEditable()) continue;
                        return component3;
                    }
                }
                break;
            }
        }
        return null;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Component component;
        switch (keyEvent.getKeyCode()) {
            case 37: 
            case 226: {
                if (this.getCaretPosition() <= 0) break;
                return;
            }
            case 39: 
            case 227: {
                if (this.getCaretPosition() >= this.getText().length()) break;
                return;
            }
            case 38: 
            case 40: 
            case 224: 
            case 225: {
                break;
            }
            default: {
                return;
            }
        }
        if ((component = this.getNeighbour(keyEvent)) != null) {
            component.requestFocus();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                String string = this.getName();
                if (string != null && string.equals("last")) break;
                this.transferFocus();
            }
        }
    }

    static String toFixed(double d, int n) {
        if (d > 1.0E7 || d < -1.0E7) {
            return "" + d;
        }
        double d2 = 1.0;
        for (int i = n; i > 0; --i) {
            d2 *= 10.0;
        }
        long l = d >= 0.0 ? (long)(d * d2 + 0.5) : (long)(d * d2 - 0.5);
        Object object = "" + (double)l / d2;
        if (n == 0 && ((String)object).indexOf("E") < 0) {
            int n2 = ((String)object).length();
            object = ((String)object).substring(0, n2 - 1);
        }
        return object;
    }

    static String toPrecision(double d, int n) {
        boolean bl;
        if (d == 0.0) {
            return "0.0";
        }
        int n2 = 0;
        double d2 = d;
        if (d >= 0.0) {
            bl = true;
        } else {
            bl = false;
            d = -d;
        }
        if (d > 1.0) {
            while (d >= 1.0) {
                d *= 0.1;
                ++n2;
            }
        } else {
            while (d < 0.1) {
                d *= 10.0;
                --n2;
            }
        }
        if (n2 > 10 || n2 < -10) {
            return NumEdit.efx(d2, n);
        }
        double d3 = d;
        while (n-- > 0) {
            d3 *= 10.0;
            --n2;
        }
        long l = (long)(d3 + 0.5);
        d = n2 < 0 ? (double)l / Math.pow(10.0, -n2) : (double)l * Math.pow(10.0, n2);
        if (!bl) {
            d = -d;
        }
        Object object = "" + d;
        if (n2 >= 0 && ((String)object).indexOf("E") < 0) {
            int n3 = ((String)object).length();
            object = ((String)object).substring(0, n3 - 1);
        }
        return object;
    }

    static String mpToStr(int n, int n2) {
        char[] cArray = new char[16];
        int n3 = 0;
        while (n > 0) {
            cArray[n3++] = (char)(n % 10 + 48);
            if (0 >= (n /= 10) || n >= 10) continue;
            cArray[n3++] = 46;
        }
        int n4 = n3--;
        for (int i = 0; i < n3; ++i, --n3) {
            char c = cArray[i];
            cArray[i] = cArray[n3];
            cArray[n3] = c;
        }
        cArray[n4++] = 69;
        int n5 = cArray[n4++] = n2 >= 0 ? 43 : 45;
        if (n2 < 0) {
            n2 = -n2;
        }
        cArray[n4 + 1] = (char)(n2 % 10 + 48);
        cArray[n4] = (char)((n2 /= 10) % 10 + 48);
        return new String(cArray, 0, n4 += 2);
    }

    static String ef(double d, int n) {
        Object object;
        if (d >= 0.0) {
            object = "+";
            if (d == 0.0) {
                object = (String)object + "0.";
                while (--n > 0) {
                    object = (String)object + "0";
                }
                return (String)object + "E+00";
            }
        } else {
            object = "-";
            d = -d;
        }
        int n2 = -1;
        double d2 = 1.0;
        if (d >= 1.0) {
            while (d >= 1.0) {
                d *= 0.1;
                ++n2;
            }
        } else {
            while (d < 0.1) {
                d *= 10.0;
                --n2;
            }
        }
        double d3 = d;
        while (n-- > 0) {
            d3 *= 10.0;
            d2 *= 10.0;
        }
        if ((d3 += 0.5) > d2) {
            d3 *= 0.1;
            ++n2;
        }
        return (String)object + NumEdit.mpToStr((int)d3, n2);
    }

    static String mpToStrX(int n, int n2) {
        char[] cArray = new char[16];
        int n3 = 0;
        boolean bl = false;
        while (n > 0) {
            cArray[n3] = (char)(n % 10 + 48);
            if (cArray[n3] != '0' || bl) {
                bl = true;
                ++n3;
            }
            if (0 >= (n /= 10) || n >= 10) continue;
            cArray[n3++] = 46;
        }
        int n4 = n3--;
        for (int i = 0; i < n3; ++i, --n3) {
            char c = cArray[i];
            cArray[i] = cArray[n3];
            cArray[n3] = c;
        }
        cArray[n4++] = 69;
        if (n2 < 0) {
            n2 = -n2;
            cArray[n4++] = 45;
        }
        cArray[n4 + 1] = (char)(n2 % 10 + 48);
        cArray[n4] = (char)((n2 /= 10) % 10 + 48);
        return new String(cArray, 0, n4 += 2);
    }

    static String efx(double d, int n) {
        String string;
        int n2 = -1;
        double d2 = 1.0;
        if (d == 0.0) {
            return "0.";
        }
        if (d > 0.0) {
            string = "";
        } else {
            string = "-";
            d = -d;
        }
        if (d >= 1.0) {
            while (d >= 1.0) {
                d *= 0.1;
                ++n2;
            }
        } else {
            while (d < 0.1) {
                d *= 10.0;
                --n2;
            }
        }
        double d3 = d;
        while (n-- > 0) {
            d3 *= 10.0;
            d2 *= 10.0;
        }
        if ((d3 += 0.5) > d2) {
            d3 *= 0.1;
            ++n2;
        }
        return string + NumEdit.mpToStrX((int)d3, n2);
    }

    void setValue(double d, int n) {
        this.setText(NumEdit.toFixed(d, n));
    }

    void setValue(double d) {
        this.setText(NumEdit.toPrecision(d, 4));
    }

    void setValueP(double d, int n) {
        this.setText(NumEdit.toPrecision(d, n));
    }

    public static double getDouble(String string) {
        if (string.trim().length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(string);
    }

    double getDouble() {
        return NumEdit.getDouble(this.getText());
    }

    public static int getInt(String string) {
        if ((string = string.trim()).length() == 0) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    int getInt() {
        return NumEdit.getInt(this.getText());
    }

    String getTrimText() {
        return this.getText().trim();
    }

    public boolean isEmpty() {
        return this.getText().trim().length() == 0;
    }

    static void shift(char[] cArray) {
        for (int i = 1; i < cArray.length; ++i) {
            cArray[i - 1] = cArray[i];
        }
        cArray[cArray.length - 1] = '\u0000';
    }

    static void skipBlanks(char[] cArray) {
        while (cArray[0] == ' ') {
            NumEdit.shift(cArray);
        }
    }

    static int getNum(char[] cArray) {
        Object object = "";
        NumEdit.skipBlanks(cArray);
        while ('0' <= cArray[0] && cArray[0] <= '9') {
            object = (String)object + cArray[0];
            NumEdit.shift(cArray);
        }
        return ((String)object).length() > 0 ? Integer.parseInt((String)object) : -1;
    }

    static boolean getMinus(char[] cArray) {
        NumEdit.skipBlanks(cArray);
        if (cArray[0] == '-') {
            NumEdit.shift(cArray);
            return true;
        }
        return false;
    }

    static int[] nextRange(char[] cArray) {
        int n = NumEdit.getNum(cArray);
        if (n < 0) {
            return null;
        }
        int n2 = !NumEdit.getMinus(cArray) ? n : NumEdit.getNum(cArray);
        int[] nArray = new int[]{n, n2};
        if (n > n2) {
            nArray[0] = n2;
            nArray[1] = n;
        }
        return nArray;
    }

    static int[] getList(String string) {
        int n;
        int[] nArray;
        int n2 = 0;
        int n3 = string.length();
        if (n3 == 0) {
            return null;
        }
        int[] nArray2 = new int[256];
        char[] cArray = new char[n3];
        string.getChars(0, n3, cArray, 0);
        while ((nArray = NumEdit.nextRange(cArray)) != null) {
            n = nArray[0];
            while (n <= nArray[1]) {
                nArray2[n2++] = n++;
            }
        }
        if (n2 == 0) {
            return null;
        }
        int[] nArray3 = new int[n2];
        for (n = 0; n < n2; ++n) {
            nArray3[n] = nArray2[n];
        }
        return nArray3;
    }

    static String[] split(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return null;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (c > ' ') {
                if (bl) continue;
                bl = true;
                n4 = n;
                continue;
            }
            if (!bl) continue;
            bl = false;
            stringArray[n3++] = string.substring(n4, n);
        }
        if (n4 < 0) {
            return null;
        }
        if (bl) {
            stringArray[n3++] = string.substring(n4, n);
        }
        String[] stringArray2 = new String[n3];
        for (n = 0; n < n3; ++n) {
            stringArray2[n] = stringArray[n];
        }
        return stringArray2;
    }

    static String stripBlanks(String string) {
        return NumEdit.deleteChar(string, ' ');
    }

    static String deleteChar(String string, char c) {
        int n = string.length();
        boolean bl = false;
        if (n == 0) {
            return string;
        }
        char[] cArray = new char[n + 1];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        while (n2 < n) {
            if (cArray[n2] == c) {
                for (int i = n2; i < n; ++i) {
                    cArray[i] = cArray[i + 1];
                }
                --n;
                bl = true;
                continue;
            }
            ++n2;
        }
        return bl ? new String(cArray, 0, n) : string;
    }
}

