/*
 * Decompiled with CFR 0.152.
 */
class Muller {
    static double MACH_EPS = 2.22045E-16;
    static double EPSQUAD = 4.93038E-32;
    static double EPSROOT = 1.49012E-8;
    static int ITERMAX = 500;
    static double START1 = 0.125;
    static double[] zreal;
    static double[] zimag;

    Muller() {
    }

    static void cpval(int n, int n2, double d, double d2, double[] dArray) {
        double d3 = zreal[n];
        double d4 = 0.0;
        if (d2 == 0.0) {
            for (int i = n; i >= n2 + 1; --i) {
                d3 = d3 * d + zreal[i - 1];
            }
        } else {
            for (int i = n; i >= n2 + 1; --i) {
                double d5 = d3;
                d3 = d3 * d - d4 * d2 + zreal[i - 1];
                d4 = d5 * d2 + d4 * d;
            }
        }
        dArray[0] = d3;
        dArray[1] = d4;
    }

    static void quadsolv(double d, double d2, double d3, double d4, double d5, double d6, double[] dArray) {
        double d7;
        double d8 = d3 * d3 - d4 * d4;
        double d9 = 2.0 * d3 * d4;
        double d10 = d * d5 - d2 * d6;
        double d11 = d * d6 + d2 * d5;
        if ((d10 = (d7 = Math.sqrt((d8 -= 4.0 * d10) * d8 + (d9 -= 4.0 * d11) * d9)) + d8) < 0.0) {
            d10 = 0.0;
        }
        d10 = Math.sqrt(0.5 * d10);
        d11 = d7 - d8;
        if (d11 < 0.0) {
            d11 = 0.0;
        }
        d11 = Math.sqrt(0.5 * d11);
        if (d9 < 0.0) {
            d11 = -d11;
        }
        if ((d7 = d10 * d3 + d11 * d4) > 0.0) {
            d10 = -d10;
            d11 = -d11;
        }
        d8 = d10 - d3;
        d9 = d11 - d4;
        d7 = 2.0 / (d8 * d8 + d9 * d9);
        dArray[0] = d7 * (d5 * d8 + d6 * d9);
        dArray[1] = d7 * (d6 * d8 - d5 * d9);
    }

    static double sumAbs(double d, double d2) {
        return Math.abs(d) + Math.abs(d2);
    }

    static int wurzeln(double[] dArray, int n, double[] dArray2, double[] dArray3) {
        int n2;
        double[] dArray4 = new double[]{0.0, 0.0};
        double[] dArray5 = new double[]{0.0, 0.0};
        boolean bl = false;
        zreal = dArray2;
        zimag = dArray3;
        if (n < 1 || dArray[0] == 0.0) {
            return -1;
        }
        double d = 2.0 * MACH_EPS;
        for (n2 = 0; n2 <= n; ++n2) {
            Muller.zreal[n2] = dArray[n - n2];
            Muller.zimag[n2] = 0.0;
        }
        double d2 = 0.0;
        if (!bl) {
            d2 = 1.0;
            int n3 = 0;
            while (true) {
                if (Math.abs(zreal[n3]) < EPSQUAD) {
                    Muller.zreal[n3] = 0.0;
                    Muller.zimag[n3] = 0.0;
                    ++n3;
                    continue;
                }
                if (n3 >= n - 1) {
                    Muller.zreal[n - 1] = zreal[n - 1] * -d2 / zreal[n];
                    Muller.zimag[n - 1] = 0.0;
                    return 0;
                }
                double d3 = 0.0;
                if (!bl) {
                    d3 = START1;
                }
                int n4 = 0;
                double d4 = -d3;
                double d5 = 0.0;
                double d6 = d3;
                double d7 = 0.0;
                double d8 = 0.0;
                double d9 = 0.0;
                double d10 = d6 - d4;
                double d11 = 0.0;
                double d12 = d8 - d6;
                double d13 = 0.0;
                double d14 = zreal[n];
                double d15 = 0.0;
                double d16 = d14;
                double d17 = 0.0;
                for (n2 = n; n2 >= n3 + 1; --n2) {
                    d14 = d14 * d4 + zreal[n2 - 1];
                    d16 = d16 * d6 + zreal[n2 - 1];
                }
                double d18 = zreal[n3];
                double d19 = 0.0;
                if (Muller.sumAbs(d14, d15) < EPSQUAD || Muller.sumAbs(d16, d17) < EPSQUAD) {
                    if (Muller.sumAbs(d14, d15) < Muller.sumAbs(d16, d17)) {
                        Muller.zreal[n3] = d4 * d2;
                        Muller.zimag[n3] = d5 * d2;
                    } else {
                        Muller.zreal[n3] = d6 * d2;
                        Muller.zimag[n3] = d7 * d2;
                    }
                    ++n3;
                }
                double d20 = (d16 - d14) / d10;
                double d21 = 0.0;
                do {
                    double d22 = d12 * d12 + d13 * d13;
                    double d23 = d18 - d16;
                    double d24 = d19 - d17;
                    double d25 = (d23 * d12 + d24 * d13) / d22;
                    double d26 = (d24 * d12 - d23 * d13) / d22;
                    d23 = d25 - d20;
                    d24 = d26 - d21;
                    double d27 = d10 + d12;
                    double d28 = d11 + d13;
                    d22 = d27 * d27 + d28 * d28;
                    double d29 = (d23 * d27 + d24 * d28) / d22;
                    double d30 = (d24 * d27 - d23 * d28) / d22;
                    double d31 = d12 * d29 - d13 * d30 + d25;
                    double d32 = d12 * d30 + d13 * d29 + d26;
                    d10 = d12;
                    d11 = d13;
                    if (d29 != 0.0 || d30 != 0.0 || d31 != 0.0 || d32 != 0.0) {
                        Muller.quadsolv(d29, d30, d31, d32, d18, d19, dArray5);
                        d12 = dArray5[0];
                        d13 = dArray5[1];
                    } else {
                        d12 = 0.5;
                        d13 = 0.0;
                    }
                    d6 = d8;
                    d7 = d9;
                    d16 = d18;
                    d17 = d19;
                    d20 = d25;
                    d21 = d26;
                    Muller.cpval(n, n3, d8 += d12, d9 += d13, dArray4);
                    d18 = dArray4[0];
                    d19 = dArray4[1];
                    for (n2 = 0; Muller.sumAbs(d18, d19) > (double)n * Muller.sumAbs(d16, d17) && n2 < 10; ++n2) {
                        Muller.cpval(n, n3, d8 -= (d12 *= 0.5), d9 -= (d13 *= 0.5), dArray4);
                        d18 = dArray4[0];
                        d19 = dArray4[1];
                    }
                    if (++n4 <= ITERMAX) continue;
                    return -2;
                } while (!(Muller.sumAbs(d18, d19) <= EPSQUAD) && !(Muller.sumAbs(d12, d13) <= d * Muller.sumAbs(d8, d9)));
                if (Muller.sumAbs(d16, d17) < Muller.sumAbs(d18, d19)) {
                    d8 = d6;
                    d9 = d7;
                }
                if (Math.abs(d9) > EPSROOT * Math.abs(d8)) {
                    double d33 = 2.0 * d8;
                    double d34 = -d8 * d8 - d9 * d9;
                    Muller.zreal[n - 1] = zreal[n - 1] + d33 * zreal[n];
                    for (n2 = n - 2; n2 >= n3 + 2; --n2) {
                        int n5 = n2;
                        zreal[n5] = zreal[n5] + (d33 * zreal[n2 + 1] + d34 * zreal[n2 + 2]);
                    }
                    Muller.zreal[n3 + 1] = d8 *= d2;
                    Muller.zimag[n3 + 1] = d9 *= d2;
                    Muller.zreal[n3] = d8;
                    Muller.zimag[n3] = -d9;
                    n3 += 2;
                } else {
                    for (n2 = n - 1; n2 >= n3 + 1; --n2) {
                        int n6 = n2;
                        zreal[n6] = zreal[n6] + zreal[n2 + 1] * d8;
                    }
                    Muller.zreal[n3] = d8 * d2;
                    Muller.zimag[n3] = 0.0;
                    ++n3;
                }
                if (n3 == n) break;
            }
        }
        return 0;
    }

    static void shellSort(double[] dArray, double[] dArray2, int n) {
        for (int i = n / 2; i > 0; i /= 2) {
            for (int j = i; j < n; ++j) {
                int n2 = j;
                for (int k = j - i; k >= 0 && !(Math.abs(dArray[k] - dArray[n2]) > 1.0E-5 ? dArray[k] < dArray[n2] : Math.abs(dArray2[k]) < Math.abs(dArray2[n2])); k -= i) {
                    double d = dArray[k];
                    dArray[k] = dArray[n2];
                    dArray[n2] = d;
                    d = dArray2[k];
                    dArray2[k] = dArray2[n2];
                    dArray2[n2] = d;
                    n2 = k;
                }
            }
        }
    }
}

