/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class MatrixEigenValueViewPanel
extends JPanel
implements ActionListener,
DocumentListener {
    static GridBagConstraints gbc;
    static GridBagLayout gbl;
    static NumEdit[][] cells;
    static NumEdit[][] eigenVektoren;
    static NumEdit[] eigenWerte;
    static NumEdit[] eigenKreisf;
    static MatrixEigenValueViewPanel sp;
    static int ngl;
    static JScrollPane fieldPane;
    MatrixEigenValuePanel myparent;
    boolean allowCopy = true;

    MatrixEigenValueViewPanel() {
        sp = this;
    }

    static void init(int n) {
        NumEdit numEdit;
        int n2;
        int n3;
        int n4;
        sp.setLayout(new BorderLayout());
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gbl);
        fieldPane = new JScrollPane(jPanel, 20, 30);
        sp.add(fieldPane);
        jPanel.setBackground(new Color(166, 187, 206));
        ngl = n;
        MatrixEigenValueViewPanel.gbc.gridy = 0;
        MatrixEigenValueViewPanel.gbc.gridwidth = 3;
        JLabel jLabel = MatrixEigenValue.labelStore.newLabel("Steifigkeitsmatrix");
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        jLabel = MatrixEigenValue.labelStore.newLabel("Massenmatrix");
        MatrixEigenValueViewPanel.gbc.gridx = n + 1;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        MatrixEigenValueViewPanel.gbc.gridwidth = 1;
        cells = new NumEdit[n][];
        for (n4 = 0; n4 < n; ++n4) {
            MatrixEigenValueViewPanel.cells[n4] = new NumEdit[n * 2];
            ++MatrixEigenValueViewPanel.gbc.gridy;
            n3 = 0;
            for (n2 = 0; n2 < 2 * n; ++n2) {
                MatrixEigenValueViewPanel.cells[n4][n2] = numEdit = new NumEdit(5, false);
                MatrixEigenValueViewPanel.gbc.gridx = n3++;
                gbl.setConstraints(numEdit, gbc);
                jPanel.add(numEdit);
                numEdit.addActionListener(sp);
                numEdit.getDocument().addDocumentListener(sp);
                if (n2 != n - 1) continue;
                jLabel = new JLabel("    ");
                MatrixEigenValueViewPanel.gbc.gridx = n3++;
                gbl.setConstraints(jLabel, gbc);
                jPanel.add(jLabel);
            }
        }
        cells[n - 1][2 * n - 1].setName("last");
        ++MatrixEigenValueViewPanel.gbc.gridy;
        jLabel = new JLabel(" ");
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ++MatrixEigenValueViewPanel.gbc.gridy;
        MatrixEigenValueViewPanel.gbc.gridwidth = 3;
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        jLabel = MatrixEigenValue.labelStore.newLabel("Eigenwerte");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ++MatrixEigenValueViewPanel.gbc.gridy;
        n3 = 0;
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        MatrixEigenValueViewPanel.gbc.gridwidth = 1;
        eigenWerte = new NumEdit[n];
        for (n2 = 0; n2 < n; ++n2) {
            MatrixEigenValueViewPanel.eigenWerte[n2] = numEdit = new NumEdit(5, false);
            numEdit.setEditable(false);
            MatrixEigenValueViewPanel.gbc.gridx = n3++;
            gbl.setConstraints(numEdit, gbc);
            jPanel.add(numEdit);
        }
        ++MatrixEigenValueViewPanel.gbc.gridy;
        MatrixEigenValueViewPanel.gbc.gridwidth = 3;
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        jLabel = MatrixEigenValue.labelStore.newLabel("Eigenkreisfrequenzen");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ++MatrixEigenValueViewPanel.gbc.gridy;
        n3 = 0;
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        MatrixEigenValueViewPanel.gbc.gridwidth = 1;
        eigenKreisf = new NumEdit[n];
        for (n2 = 0; n2 < n; ++n2) {
            MatrixEigenValueViewPanel.eigenKreisf[n2] = numEdit = new NumEdit(5, false);
            numEdit.setEditable(false);
            MatrixEigenValueViewPanel.gbc.gridx = n3++;
            gbl.setConstraints(numEdit, gbc);
            jPanel.add(numEdit);
        }
        MatrixEigenValueViewPanel.gbc.gridwidth = 3;
        ++MatrixEigenValueViewPanel.gbc.gridy;
        MatrixEigenValueViewPanel.gbc.gridx = 0;
        jLabel = MatrixEigenValue.labelStore.newLabel("Eigenvektoren");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        eigenVektoren = new NumEdit[n][];
        for (n4 = 0; n4 < n; ++n4) {
            MatrixEigenValueViewPanel.eigenVektoren[n4] = new NumEdit[n];
            ++MatrixEigenValueViewPanel.gbc.gridy;
            n3 = 0;
            MatrixEigenValueViewPanel.gbc.gridx = 0;
            MatrixEigenValueViewPanel.gbc.gridwidth = 1;
            for (n2 = 0; n2 < n; ++n2) {
                MatrixEigenValueViewPanel.eigenVektoren[n4][n2] = numEdit = new NumEdit(5, false);
                numEdit.setEditable(false);
                MatrixEigenValueViewPanel.gbc.gridx = n3++;
                gbl.setConstraints(numEdit, gbc);
                jPanel.add(numEdit);
            }
        }
    }

    public void keepSymmetrical(DocumentEvent documentEvent) {
        boolean bl = false;
        if (!this.allowCopy) {
            return;
        }
        this.allowCopy = false;
        Document document = documentEvent.getDocument();
        int n = cells.length;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (cells[i][j].getDocument() == document) {
                    if (i != j) {
                        cells[j][i].setText(cells[i][j].getText());
                    }
                    bl = true;
                    break;
                }
                if (cells[i][j + n].getDocument() != document) continue;
                if (i != j) {
                    cells[j][i + n].setText(cells[i][j + n].getText());
                }
                bl = true;
                break;
            }
            if (bl) break;
        }
        this.allowCopy = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.keepSymmetrical(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.keepSymmetrical(documentEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        int n2;
        int n3;
        double[][] dArray = new double[ngl][ngl];
        double[][] dArray2 = new double[ngl][ngl];
        double[][] dArray3 = new double[ngl][ngl];
        double[] dArray4 = new double[ngl];
        this.myparent = (MatrixEigenValuePanel)this.getParent();
        if (actionEvent != null) {
            this.myparent.cbox.setSelectedIndex(0);
        }
        Ftree.resetStatus();
        Ftree.delAllVars();
        for (n3 = 1; n3 <= 2; ++n3) {
            for (n2 = 0; n2 < ngl; ++n2) {
                for (n = 0; n <= n2; ++n) {
                    dArray[n2][n] = Ftree.evaluate(cells[n2][n + ngl].getText());
                    if (Ftree.getStatus() != 0) {
                        this.myparent.errorMsg(myLocale.getString("fehlerhafteFormelinderMassenMatrix") + "(" + (n2 + 1) + "," + (n + 1) + ")");
                        return;
                    }
                    dArray2[n2][n] = Ftree.evaluate(cells[n2][n].getText());
                    if (Ftree.getStatus() == 0) continue;
                    this.myparent.errorMsg(myLocale.getString("fehlerhafteFormelinderSteifigkeitsMatrix") + "(" + (n2 + 1) + "," + (n + 1) + ")");
                    return;
                }
            }
        }
        String string = Ftree.notInitializedVars();
        if (string.length() > 0) {
            this.myparent.errorMsg(myLocale.getString("nichtDefinierteVariable") + ": " + string);
            return;
        }
        this.myparent.errorMsg("");
        int n4 = Jacobi.allgEWP(dArray2, dArray, dArray4, dArray3);
        if (n4 < 0) {
            this.myparent.errorMsg(myLocale.getString("EigenwerteNichtBestimmbarMassenmatrixIstPositivIndefinit"));
        }
        for (n2 = 0; n2 < ngl; ++n2) {
            n3 = ngl - n2 - 1;
            if (Math.abs(dArray4[n2]) < 1.0E-12) {
                dArray4[n2] = 0.0;
            }
            eigenWerte[n3].setValueP(dArray4[n2], 4);
            if (dArray4[n2] >= 0.0) {
                double d = Math.sqrt(dArray4[n2]);
                eigenKreisf[n3].setValueP(d, 4);
                continue;
            }
            eigenKreisf[n3].setText("");
            this.myparent.errorMsg(myLocale.getString("EigenwerteNichtBestimmbarSteifigkeitsmatrixIstPositivIndefinit"));
        }
        for (n2 = 0; n2 < ngl; ++n2) {
            for (n = 0; n < ngl; ++n) {
                n3 = ngl - n - 1;
                if (Math.abs(dArray3[n2][n]) < 1.0E-12) {
                    dArray3[n2][n] = 0.0;
                }
                eigenVektoren[n2][n3].setValueP(dArray3[n2][n], 3);
            }
        }
    }

    static {
        cells = null;
        eigenVektoren = null;
        eigenWerte = null;
        eigenKreisf = null;
        sp = null;
        fieldPane = null;
    }
}

