/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

class LinearSolverMaViewPanel
extends JPanel
implements ActionListener,
DocumentListener {
    static GridBagConstraints gbc;
    static GridBagLayout gbl;
    static NumEdit[][] cells;
    static LinearSolverMaViewPanel sp;
    static int ngl;
    static NumEdit[] varn;
    static NumEdit[] vars;
    static NumEdit[] varv;
    static JScrollPane fieldPane;
    LinearSolverMaPanel myparent;
    boolean allowCopy = true;

    LinearSolverMaViewPanel(LinearSolverMaPanel linearSolverMaPanel) {
        this.myparent = linearSolverMaPanel;
        sp = this;
    }

    static void init(int n) {
        int n2;
        varn = new NumEdit[8];
        vars = new NumEdit[varn.length];
        varv = new NumEdit[varn.length];
        Font font = new Font("Dialog", 1, 12);
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        LinearSolverMaViewPanel.gbc.fill = 2;
        sp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBackground(new Color(166, 187, 206));
        jPanel.setLayout(gbl);
        sp.add(jPanel);
        LinearSolverMaViewPanel.gbc.gridy = 0;
        LinearSolverMaViewPanel.gbc.gridx = 0;
        LinearSolverMaViewPanel.gbc.gridwidth = 2;
        JLabel jLabel = LinearSolver.labelStore.newLabel("KoeffizientenMatrix");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        LinearSolverMaViewPanel.gbc.gridx = n + 1;
        LinearSolverMaViewPanel.gbc.gridwidth = 1;
        jLabel = LinearSolver.labelStore.newLabel("Loesung");
        jLabel.setFont(font);
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        LinearSolverMaViewPanel.gbc.gridx = n + 3;
        jLabel = LinearSolver.labelStore.newLabel("rechteSeite");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ngl = n;
        cells = new NumEdit[n][];
        for (n2 = 0; n2 < n; ++n2) {
            LinearSolverMaViewPanel.cells[n2] = new NumEdit[n + 2];
            ++LinearSolverMaViewPanel.gbc.gridy;
            int n3 = 0;
            for (int i = 0; i < n + 2; ++i) {
                NumEdit numEdit;
                LinearSolverMaViewPanel.cells[n2][i] = numEdit = new NumEdit(i == n ? 7 : 5, false);
                LinearSolverMaViewPanel.gbc.gridx = n3++;
                gbl.setConstraints(numEdit, gbc);
                jPanel.add(numEdit);
                if (i != n) {
                    numEdit.addActionListener(sp);
                    if (i < n) {
                        numEdit.getDocument().addDocumentListener(sp);
                    }
                } else {
                    numEdit.setFont(font);
                    numEdit.setEditable(false);
                }
                if (i < n - 1) continue;
                String string = i == n - 1 && n2 == n / 2 ? " * " : (i == n && n2 == n / 2 ? " = " : " ");
                jLabel = new JLabel(string, 0);
                LinearSolverMaViewPanel.gbc.gridx = n3++;
                gbl.setConstraints(jLabel, gbc);
                jPanel.add(jLabel);
            }
        }
        ++LinearSolverMaViewPanel.gbc.gridy;
        jLabel = new JLabel(" ");
        LinearSolverMaViewPanel.gbc.gridx = 0;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ++LinearSolverMaViewPanel.gbc.gridy;
        LinearSolverMaViewPanel.gbc.gridwidth = 1;
        jLabel = LinearSolver.labelStore.newLabel("Name");
        LinearSolverMaViewPanel.gbc.gridx = 0;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        LinearSolverMaViewPanel.gbc.gridwidth = 4;
        LinearSolverMaViewPanel.gbc.gridx = 1;
        jLabel = LinearSolver.labelStore.newLabel("DefinitionderParameter");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        for (n2 = 0; n2 < vars.length; ++n2) {
            ++LinearSolverMaViewPanel.gbc.gridy;
            LinearSolverMaViewPanel.gbc.gridx = 0;
            LinearSolverMaViewPanel.gbc.gridwidth = 1;
            if (varn[n2] == null) {
                LinearSolverMaViewPanel.varn[n2] = new NumEdit(5, false);
            }
            varn[n2].setAlNumOnly();
            gbl.setConstraints(varn[n2], gbc);
            jPanel.add(varn[n2]);
            varn[n2].addActionListener(sp);
            LinearSolverMaViewPanel.gbc.gridx = 1;
            LinearSolverMaViewPanel.gbc.gridwidth = 4;
            if (vars[n2] == null) {
                LinearSolverMaViewPanel.vars[n2] = new NumEdit(20, false);
            }
            gbl.setConstraints(vars[n2], gbc);
            jPanel.add(vars[n2]);
            vars[n2].addActionListener(sp);
            LinearSolverMaViewPanel.gbc.gridx = n == 4 || n == 6 ? 7 : 6;
            LinearSolverMaViewPanel.gbc.gridwidth = 1;
            if (varv[n2] == null) {
                LinearSolverMaViewPanel.varv[n2] = new NumEdit(5, false);
            }
            varv[n2].setEditable(false);
            gbl.setConstraints(varv[n2], gbc);
            jPanel.add(varv[n2]);
        }
        fieldPane = new JScrollPane(jPanel, 20, 30);
        sp.add(fieldPane);
    }

    public void keepSymmetrical(DocumentEvent documentEvent) {
        int n;
        boolean bl = false;
        if (!this.allowCopy) {
            return;
        }
        if (!LinearSolverMaPanel.symmetrical.isSelected()) {
            return;
        }
        this.allowCopy = false;
        Document document = documentEvent.getDocument();
        int n2 = n = cells.length;
        while (--n2 >= 0) {
            int n3 = n;
            while (--n3 >= 0) {
                if (cells[n2][n3].getDocument() != document) continue;
                if (n2 != n3) {
                    cells[n3][n2].setText(cells[n2][n3].getText());
                }
                bl = true;
            }
            if (!bl) continue;
        }
        this.allowCopy = true;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.keepSymmetrical(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.keepSymmetrical(documentEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        String string;
        int n2;
        double[][] dArray = new double[ngl][ngl];
        double[] dArray2 = new double[ngl];
        Ftree.delAllVars();
        if (actionEvent != null) {
            this.myparent.ch.setSelectedIndex(0);
        }
        this.myparent.errorMsg("");
        Ftree.resetStatus();
        for (n2 = 0; n2 < vars.length; ++n2) {
            string = varn[n2].getTrimText();
            String string2 = vars[n2].getTrimText();
            if (string.length() <= 0) continue;
            if (!Ftree.isalpha(string.charAt(0))) {
                this.myparent.errorMsg(myLocale.getString("EinParameternamemussmiteinemBuchstabenbeginnen"));
                return;
            }
            Ftree.setVar(string, string2);
            if (Ftree.getStatus() == 0) continue;
            this.myparent.errorMsg(myLocale.getString("fehlerhafteFormelbeiParameterdefinition") + " " + string);
            return;
        }
        Ftree.resetStatus();
        for (n2 = 0; n2 < vars.length; ++n2) {
            string = varn[n2].getTrimText();
            varv[n2].setText("");
            if (string.length() == 0) continue;
            double d = Ftree.getVar(string);
            if (Ftree.getStatus() != 0) {
                this.myparent.errorMsg(myLocale.getString("FehlerbeiVariable") + " " + string);
                return;
            }
            varv[n2].setText(NumEdit.toPrecision(d, 3));
        }
        String string3 = Ftree.notInitializedVars();
        if (string3.length() > 0) {
            this.myparent.errorMsg(myLocale.getString("NichtdefinierteParameter") + ": " + string3);
            return;
        }
        this.myparent.errorMsg("");
        if (LinearSolverMaPanel.symmetrical.isSelected()) {
            n2 = ngl;
            while (--n2 >= 0) {
                n = ngl;
                while (--n >= 0) {
                    if (cells[n][n2].getText().length() != 0 || cells[n2][n].getText().length() == 0) continue;
                    cells[n][n2].setText(cells[n2][n].getText());
                }
            }
        }
        int n3 = 0;
        n2 = ngl;
        while (--n2 >= 0) {
            n = ngl;
            while (--n >= 0) {
                string = cells[n2][n].getText();
                dArray[n2][n] = Ftree.evaluate(string);
                if (string.length() != 0) {
                    ++n3;
                }
                if (Ftree.getStatus() == 0) continue;
                this.myparent.errorMsg(myLocale.getString("fehlerhafteFormelbeiMatrixelement") + " " + (n2 + 1) + "," + (n + 1));
                return;
            }
        }
        if (n3 == 0) {
            return;
        }
        n2 = ngl;
        while (--n2 >= 0) {
            dArray2[n2] = Ftree.evaluate(cells[n2][ngl + 1].getText());
        }
        if (Ftree.getStatus() != 0) {
            this.myparent.errorMsg(myLocale.getString("fehlerhafteFormelimVektorderrechtenSeite"));
            return;
        }
        string3 = Ftree.notInitializedVars();
        if (string3.length() > 0) {
            this.myparent.errorMsg(myLocale.getString("NichtdefinierteParameter") + ": " + string3);
            return;
        }
        int n4 = Gauss.fullPivoting(dArray, dArray2, ngl);
        if (n4 < 0) {
            this.myparent.errorMsg(myLocale.getString("DieKoeffizientenmatrixistsingulaer") + " - " + myLocale.getString("esexistiertkeineLoesung"));
            for (n2 = 0; n2 < ngl; ++n2) {
                cells[n2][ngl].setText("");
            }
        } else {
            if (n4 > 0) {
                this.myparent.errorMsg(myLocale.getString("DieKoeffizientenmatrixistsingulaer") + " - " + myLocale.getString("esgibtunendlichvieleLoesungen"));
            } else {
                this.myparent.errorMsg("");
            }
            double d = VectorSet.vsAbsMax(dArray2) * 1.0E-10;
            VectorSet.vsclear(dArray2, d);
            for (n2 = 0; n2 < ngl; ++n2) {
                cells[n2][ngl].setText(NumEdit.toPrecision(dArray2[n2], 4));
            }
        }
    }

    static {
        cells = null;
        sp = null;
        varn = null;
        vars = null;
        varv = null;
        fieldPane = null;
    }
}

