/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class LinearSolverMaPanel
extends LinearSolverPanel
implements ItemListener {
    JComboBox<String> ch = new JComboBox();
    static JCheckBox symmetrical = null;
    JLabel tr;
    String[][] sCells;
    String[] savedVarn;
    String[] savedVars;
    String[] example = new String[]{"#(Beispiel) 1", "n 5", "0 0 k", "0 1 -k", "1 0 -k", "1 1 2*k", "2 2 2*k", "2 1 -k", "1 2 -k", "3 3 2*k", "3 2 -k", "2 3 -k", "4 4 k", "0 100", "1 0", "2 0", "3 0", "4 0", "_L .5", "_r .01", "_Ip PI*r^4/2", "_G 2.1E11/2/1.3", "_k G*Ip*4/L", "#(Beispiel) 2", "n 6", "0 0 12*B", "0 1 6*L*B", "0 2 -12*B", "0 3 6*L*B", "0 4 -1", "1 0 6*L*B", "1 1 4*L*L*B", "1 2 -6*L*B", "1 3 2*L*L*B", "1 5 -1", "2 0 -12*B", "2 1 -6*L*B", "2 2 12*B", "2 3 -6*L*B", "3 0 6*L*B", "3 1 2*L*L*B", "3 2 -6*L*B", "3 3 4*L*L*B", "4 0 -1", "5 1 -1", "2 -F", "_L 5", "_b .1", "_I b^4/12", "_B E*I/L^3", "_E 2.1E11", "_F 1E3"};
    int[] start = new int[10];
    int varCnt = 0;

    LinearSolverMaPanel() {
        this.viewPanel = new LinearSolverMaViewPanel(this);
        this.add((Component)this.viewPanel, "Center");
        LinearSolverMaViewPanel.init(this.numgl.getInt());
        this.tr = new JLabel(" ");
        this.fpAdd(this.tr, 0, ++this.gbc.gridy, 2, 1);
        symmetrical = new JCheckBox(myLocale.getString("symmetrischeMatrix"));
        this.fpAdd(symmetrical, 0, ++this.gbc.gridy, 2, 1);
        this.tr = new JLabel(" ");
        this.fpAdd(this.tr, 0, ++this.gbc.gridy, 2, 1);
        this.tr = LinearSolver.labelStore.newLabel("Beispiele");
        this.fpAdd(this.tr, 0, ++this.gbc.gridy, 2, 1);
        this.fpAdd(this.ch, 0, ++this.gbc.gridy, 2, 1);
        this.ch.addItemListener(this);
        this.exampleInit();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.neu && object != this.numgl) {
            return;
        }
        int n = this.numgl.getInt();
        LinearSolver.labelStore.changeTexts();
        if (n == LinearSolverMaViewPanel.cells.length && object == this.numgl) {
            return;
        }
        if (n < 2) {
            n = 2;
        }
        if (n > 16) {
            n = 16;
        }
        this.numgl.setText("" + n);
        if (object != this.neu) {
            this.saveCells();
        }
        this.viewPanel.setVisible(false);
        this.viewPanel.removeAll();
        this.viewPanel.setVisible(true);
        LinearSolverMaViewPanel.init(n);
        if (object != this.neu) {
            this.restoreCells();
        }
        this.validate();
        this.ch.setSelectedIndex(0);
    }

    public void saveCells() {
        int n;
        int n2 = LinearSolverMaViewPanel.cells.length;
        int n3 = Math.min(LinearSolverMaViewPanel.cells.length, this.numgl.getInt());
        this.sCells = new String[n3][];
        for (n = 0; n < n3; ++n) {
            this.sCells[n] = new String[n3 + 2];
            for (int i = 0; i < n3; ++i) {
                this.sCells[n][i] = LinearSolverMaViewPanel.cells[n][i].getText();
            }
            this.sCells[n][n3 + 1] = LinearSolverMaViewPanel.cells[n][n2 + 1].getText();
        }
        n3 = LinearSolverMaViewPanel.varn.length;
        this.savedVarn = new String[n3];
        this.savedVars = new String[n3];
        for (n = 0; n < n3; ++n) {
            this.savedVarn[n] = LinearSolverMaViewPanel.varn[n].getText();
            this.savedVars[n] = LinearSolverMaViewPanel.vars[n].getText();
        }
    }

    public void restoreCells() {
        int n;
        int n2 = this.sCells.length;
        int n3 = LinearSolverMaViewPanel.cells.length;
        int n4 = n2 < n3 ? n2 : n3;
        for (n = 0; n < n4; ++n) {
            for (int i = 0; i < n4; ++i) {
                LinearSolverMaViewPanel.cells[n][i].setText(this.sCells[n][i]);
            }
            LinearSolverMaViewPanel.cells[n][n3 + 1].setText(this.sCells[n][n2 + 1]);
        }
        n3 = LinearSolverMaViewPanel.varn.length;
        for (n = 0; n < n3; ++n) {
            LinearSolverMaViewPanel.varn[n].setText(this.savedVarn[n]);
            LinearSolverMaViewPanel.vars[n].setText(this.savedVars[n]);
        }
    }

    void exampleInit() {
        int n = 0;
        this.ch.addItem("");
        for (int i = 0; i < this.example.length; ++i) {
            String string = this.example[i];
            if (string.charAt(0) != '#') continue;
            string = myLocale.replaceFromResourceFile(string.substring(1));
            this.ch.addItem(string);
            this.start[n++] = i + 1;
        }
    }

    public void stringToFields(String string) {
        String[] stringArray = NumEdit.split(string);
        switch (stringArray[0].charAt(0)) {
            case 'n': {
                int n = Integer.parseInt(stringArray[1]);
                this.viewPanel.setVisible(false);
                this.viewPanel.removeAll();
                this.viewPanel.setVisible(true);
                LinearSolverMaViewPanel.init(n);
                this.validate();
                this.numgl.setText("" + n);
                break;
            }
            case '_': {
                LinearSolverMaViewPanel.varn[this.varCnt].setText(stringArray[0].substring(1));
                LinearSolverMaViewPanel.vars[this.varCnt].setText(stringArray[1]);
                ++this.varCnt;
                break;
            }
            default: {
                if (Ftree.isdigit(stringArray[0].charAt(0)) && stringArray.length == 3) {
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = Integer.parseInt(stringArray[1]);
                    LinearSolverMaViewPanel.cells[n][n2].setText(stringArray[2]);
                    break;
                }
                if (!Ftree.isdigit(stringArray[0].charAt(0)) || stringArray.length != 2) break;
                int n = Integer.parseInt(stringArray[0]);
                LinearSolverMaViewPanel.cells[n][LinearSolverMaViewPanel.ngl + 1].setText(stringArray[1]);
            }
        }
    }

    public void loadExample(int n) {
        String string;
        if (--n < 0) {
            return;
        }
        int n2 = LinearSolverMaViewPanel.varn.length;
        while (--n2 >= 0) {
            LinearSolverMaViewPanel.varn[n2].setText("");
            LinearSolverMaViewPanel.vars[n2].setText("");
        }
        this.varCnt = 0;
        for (n2 = this.start[n]; n2 < this.example.length && (string = this.example[n2]).charAt(0) != '#'; ++n2) {
            this.stringToFields(string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.ch.getSelectedIndex();
        if (n >= 0) {
            this.loadExample(n);
            ((LinearSolverMaViewPanel)this.viewPanel).actionPerformed(null);
        }
    }
}

