/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

class LinearSolverEqViewPanel
extends JPanel
implements ActionListener {
    static GridBagConstraints gbc;
    static GridBagLayout gbl;
    static NumEdit[][] cells;
    static LinearSolverEqViewPanel sp;
    static int ngl;
    static NumEdit[] varn;
    static NumEdit[] vars;
    static NumEdit[] varv;
    static JScrollPane fieldPane;
    LinearSolverEqPanel myparent;

    LinearSolverEqViewPanel(LinearSolverEqPanel linearSolverEqPanel) {
        this.myparent = linearSolverEqPanel;
        sp = this;
    }

    static void init(int n) {
        int n2;
        Font font = new Font("Dialog", 1, 12);
        int n3 = 3;
        varn = new NumEdit[8];
        vars = new NumEdit[varn.length];
        varv = new NumEdit[varn.length];
        gbl = new GridBagLayout();
        gbc = new GridBagConstraints();
        LinearSolverEqViewPanel.gbc.fill = 2;
        sp.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gbl);
        jPanel.setBackground(new Color(166, 187, 206));
        LinearSolverEqViewPanel.gbc.gridx = 0;
        LinearSolverEqViewPanel.gbc.gridy = 0;
        LinearSolverEqViewPanel.gbc.gridwidth = n3;
        JLabel jLabel = LinearSolver.labelStore.newLabel("Gleichungen");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        LinearSolverEqViewPanel.gbc.gridx = n3 + 2;
        LinearSolverEqViewPanel.gbc.gridwidth = 1;
        jLabel = new JLabel(myLocale.getString("Loesung"));
        jLabel.setFont(font);
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ngl = n;
        cells = new NumEdit[n][];
        for (n2 = 0; n2 < n; ++n2) {
            LinearSolverEqViewPanel.cells[n2] = new NumEdit[3];
            NumEdit numEdit = new NumEdit(40, false);
            LinearSolverEqViewPanel.cells[n2][0] = numEdit;
            NumEdit numEdit2 = numEdit;
            LinearSolverEqViewPanel.gbc.gridwidth = n3;
            LinearSolverEqViewPanel.gbc.gridx = 0;
            ++LinearSolverEqViewPanel.gbc.gridy;
            gbl.setConstraints(numEdit2, gbc);
            jPanel.add(numEdit2);
            numEdit2.addActionListener(sp);
            LinearSolverEqViewPanel.gbc.gridx = n3;
            LinearSolverEqViewPanel.gbc.gridwidth = 1;
            jLabel = new JLabel(" ");
            gbl.setConstraints(jLabel, gbc);
            jPanel.add(jLabel);
            LinearSolverEqViewPanel.gbc.gridwidth = 1;
            LinearSolverEqViewPanel.gbc.gridx = n3 + 1;
            NumEdit numEdit3 = new NumEdit(4);
            LinearSolverEqViewPanel.cells[n2][1] = numEdit3;
            numEdit2 = numEdit3;
            numEdit2.setEditable(false);
            numEdit2.setFont(font);
            gbl.setConstraints(numEdit2, gbc);
            jPanel.add(numEdit2);
            LinearSolverEqViewPanel.gbc.gridx = n3 + 2;
            NumEdit numEdit4 = new NumEdit(5);
            LinearSolverEqViewPanel.cells[n2][2] = numEdit4;
            numEdit2 = numEdit4;
            numEdit2.setEditable(false);
            numEdit2.setFont(font);
            gbl.setConstraints(numEdit2, gbc);
            jPanel.add(numEdit2);
        }
        ++LinearSolverEqViewPanel.gbc.gridy;
        LinearSolverEqViewPanel.gbc.gridx = 0;
        jLabel = new JLabel(" ");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        ++LinearSolverEqViewPanel.gbc.gridy;
        LinearSolverEqViewPanel.gbc.gridx = 0;
        LinearSolverEqViewPanel.gbc.gridwidth = 1;
        jLabel = LinearSolver.labelStore.newLabel("Name");
        LinearSolverEqViewPanel.gbc.gridx = 0;
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        LinearSolverEqViewPanel.gbc.gridwidth = 2;
        LinearSolverEqViewPanel.gbc.gridx = 1;
        jLabel = LinearSolver.labelStore.newLabel("DefinitionderParameter");
        gbl.setConstraints(jLabel, gbc);
        jPanel.add(jLabel);
        for (n2 = 0; n2 < vars.length; ++n2) {
            ++LinearSolverEqViewPanel.gbc.gridy;
            LinearSolverEqViewPanel.gbc.gridx = 0;
            LinearSolverEqViewPanel.gbc.gridwidth = 1;
            if (varn[n2] == null) {
                LinearSolverEqViewPanel.varn[n2] = new NumEdit(5, false);
            }
            varn[n2].setAlNumOnly();
            gbl.setConstraints(varn[n2], gbc);
            jPanel.add(varn[n2]);
            varn[n2].addActionListener(sp);
            LinearSolverEqViewPanel.gbc.gridx = 1;
            LinearSolverEqViewPanel.gbc.gridwidth = 2;
            if (vars[n2] == null) {
                LinearSolverEqViewPanel.vars[n2] = new NumEdit(20, false);
            }
            gbl.setConstraints(vars[n2], gbc);
            jPanel.add(vars[n2]);
            vars[n2].addActionListener(sp);
            LinearSolverEqViewPanel.gbc.gridx = 4;
            LinearSolverEqViewPanel.gbc.gridwidth = 1;
            if (varv[n2] == null) {
                LinearSolverEqViewPanel.varv[n2] = new NumEdit(5, false);
            }
            varv[n2].setEditable(false);
            gbl.setConstraints(varv[n2], gbc);
            jPanel.add(varv[n2]);
        }
        fieldPane = new JScrollPane(jPanel, 20, 30);
        sp.add(fieldPane);
    }

    int collectNames(String[] stringArray, String[] stringArray2) {
        if (stringArray2 == null) {
            return 0;
        }
        for (int i = 0; i < stringArray2.length; ++i) {
            int n;
            boolean bl = false;
            for (n = 0; n < stringArray.length && stringArray[n] != null; ++n) {
                if (!stringArray[n].equals(stringArray2[i])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            if (n == stringArray.length) {
                return -1;
            }
            stringArray[n] = stringArray2[i];
        }
        return 0;
    }

    void qsort(String[] stringArray, int n, int n2) {
        if (n2 > n) {
            String string = stringArray[n2 + n >> 1];
            int n3 = n;
            int n4 = n2;
            while (true) {
                if (stringArray[n3].compareTo(string) < 0) {
                    ++n3;
                    continue;
                }
                while (stringArray[n4].compareTo(string) > 0) {
                    --n4;
                }
                if (n3 > n4) break;
                String string2 = stringArray[n3];
                stringArray[n3++] = stringArray[n4];
                stringArray[n4--] = string2;
                if (n3 > n4) break;
            }
            this.qsort(stringArray, n, n4);
            this.qsort(stringArray, n3, n2);
        }
    }

    String wrap(int n) {
        return " " + n + " ";
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string;
        int n;
        double[][] dArray = new double[ngl][ngl];
        double[] dArray2 = new double[ngl];
        String[] stringArray = new String[ngl];
        String[] stringArray2 = new String[ngl];
        if (actionEvent != null) {
            this.myparent.ch.setSelectedIndex(0);
        }
        Ftree.delAllVars();
        Ftree.resetStatus();
        for (n = 0; n < ngl; ++n) {
            cells[n][1].setText("");
            cells[n][2].setText("");
        }
        for (n = 0; n < vars.length; ++n) {
            string = varn[n].getTrimText();
            String string2 = vars[n].getTrimText();
            if (string.length() > 0) {
                if (!Ftree.isalpha(string.charAt(0))) {
                    this.myparent.errorMsg(myLocale.getString("EinParameternamemussmiteinemBuchstabenbeginnen"));
                    return;
                }
                Ftree.setVar(string, string2);
            }
            if (Ftree.getStatus() == 0) continue;
            this.myparent.errorMsg(myLocale.getString("FehlerinFormelbeiParameterdefinition") + this.wrap(n + 1));
            return;
        }
        for (n = 0; n < vars.length; ++n) {
            string = varn[n].getTrimText();
            varv[n].setText("");
            if (string.length() == 0) continue;
            double d = Ftree.getVar(string);
            if (Ftree.getStatus() != 0) {
                this.myparent.errorMsg(myLocale.getString("FehlerbeiVariable") + " " + string);
                return;
            }
            varv[n].setText(NumEdit.toPrecision(d, 3));
        }
        string = Ftree.notInitializedVars();
        if (string.length() > 0) {
            this.myparent.errorMsg(myLocale.getString("NichtdefinierteParameter") + ": " + string);
            return;
        }
        this.myparent.errorMsg("");
        int n2 = 0;
        for (n = 0; n < ngl; ++n) {
            object = cells[n][0].getTrimText();
            if (((String)object).length() == 0) continue;
            int n3 = ((String)object).indexOf(61);
            if (n3 < 0) {
                this.myparent.errorMsg(myLocale.getString("InderZeile") + this.wrap(n + 1) + myLocale.getString("fehltdierechteSeite"));
                return;
            }
            stringArray2[n2] = ((String)object).substring(0, n3);
            String string3 = ((String)object).substring(n3 + 1);
            if (stringArray2[n2].length() == 0) {
                this.myparent.errorMsg(myLocale.getString("InderZeile") + this.wrap(n + 1) + myLocale.getString("fehltdielinkeSeite"));
                return;
            }
            if (string3.length() == 0) {
                this.myparent.errorMsg(myLocale.getString("InderZeile") + this.wrap(n + 1) + myLocale.getString("fehltdierechteSeite"));
                return;
            }
            if (string3.indexOf(61) >= 0) {
                this.myparent.errorMsg(myLocale.getString("InderZeile") + this.wrap(n + 1) + myLocale.getString("sind2Gleichheitszeichen"));
                return;
            }
            int n4 = n2++;
            stringArray2[n4] = stringArray2[n4] + "-(" + string3 + ")";
        }
        if (n2 == 0) {
            return;
        }
        object = new Ftree[n2];
        Ftree.delNotInitializedVars();
        for (n = 0; n < n2; ++n) {
            object[n] = new Ftree(stringArray2[n]);
            string = Ftree.notInitializedVars();
            String[] stringArray3 = NumEdit.split(string);
            if (this.collectNames(stringArray, stringArray3) != 0) {
                this.myparent.errorMsg(myLocale.getString("mehrUnbekanntealsGleichungen"));
                return;
            }
            if (Ftree.getStatus() == 0) continue;
            this.myparent.errorMsg(myLocale.getString("FehlerinGleichung") + this.wrap(n + 1));
            return;
        }
        if (stringArray[n2 - 1] == null) {
            this.myparent.errorMsg(myLocale.getString("wenigerUnbekanntealsGleichungen"));
            return;
        }
        if (n2 < ngl && stringArray[n2] != null) {
            this.myparent.errorMsg(myLocale.getString("mehrUnbekanntealsGleichungen"));
            return;
        }
        this.qsort(stringArray, 0, n2 - 1);
        for (n = 0; n < n2; ++n) {
            double d;
            int n5;
            Object object2 = object[n];
            for (n5 = 0; n5 < n2; ++n5) {
                Ftree.setVar(stringArray[n5], 0.0);
            }
            dArray2[n] = -((Ftree)object2).evaluate();
            Ftree.resetStatus();
            for (int i = 0; i < n2; ++i) {
                for (n5 = 0; n5 < n2; ++n5) {
                    Ftree.setVar(stringArray[n5], n5 == i ? 1.0 : 0.0);
                }
                dArray[n][i] = ((Ftree)object2).evaluate() + dArray2[n];
                Ftree.setVar(stringArray[i], 2.0);
                d = 0.5 * (((Ftree)object2).evaluate() + dArray2[n]);
                if (Math.abs(dArray[n][i] - d) > 1.0E-5) {
                    this.myparent.errorMsg(myLocale.getString("DieGleichung") + this.wrap(n + 1) + myLocale.getString("istnichtlinearbezueglich") + " " + stringArray[i]);
                    return;
                }
                if (Ftree.getStatus() == 0) continue;
                this.myparent.errorMsg(myLocale.getString("FehlerinGleichung") + this.wrap(n + 1));
                return;
            }
            for (n5 = 0; n5 < n2; ++n5) {
                Ftree.setVar(stringArray[n5], 1.0);
            }
            double d2 = ((Ftree)object2).evaluate() + dArray2[n];
            for (n5 = 0; n5 < n2; ++n5) {
                Ftree.setVar(stringArray[n5], 2.0);
            }
            d = 0.5 * (((Ftree)object2).evaluate() + dArray2[n]);
            if (!(Math.abs(d2 - d) > 1.0E-5)) continue;
            this.myparent.errorMsg(myLocale.getString("DieGleichung") + this.wrap(n + 1) + myLocale.getString("istnichtlinear"));
            return;
        }
        int n6 = Gauss.fullPivoting(dArray, dArray2, n2);
        if (n6 < 0) {
            this.myparent.errorMsg(myLocale.getString("DieKoeffizientenmatrixistsingulaer") + " - " + myLocale.getString("esexistiertkeineLoesung"));
            dArray2 = null;
        } else {
            if (n6 > 0) {
                this.myparent.errorMsg(myLocale.getString("DieKoeffizientenmatrixistsingulaer") + " - " + myLocale.getString("esgibtunendlichvieleLoesungen"));
            } else {
                this.myparent.errorMsg("");
            }
            double d = VectorSet.vsAbsMax(dArray2) * 1.0E-10;
            VectorSet.vsclear(dArray2, d);
        }
        n = n2;
        while (--n >= 0) {
            cells[n][1].setText(stringArray[n]);
            cells[n][2].setText(dArray2 != null ? NumEdit.toPrecision(dArray2[n], 4) : "");
        }
    }

    static {
        cells = null;
        sp = null;
        varn = null;
        vars = null;
        varv = null;
        fieldPane = null;
    }
}

