/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JComboBox;
import javax.swing.JLabel;

class LinearSolverEqPanel
extends LinearSolverPanel {
    JComboBox<String> ch = new JComboBox();
    JLabel tr;
    String[][] sCells;
    String[] savedVarn;
    String[] savedVars;
    String[] example = new String[]{"#(Beispiel) 1", "n 3", "0 a + b + c = 4", "1 a + b - 3*c = 2", "2 2*a + b = 3", "#(Beispiel) 2", "n 3", "0 FAx + Fx = 0", "1 FAy + FB + Fy = 0", "2 FB*xB + Fy*xF = 0", "_phi -PI/2", "_Fx 10*cos(phi)", "_Fy 10*sin(phi)", "_xB 4", "_xF 1"};
    int[] start = new int[10];
    int varCnt = 0;

    LinearSolverEqPanel() {
        this.viewPanel = new LinearSolverEqViewPanel(this);
        this.add((Component)this.viewPanel, "Center");
        LinearSolverEqViewPanel.init(this.numgl.getInt());
        this.tr = new JLabel(" ");
        this.fpAdd(this.tr, 0, ++this.gbc.gridy, 1, 1);
        this.tr = LinearSolver.labelStore.newLabel("Beispiele");
        this.fpAdd(this.tr, 0, ++this.gbc.gridy, 1, 1);
        this.fpAdd(this.ch, 0, ++this.gbc.gridy, 1, 1);
        this.ch.addItemListener(this);
        this.exampleInit();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object != this.neu && object != this.numgl) {
            return;
        }
        int n = this.numgl.getInt();
        LinearSolver.labelStore.changeTexts();
        if (n == LinearSolverEqViewPanel.cells.length && object == this.numgl) {
            return;
        }
        if (n < 2) {
            n = 2;
        }
        if (n > 16) {
            n = 16;
        }
        this.numgl.setText("" + n);
        if (object != this.neu) {
            this.saveCells();
        }
        this.viewPanel.setVisible(false);
        this.viewPanel.removeAll();
        this.viewPanel.setVisible(true);
        LinearSolverEqViewPanel.init(n);
        if (object != this.neu) {
            this.restoreCells();
        }
        this.validate();
    }

    public void saveCells() {
        int n;
        int n2 = LinearSolverEqViewPanel.cells.length;
        int n3 = 1;
        this.sCells = new String[n2][];
        for (n = 0; n < n2; ++n) {
            this.sCells[n] = new String[n3];
            for (int i = 0; i < n3; ++i) {
                this.sCells[n][i] = LinearSolverEqViewPanel.cells[n][i].getText();
            }
        }
        n2 = LinearSolverEqViewPanel.varn.length;
        this.savedVarn = new String[n2];
        this.savedVars = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.savedVarn[n] = LinearSolverEqViewPanel.varn[n].getText();
            this.savedVars[n] = LinearSolverEqViewPanel.vars[n].getText();
        }
    }

    public void restoreCells() {
        int n;
        int n2 = LinearSolverEqViewPanel.cells.length;
        int n3 = 1;
        if (this.sCells.length < n2) {
            n2 = this.sCells.length;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                LinearSolverEqViewPanel.cells[n][i].setText(this.sCells[n][i]);
            }
        }
        n2 = LinearSolverMaViewPanel.varn.length;
        for (n = 0; n < n2; ++n) {
            LinearSolverEqViewPanel.varn[n].setText(this.savedVarn[n]);
            LinearSolverEqViewPanel.vars[n].setText(this.savedVars[n]);
        }
    }

    void exampleInit() {
        int n = 0;
        this.ch.addItem("");
        for (int i = 0; i < this.example.length; ++i) {
            String string = this.example[i];
            if (string.charAt(0) != '#') continue;
            string = myLocale.replaceFromResourceFile(string.substring(1));
            this.ch.addItem(string);
            this.start[n++] = i + 1;
        }
    }

    public void stringToFields(String string) {
        String[] stringArray = NumEdit.split(string);
        switch (stringArray[0].charAt(0)) {
            case 'n': {
                int n = Integer.parseInt(stringArray[1]);
                this.viewPanel.setVisible(false);
                this.viewPanel.removeAll();
                this.viewPanel.setVisible(true);
                LinearSolverEqViewPanel.init(n);
                this.validate();
                this.numgl.setText("" + n);
                break;
            }
            case '_': {
                LinearSolverEqViewPanel.varn[this.varCnt].setText(stringArray[0].substring(1));
                LinearSolverEqViewPanel.vars[this.varCnt].setText(stringArray[1]);
                ++this.varCnt;
                break;
            }
            default: {
                int n;
                if (!Ftree.isdigit(stringArray[0].charAt(0))) break;
                Object object = "";
                for (n = 1; n < stringArray.length; ++n) {
                    object = (String)object + stringArray[n] + " ";
                }
                object = ((String)object).trim();
                n = Integer.parseInt(stringArray[0]);
                LinearSolverEqViewPanel.cells[n][0].setText((String)object);
            }
        }
    }

    public void loadExample(int n) {
        String string;
        if (--n < 0) {
            return;
        }
        int n2 = LinearSolverMaViewPanel.varn.length;
        while (--n2 >= 0) {
            LinearSolverEqViewPanel.varn[n2].setText("");
            LinearSolverEqViewPanel.vars[n2].setText("");
        }
        this.varCnt = 0;
        for (n2 = this.start[n]; n2 < this.example.length && (string = this.example[n2]).charAt(0) != '#'; ++n2) {
            this.stringToFields(string);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        int n = this.ch.getSelectedIndex();
        if (n >= 0) {
            this.loadExample(n);
            ((LinearSolverEqViewPanel)this.viewPanel).actionPerformed(null);
        }
    }
}

