/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;

class LavalRotorSimulation
extends GrPanel
implements Runnable {
    int NFG = 4;
    MyRuKu rk = null;
    int nf = 31;
    double fmax = 40.0;
    double dfg = this.fmax / (double)(this.nf - 1);
    static LavalRotorSimulation currSimu = null;
    Thread simuThread = null;
    boolean isRunning = false;
    double g = 9.81;
    double[][] M = new double[this.NFG][this.NFG];
    double[][] D = new double[this.NFG][this.NFG];
    double[][] G = new double[this.NFG][this.NFG];
    double[][] S = new double[this.NFG][this.NFG];
    static double[] l = new double[]{0.3, 0.9, 0.4};
    static double[] d = new double[]{0.05, 0.6, 0.04};
    double phi;
    double rho = 7850.0;
    double EM = 2.1E11;
    static double mR;
    static double JA;
    static double JP;
    static double s11;
    static double s12;
    static double s22;
    static double eunwucht;
    static double f;
    static double t;
    static double tw;
    double dt = 0.014;
    static double[] polyF;
    static double[][] polys;
    LavalRotorPanel parent = null;
    double[] yarr = new double[2 * this.NFG + 1];
    int a = 6;
    int b = 8;
    int[] lines_fest = new int[]{0, 0, this.a, this.b, 0, 0, -this.a, this.b, this.a + 3, this.b, -this.a - 3, this.b, -this.a - 6, this.b + 3, -this.a - 3, this.b, -this.a - 3, this.b + 3, -this.a, this.b, -this.a, this.b + 3, -this.a + 3, this.b, -this.a + 3, this.b + 3, -this.a + 6, this.b, -this.a + 6, this.b + 3, -this.a + 9, this.b, -this.a + 9, this.b + 3, -this.a + 12, this.b, -this.a + 12, this.b + 3, -this.a + 15, this.b};

    LavalRotorSimulation() {
        currSimu = this;
    }

    static void setf(int n) {
        f = n;
        tw = t;
    }

    public void init() {
        this.initData();
        this.simuThread = new Thread(this);
        this.simuThread.start();
    }

    void eigenfrequenzen() {
        int n;
        double[] dArray = new double[this.NFG];
        double[][] dArray2 = new double[this.NFG][this.NFG];
        double[][] dArray3 = new double[this.NFG][this.NFG];
        double[][] dArray4 = new double[this.NFG][this.NFG];
        for (int i = 0; i < this.NFG; ++i) {
            for (n = 0; n < this.NFG; ++n) {
                dArray2[i][n] = this.S[i][n];
                dArray3[i][n] = this.M[i][n];
            }
        }
        Jacobi.allgEWP(dArray2, dArray3, dArray, dArray4);
        Object object = "Eigenfrequenzen im Stillstand:";
        this.fmax = 0.0;
        for (n = dArray.length - 1; n >= 0; n -= 2) {
            dArray[n] = Math.sqrt(dArray[n]) / (Math.PI * 2);
            if (dArray[n] > this.fmax) {
                this.fmax = dArray[n];
            }
            object = (String)object + "   " + NumEdit.toFixed(dArray[n], 2) + " Hz";
        }
        this.fmax = 4.0 * this.fmax;
        this.dfg = this.fmax / (double)(this.nf - 1);
        this.parent.slider.setMaximum((int)this.fmax);
        this.parent.statusMsg((String)object);
    }

    void frequenzDiagramm() {
        LavalRotorSimulation.polys[0] = new double[this.nf];
        LavalRotorSimulation.polys[1] = new double[this.nf];
        polyF = new double[this.nf];
        double[] dArray = new double[5];
        double d = Math.PI * 2;
        int n = 4;
        double[] dArray2 = new double[n + 1];
        double[] dArray3 = new double[n + 1];
        for (int i = 0; i < this.nf; ++i) {
            double d2;
            LavalRotorSimulation.polyF[i] = d2 = this.dfg * (double)i;
            double d3 = d2 * d;
            dArray[0] = mR * JA;
            dArray[1] = -mR * JP * d3;
            dArray[2] = -(s22 * mR + s11 * JA);
            dArray[3] = s11 * JP * d3;
            dArray[4] = s11 * s22 - s12 * s12;
            Muller.wurzeln(dArray, n, dArray2, dArray3);
            Muller.shellSort(dArray2, dArray3, n);
            LavalRotorSimulation.polys[0][i] = dArray2[2] / d;
            LavalRotorSimulation.polys[1][i] = dArray2[3] / d;
        }
    }

    void initData() {
        int n;
        tw = 0.0;
        if (!this.isRunning) {
            for (n = 0; n < this.yarr.length; ++n) {
                this.yarr[n] = 0.0;
            }
        }
        LavalRotorSimulation.d[0] = this.parent.datField[0].getDouble();
        LavalRotorSimulation.d[1] = this.parent.datField[1].getDouble();
        LavalRotorSimulation.d[2] = this.parent.datField[2].getDouble();
        LavalRotorSimulation.l[0] = this.parent.datField[3].getDouble();
        LavalRotorSimulation.l[1] = this.parent.datField[4].getDouble();
        LavalRotorSimulation.l[2] = this.parent.datField[5].getDouble();
        eunwucht = this.parent.datField[6].getDouble();
        for (n = 0; n < this.M[0].length; ++n) {
            for (int i = 0; i < this.M[0].length; ++i) {
                this.M[n][i] = 0.0;
                this.S[n][i] = 0.0;
            }
        }
        double d = l[0];
        double d2 = l[2];
        double d3 = l[0] + l[1] * 0.5;
        double d4 = l[2] + l[1] * 0.5;
        double d5 = d3 + d4;
        double d6 = Math.PI * Math.pow(LavalRotorSimulation.d[0], 4.0) / 64.0;
        double d7 = Math.PI * Math.pow(LavalRotorSimulation.d[2], 4.0) / 64.0;
        if (1.1 * LavalRotorSimulation.d[0] >= LavalRotorSimulation.d[1] || 1.1 * LavalRotorSimulation.d[2] >= LavalRotorSimulation.d[1]) {
            d = d3;
            d2 = d4;
        }
        s11 = d * d * d / (3.0 * this.EM * d6) * Math.pow(d4 / d5, 2.0) + d2 * d2 * d2 / (3.0 * this.EM * d7) * Math.pow(d3 / d5, 2.0);
        s22 = d / (3.0 * this.EM * d6) * Math.pow(d / d5, 2.0) + d2 / (3.0 * this.EM * d7) * Math.pow(d2 / d5, 2.0);
        s12 = d * d * d / (3.0 * this.EM * d6) * d4 / (d5 * d5) - d2 * d2 * d2 / (3.0 * this.EM * d7) * d3 / (d5 * d5);
        mR = 0.25 * this.rho * Math.PI * LavalRotorSimulation.d[1] * LavalRotorSimulation.d[1] * l[1];
        JA = mR / 12.0 * (l[1] * l[1] + 0.75 * LavalRotorSimulation.d[1] * LavalRotorSimulation.d[1]);
        JP = mR * LavalRotorSimulation.d[1] * LavalRotorSimulation.d[1] / 8.0;
        double d8 = mR += 0.5 * this.rho * Math.PI * 0.25 * (LavalRotorSimulation.d[0] * LavalRotorSimulation.d[0] * l[0] + LavalRotorSimulation.d[2] * LavalRotorSimulation.d[2] * l[2]);
        this.M[0][0] = d8;
        this.M[1][1] = d8;
        double d9 = JA;
        this.M[2][2] = d9;
        this.M[3][3] = d9;
        this.S[0][0] = s11;
        this.S[1][1] = s11;
        this.S[2][2] = s22;
        this.S[3][3] = s22;
        double d10 = -s12;
        this.S[0][2] = d10;
        this.S[2][0] = d10;
        double d11 = s12;
        this.S[1][3] = d11;
        this.S[3][1] = d11;
        int n2 = Gauss.invert(this.S, this.NFG);
        s11 = this.S[0][0];
        s22 = this.S[2][2];
        s12 = this.S[0][2];
        double d12 = 0.05;
        this.D[0][0] = 2.0 * d12 * Math.sqrt(this.M[0][0] * this.S[0][0]);
        this.D[1][1] = 2.0 * d12 * Math.sqrt(this.M[1][1] * this.S[1][1]);
        this.D[2][2] = 2.0 * d12 * Math.sqrt(this.M[2][2] * this.S[2][2]);
        this.D[3][3] = 2.0 * d12 * Math.sqrt(this.M[3][3] * this.S[3][3]);
        this.G[2][3] = -JP;
        this.G[3][2] = JP;
        this.eigenfrequenzen();
        this.frequenzDiagramm();
        n2 = Gauss.invert(this.M, this.NFG);
        VectorSet.mamu(this.S, this.M, this.S);
        VectorSet.mamu(this.D, this.M, this.D);
        VectorSet.mamu(this.G, this.M, this.G);
    }

    void timer() {
        if (this.rk == null) {
            this.rk = new MyRuKu();
            this.rk.init(2 * this.NFG + 1);
        }
        this.rk.timeAutoStep(this.yarr, this.dt);
        t = this.yarr[0];
        int n = (int)(t * 100.0) % 10;
        if (n != 0) {
            return;
        }
    }

    @Override
    public void run() {
        int n;
        this.isRunning = true;
        if (f == 0.0) {
            f = 1.0;
        }
        this.parent.slider.setValue((int)f);
        this.parent.horizontal.setText(NumEdit.toFixed(f, 1));
        for (n = 0; n < this.parent.datField.length - 1; ++n) {
            this.parent.datField[n].setEnabled(false);
        }
        this.parent.b1.setText("Stop");
        while (this.isRunning) {
            try {
                long l = System.currentTimeMillis();
                this.timer();
                this.repaint();
                long l2 = System.currentTimeMillis();
                int n2 = (int)(this.dt * 1000.0 - (double)(l2 - l));
                if (n2 <= 0) continue;
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.parent.b1.setText("Start");
        for (n = 0; n < this.parent.datField.length - 1; ++n) {
            this.parent.datField[n].setEnabled(true);
        }
    }

    public void stop() {
        this.isRunning = false;
    }

    void rotor(double d, double d2, double d3, double d4, double d5) {
        double d6 = d3 - d;
        double d7 = d4 - d2;
        double d8 = -d7;
        double d9 = d6;
        double d10 = Math.sqrt(d8 * d8 + d9 * d9);
        this.wMoveTo(d, d2);
        this.wLineTo(d + (d8 *= d5 / d10), d2 + (d9 *= d5 / d10));
        this.wLineTo(d3 + d8, d4 + d9);
        this.wLineTo(d3 - d8, d4 - d9);
        this.wLineTo(d - d8, d2 - d9);
        this.wLineTo(d, d2);
    }

    void drawBeam(double d, double d2, double d3, double d4, int n) {
        int n2 = 15;
        double d5 = d2 - d;
        double d6 = d5 / (double)n2;
        d4 *= d5;
        if (n == 1) {
            double d7 = d;
            this.wMoveTo(d7, 0.0);
            for (int i = 0; i <= n2; ++i) {
                double d8 = (d7 - d) / d5;
                double d9 = (-0.5 * d8 * d8 * d8 + 1.5 * d8) * d3 + (0.5 * d8 * d8 * d8 - 0.5 * d8) * d4;
                this.wLineTo2(d7, d9);
                d7 += d6;
            }
        } else {
            double d10 = d2;
            this.wMoveTo(d10, 0.0);
            for (int i = 0; i <= n2; ++i) {
                double d11 = (d10 - d) / d5;
                double d12 = (0.5 * d11 * d11 * d11 - 1.5 * d11 * d11 + 1.0) * d3 + (0.5 * d11 * d11 * d11 - 1.5 * d11 * d11 + d11) * d4;
                this.wLineTo2(d10, d12);
                d10 -= d6;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        double d = Math.PI * 2 * f;
        this.myg = graphics;
        double d2 = LavalRotorSimulation.d[0] > LavalRotorSimulation.d[1] ? LavalRotorSimulation.d[0] : LavalRotorSimulation.d[1];
        d2 = d2 > LavalRotorSimulation.d[2] ? d2 : LavalRotorSimulation.d[2];
        double d3 = l[0] + l[1] + l[2];
        this.setMinMax(0.0, -d2 * 1000.0, d3 * 1.2 * 1000.0, d2 * 1000.0);
        this.myg.setColor(new Color(111, 125, 137));
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        double[] dArray = new double[]{0.0, l[0] * 1000.0, (l[0] + l[1]) * 1000.0, (l[0] + l[1] + l[2]) * 1000.0};
        this.myg.setColor(Color.yellow);
        double d4 = Math.tan(this.yarr[this.NFG + 4]);
        double d5 = 0.5 * l[1] * (1.0 - Math.cos(d4));
        double d6 = 0.5 * l[1] * Math.sin(d4);
        this.drawBeam(dArray[0], dArray[1], 1000.0 * (this.yarr[this.NFG + 2] + d6), -d4, 1);
        this.drawBeam(dArray[2], dArray[3], 1000.0 * (this.yarr[this.NFG + 2] - d6), -d4, 2);
        this.wMoveTo(dArray[1], 1000.0 * (this.yarr[this.NFG + 2] + d6));
        this.wLineTo(dArray[2], 1000.0 * (this.yarr[this.NFG + 2] - d6));
        this.rotor(1000.0 * (l[0] + d5), 1000.0 * (this.yarr[this.NFG + 2] + d6), 1000.0 * (l[0] + l[1] - d5), 1000.0 * (this.yarr[this.NFG + 2] - d6), 1000.0 * LavalRotorSimulation.d[1] * 0.5);
        this.fillCircle(1000.0 * (this.yarr[this.NFG + 1] + 1.1 * d3), 1000.0 * this.yarr[this.NFG + 2], 1);
        this.myg.setColor(Color.red);
        double d7 = 1000.0 * (this.yarr[this.NFG + 2] + eunwucht * Math.sin(d * t));
        this.fillCircle(1000.0 * (this.yarr[this.NFG + 1] + eunwucht * Math.cos(d * t) + 1.1 * d3), d7, 1);
        this.fillCircle(0.5 * (dArray[1] + dArray[2]), d7, 1);
        this.myg.setColor(Color.white);
        this.drawLines(this.lines_fest, this.screenx(0.0), this.screeny(0.0), 0.0);
        this.drawLines(this.lines_fest, this.screenx(d3 * 1000.0), this.screeny(0.0), 0.0);
    }

    void setParent(LavalRotorPanel lavalRotorPanel) {
        this.parent = lavalRotorPanel;
    }

    static {
        eunwucht = 0.01;
        f = 0.0;
        tw = 0.0;
        polyF = null;
        polys = new double[9][];
    }

    class MyRuKu
    extends RungeKutta {
        MyRuKu() {
        }

        @Override
        void funk(double[] dArray, double[] dArray2) {
            double d = Math.PI * 2 * f;
            dArray[0] = 1.0;
            for (int i = 0; i < LavalRotorSimulation.this.NFG; ++i) {
                dArray[i + 1] = 0.0;
                for (int j = 0; j < LavalRotorSimulation.this.NFG; ++j) {
                    int n = i + 1;
                    dArray[n] = dArray[n] - (LavalRotorSimulation.this.S[i][j] * dArray2[j + LavalRotorSimulation.this.NFG + 1] + (LavalRotorSimulation.this.D[i][j] + LavalRotorSimulation.this.G[i][j] * d) * dArray2[j + 1]);
                }
            }
            double d2 = 1.0 - Math.exp(-Math.abs(t - tw));
            double d3 = d * d * eunwucht * d2;
            dArray[1] = dArray[1] + d3 * Math.cos(d * dArray2[0]);
            dArray[2] = dArray[2] + d3 * Math.sin(d * dArray2[0]);
            for (int i = 1; i <= LavalRotorSimulation.this.NFG; ++i) {
                dArray[i + LavalRotorSimulation.this.NFG] = dArray2[i];
            }
        }
    }
}

