/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.FileWriter;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.text.DefaultHighlighter;

class LaplaceResultPanel
extends DekorPanel {
    static int npsoll = 300;
    JTextArea txarea;
    JCheckBox c1 = Laplace.labelStore.newCheckBox("Netzdarstellung");
    JCheckBox c2 = Laplace.labelStore.newCheckBox("Knotennummern");
    JCheckBox c3 = Laplace.labelStore.newCheckBox("3D-Darstellung");
    ButtonGroup cbg = new ButtonGroup();
    JRadioButton c4 = new JRadioButton("T", true);
    JRadioButton c5 = new JRadioButton("|grad T|");
    JRadioButton c6 = new JRadioButton("\u2202T/\u2202x");
    JRadioButton c7 = new JRadioButton("\u2202T/\u2202y");
    JToggleButton[] cAlle = new JToggleButton[]{this.c1, this.c2, this.c3, this.c4, this.c5, this.c6, this.c7};
    static NumEdit tf;
    static NumEdit cpMin;
    static NumEdit cpMax;
    public static int np;
    public static int nt;
    public static int nrb;
    public static int nrand;
    public static final int MAXP = 40;
    public static final int MAXR = 10;
    static String currFile;
    static Dreieck[] tria;
    static Rand[] rand;
    static double[] x;
    static double[] y;
    static double[] T;
    static double[] temperatur;
    static double[] gradient;
    static double[] gradx;
    static double[] grady;
    static boolean showElementGrid;
    static boolean showNodeNumbers;
    static final int showTemp = 0;
    static final int showGradient = 1;
    static final int showGradx = 2;
    static final int showGrady = 3;
    static int showMode;
    static boolean is3d;
    static LaplaceResultPanel self;
    Object lastMark = null;
    int[] randpunktIndizes;
    static int[] permfw;
    double[][] K = null;

    LaplaceResultPanel() {
        super(new LaplaceGrafikPanel(), 228);
        this.txarea = new JTextArea("", 15, 20);
        this.txarea.setFont(new Font("MonoSpaced", 0, 13));
        this.txarea.setEditable(false);
        this.txarea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane jScrollPane = new JScrollPane(this.txarea, 20, 30);
        self = this;
        is3d = false;
        showElementGrid = false;
        showNodeNumbers = false;
        nrb = 0;
        this.gbc.gridx = 1;
        this.gbc.gridy = 0;
        this.gbc.gridwidth = 2;
        this.gbc.anchor = 17;
        this.cbg.add(this.c4);
        this.cbg.add(this.c5);
        this.cbg.add(this.c6);
        this.cbg.add(this.c7);
        for (int i = 0; i < this.cAlle.length; ++i) {
            this.gbl.setConstraints(this.cAlle[i], this.gbc);
            this.fieldPanel.add(this.cAlle[i]);
            ++this.gbc.gridy;
            this.cAlle[i].addItemListener(this);
        }
        this.gbc.gridwidth = 1;
        tf = new NumEdit("" + npsoll, 4);
        this.gbl.setConstraints(tf, this.gbc);
        this.fieldPanel.add(tf);
        tf.setNumOnly();
        this.gbc.gridx = 2;
        JLabel jLabel = Laplace.labelStore.newLabel(" (Knoten)");
        this.gbc.anchor = 17;
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        ++this.gbc.gridy;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        cpMin = new NumEdit("", 4);
        this.gbl.setConstraints(cpMin, this.gbc);
        this.fieldPanel.add(cpMin);
        this.gbc.gridx = 2;
        jLabel = Laplace.labelStore.newLabel(" Min");
        this.gbc.anchor = 17;
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        ++this.gbc.gridy;
        this.gbc.gridx = 1;
        this.gbc.gridwidth = 1;
        cpMax = new NumEdit("", 4);
        this.gbl.setConstraints(cpMax, this.gbc);
        this.fieldPanel.add(cpMax);
        cpMax.setName("last");
        this.gbc.gridx = 2;
        jLabel = Laplace.labelStore.newLabel(" Max");
        this.gbc.anchor = 17;
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        this.gbc.gridx = 0;
        ++this.gbc.gridy;
        jLabel = new JLabel(" ");
        this.gbl.setConstraints(jLabel, this.gbc);
        this.fieldPanel.add(jLabel);
        ++this.gbc.gridy;
        this.gbc.gridwidth = 4;
        this.gbl.setConstraints(jScrollPane, this.gbc);
        this.fieldPanel.add(jScrollPane);
        tf.addActionListener(this);
        cpMin.addActionListener(this);
        cpMax.addActionListener(this);
    }

    public void unmark() {
        if (this.lastMark == null) {
            return;
        }
        DefaultHighlighter defaultHighlighter = (DefaultHighlighter)this.txarea.getHighlighter();
        defaultHighlighter.removeHighlight(this.lastMark);
        this.lastMark = null;
    }

    public void mark(int n) {
        DefaultHighlighter defaultHighlighter = (DefaultHighlighter)this.txarea.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(Color.GRAY);
        try {
            this.unmark();
            int n2 = this.txarea.getLineStartOffset(n);
            int n3 = this.txarea.getLineEndOffset(n);
            this.lastMark = defaultHighlighter.addHighlight(n2, n3, defaultHighlightPainter);
            this.txarea.setCaretPosition(this.txarea.getDocument().getDefaultRootElement().getElement(n).getStartOffset());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void showSolution() {
        String string;
        if (T == null) {
            string = "";
            this.errorMsg(myLocale.getString("DieSystemmatrixIstSingulaer"));
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < T.length; ++i) {
                stringBuilder.append(TextPanel.toStr(i + 1));
                stringBuilder.append(' ');
                stringBuilder.append(NumEdit.toPrecision(T[i], 4));
                stringBuilder.append('\n');
            }
            string = stringBuilder.toString();
        }
        this.txarea.setText(string);
        this.txarea.setCaretPosition(0);
    }

    static void speichern(String string) {
        currFile = string;
        try {
            int n;
            FileWriter fileWriter = new FileWriter(string);
            if (fileWriter == null) {
                return;
            }
            fileWriter.write("N " + npsoll + "\n");
            for (n = 0; n < 40; ++n) {
                String string2 = NumEdit.stripBlanks(LaplacePunktePanel.tfx[n].getText());
                String string3 = NumEdit.stripBlanks(LaplacePunktePanel.tfy[n].getText());
                if (string2.length() == 0 && string3.length() == 0) continue;
                if (string2.length() == 0) {
                    string2 = "0";
                }
                if (string3.length() == 0) {
                    string3 = "0";
                }
                fileWriter.write("P " + string2 + " " + string3 + "\n");
            }
            for (n = 0; n < nrb; ++n) {
                if (LaplaceResultPanel.rand[n].mode == 1) {
                    fileWriter.write("T ");
                } else {
                    fileWriter.write("Q ");
                }
                fileWriter.write(LaplaceResultPanel.rand[n].n1 + " " + LaplaceResultPanel.rand[n].n2);
                if (LaplaceResultPanel.rand[n].mode == 1) {
                    fileWriter.write(" " + LaplaceResultPanel.rand[n].t);
                } else if (LaplaceResultPanel.rand[n].mode == 2) {
                    fileWriter.write(" " + LaplaceResultPanel.rand[n].a);
                } else {
                    fileWriter.write(" " + LaplaceResultPanel.rand[n].t + " " + LaplaceResultPanel.rand[n].a);
                }
                fileWriter.write("\n");
            }
            fileWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void storeFileOperations(String string) {
        LaplaceResultPanel.speichern(string);
    }

    static void speichernAls() {
        FileOperations.storeAs("lpc", self);
    }

    static void speichern() {
        if (currFile != null) {
            LaplaceResultPanel.speichern(currFile);
        } else {
            LaplaceResultPanel.speichernAls();
        }
    }

    static void maskenLoeschen() {
        int n = LaplacePunktePanel.tfx.length;
        while (--n >= 0) {
            LaplacePunktePanel.tfx[n].setText("");
            LaplacePunktePanel.tfy[n].setText("");
        }
        n = LaplaceRandbdgPanel.tf1.length;
        while (--n >= 0) {
            LaplaceRandbdgPanel.tf1[n].setText("");
            LaplaceRandbdgPanel.tf2[n].setText("");
            LaplaceRandbdgPanel.tft[n].setText("");
            LaplaceRandbdgPanel.tfq[n].setText("");
        }
        np = 0;
        nrb = 0;
        Graph3d.limitMin = 0.0;
        Graph3d.limitMax = 0.0;
        cpMin.setText("");
        cpMax.setText("");
        LaplacePunktePanel.auslesen();
    }

    static void stringToFields(String string) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 2;
        String[] stringArray = NumEdit.split(string);
        if (stringArray.length > 0) {
            switch (stringArray[0].charAt(0)) {
                case 'P': {
                    LaplacePunktePanel.tfx[np].setText(stringArray[1]);
                    LaplacePunktePanel.tfy[np].setText(stringArray[2]);
                    ++np;
                    break;
                }
                case 'N': {
                    npsoll = Integer.parseInt(stringArray[1]);
                    tf.setText(stringArray[1]);
                    break;
                }
                case 'T': {
                    n = 1;
                    d = Ftree.evaluate(stringArray[3]);
                }
                case 'Q': {
                    d2 = Ftree.evaluate(stringArray[3]);
                    if (stringArray.length > 4) {
                        n = 3;
                        d = Ftree.evaluate(stringArray[3]);
                        d2 = Ftree.evaluate(stringArray[4]);
                    }
                    int n2 = Integer.parseInt(stringArray[1]);
                    int n3 = Integer.parseInt(stringArray[2]);
                    LaplaceResultPanel.rand[LaplaceResultPanel.nrb] = new Rand(n2, n3, d, d2, n);
                    LaplaceRandbdgPanel.tf1[nrb].setText("" + (n2 + 1));
                    LaplaceRandbdgPanel.tf2[nrb].setText("" + (n3 + 1));
                    if (n == 1) {
                        LaplaceRandbdgPanel.tft[nrb].setText("" + d);
                        LaplaceRandbdgPanel.tfq[nrb].setText("");
                    } else if (n == 2) {
                        LaplaceRandbdgPanel.tft[nrb].setText("");
                        LaplaceRandbdgPanel.tfq[nrb].setText("" + d2);
                    } else {
                        LaplaceRandbdgPanel.tft[nrb].setText("" + d);
                        LaplaceRandbdgPanel.tfq[nrb].setText("" + d2);
                    }
                    ++nrb;
                }
            }
        }
    }

    public static void beforeFileOperations() {
        LaplaceResultPanel.maskenLoeschen();
    }

    public static void afterFileOperations(String string) {
        currFile = string;
        LaplacePunktePanel.auslesen();
    }

    public static void eachLineFileOperations(String string) {
        LaplaceResultPanel.stringToFields(string);
    }

    static void laden() {
        FileOperations.load("lpc", self);
    }

    boolean hasMinDist(double d, double d2, double[] dArray, double[] dArray2, int n, double d3) {
        double d4 = d3 * d3;
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            double d5;
            double d6 = d - dArray[n3];
            double d7 = d2 - dArray2[n3];
            if (d6 * d6 + d7 * d7 < d4) {
                return false;
            }
            double d8 = dArray[n2] - dArray[n3];
            double d9 = dArray2[n2] - dArray2[n3];
            double d10 = d8 * d6 + d9 * d7;
            if (d10 > 0.0 && d10 < (d5 = d8 * d8 + d9 * d9) && Math.abs(-d9 * d6 + d8 * d7) < d3 * Math.sqrt(d5)) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    int mehrRandPunkte(double[] dArray, double[] dArray2, int n, double d) {
        int n2;
        double[] dArray3 = new double[n + 1];
        double[] dArray4 = new double[n + 1];
        for (n2 = 0; n2 < n; ++n2) {
            dArray3[n2] = dArray[n2];
            dArray4[n2] = dArray2[n2];
        }
        dArray3[n] = dArray3[0];
        dArray4[n] = dArray4[0];
        this.randpunktIndizes = new int[n + 1];
        this.randpunktIndizes[0] = 0;
        int n3 = 0;
        for (n2 = 1; n2 <= n; ++n2) {
            double d2 = dArray3[n2] - dArray3[n2 - 1];
            double d3 = dArray4[n2] - dArray4[n2 - 1];
            double d4 = Math.sqrt(d2 * d2 + d3 * d3);
            dArray[n3] = dArray3[n2 - 1];
            dArray2[n3] = dArray4[n2 - 1];
            ++n3;
            int n4 = 0;
            if (d4 > d) {
                int n5 = (int)(d4 / d + 0.5);
                d2 /= (double)n5;
                d3 /= (double)n5;
                while (--n5 > 0) {
                    dArray[n3] = dArray[n3 - 1] + d2;
                    dArray2[n3] = dArray2[n3 - 1] + d3;
                    ++n3;
                    ++n4;
                }
            }
            this.randpunktIndizes[n2] = this.randpunktIndizes[n2 - 1] + n4 + 1;
        }
        dArray[n3] = dArray3[0];
        dArray2[n3] = dArray4[0];
        return n3;
    }

    int toMcKee(int n) {
        return permfw != null ? permfw[n] : n;
    }

    void pointsAndTriangulation() {
        double d;
        int n;
        double[] dArray = new double[40];
        double[] dArray2 = new double[40];
        boolean[] blArray = LaplacePunktePanel.isNode;
        WPoint3d[] wPoint3dArray = LaplacePunktePanel.pp;
        int n2 = 2 * npsoll;
        if (n2 < 100) {
            n2 = 100;
        }
        x = new double[n2];
        y = new double[n2];
        LaplaceGrafikPanel.hilight = 0;
        LaplacePunktePanel.auslesen();
        LaplaceRandbdgPanel.auslesen();
        int n3 = 0;
        for (n = 0; n < 40; ++n) {
            if (!blArray[n]) continue;
            dArray[n3] = LaplaceResultPanel.x[n3] = wPoint3dArray[n].x;
            dArray2[n3] = LaplaceResultPanel.y[n3] = wPoint3dArray[n].y;
            if (n3 > 0 && x[n3] == x[n3 - 1] && y[n3] == y[n3 - 1]) continue;
            ++n3;
        }
        nrand = n3;
        double d2 = WPoint3d.flaeche(wPoint3dArray, n3);
        double d3 = VectorSet.vsMin(x, n3);
        double d4 = VectorSet.vsMax(x, n3);
        double d5 = VectorSet.vsMin(y, n3);
        double d6 = VectorSet.vsMax(y, n3);
        if (npsoll <= 1) {
            npsoll = 2;
        }
        double d7 = WPoint3d.umfang(wPoint3dArray, n3);
        double d8 = d = d7 * 0.25 / (double)npsoll + Math.sqrt(Math.pow(d7 * 0.5 / (double)npsoll, 2.0) + d2 / (double)npsoll);
        while ((double)n3 > d7 / d8 && npsoll > 2) {
            int n4 = (int)(2.0 * ((double)n3 - d7 / d8));
            if (n4 < 1) {
                n4 = 1;
            }
            if ((npsoll -= n4) <= 1) {
                npsoll = 2;
            }
            d8 = d = d7 * 0.25 / (double)npsoll + Math.sqrt(Math.pow(d7 * 0.5 / (double)npsoll, 2.0) + d2 / (double)npsoll);
        }
        double d9 = Math.sqrt(0.5 * Math.sqrt(3.0));
        n3 = this.mehrRandPunkte(x, y, n3, d8 *= d9);
        double d10 = 0.5 * d8;
        d3 += d8;
        d5 += (d /= d9);
        n = n3;
        int n5 = 0;
        while (d3 < d4) {
            d5 = n5++ % 2 == 0 ? (d5 -= 0.05 * d) : (d5 += 0.05 * d);
            for (double d11 = d5; d11 < d6; d11 += d) {
                if (!Delaunay.inArea(d3, d11, dArray, dArray2, nrand) || !this.hasMinDist(d3, d11, x, y, n3, d10)) continue;
                LaplaceResultPanel.x[n] = d3;
                LaplaceResultPanel.y[n] = d11;
                ++n;
            }
            d3 += d8;
        }
        np = n;
        tria = new Dreieck[np * 2];
        StopWatch.start(1);
        nt = new Delaunay().triangulate(x, y, np, n3, tria);
        this.errorMsg("");
        if (nt == 0) {
            this.txarea.setText("");
            return;
        }
        Smooth.smooth(x, y, np, n3, tria, nt);
        StopWatch.stop(1);
        int[] nArray = new int[np];
        int[][] nArray2 = new int[nt][3];
        for (n = 0; n < nt; ++n) {
            nArray2[n][0] = LaplaceResultPanel.tria[n].a;
            nArray2[n][1] = LaplaceResultPanel.tria[n].c;
            nArray2[n][2] = LaplaceResultPanel.tria[n].b;
        }
        StopWatch.start(2);
        this.mckee(x, y, null, nArray2, nArray, nt, n3);
        int n6 = Mckee.bandbreite(nArray2, nt);
        if (this.K == null || this.K.length != np || this.K[0].length != n6) {
            this.K = new double[np][n6];
        } else {
            VectorSet.vszero(this.K);
        }
        T = new double[np];
        this.systemMatrix(this.K, x, y, nArray2, nt);
        this.randbedingungen(this.K, T, n3);
        n = Gauss.solveBand(this.K, T, np, n6);
        StopWatch.stop(2);
        this.statusMsg(nt + " " + myLocale.getString("Elemente") + ", " + np + " " + myLocale.getString("Knoten") + ", " + myLocale.getString("Bandbreite") + ": " + n6 + ", " + myLocale.getString("ZeitFuerTriangulieren") + ": " + StopWatch.ms(1) + "ms, " + myLocale.getString("ZeitFuerLoesen") + ": " + StopWatch.ms(2) + "ms");
        this.backpermute(np, nArray, x, y, T, nArray2, nt);
        gradient = new double[np];
        gradx = new double[np];
        grady = new double[np];
        this.calculateGradient(x, y, T, nArray2, gradient, gradx, grady);
        temperatur = T;
        switch (showMode) {
            case 1: {
                T = gradient;
                break;
            }
            case 2: {
                T = gradx;
                break;
            }
            case 3: {
                T = grady;
            }
        }
        if (n < 0) {
            T = null;
        }
        this.showSolution();
        this.grafikPanel.repaint();
    }

    int elementMatrix3(double[][] dArray, double[] dArray2, double[] dArray3, int n, int n2, int n3) {
        double d = dArray2[n2] - dArray2[n];
        double d2 = dArray2[n] - dArray2[n3];
        double d3 = dArray2[n3] - dArray2[n2];
        double d4 = dArray3[n2] - dArray3[n];
        double d5 = dArray3[n] - dArray3[n3];
        double d6 = dArray3[n3] - dArray3[n2];
        double d7 = 0.5 / (-d * d5 + d2 * d4);
        if (d7 < 0.0) {
            return -1;
        }
        dArray[0][0] = (d3 * d3 + d6 * d6) * d7;
        dArray[1][1] = (d2 * d2 + d5 * d5) * d7;
        dArray[2][2] = (d * d + d4 * d4) * d7;
        double d8 = (d3 * d2 + d6 * d5) * d7;
        dArray[0][1] = d8;
        dArray[1][0] = d8;
        double d9 = (d3 * d + d6 * d4) * d7;
        dArray[0][2] = d9;
        dArray[2][0] = d9;
        double d10 = (d2 * d + d5 * d4) * d7;
        dArray[1][2] = d10;
        dArray[2][1] = d10;
        return 0;
    }

    void systemMatrix(double[][] dArray, double[] dArray2, double[] dArray3, int[][] nArray, int n) {
        double[][] dArray4 = new double[3][3];
        for (int i = 0; i < n; ++i) {
            int[] nArray2 = nArray[i];
            this.elementMatrix3(dArray4, dArray2, dArray3, nArray2[0], nArray2[1], nArray2[2]);
            for (int j = 0; j < 3; ++j) {
                int n2 = nArray2[j];
                for (int k = 0; k < 3; ++k) {
                    int n3 = nArray2[k] - n2;
                    if (n3 < 0) continue;
                    double[] dArray5 = dArray[n2];
                    int n4 = n3;
                    dArray5[n4] = dArray5[n4] + dArray4[j][k];
                }
            }
        }
    }

    void mittelungVorbereiten() {
        int n;
        for (n = 0; n < nrb; ++n) {
            LaplaceResultPanel.rand[n].m1 = false;
            LaplaceResultPanel.rand[n].m2 = false;
        }
        for (n = 0; n < nrb; ++n) {
            for (int i = 0; i < nrb; ++i) {
                if (LaplaceResultPanel.rand[n].mode != 1 || LaplaceResultPanel.rand[i].mode != 1 || LaplaceResultPanel.rand[n].n1 != LaplaceResultPanel.rand[i].n2 || n == i) continue;
                LaplaceResultPanel.rand[n].m1 = true;
                LaplaceResultPanel.rand[i].m2 = true;
                LaplaceResultPanel.rand[n].t1 = LaplaceResultPanel.rand[i].t2 = 0.5 * (LaplaceResultPanel.rand[n].t + LaplaceResultPanel.rand[i].t);
            }
        }
    }

    void randbedingungen(double[][] dArray, double[] dArray2, int n) {
        int n2;
        double d;
        double d2;
        int n3;
        int n4;
        int n5;
        int n6 = dArray[0].length;
        int n7 = dArray.length;
        for (n5 = 0; n5 < nrb; ++n5) {
            n4 = this.randpunktIndizes[LaplaceResultPanel.rand[n5].n2];
            n3 = this.randpunktIndizes[LaplaceResultPanel.rand[n5].n1];
            if (n4 < n3) {
                n4 += n;
            }
            d2 = LaplaceResultPanel.rand[n5].a;
            d = LaplaceResultPanel.rand[n5].t;
            for (n2 = n3; n2 < n4; ++n2) {
                if (LaplaceResultPanel.rand[n5].mode == 1) continue;
                int n8 = this.toMcKee(n2 % n);
                int n9 = this.toMcKee((n2 + 1) % n);
                double d3 = d2 * Math.sqrt(Math.pow(x[n9] - x[n8], 2.0) + Math.pow(y[n9] - y[n8], 2.0));
                if (LaplaceResultPanel.rand[n5].mode == 3) {
                    if (n8 > n9) {
                        int n10 = n8;
                        n8 = n9;
                        n9 = n10;
                    }
                    double[] dArray3 = dArray[n8];
                    dArray3[0] = dArray3[0] + d3 / 3.0;
                    double[] dArray4 = dArray[n9];
                    dArray4[0] = dArray4[0] + d3 / 3.0;
                    double[] dArray5 = dArray[n8];
                    int n11 = n9 - n8;
                    dArray5[n11] = dArray5[n11] + d3 / 6.0;
                    int n12 = n8;
                    dArray2[n12] = dArray2[n12] + 0.5 * d * d3;
                    int n13 = n9;
                    dArray2[n13] = dArray2[n13] + 0.5 * d * d3;
                    continue;
                }
                int n14 = n8;
                dArray2[n14] = dArray2[n14] + 0.5 * d3;
                int n15 = n9;
                dArray2[n15] = dArray2[n15] + 0.5 * d3;
            }
        }
        this.mittelungVorbereiten();
        for (n5 = 0; n5 < nrb; ++n5) {
            if (LaplaceResultPanel.rand[n5].mode != 1) continue;
            n4 = this.randpunktIndizes[LaplaceResultPanel.rand[n5].n2];
            n3 = this.randpunktIndizes[LaplaceResultPanel.rand[n5].n1];
            if (n4 < n3) {
                n4 += n;
            }
            d2 = LaplaceResultPanel.rand[n5].t;
            for (n2 = n3; n2 <= n4; ++n2) {
                int n16;
                d = d2;
                if (n2 == n3 && LaplaceResultPanel.rand[n5].m1) {
                    d = LaplaceResultPanel.rand[n5].t1;
                }
                if (n2 == n4 && LaplaceResultPanel.rand[n5].m2) {
                    d = LaplaceResultPanel.rand[n5].t2;
                }
                int n17 = this.toMcKee(n2 % n);
                if (d != 0.0) {
                    for (n16 = 1; n16 < n6 && n17 - n16 >= 0; ++n16) {
                        int n18 = n17 - n16;
                        dArray2[n18] = dArray2[n18] - dArray[n17 - n16][n16] * d;
                    }
                    for (n16 = 1; n16 < n6 && n17 + n16 < n7; ++n16) {
                        int n19 = n17 + n16;
                        dArray2[n19] = dArray2[n19] - dArray[n17][n16] * d;
                    }
                }
                for (n16 = 0; n16 < n6; ++n16) {
                    dArray[n17][n16] = 0.0;
                }
                for (n16 = 1; n16 < n6 && n17 - n16 >= 0; ++n16) {
                    dArray[n17 - n16][n16] = 0.0;
                }
                dArray[n17][0] = 1.0;
                dArray2[n17] = d;
            }
        }
    }

    static void permute(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3) {
        int n2;
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < n; ++n2) {
            nArray2[n2] = n2;
        }
        for (n2 = 0; n2 < n; ++n2) {
            while (nArray[n2] != n2) {
                int n3 = nArray[n2];
                double d = dArray2[n3];
                dArray2[n3] = dArray2[n2];
                dArray2[n2] = d;
                d = dArray[n3];
                dArray[n3] = dArray[n2];
                dArray[n2] = d;
                if (dArray3 != null) {
                    d = dArray3[n3];
                    dArray3[n3] = dArray3[n2];
                    dArray3[n2] = d;
                }
                int n4 = nArray2[n3];
                nArray2[n3] = nArray2[n2];
                nArray2[n2] = n4;
                nArray[n2] = nArray[n3];
                nArray[n3] = n3;
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            nArray[n2] = nArray2[n2];
        }
    }

    void backpermute(int n, int[] nArray, double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray2, int n2) {
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n3 = nArray2[i][j];
                if (n3 < 0) continue;
                nArray2[i][j] = nArray[n3];
            }
        }
        LaplaceResultPanel.permute(n, nArray, dArray, dArray2, dArray3);
    }

    void mckee(double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray, int[] nArray2, int n, int n2) {
        int n3;
        int n4 = 3;
        int n5 = Math.min(np, n2) / 16;
        if (n5 == 0) {
            n5 = 1;
        }
        Mckee.setdata(np, n, -n5, n4, nArray, null, nArray2, null);
        Mckee.findoptimum();
        permfw = new int[np];
        for (n3 = 0; n3 < np; ++n3) {
            LaplaceResultPanel.permfw[n3] = nArray2[n3];
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n4 = 0; n4 < 3; ++n4) {
                int n6 = nArray[n3][n4];
                if (n6 < 0) continue;
                nArray[n3][n4] = nArray2[n6];
            }
        }
        LaplaceResultPanel.permute(np, nArray2, dArray, dArray2, dArray3);
    }

    void calculateGradient(double[] dArray, double[] dArray2, double[] dArray3, int[][] nArray, double[] dArray4, double[] dArray5, double[] dArray6) {
        if (dArray4 == null) {
            return;
        }
        double[] dArray7 = new double[2];
        for (int i = 0; i < np; ++i) {
            Glatt.geglaetteterGradient(dArray, dArray2, dArray3, i, dArray7, nArray, nt);
            dArray5[i] = dArray7[0];
            dArray6[i] = dArray7[1];
            dArray4[i] = Math.sqrt(dArray7[0] * dArray7[0] + dArray7[1] * dArray7[1]);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.c1) {
            showElementGrid = this.c1.isSelected();
        } else if (itemEvent.getSource() == this.c2) {
            showNodeNumbers = this.c2.isSelected();
            LaplaceGrafikPanel.hilight = 0;
        } else if (itemEvent.getSource() == this.c3) {
            is3d = this.c3.isSelected();
        } else {
            if (this.c4.isSelected()) {
                showMode = 0;
                T = temperatur;
            } else if (this.c5.isSelected()) {
                showMode = 1;
                T = gradient;
            } else if (this.c6.isSelected()) {
                showMode = 2;
                T = gradx;
            } else if (this.c7.isSelected()) {
                showMode = 3;
                T = grady;
            }
            this.showSolution();
        }
        super.itemStateChanged(itemEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == cpMin || actionEvent.getSource() == cpMax) {
            Graph3d.limitMin = !cpMin.isEmpty() ? cpMin.getDouble() : 0.0;
            Graph3d.limitMax = !cpMax.isEmpty() ? cpMax.getDouble() : 0.0;
        } else if (actionEvent.getSource() == tf) {
            npsoll = tf.getInt();
        }
        if (npsoll > 2000) {
            npsoll = 2000;
            tf.setText("" + npsoll);
        }
        this.pointsAndTriangulation();
        super.actionPerformed(actionEvent);
    }

    static {
        currFile = null;
        tria = null;
        rand = new Rand[10];
        x = null;
        y = null;
        gradient = null;
        gradx = null;
        grady = null;
        showElementGrid = false;
        showNodeNumbers = false;
        showMode = 0;
        is3d = false;
        permfw = null;
    }
}

