/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;

class LaplaceGrafikPanel
extends Graph3d {
    static int hilight = 0;
    int mouseDraggIndex = -1;

    void drawAllTriangles() {
        int n = LaplaceResultPanel.nt;
        Dreieck[] dreieckArray = LaplaceResultPanel.tria;
        double[] dArray = LaplaceResultPanel.x;
        double[] dArray2 = LaplaceResultPanel.y;
        this.myg.setColor(Color.black);
        int n2 = n;
        while (--n2 >= 0) {
            Dreieck dreieck = dreieckArray[n2];
            this.drawtria(dArray[dreieck.a], dArray2[dreieck.a], dArray[dreieck.b], dArray2[dreieck.b], dArray[dreieck.c], dArray2[dreieck.c]);
        }
    }

    void allIsolines() {
        this.allIsolines(LaplaceResultPanel.T, LaplaceResultPanel.x, LaplaceResultPanel.y, LaplaceResultPanel.tria, LaplaceResultPanel.nt, LaplaceResultPanel.showElementGrid);
    }

    void d3display() {
        double[] dArray = LaplaceResultPanel.T;
        if (dArray == null) {
            return;
        }
        this.initLimit(dArray);
        Dreieck[] dreieckArray = LaplaceResultPanel.tria;
        this.setTransform((double)angleX * Math.PI / 180.0, (double)angleZ * Math.PI / 180.0);
        double[] dArray2 = LaplaceResultPanel.x;
        double[] dArray3 = LaplaceResultPanel.y;
        double d = VectorSet.vsMax(dArray2);
        double d2 = VectorSet.vsMin(dArray2);
        double d3 = VectorSet.vsMax(dArray3);
        double d4 = VectorSet.vsMin(dArray3);
        double d5 = VectorSet.vsMax(dArray) - VectorSet.vsMin(dArray);
        d -= d2;
        d3 -= d4;
        if (d3 > d) {
            d = d3;
        }
        double d6 = d5 > 1.0E-10 ? 0.7 * d / d5 : 1.0;
        dArray2 = new double[dArray2.length];
        dArray3 = new double[dArray3.length];
        VectorSet.vsscale(dArray2, LaplaceResultPanel.x, 1.0 / d6);
        VectorSet.vsscale(dArray3, LaplaceResultPanel.y, 1.0 / d6);
        this.w3setMinMax(dArray2, dArray3, dArray);
        this.myg.setColor(Color.black);
        this.drawGrid(dreieckArray, dArray2, dArray3, dArray, LaplaceResultPanel.nt);
        this.drawTriangles(dreieckArray, dArray2, dArray3, dArray, LaplaceResultPanel.nt, LaplaceResultPanel.showElementGrid);
    }

    @Override
    public void paint(Graphics graphics) {
        block22: {
            int n;
            boolean[] blArray;
            WPoint3d[] wPoint3dArray;
            boolean bl;
            block21: {
                int n2;
                int n3;
                int n4;
                Color color = LaplaceGrafikPanel.newColor(75, 75, 75);
                Color color2 = LaplaceGrafikPanel.newColor(110, 110, 110);
                Color color3 = LaplaceGrafikPanel.newColor(185, 185, 185);
                Color color4 = LaplaceGrafikPanel.newColor(145, 145, 145);
                Color color5 = LaplaceGrafikPanel.newColor(111, 125, 137);
                bl = LaplaceResultPanel.is3d;
                wPoint3dArray = LaplacePunktePanel.pp;
                blArray = LaplacePunktePanel.isNode;
                this.myg = graphics;
                int n5 = Math.abs(GR_W - this.getSize().width);
                if (n5 > 50) {
                    GR_W = this.getSize().width;
                }
                if (!bl || Laplace.currpan != 2) {
                    this.setTransform(0.0, 0.0);
                    if (this.mouseDraggIndex < 0) {
                        this.setMinMax(wPoint3dArray);
                    }
                }
                this.myg.setColor(color5);
                this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
                Polygon polygon = new Polygon();
                this.myg.setColor(color);
                int n6 = 0;
                int n7 = wPoint3dArray.length;
                while (--n7 >= 0) {
                    if (!blArray[n7]) continue;
                    if (Laplace.currpan != 2) {
                        polygon.addPoint(this.screenx(wPoint3dArray[n7]), this.screeny(wPoint3dArray[n7]));
                    }
                    ++n6;
                }
                LaplaceResultPanel.nrand = n6;
                if (Laplace.currpan != 2) {
                    ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                if (!bl || Laplace.currpan != 2) {
                    this.myg.setColor(color2);
                    this.myg.fillPolygon(polygon);
                    this.myg.setColor(color4);
                    this.grid();
                    this.myg.setColor(color3);
                    this.axes();
                    this.myg.setColor(color);
                    this.myg.drawPolygon(polygon);
                }
                if (Laplace.currpan == 1 || Laplace.currpan == 3) {
                    for (n = 0; n < LaplaceResultPanel.nrb; ++n) {
                        n4 = LaplaceResultPanel.rand[n].n1;
                        n3 = LaplaceResultPanel.rand[n].n2;
                        if (LaplaceResultPanel.rand[n].mode == 1) {
                            this.myg.setColor(Color.blue);
                        } else if (LaplaceResultPanel.rand[n].mode == 2) {
                            this.myg.setColor(Color.red);
                        } else {
                            this.myg.setColor(Color.magenta);
                        }
                        if (n3 < n4) {
                            n3 += n6;
                        }
                        for (n7 = n4; n7 < n3; ++n7) {
                            n2 = n7 % n6;
                            int n8 = (n7 + 1) % n6;
                            this.wMoveTo(wPoint3dArray[n2].x, wPoint3dArray[n2].y);
                            this.wLineTo2(wPoint3dArray[n8].x, wPoint3dArray[n8].y);
                        }
                    }
                }
                if (Laplace.currpan != 2 || bl) break block21;
                if (LaplaceResultPanel.T == null) {
                    this.drawAllTriangles();
                    return;
                }
                this.allIsolines();
                if (n6 > 0) {
                    this.showPallete();
                }
                if (!LaplaceResultPanel.showNodeNumbers && hilight <= 0) break block22;
                this.myg.setColor(Color.black);
                this.myg.setFont(new Font("MonoSpaced", 0, 11));
                for (n = 0; n < LaplaceResultPanel.np; ++n) {
                    n4 = this.screenx(LaplaceResultPanel.x[n]);
                    n3 = this.screeny(LaplaceResultPanel.y[n]);
                    if (n + 1 == hilight) continue;
                    this.myg.fillOval(n4 - 1, n3 - 1, 3, 3);
                    if (hilight != 0) continue;
                    this.myg.drawString("" + (n + 1), n4 + 2, n3 - 2);
                }
                if (hilight <= 0) break block22;
                this.myg.setFont(new Font("MonoSpaced", 1, 14));
                n = hilight - 1;
                String string = "(" + NumEdit.toPrecision(LaplaceResultPanel.T[n], 4) + ")";
                n3 = this.screenx(LaplaceResultPanel.x[n]);
                n2 = this.screeny(LaplaceResultPanel.y[n]);
                this.myg.fillOval(n3 - 2, n2 - 2, 4, 4);
                this.myg.drawString(n + 1 + string, n3 + 2, n2 - 2);
                break block22;
            }
            if (Laplace.currpan == 2 && bl) {
                this.d3display();
                this.showPallete();
            } else {
                this.myg.setColor(Color.yellow);
                n = wPoint3dArray.length;
                while (--n >= 0) {
                    if (!blArray[n]) continue;
                    this.myg.fillOval(this.screenx(wPoint3dArray[n]) - 2, this.screeny(wPoint3dArray[n]) - 2, 4, 4);
                    this.myg.drawString("" + (n + 1), this.screenx(wPoint3dArray[n]) + 2, this.screeny(wPoint3dArray[n]) - 2);
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        super.mousePressed(mouseEvent);
        int n = -1;
        int n2 = 1000;
        double[] dArray = LaplaceResultPanel.x;
        double[] dArray2 = LaplaceResultPanel.y;
        if (dArray == null) {
            return;
        }
        int n3 = mouseEvent.getX();
        int n4 = mouseEvent.getY();
        int n5 = LaplaceResultPanel.np;
        while (--n5 >= 0) {
            int n6 = this.screenx(dArray[n5]);
            int n7 = this.screeny(dArray2[n5]);
            int n8 = Math.abs(n6 - n3) + Math.abs(n7 - n4);
            if (n8 >= n2) continue;
            n2 = n8;
            n = n5;
        }
        if (n2 < 20) {
            hilight = n + 1;
            LaplaceResultPanel.self.mark(n);
        } else {
            LaplaceResultPanel.self.unmark();
            hilight = 0;
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        if (Laplace.currpan == 0) {
            boolean[] blArray = LaplacePunktePanel.isNode;
            WPoint3d[] wPoint3dArray = LaplacePunktePanel.pp;
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (this.mouseDraggIndex < 0) {
                int n3 = wPoint3dArray.length;
                while (--n3 >= 0) {
                    int n4;
                    if (!blArray[n3] || (n4 = Math.abs(this.screenx(wPoint3dArray[n3].x) - n) + Math.abs(this.screeny(wPoint3dArray[n3].y) - n2)) >= 10) continue;
                    this.mouseDraggIndex = n3;
                    break;
                }
            }
            if (this.mouseDraggIndex >= 0) {
                LaplacePunktePanel.tfx[this.mouseDraggIndex].setValue(this.worldx(n), 2);
                LaplacePunktePanel.tfy[this.mouseDraggIndex].setValue(this.worldy(n2), 2);
                LaplacePunktePanel.auslesen();
                this.repaint();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mouseDraggIndex >= 0) {
            this.mouseDraggIndex = -1;
            this.repaint();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        super.mouseClicked(mouseEvent);
        if (Laplace.currpan != 0) {
            return;
        }
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed()) {
            mouseEvent.consume();
            boolean[] blArray = LaplacePunktePanel.isNode;
            WPoint3d[] wPoint3dArray = LaplacePunktePanel.pp;
            for (int i = 0; i < wPoint3dArray.length; ++i) {
                if (blArray[i]) continue;
                wPoint3dArray[i].x = this.worldx(mouseEvent.getX());
                wPoint3dArray[i].y = this.worldy(mouseEvent.getY());
                LaplacePunktePanel.tfx[i].setValue(wPoint3dArray[i].x, 2);
                LaplacePunktePanel.tfy[i].setValue(wPoint3dArray[i].y, 2);
                blArray[i] = true;
                this.repaint();
                break;
            }
        }
    }

    LaplaceGrafikPanel() {
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addKeyListener(this);
        angleX = 290;
        angleZ = 340;
    }
}

