/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class KurbelViewPanel
extends GrPanel
implements Runnable {
    double phi1;
    Thread simuThread = null;
    boolean ok = false;
    static boolean isRunning = false;
    boolean properl = false;

    KurbelViewPanel() {
        this.addMouseMotionListener(this);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = KurbelViewPanel.newColor(185, 185, 185);
        Color color2 = KurbelViewPanel.newColor(145, 145, 145);
        Color color3 = KurbelViewPanel.newColor(80, 80, 150);
        double d = 0.0;
        double[] dArray = new double[4];
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[12];
        double[] dArray4 = new double[2];
        this.myg = graphics;
        int n = KurbelPanel.tfv.length;
        while (--n >= 0) {
            dArray3[n] = KurbelPanel.tfv[n].getDouble();
        }
        dArray[0] = dArray3[0] - dArray3[2];
        dArray[1] = dArray3[0] + dArray3[2];
        dArray[2] = dArray3[3] - dArray3[5];
        dArray[3] = dArray3[3] + dArray3[5];
        dArray2[0] = dArray3[1] - dArray3[2];
        dArray2[1] = dArray3[1] + dArray3[2];
        dArray2[2] = dArray3[4] - dArray3[5];
        dArray2[3] = dArray3[4] + dArray3[5];
        this.setMinMax(VectorSet.vsMin(dArray, 4), VectorSet.vsMin(dArray2, 4), VectorSet.vsMax(dArray, 4), VectorSet.vsMax(dArray2, 4));
        this.myg.setColor(KurbelViewPanel.newColor(111, 125, 137));
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.myg.setColor(color2);
        this.grid();
        this.myg.setColor(color);
        this.axes();
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.myg.setColor(KurbelViewPanel.newColor(188, 188, 188));
        int n2 = this.screenx(dArray3[2]) - this.screenx(0.0);
        int n3 = this.screenx(dArray3[5]) - this.screenx(0.0);
        this.myg.drawOval(this.screenx(dArray[0]), this.screeny(dArray2[1]), 2 * n2, 2 * n2);
        this.myg.drawOval(this.screenx(dArray[2]), this.screeny(dArray2[3]), 2 * n3, 2 * n3);
        this.myg.setColor(Color.red);
        if (!isRunning) {
            this.phi1 = dArray3[7] * Math.PI / 180.0;
        }
        double d2 = dArray3[0];
        double d3 = dArray3[1];
        double d4 = dArray3[2];
        double d5 = dArray3[3];
        double d6 = dArray3[4];
        double d7 = dArray3[5];
        double d8 = dArray3[6];
        double d9 = d2 + Math.cos(this.phi1) * d4;
        double d10 = d3 + Math.sin(this.phi1) * d4;
        this.wMoveTo(d2, d3);
        this.wLineTo3(d9, d10);
        this.myg.setColor(color3);
        double d11 = (d4 > d7 ? d4 : d7) * 10.0;
        double d12 = d2 + Math.cos(this.phi1) * d11;
        double d13 = d3 + Math.sin(this.phi1) * d11;
        this.wMoveTo(d9, d10);
        this.wLineTo(d12, d13);
        d12 = d2 - Math.cos(this.phi1) * d11;
        d13 = d3 - Math.sin(this.phi1) * d11;
        this.wMoveTo(d2, d3);
        this.wLineTo(d12, d13);
        double d14 = Math.sqrt((d5 - d9) * (d5 - d9) + (d6 - d10) * (d6 - d10));
        this.properl = false;
        if (d8 > 0.0) {
            double d15 = (d14 * d14 + d7 * d7 - d8 * d8) / (2.0 * d14 * d7);
            this.properl = d15 >= -1.0 && d15 <= 1.0;
            double d16 = Math.acos(d15);
            d = KurbelViewPanel.winkel(d9 - d5, d10 - d6);
            d += d16;
            this.ok = true;
        }
        if (!this.properl) {
            if (d8 > 0.0) {
                ((KurbelPanel)this.getParent()).errorMsg("Koppelgliedlaenge falsch!");
            }
            return;
        }
        ((KurbelPanel)this.getParent()).errorMsg("");
        this.myg.setColor(Color.red);
        double d17 = d5 + Math.cos(d) * d7;
        double d18 = d6 + Math.sin(d) * d7;
        this.wMoveTo(d5, d6);
        this.wLineTo3(d17, d18);
        this.myg.setColor(color3);
        d12 = d5 + Math.cos(d) * d11;
        d13 = d6 + Math.sin(d) * d11;
        this.wMoveTo(d17, d18);
        this.wLineTo(d12, d13);
        d12 = d5 - Math.cos(d) * d11;
        d13 = d6 - Math.sin(d) * d11;
        this.wMoveTo(d5, d6);
        this.wLineTo(d12, d13);
        this.myg.setColor(Color.green);
        this.wMoveTo(d9, d10);
        this.wLineTo3(d17, d18);
        if (CenterOfRotation.schnittpunkt(d2, d3, this.phi1, d5, d6, d, dArray4)) {
            this.myg.setColor(Color.green);
            this.fillCircle(dArray4[0], dArray4[1], 3);
        }
        this.myg.setColor(Color.yellow);
        this.fillCircle(d2, d3, 2);
        this.fillCircle(d5, d6, 2);
        this.fillCircle(d9, d10, 2);
        this.fillCircle(d17, d18, 2);
    }

    public boolean isOk() {
        return !isRunning && this.ok;
    }

    public void init() {
        this.simuThread = new Thread(this);
        this.simuThread.start();
    }

    @Override
    public void run() {
        isRunning = true;
        while (isRunning) {
            try {
                Thread.sleep(60L);
                this.phi1 += Math.PI / 180;
                KurbelPanel.setPhi(this.phi1);
                this.repaint();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        isRunning = false;
    }
}

