/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

class KinematicCurvesEingabePanel
extends DekorPanel
implements ActionListener,
ItemListener {
    String[] headings = new String[]{"", "t", "...."};
    String[] modeheading = new String[]{"x(t)", "v(t)", "a(t)"};
    JLabel[] hJLabels = new JLabel[this.headings.length];
    ButtonGroup cbg = new ButtonGroup();
    JRadioButton c2 = new JRadioButton("v(t) - " + myLocale.getString("Eingabe"), false);
    JRadioButton c3 = new JRadioButton("a(t) - " + myLocale.getString("Eingabe"), true);
    static int editMode = 2;
    static NumEdit[] tfx = new NumEdit[15];
    static NumEdit[] tfy = new NumEdit[tfx.length];
    static NumEdit[] tstart = new NumEdit[2];
    static JLabel[] lstart = new JLabel[]{new JLabel("x(t1)"), new JLabel("v(t1)"), new JLabel(" ")};
    static double v0;
    static double s0;
    static int VCNT;
    static double[] x;
    static double[] y;
    static double[] vx;
    static double[] vy;
    static double[] ax;
    static double[] ay;
    static int ns;
    static int nv;
    static int na;
    JComboBox<String> choiceExamples = new JComboBox();
    String[] example1 = new String[]{"0", "0", "2", "10", "3", "-20", "3.5", "0", "5", "0"};
    String[] example2 = new String[]{"0", "0", "1", "1", "2", "1", "3", "0", "5", "0"};
    String[] example3 = new String[]{"0", "0", "1", "-10", "2", "5", "6", "0", "9", "0"};
    String[] example4 = new String[]{"0", "(t-1)^2", ".5", "(t-1)^2", ".75", "(t-1)^2", "1", "(t-1)^2", "2", "0", "3", "-.333", "4", "0"};

    KinematicCurvesEingabePanel() {
        super(new KinematicCurvesDiagrammPanel(), 180);
        int n;
        this.cbg.add(this.c2);
        this.cbg.add(this.c3);
        this.c2.addItemListener(this);
        this.c3.addItemListener(this);
        this.fpAdd(this.choiceExamples, 0, 0, 3, 1);
        this.choiceExamples.addItemListener(this);
        this.choiceExamples.addItem("");
        this.choiceExamples.addItem(myLocale.getString("Beispiel") + " 1");
        this.choiceExamples.addItem(myLocale.getString("Beispiel") + " 2");
        this.choiceExamples.addItem(myLocale.getString("Beispiel") + " 3");
        this.choiceExamples.addItem(myLocale.getString("Beispiel") + " 4");
        JLabel jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 1, 3, 1);
        this.fpAdd(this.c2, 0, 2, 3, 1);
        this.fpAdd(this.c3, 0, 3, 3, 1);
        jLabel = new JLabel(" ");
        this.fpAdd(jLabel, 0, 4, 1, 1);
        for (n = 0; n < 3; ++n) {
            this.fpAdd(lstart[n], 0, 5 + n, 1, 1);
            if (n >= 2) continue;
            KinematicCurvesEingabePanel.tstart[n] = new NumEdit(5);
            this.fpAdd(tstart[n], 1, 5 + n, 1, 2);
            tstart[n].addActionListener(this);
        }
        ++this.gbc.gridy;
        for (n = 0; n < this.headings.length; ++n) {
            this.hJLabels[n] = jLabel = new JLabel(this.headings[n]);
            this.fpAdd(jLabel, n, this.gbc.gridy, 1, 1);
        }
        for (n = 0; n < tfx.length; ++n) {
            jLabel = new JLabel("" + (n + 1));
            KinematicCurvesEingabePanel.tfx[n] = new NumEdit(5);
            KinematicCurvesEingabePanel.tfy[n] = new NumEdit(5, false);
            ++this.gbc.gridy;
            this.fpAdd(jLabel, 0, this.gbc.gridy, 1, 1);
            this.fpAdd(tfx[n], 1, this.gbc.gridy, 1, 2);
            this.fpAdd(tfy[n], 2, this.gbc.gridy, 1, 2);
            tfx[n].addActionListener(this);
            tfy[n].addActionListener(this);
        }
        tfx[0].setText("0");
        tfy[tfy.length - 1].setName("last");
        ((KinematicCurvesDiagrammPanel)this.grafikPanel).setModeEx(editMode);
        this.hJLabels[2].setText(this.modeheading[editMode]);
        this.tabelleErstellen();
    }

    void tabelleErstellen() {
        double[] dArray;
        int n = 0;
        int n2 = tfx.length;
        if (editMode == 1) {
            dArray = vx;
            var6_4 = vy;
        } else {
            dArray = ax;
            var6_4 = ay;
        }
        for (int i = 0; i < n2; ++i) {
            if (!tfx[i].isEmpty()) {
                n = i + 1;
            }
            try {
                dArray[i] = tfx[i].getDouble();
                Ftree.setVar("t" + (i + 1), dArray[i]);
                Ftree.setVar("t", dArray[i]);
                String string = tfy[i].getText();
                var6_4[i] = Ftree.evaluate(string);
                continue;
            }
            catch (Exception exception) {
                this.errorMsg(myLocale.getString("FehlerhafteEingabedaten"));
            }
        }
        s0 = tstart[0].getDouble();
        v0 = tstart[1].getDouble();
        if (editMode == 1) {
            nv = n;
            KinematicCurvesEingabePanel.sausv(20);
            this.aausv();
        } else {
            na = n;
            KinematicCurvesEingabePanel.vausa(20);
            KinematicCurvesEingabePanel.sausv(2);
        }
    }

    static void vausa(int n) {
        nv = KinematicCurvesEingabePanel.integriere(ax, ay, vx, vy, v0, na, n);
    }

    static void sausv(int n) {
        ns = KinematicCurvesEingabePanel.integriere(vx, vy, x, y, s0, nv, n);
    }

    static int integriere(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double d, int n, int n2) {
        dArray3[0] = dArray[0];
        dArray4[0] = d;
        int n3 = 1;
        for (int i = 1; i < n; ++i) {
            double d2 = dArray[i] - dArray[i - 1];
            double d3 = dArray2[i] - dArray2[i - 1];
            d2 /= (double)n2;
            d3 /= (double)n2;
            double d4 = dArray2[i - 1];
            for (int j = 0; j < n2; ++j) {
                dArray3[n3] = dArray3[n3 - 1] + d2;
                dArray4[n3] = dArray4[n3 - 1] + (d4 + 0.5 * d3) * d2;
                d4 += d3;
                ++n3;
            }
        }
        return n3;
    }

    static int differenziere(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n) {
        int n2 = 0;
        for (int i = 1; i < n; ++i) {
            double d = dArray[i] - dArray[i - 1];
            if (Math.abs(d) < 1.0E-6) continue;
            double d2 = (dArray2[i] - dArray2[i - 1]) / d;
            dArray3[n2] = dArray[i - 1];
            dArray4[n2] = d2;
            dArray3[++n2] = dArray[i];
            dArray4[n2] = d2;
            ++n2;
        }
        return n2;
    }

    void aausv() {
        na = KinematicCurvesEingabePanel.differenziere(vx, vy, ax, ay, nv);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.statusMsg("");
        this.choiceExamples.setSelectedIndex(0);
        this.tabelleErstellen();
        this.grafikPanel.fit();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.choiceExamples) {
            String[] stringArray;
            int n = this.choiceExamples.getSelectedIndex();
            switch (n) {
                case 1: {
                    stringArray = this.example1;
                    break;
                }
                case 2: {
                    stringArray = this.example2;
                    break;
                }
                case 3: {
                    stringArray = this.example3;
                    break;
                }
                case 4: {
                    stringArray = this.example4;
                    break;
                }
                default: {
                    Object var3_4 = null;
                    return;
                }
            }
            int n2 = 0;
            while (2 * n2 + 1 < stringArray.length) {
                tfx[n2].setText(stringArray[2 * n2]);
                tfy[n2].setText(stringArray[2 * n2 + 1]);
                ++n2;
            }
            while (n2 < tfx.length) {
                tfx[n2].setText("");
                tfy[n2].setText("");
                ++n2;
            }
            KinematicCurvesSimulationViewPanel.currS = 0.0;
        } else if (itemEvent.getSource() == this.c3) {
            editMode = 2;
        } else if (itemEvent.getSource() == this.c2) {
            editMode = 1;
        }
        this.hJLabels[2].setText(this.modeheading[editMode]);
        KinematicCurves.setPanMode(editMode);
        ((KinematicCurvesDiagrammPanel)this.grafikPanel).setModeEx(editMode);
        this.validate();
        this.tabelleErstellen();
        this.grafikPanel.fit();
    }

    static {
        VCNT = 300;
        x = new double[2 * VCNT];
        y = new double[2 * VCNT];
        vx = new double[VCNT];
        vy = new double[VCNT];
        ax = new double[VCNT];
        ay = new double[VCNT];
    }
}

