/*
 * Decompiled with CFR 0.152.
 */
class Jacobi {
    Jacobi() {
    }

    static void solve(int n, double[][] dArray, double[] dArray2, double[][] dArray3) {
        Jacobi.solve(n, dArray, dArray2, dArray3, false);
    }

    static void solve(int n, double[][] dArray, double[] dArray2, double[][] dArray3, boolean bl) {
        int n2;
        double[] dArray4;
        int n3;
        int n4 = n - 1;
        double d = 0.0;
        for (n3 = n4; n3 >= 0; --n3) {
            dArray4 = dArray3[n3];
            for (n2 = n4; n2 >= 0; --n2) {
                dArray4[n2] = 0.0;
            }
            dArray4[n3] = 1.0;
        }
        for (n3 = n4; n3 >= 0; --n3) {
            dArray4 = dArray[n3];
            for (n2 = n3; n2 >= 0; --n2) {
                if (!(Math.abs(dArray4[n2]) > d)) continue;
                d = Math.abs(dArray4[n2]);
            }
        }
        if (d == 0.0) {
            if (dArray2 != null) {
                for (n3 = n4; n3 >= 0; --n3) {
                    dArray2[n3] = 0.0;
                }
            }
            return;
        }
        double d2 = (double)n * d * 1.0E-16;
        block5: while (true) {
            double d3 = 0.0;
            for (n3 = 1; n3 <= n4; ++n3) {
                dArray4 = dArray[n3];
                for (n2 = 0; n2 < n3; ++n2) {
                    if (Math.abs(dArray4[n2]) <= d2) {
                        dArray4[n2] = 0.0;
                        continue;
                    }
                    d3 += dArray4[n2] * dArray4[n2];
                }
            }
            if (2.0 * d3 <= d2 * d2) break;
            int n5 = 1;
            while (true) {
                if (n5 > n4) continue block5;
                for (int i = 0; i <= n4 - n5; ++i) {
                    double d4;
                    int n6 = n5 + i;
                    double[] dArray5 = dArray[i];
                    double[] dArray6 = dArray[n6];
                    if (!(Math.abs(dArray6[i]) > d2)) continue;
                    double d5 = 0.5 * (dArray6[n6] - dArray5[i]) / dArray6[i];
                    if (Math.abs(d5) < 1.0E-8) {
                        d4 = 1.0;
                    } else {
                        d4 = 1.0 / (Math.abs(d5) + Math.sqrt(1.0 + d5 * d5));
                        if (d5 < 0.0) {
                            d4 = -d4;
                        }
                    }
                    double d6 = 1.0 / Math.sqrt(1.0 + d4 * d4);
                    double d7 = d6 * d4;
                    double d8 = dArray6[i] * d4;
                    int n7 = i;
                    dArray5[n7] = dArray5[n7] - d8;
                    int n8 = n6;
                    dArray6[n8] = dArray6[n8] + d8;
                    dArray6[i] = 0.0;
                    n2 = i;
                    while (--n2 >= 0) {
                        d8 = d6 * dArray5[n2] - d7 * dArray6[n2];
                        dArray6[n2] = d7 * dArray5[n2] + d6 * dArray6[n2];
                        dArray5[n2] = d8;
                    }
                    for (n2 = i + 1; n2 < n6; ++n2) {
                        dArray4 = dArray[n2];
                        d8 = d6 * dArray4[i] - d7 * dArray6[n2];
                        dArray6[n2] = d7 * dArray4[i] + d6 * dArray6[n2];
                        dArray4[i] = d8;
                    }
                    if (n6 - i - 1 >= 0) {
                        for (n2 = n6 + 1; n2 <= n4; ++n2) {
                            dArray4 = dArray[n2];
                            d8 = d6 * dArray4[i] - d7 * dArray4[n6];
                            dArray4[n6] = d7 * dArray4[i] + d6 * dArray4[n6];
                            dArray4[i] = d8;
                        }
                    }
                    for (n2 = n4; n2 >= 0; --n2) {
                        dArray4 = dArray3[n2];
                        d8 = d6 * dArray4[i] - d7 * dArray4[n6];
                        dArray4[n6] = d7 * dArray4[i] + d6 * dArray4[n6];
                        dArray4[i] = d8;
                    }
                }
                ++n5;
            }
            break;
        }
        if (dArray2 == null) {
            dArray2 = new double[n];
        }
        for (n3 = n4; n3 >= 0; --n3) {
            dArray2[n3] = dArray[n3][n3];
        }
        Jacobi.sort(dArray2, dArray3, bl, n, n);
        for (n3 = n4; n3 >= 0; --n3) {
            dArray[n3][n3] = dArray2[n3];
        }
    }

    static void sort(double[] dArray, double[][] dArray2, boolean bl, int n, int n2) {
        int n3;
        double d;
        int n4;
        double[] dArray3 = new double[n2];
        int[] nArray = new int[n];
        for (n4 = 0; n4 < n; ++n4) {
            nArray[n4] = n4;
        }
        if (bl) {
            for (var11_8 = n / 2; var11_8 > 0; var11_8 /= 2) {
                for (n4 = var11_8; n4 < n; ++n4) {
                    d = dArray[n4];
                    n3 = nArray[n4];
                    var7_10 = n4;
                    while (var7_10 >= var11_8 && !(d >= dArray[var12_12 = var7_10 - var11_8])) {
                        nArray[var7_10] = nArray[var12_12];
                        dArray[var7_10] = dArray[var12_12];
                        var7_10 = var12_12;
                    }
                    if (n4 == var7_10) continue;
                    dArray[var7_10] = d;
                    nArray[var7_10] = n3;
                }
            }
        } else {
            for (var11_8 = n / 2; var11_8 > 0; var11_8 /= 2) {
                for (n4 = var11_8; n4 < n; ++n4) {
                    d = dArray[n4];
                    n3 = nArray[n4];
                    var7_10 = n4;
                    while (var7_10 >= var11_8 && !(d <= dArray[var12_12 = var7_10 - var11_8])) {
                        nArray[var7_10] = nArray[var12_12];
                        dArray[var7_10] = dArray[var12_12];
                        var7_10 = var12_12;
                    }
                    if (n4 == var7_10) continue;
                    dArray[var7_10] = d;
                    nArray[var7_10] = n3;
                }
            }
        }
        int[] nArray2 = new int[n];
        n4 = 0;
        while (n4 < n) {
            n3 = nArray[n4];
            nArray2[n3] = n4++;
        }
        for (n4 = 0; n4 < n; ++n4) {
            while (nArray2[n4] != n4) {
                n3 = nArray2[n4];
                int n5 = n2;
                while (--n5 >= 0) {
                    d = dArray2[n5][n4];
                    dArray2[n5][n4] = dArray2[n5][n3];
                    dArray2[n5][n3] = d;
                }
                nArray2[n4] = nArray2[n3];
                nArray2[n3] = n3;
            }
        }
    }

    static void scaleBack(int n, double[] dArray, double[] dArray2, double[] dArray3, double[][] dArray4) {
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            dArray3[n2] = dArray3[n2] / dArray2[0];
            for (int j = 0; j < n; ++j) {
                double[] dArray5 = dArray4[j];
                int n3 = i;
                dArray5[n3] = dArray5[n3] * dArray[j];
            }
        }
    }

    static int scaleBefore(double[][] dArray, double[][] dArray2, int n, double[] dArray3, double[] dArray4) {
        int n2;
        double[] dArray5;
        double[] dArray6;
        int n3;
        for (n3 = 0; n3 < n; ++n3) {
            dArray6 = dArray2[n3];
            if (dArray6[n3] <= 0.0) {
                for (int i = 0; i < n; ++i) {
                    dArray3[i] = 1.0;
                }
                return -1;
            }
            dArray3[n3] = 1.0 / Math.sqrt(dArray6[n3]);
        }
        for (n3 = 0; n3 < n; ++n3) {
            dArray5 = dArray[n3];
            dArray6 = dArray2[n3];
            n2 = 0;
            while (n2 <= n3) {
                double d = dArray3[n3] * dArray3[n2];
                int n4 = n2;
                dArray5[n4] = dArray5[n4] * d;
                int n5 = n2++;
                dArray6[n5] = dArray6[n5] * d;
            }
        }
        dArray4[0] = 0.0;
        for (n3 = 0; n3 < n; ++n3) {
            if (!(Math.abs(dArray[n3][n3]) > dArray4[0])) continue;
            dArray4[0] = Math.abs(dArray[n3][n3]);
        }
        if (dArray4[0] == 0.0) {
            dArray4[0] = 1.0;
            return -2;
        }
        dArray4[0] = 1.0 / dArray4[0];
        for (n3 = 0; n3 < n; ++n3) {
            dArray5 = dArray[n3];
            n2 = 0;
            while (n2 <= n3) {
                int n6 = n2++;
                dArray5[n6] = dArray5[n6] * dArray4[0];
            }
        }
        return 0;
    }

    static int cholesky(double[][] dArray, double[][] dArray2, int n) {
        double d;
        int n2;
        double[] dArray3;
        int n3;
        int n4;
        for (n4 = 0; n4 < n; ++n4) {
            int n5;
            double[] dArray4 = dArray2[n4];
            if (dArray4[n4] <= 0.0) {
                return -1;
            }
            dArray4[n4] = Math.sqrt(dArray4[n4]);
            for (n3 = n5 = n4 + 1; n3 < n; ++n3) {
                dArray3 = dArray2[n3];
                int n6 = n4;
                dArray3[n6] = dArray3[n6] / dArray4[n4];
                for (n2 = n5; n2 <= n3; ++n2) {
                    int n7 = n2;
                    dArray3[n7] = dArray3[n7] - dArray3[n4] * dArray2[n2][n4];
                }
            }
        }
        for (n2 = 0; n2 < n; ++n2) {
            for (n3 = n2; n3 < n; ++n3) {
                double[] dArray5 = dArray[n3];
                d = dArray5[n2];
                double[] dArray6 = dArray2[n2];
                for (n4 = 0; n4 < n2; ++n4) {
                    d -= dArray5[n4] * dArray6[n4];
                }
                dArray5[n2] = d / dArray6[n2];
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = 0; n2 <= n3; ++n2) {
                d = dArray[n3][n2];
                double[] dArray7 = dArray[n2];
                dArray3 = dArray2[n3];
                for (n4 = 0; n4 < n3; ++n4) {
                    if (n4 < n2) {
                        d -= dArray3[n4] * dArray7[n4];
                        continue;
                    }
                    d -= dArray3[n4] * dArray[n4][n2];
                }
                dArray[n3][n2] = d / dArray3[n3];
            }
        }
        return 0;
    }

    static void eigenVektorenRuecktrans(double[][] dArray, double[][] dArray2, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = n - 1; j >= 0; --j) {
                double d = dArray[j][i];
                for (int k = j + 1; k < n; ++k) {
                    d -= dArray2[k][j] * dArray[k][i];
                }
                dArray[j][i] = d / dArray2[j][j];
            }
        }
    }

    static int allgEWP(double[][] dArray, double[][] dArray2, double[] dArray3, double[][] dArray4) {
        return Jacobi.allgEWP(dArray, dArray2, dArray3, dArray4, dArray3.length);
    }

    static int allgEWP(double[][] dArray, double[][] dArray2, double[] dArray3, double[][] dArray4, int n) {
        double[] dArray5 = new double[n];
        double[] dArray6 = new double[]{0.0};
        int n2 = Jacobi.scaleBefore(dArray, dArray2, n, dArray5, dArray6);
        if (n2 == -1) {
            return -2;
        }
        n2 = Jacobi.cholesky(dArray, dArray2, n);
        if (n2 != 0) {
            return -1;
        }
        Jacobi.solve(n, dArray, dArray3, dArray4);
        Jacobi.eigenVektorenRuecktrans(dArray4, dArray2, n);
        Jacobi.scaleBack(n, dArray5, dArray6, dArray3, dArray4);
        for (int i = 0; i < n; ++i) {
            int n3;
            double d = 0.0;
            for (n3 = 0; n3 < n; ++n3) {
                d += dArray4[n3][i] * dArray4[n3][i];
            }
            if (d == 0.0) continue;
            d = 1.0 / Math.sqrt(d);
            for (n3 = 0; n3 < n; ++n3) {
                double[] dArray7 = dArray4[n3];
                int n4 = i;
                dArray7[n4] = dArray7[n4] * d;
            }
        }
        return 0;
    }
}

