/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;

class HistoryEdit
extends NumEdit {
    int MAX = 16;
    String[] history = new String[this.MAX];
    int currpos = 0;
    ActionListener parent;

    HistoryEdit(int n, ActionListener actionListener) {
        super(n);
        this.parent = actionListener;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                int n = this.currpos + 1;
                if (n >= this.MAX) {
                    --n;
                }
                if (this.history[n] == null) break;
                this.currpos = n;
                this.setText(this.history[this.currpos]);
                this.parent.actionPerformed(null);
                break;
            }
            case 40: {
                int n = this.currpos - 1;
                if (n < 0) {
                    super.keyPressed(keyEvent);
                    break;
                }
                if (this.history[n] == null) break;
                this.currpos = n;
                this.setText(this.history[this.currpos]);
                this.parent.actionPerformed(null);
                break;
            }
            case 10: {
                this.pushHistory(this.getText());
                this.currpos = 0;
            }
        }
    }

    void pushHistory(String string) {
        int n;
        int n2 = this.MAX - 1;
        if (string.length() == 0) {
            return;
        }
        for (n = n2; n >= 1; --n) {
            if (this.history[n] == null || !string.equals(this.history[n])) continue;
            n2 = n;
            break;
        }
        for (n = n2; n >= 1; --n) {
            this.history[n] = this.history[n - 1];
        }
        this.history[0] = string;
    }
}

