/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;

class Graph3d
extends GrPanel {
    Color[] palette = new Color[17];
    double[] limit = new double[this.palette.length + 1];
    int[] pTriaX = new int[3];
    int[] pTriaY = new int[3];
    static double limitMin = 0.0;
    static double limitMax = 0.0;
    WPoint3d[] ph = new WPoint3d[]{new WPoint3d(), new WPoint3d(), new WPoint3d(), new WPoint3d(), new WPoint3d()};
    int[] xh = new int[5];
    int[] yh = new int[5];
    static WPoint3d[] posi = new WPoint3d[84];
    double[] savePosiZ = new double[posi.length];

    Graph3d() {
    }

    void initPalette(Color[] colorArray) {
        int n = this.palette.length;
        double d = ((double)n - 1.0) / (double)(colorArray.length - 1);
        int n2 = 0;
        for (int i = 0; i < colorArray.length - 1; ++i) {
            int n3 = (int)((double)(i + 1) * d) - n2;
            Color color = colorArray[i];
            Color color2 = colorArray[i + 1];
            this.palette[n2] = color;
            double d2 = color.getRed();
            double d3 = color.getGreen();
            double d4 = color.getBlue();
            double d5 = ((double)color2.getRed() - d2) / (double)n3;
            double d6 = ((double)color2.getGreen() - d3) / (double)n3;
            double d7 = ((double)color2.getBlue() - d4) / (double)n3;
            for (int j = 1; j < n3; ++j) {
                this.palette[n2 + j] = new Color((int)(d2 += d5), (int)(d3 += d6), (int)(d4 += d7));
            }
            n2 += n3;
        }
        this.palette[n - 1] = colorArray[colorArray.length - 1];
    }

    final void setupPolyforTria(double d, double d2, double d3, double d4, double d5, double d6) {
        this.pTriaX[0] = this.screenx(d);
        this.pTriaX[1] = this.screenx(d3);
        this.pTriaX[2] = this.screenx(d5);
        this.pTriaY[0] = this.screeny(d2);
        this.pTriaY[1] = this.screeny(d4);
        this.pTriaY[2] = this.screeny(d6);
    }

    final void drawtria(double d, double d2, double d3, double d4, double d5, double d6) {
        this.setupPolyforTria(d, d2, d3, d4, d5, d6);
        this.myg.drawPolygon(this.pTriaX, this.pTriaY, 3);
    }

    final void drawtria(double d, double d2, double d3, double d4, double d5, double d6, Color color) {
        this.setupPolyforTria(d, d2, d3, d4, d5, d6);
        this.myg.setColor(color);
        this.myg.fillPolygon(this.pTriaX, this.pTriaY, 3);
    }

    final void drawtria(double d, double d2, double d3, double d4, double d5, double d6, Color color, Color color2) {
        this.setupPolyforTria(d, d2, d3, d4, d5, d6);
        this.myg.setColor(color);
        this.myg.fillPolygon(this.pTriaX, this.pTriaY, 3);
        if (color2 != color) {
            this.myg.setColor(color2);
            this.myg.drawPolygon(this.pTriaX, this.pTriaY, 3);
        }
    }

    void showPallete() {
        double d;
        int n;
        int n2 = this.limit.length - 1;
        double d2 = this.limit[n2];
        double d3 = (this.limit[n2] - this.limit[0]) / (double)n2;
        this.myg.setColor(Color.black);
        for (n = 0; n <= n2; ++n) {
            d = d2 - (double)n * d3;
            if (Math.abs(d) < 1.0E-5) {
                d = 0.0;
            }
            Object object = NumEdit.toPrecision(d, 3);
            if (d >= 0.0) {
                object = " " + (String)object;
            }
            this.myg.drawString((String)object, 12, 25 + n * 10);
        }
        d2 += 0.4 * d3;
        for (n = 0; n < n2; ++n) {
            d = d2 - (double)(n + 1) * d3;
            this.myg.setColor(this.getColor(d));
            this.myg.fillRect(5, 20 + n * 10, 5, 10);
        }
    }

    void initLimit(double[] dArray) {
        double d;
        double d2;
        double d3;
        if (this.palette[0] == null) {
            this.initPalette(new Color[]{new Color(100, 0, 155), Color.BLUE, new Color(0, 145, 255), Color.GREEN, new Color(255, 205, 0), Color.RED, new Color(155, 0, 0)});
        }
        if (limitMax == limitMin) {
            d3 = VectorSet.vsMax(dArray);
            d2 = VectorSet.vsMin(dArray);
        } else {
            d3 = limitMax;
            d2 = limitMin;
        }
        double d4 = d = Math.abs(d3) > Math.abs(d2) ? Math.abs(d3) : Math.abs(d2);
        if (d < 1.0E-9 || (d3 - d2) / d < 1.0E-7) {
            int n = this.limit.length;
            while (--n >= 0) {
                this.limit[n] = d2;
            }
        } else {
            double d5 = 1.00000011 * (d3 - d2) / (double)(this.limit.length - 1);
            d2 -= 6.8E-8 * (d3 - d2);
            int n = this.limit.length;
            while (--n >= 0) {
                this.limit[n] = d2 + d5 * (double)n;
            }
        }
    }

    int getColorIndex(double d) {
        double d2 = this.limit[1] - this.limit[0];
        return d2 > 0.0 ? (int)((d - this.limit[0]) / d2 + 1.0E-9) : 0;
    }

    Color getColor(double d) {
        int n = this.getColorIndex(d);
        if (n < 0) {
            n = 0;
        } else if (n >= this.palette.length) {
            n = this.palette.length - 1;
        }
        return this.palette[n];
    }

    void qsortZ(WPoint3d[] wPoint3dArray, int n, int n2) {
        if (n2 > n) {
            if (n2 - n == 1) {
                if (wPoint3dArray[n].z > wPoint3dArray[n2].z) {
                    WPoint3d wPoint3d = wPoint3dArray[n2];
                    wPoint3dArray[n2] = wPoint3dArray[n];
                    wPoint3dArray[n] = wPoint3d;
                }
                return;
            }
            WPoint3d wPoint3d = wPoint3dArray[n2 + n >> 1];
            int n3 = n;
            int n4 = n2;
            while (true) {
                if (wPoint3dArray[n3].z < wPoint3d.z) {
                    ++n3;
                    continue;
                }
                while (wPoint3dArray[n4].z > wPoint3d.z) {
                    --n4;
                }
                if (n3 > n4) break;
                WPoint3d wPoint3d2 = wPoint3dArray[n3];
                wPoint3dArray[n3++] = wPoint3dArray[n4];
                wPoint3dArray[n4--] = wPoint3d2;
                if (n3 > n4) break;
            }
            this.qsortZ(wPoint3dArray, n, n4);
            this.qsortZ(wPoint3dArray, n3, n2);
        }
    }

    int scanLine(WPoint3d wPoint3d, WPoint3d wPoint3d2, double[] dArray, int n, WPoint3d[] wPoint3dArray) {
        double d;
        WPoint3d wPoint3d3;
        int n2 = dArray.length;
        if (wPoint3d2.z < wPoint3d.z) {
            wPoint3d3 = wPoint3d2;
            wPoint3d2 = wPoint3d;
            wPoint3d = wPoint3d3;
        }
        if ((d = wPoint3d2.z - wPoint3d.z) < 1.0E-8) {
            return n;
        }
        double d2 = (wPoint3d2.x - wPoint3d.x) / d;
        double d3 = (wPoint3d2.y - wPoint3d.y) / d;
        int n3 = this.getColorIndex(wPoint3d.z);
        int n4 = this.getColorIndex(wPoint3d2.z) + 1;
        if (limitMin != limitMax && wPoint3d.z < limitMin) {
            if (wPoint3d2.z < limitMin) {
                return n;
            }
            double d4 = wPoint3d2.z;
            n3 = n2;
            while (--n3 >= 0) {
                if (!(d4 >= dArray[n3])) continue;
                wPoint3dArray[n++] = wPoint3d3 = WPoint3d.getFromPool();
                wPoint3d3.z = dArray[n3];
                double d5 = dArray[n3] - d4;
                wPoint3d3.x = wPoint3d2.x + d5 * d2;
                wPoint3d3.y = wPoint3d2.y + d5 * d3;
            }
            return n;
        }
        if (n4 < n2) {
            n2 = n4;
        }
        double d6 = wPoint3d.z;
        while (n3 < n2) {
            if (d6 <= dArray[n3]) {
                wPoint3dArray[n++] = wPoint3d3 = WPoint3d.getFromPool();
                wPoint3d3.z = dArray[n3];
                double d7 = dArray[n3] - d6;
                wPoint3d3.x = wPoint3d.x + d7 * d2;
                wPoint3d3.y = wPoint3d.y + d7 * d3;
            }
            ++n3;
        }
        return n;
    }

    void sortPoints(WPoint3d[] wPoint3dArray, int n) {
        double d = wPoint3dArray[0].x;
        double d2 = wPoint3dArray[0].y;
        int n2 = n;
        while (--n2 >= 1) {
            d += wPoint3dArray[n2].x;
            d2 += wPoint3dArray[n2].y;
        }
        d /= (double)n;
        d2 /= (double)n;
        n2 = n;
        while (--n2 >= 0) {
            wPoint3dArray[n2].z = Delaunay.angle1(wPoint3dArray[n2].x - d, wPoint3dArray[n2].y - d2);
        }
        this.qsortZ(wPoint3dArray, 0, n - 1);
    }

    void fillArea(WPoint3d[] wPoint3dArray, int n, int n2) {
        int n3 = n2;
        while (--n3 >= 0) {
            this.ph[n3].x = wPoint3dArray[n].x;
            this.ph[n3].y = wPoint3dArray[n].y;
            ++n;
        }
        if (n2 > 3) {
            this.sortPoints(this.ph, n2);
        }
        n3 = n2;
        while (--n3 >= 0) {
            this.xh[n3] = this.screenx(this.ph[n3].x);
            this.yh[n3] = this.screeny(this.ph[n3].y);
        }
        this.myg.fillPolygon(this.xh, this.yh, n2);
    }

    void w3setMinMax(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray3.length;
        WPoint3d wPoint3d = new WPoint3d();
        wPoint3d.x = dArray[0];
        wPoint3d.y = dArray2[0];
        wPoint3d.z = dArray3[0];
        this.transform2(wPoint3d);
        double d = wPoint3d.x;
        double d2 = wPoint3d.y;
        double d3 = wPoint3d.x;
        double d4 = wPoint3d.y;
        int n2 = n;
        while (--n2 >= 1) {
            wPoint3d.x = dArray[n2];
            wPoint3d.y = dArray2[n2];
            wPoint3d.z = dArray3[n2];
            this.transform2(wPoint3d);
            if (wPoint3d.x > d3) {
                d3 = wPoint3d.x;
            } else if (wPoint3d.x < d) {
                d = wPoint3d.x;
            }
            if (wPoint3d.y < d2) {
                d2 = wPoint3d.y;
                continue;
            }
            if (!(wPoint3d.y > d4)) continue;
            d4 = wPoint3d.y;
        }
        double d5 = 0.012 * (d3 - d);
        double d6 = 0.012 * (d4 - d2);
        this.setMinMax(d - d5, d2 - d6, d3 + d5, d4 + d6);
    }

    void dreieckeOrdnen(Dreieck[] dreieckArray, double[] dArray, double[] dArray2, double[] dArray3, int n) {
        Dreieck dreieck;
        int n2;
        double[] dArray4 = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            dreieck = dreieckArray[n2];
            double d = this.transform3(dArray[dreieck.a], dArray2[dreieck.a], dArray3[dreieck.a]);
            double d2 = this.transform3(dArray[dreieck.b], dArray2[dreieck.b], dArray3[dreieck.b]);
            double d3 = this.transform3(dArray[dreieck.c], dArray2[dreieck.c], dArray3[dreieck.c]);
            dArray4[n2] = d + d2 + d3;
        }
        int[] nArray = new int[]{11969, 4711, 1968, 815, 271, 111, 41, 13, 4, 1};
        for (int i = 0; i < nArray.length; ++i) {
            int n3;
            for (n2 = n3 = nArray[i]; n2 < n; ++n2) {
                int n4;
                double d = dArray4[n2];
                dreieck = dreieckArray[n2];
                int n5 = n2;
                while (n5 >= n3 && !(d >= dArray4[n4 = n5 - n3])) {
                    dArray4[n5] = dArray4[n4];
                    dreieckArray[n5] = dreieckArray[n4];
                    n5 = n4;
                }
                dArray4[n5] = d;
                dreieckArray[n5] = dreieck;
            }
        }
    }

    void drawGrid(Dreieck[] dreieckArray, double[] dArray, double[] dArray2, double[] dArray3, int n) {
        WPoint3d wPoint3d = WPoint3d.getFromPool();
        WPoint3d wPoint3d2 = WPoint3d.getFromPool();
        WPoint3d wPoint3d3 = WPoint3d.getFromPool();
        double[] dArray4 = new double[2];
        VectorSet.vsMinMax(dArray3, dArray3.length, dArray4);
        double d = dArray4[0];
        double d2 = dArray4[1];
        wPoint3d3.z = d2 != d ? d : 0.0;
        wPoint3d2.z = wPoint3d3.z;
        wPoint3d.z = wPoint3d3.z;
        for (int i = 0; i < n; ++i) {
            Dreieck dreieck = dreieckArray[i];
            wPoint3d.x = dArray[dreieck.a];
            wPoint3d.y = dArray2[dreieck.a];
            wPoint3d2.x = dArray[dreieck.b];
            wPoint3d2.y = dArray2[dreieck.b];
            wPoint3d3.x = dArray[dreieck.c];
            wPoint3d3.y = dArray2[dreieck.c];
            this.wMoveTo(wPoint3d);
            this.wLineTo(wPoint3d2);
            this.wLineTo(wPoint3d3);
            this.wLineTo(wPoint3d);
        }
        WPoint3d.release(wPoint3d);
        WPoint3d.release(wPoint3d2);
        WPoint3d.release(wPoint3d3);
    }

    void allIsolines(double[] dArray, double[] dArray2, double[] dArray3, Dreieck[] dreieckArray, int n, boolean bl) {
        WPoint3d wPoint3d = new WPoint3d();
        WPoint3d wPoint3d2 = new WPoint3d();
        WPoint3d wPoint3d3 = new WPoint3d();
        this.initLimit(dArray);
        int n2 = n;
        while (--n2 >= 0) {
            int n3 = dreieckArray[n2].a;
            int n4 = dreieckArray[n2].b;
            int n5 = dreieckArray[n2].c;
            wPoint3d.x = dArray2[n3];
            wPoint3d.y = dArray3[n3];
            wPoint3d.z = dArray[n3];
            wPoint3d2.x = dArray2[n4];
            wPoint3d2.y = dArray3[n4];
            wPoint3d2.z = dArray[n4];
            wPoint3d3.x = dArray2[n5];
            wPoint3d3.y = dArray3[n5];
            wPoint3d3.z = dArray[n5];
            this.s1_isolines(wPoint3d, wPoint3d2, wPoint3d3, bl);
        }
    }

    void s1_isolines(WPoint3d wPoint3d, WPoint3d wPoint3d2, WPoint3d wPoint3d3, boolean bl) {
        this.isoLines(wPoint3d, wPoint3d2, wPoint3d3, this.limit, false);
        if (bl) {
            this.myg.setColor(Color.gray);
            this.wMoveTo(wPoint3d.x, wPoint3d.y);
            this.wLineTo(wPoint3d2.x, wPoint3d2.y);
            this.wLineTo(wPoint3d3.x, wPoint3d3.y);
            this.wLineTo(wPoint3d.x, wPoint3d.y);
        }
    }

    void isoLines(WPoint3d wPoint3d, WPoint3d wPoint3d2, WPoint3d wPoint3d3, double[] dArray, boolean bl) {
        int n;
        int n2 = dArray.length;
        int n3 = 0;
        if (Math.abs(dArray[0] - dArray[n2 - 1]) > 1.0E-6) {
            n3 = this.scanLine(wPoint3d, wPoint3d2, dArray, n3, posi);
            n3 = this.scanLine(wPoint3d2, wPoint3d3, dArray, n3, posi);
            n3 = this.scanLine(wPoint3d3, wPoint3d, dArray, n3, posi);
        }
        if (n3 < 1) {
            Color color = this.getColor(wPoint3d.z);
            if (bl) {
                this.transform2(wPoint3d);
                this.transform2(wPoint3d2);
                this.transform2(wPoint3d3);
            }
            this.drawtria(wPoint3d.x, wPoint3d.y, wPoint3d2.x, wPoint3d2.y, wPoint3d3.x, wPoint3d3.y, color);
            return;
        }
        Graph3d.posi[n3++] = WPoint3d.getFromPool(wPoint3d);
        Graph3d.posi[n3++] = WPoint3d.getFromPool(wPoint3d2);
        Graph3d.posi[n3++] = WPoint3d.getFromPool(wPoint3d3);
        this.qsortZ(posi, 0, n3 - 1);
        if (bl) {
            this.transform2(wPoint3d);
            this.transform2(wPoint3d2);
            this.transform2(wPoint3d3);
            n = n3;
            while (--n >= 0) {
                this.transform2(posi[n]);
            }
        }
        int n4 = 0;
        n = 0;
        while (n < n3) {
            this.myg.setColor(this.getColor(Graph3d.posi[n4].z));
            if (n == n3 - 1) {
                if (n4 == n - 3) {
                    this.fillArea(posi, n4, 4);
                    break;
                }
                this.fillArea(posi, n4, 3);
                break;
            }
            if (Graph3d.posi[n].z == Graph3d.posi[n + 1].z) {
                if (n == 1) {
                    this.fillArea(posi, n4, 3);
                } else {
                    if (n == 0) {
                        ++n;
                        continue;
                    }
                    if (n4 == n - 2) {
                        this.fillArea(posi, n4, 4);
                    } else {
                        this.fillArea(posi, n4, 5);
                    }
                }
                n4 = n++;
            }
            ++n;
        }
        n = n3;
        while (--n >= 0) {
            WPoint3d.release(posi[n]);
        }
    }

    void drawTriangles(Dreieck[] dreieckArray, double[] dArray, double[] dArray2, double[] dArray3, int n, boolean bl) {
        WPoint3d wPoint3d = WPoint3d.getFromPool();
        WPoint3d wPoint3d2 = WPoint3d.getFromPool();
        WPoint3d wPoint3d3 = WPoint3d.getFromPool();
        Color color = Graph3d.newColor(90, 90, 90);
        this.dreieckeOrdnen(dreieckArray, dArray, dArray2, dArray3, n);
        for (int i = 0; i < n; ++i) {
            Dreieck dreieck = dreieckArray[i];
            wPoint3d.x = dArray[dreieck.a];
            wPoint3d.y = dArray2[dreieck.a];
            wPoint3d.z = dArray3[dreieck.a];
            wPoint3d2.x = dArray[dreieck.b];
            wPoint3d2.y = dArray2[dreieck.b];
            wPoint3d2.z = dArray3[dreieck.b];
            wPoint3d3.x = dArray[dreieck.c];
            wPoint3d3.y = dArray2[dreieck.c];
            wPoint3d3.z = dArray3[dreieck.c];
            this.isoLines(wPoint3d, wPoint3d2, wPoint3d3, this.limit, true);
            if (!bl) continue;
            this.myg.setColor(color);
            this.drawtria(wPoint3d.x, wPoint3d.y, wPoint3d2.x, wPoint3d2.y, wPoint3d3.x, wPoint3d3.y);
        }
        WPoint3d.release(wPoint3d);
        WPoint3d.release(wPoint3d2);
        WPoint3d.release(wPoint3d3);
    }

    void drawTrianglesShaded(Dreieck[] dreieckArray, double[] dArray, double[] dArray2, double[] dArray3, int n, boolean bl) {
        WPoint3d wPoint3d = WPoint3d.getFromPool(0.0, 0.0, 1.0);
        WPoint3d wPoint3d2 = WPoint3d.getFromPool(1.0, 1.0, 1.0);
        WPoint3d wPoint3d3 = WPoint3d.getFromPool();
        WPoint3d wPoint3d4 = WPoint3d.getFromPool();
        WPoint3d wPoint3d5 = WPoint3d.getFromPool();
        WPoint3d wPoint3d6 = WPoint3d.getFromPool();
        double d = 0.7;
        double d2 = 0.3;
        double d3 = 5.0;
        Color color = Graph3d.newColor(90, 90, 90);
        wPoint3d2.normiere();
        wPoint3d.plus(wPoint3d2);
        wPoint3d.normiere();
        this.dreieckeOrdnen(dreieckArray, dArray, dArray2, dArray3, n);
        for (int i = 0; i < n; ++i) {
            Color color2;
            Dreieck dreieck = dreieckArray[i];
            wPoint3d4.x = dArray[dreieck.a];
            wPoint3d4.y = dArray2[dreieck.a];
            wPoint3d4.z = dArray3[dreieck.a];
            wPoint3d5.x = dArray[dreieck.b];
            wPoint3d5.y = dArray2[dreieck.b];
            wPoint3d5.z = dArray3[dreieck.b];
            wPoint3d6.x = dArray[dreieck.c];
            wPoint3d6.y = dArray2[dreieck.c];
            wPoint3d6.z = dArray3[dreieck.c];
            this.transform(wPoint3d4);
            this.transform(wPoint3d5);
            this.transform(wPoint3d6);
            wPoint3d3.flaechenNormale(wPoint3d5, wPoint3d4, wPoint3d6);
            double d4 = WPoint3d.skalarProdukt(wPoint3d2, wPoint3d3) * d;
            if (d4 < 0.0) {
                d4 = 0.0;
            }
            if (wPoint3d3.z >= 0.0) {
                double d5 = WPoint3d.skalarProdukt(wPoint3d, wPoint3d3);
                d5 = d5 < 0.0 ? 0.0 : Math.pow(d5, d3) * d2;
                var27_22 = 70 + (int)(d4 * 170.0) & 0xFFFFFFFE;
                int n2 = (int)(d5 * 240.0) & 0xFFFFFFFE;
                color2 = Graph3d.newColor(n2, n2, n2 + var27_22);
            } else {
                var27_22 = (int)(d4 * 100.0);
                color2 = Graph3d.newColor(105 - var27_22, 0, 0);
            }
            if (bl) {
                this.drawtria(wPoint3d4.x, wPoint3d4.y, wPoint3d5.x, wPoint3d5.y, wPoint3d6.x, wPoint3d6.y, color2, color);
                continue;
            }
            this.drawtria(wPoint3d4.x, wPoint3d4.y, wPoint3d5.x, wPoint3d5.y, wPoint3d6.x, wPoint3d6.y, color2);
        }
        WPoint3d.release(wPoint3d4);
        WPoint3d.release(wPoint3d5);
        WPoint3d.release(wPoint3d6);
        WPoint3d.release(wPoint3d);
        WPoint3d.release(wPoint3d2);
        WPoint3d.release(wPoint3d3);
    }
}

