/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

class GrPanel
extends JPanel
implements MouseMotionListener,
KeyListener,
MouseListener,
ActionListener {
    Graphics myg;
    JPopupMenu zoomMenu = new JPopupMenu();
    static boolean zoomstate = false;
    JMenuItem zoom = new JMenuItem("Zoom");
    JMenuItem fit = new JMenuItem("Fit");
    int curx;
    int cury;
    static double xmit;
    static double ymit;
    double xfak;
    double yfak;
    double[] tmat0 = new double[3];
    double[] tmat1 = new double[3];
    double[] tmat2 = new double[3];
    double[] vtrans = new double[3];
    public static int GR_W;
    public static int GR_H;
    public static int GR_WH;
    public static int GR_HH;
    static double scaleFactor;
    static int angleX;
    static int angleZ;
    int xMouse = 0;
    int yMouse = 0;
    int zoomx;
    int zoomy;
    static final int MAXL = 3331;
    static Color[] colorHashTable;
    static int zmax;

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = n - this.xMouse;
        int n4 = n2 - this.yMouse;
        this.requestFocusInWindow();
        if (Math.abs(n3) < 40 && Math.abs(n4) < 40) {
            if (zoomstate) {
                xmit = this.worldx(this.screenx(xmit) - n3);
                ymit = this.worldy(this.screeny(ymit) - n4);
            } else {
                angleZ = (int)((double)angleZ + (double)n3 * 0.6);
                angleX = (int)((double)angleX + (double)n4 * 0.6);
                if (angleZ > 360) {
                    angleZ -= 360;
                }
                if (angleZ < 0) {
                    angleZ += 360;
                }
                if (angleX > 360) {
                    angleX = 360;
                }
                if (angleX < 275) {
                    angleX = 275;
                }
            }
            this.repaint();
        }
        this.xMouse = n;
        this.yMouse = n2;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        angleX = angleX / 5 * 5;
        angleZ = angleZ / 5 * 5;
        switch (keyEvent.getKeyCode()) {
            case 38: {
                angleX -= 5;
                this.repaint();
                break;
            }
            case 40: {
                angleX += 5;
                this.repaint();
                break;
            }
            case 39: {
                angleZ += 5;
                this.repaint();
                break;
            }
            case 37: {
                angleZ -= 5;
                this.repaint();
            }
        }
        if (angleZ > 360) {
            angleZ -= 360;
        }
        if (angleZ < 0) {
            angleZ += 360;
        }
        if (angleX > 360) {
            angleX = 360;
        }
        if (angleX < 275) {
            angleX = 275;
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getButton() == 3) {
            this.zoomx = mouseEvent.getX();
            this.zoomy = mouseEvent.getY();
            this.zoomMenu.show(this, this.zoomx, this.zoomy);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocusInWindow();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void fit() {
        GrPanel.fittingReset();
        this.repaint();
    }

    public static void fittingReset() {
        zoomstate = false;
        scaleFactor = 0.85;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.zoom) {
            zoomstate = true;
            scaleFactor *= 1.7;
            xmit = this.worldx(this.zoomx);
            ymit = this.worldy(this.zoomy);
            this.repaint();
        }
        if (actionEvent.getSource() == this.fit) {
            this.fit();
        }
    }

    GrPanel() {
        this.setBackground(GrPanel.newColor(111, 125, 137));
        this.tmat0[0] = 1.0;
        this.tmat1[1] = 1.0;
        this.tmat2[2] = 1.0;
        this.zoomMenu.setBorder(BorderFactory.createRaisedBevelBorder());
        this.zoomMenu.add(this.zoom);
        this.zoomMenu.add(this.fit);
        this.add(this.zoomMenu);
        this.addMouseListener(this);
        this.zoom.addActionListener(this);
        this.fit.addActionListener(this);
        this.setFocusable(true);
        zoomstate = false;
        scaleFactor = 0.85;
    }

    void setMinMax(WPoint3d[] wPoint3dArray) {
        double d;
        double d2;
        boolean bl = true;
        this.transform2(wPoint3dArray[0].x, wPoint3dArray[0].y, wPoint3dArray[0].z);
        double d3 = d2 = this.vtrans[0];
        double d4 = d = this.vtrans[1];
        int n = wPoint3dArray.length;
        while (--n >= 1) {
            if (wPoint3dArray[n] == null) continue;
            bl = false;
            this.transform2(wPoint3dArray[n].x, wPoint3dArray[n].y, wPoint3dArray[n].z);
            if (this.vtrans[0] > d3) {
                d3 = this.vtrans[0];
            } else if (this.vtrans[0] < d2) {
                d2 = this.vtrans[0];
            }
            if (d4 < this.vtrans[1]) {
                d4 = this.vtrans[1];
                continue;
            }
            if (!(d > this.vtrans[1])) continue;
            d = this.vtrans[1];
        }
        if (bl) {
            d2 = -1.0;
            d3 = 1.0;
            d = -1.0;
            d4 = 1.0;
        }
        this.setMinMax(d2, d, d3, d4);
    }

    void setMinMax(WPoint[] wPointArray, int n) {
        double d;
        double d2;
        boolean bl = true;
        double d3 = d2 = wPointArray[0].x;
        double d4 = d = wPointArray[0].y;
        if (n > wPointArray.length) {
            n = wPointArray.length;
        }
        int n2 = n;
        while (--n2 >= 1) {
            if (wPointArray[n2] == null) continue;
            bl = false;
            if (d3 < wPointArray[n2].x) {
                d3 = wPointArray[n2].x;
            } else if (d2 > wPointArray[n2].x) {
                d2 = wPointArray[n2].x;
            }
            if (d4 < wPointArray[n2].y) {
                d4 = wPointArray[n2].y;
                continue;
            }
            if (!(d > wPointArray[n2].y)) continue;
            d = wPointArray[n2].y;
        }
        if (bl) {
            d2 = -1.0;
            d3 = 1.0;
            d = -1.0;
            d4 = 1.0;
        }
        this.setMinMax(d2, d, d3, d4);
    }

    void setMinMax(WPoint[] wPointArray) {
        this.setMinMax(wPointArray, wPointArray.length);
    }

    void setMinMax(double d, double d2, double d3, double d4) {
        this.setMinMax(d, d2, d3, d4, 0);
    }

    void setMinMax(double d, double d2, double d3, double d4, int n) {
        double d5 = d3 - d;
        double d6 = d4 - d2;
        if (d5 == 0.0) {
            d5 = d6;
        }
        if (d6 == 0.0) {
            d6 = d5;
        }
        if (d5 == 0.0 && d6 == 0.0) {
            d6 = 2.0;
            d5 = 2.0;
        }
        GR_W = this.getSize().width;
        GR_H = this.getSize().height;
        GR_WH = GR_W / 2;
        GR_HH = GR_H / 2;
        if (!zoomstate) {
            xmit = (d + d3) * 0.5;
            ymit = (d2 + d4) * 0.5;
        }
        this.xfak = (double)GR_W / d5;
        this.yfak = (double)GR_H / d6;
        if (n == 0) {
            if (this.xfak < this.yfak) {
                this.yfak = this.xfak;
            } else {
                this.xfak = this.yfak;
            }
        }
        this.xfak *= scaleFactor;
        this.yfak *= scaleFactor;
    }

    void setScaleFactor(double d) {
        scaleFactor = d;
    }

    final double gfak() {
        return this.xfak;
    }

    final double getwmaxx() {
        return xmit + 0.5 * (double)GR_W / this.xfak;
    }

    double getwminx() {
        return xmit - 0.5 * (double)GR_W / this.xfak;
    }

    double getwmaxy() {
        return ymit + 0.5 * (double)GR_H / this.yfak;
    }

    double getwminy() {
        return ymit - 0.5 * (double)GR_H / this.yfak;
    }

    double worldx(int n) {
        return xmit + (double)(n - GR_WH) / this.xfak;
    }

    double worldy(int n) {
        return ymit - (double)(n - GR_HH) / this.yfak;
    }

    final int screenx(double d) {
        return (int)((double)GR_WH + (d - xmit) * this.xfak + 0.5);
    }

    final int screeny(double d) {
        return (int)((double)GR_HH + (ymit - d) * this.yfak + 0.5);
    }

    int screenx(WPoint wPoint) {
        return this.screenx(wPoint.x);
    }

    int screeny(WPoint wPoint) {
        return this.screeny(wPoint.y);
    }

    int screenx(WPoint3d wPoint3d) {
        return this.screenx(this.transform0(wPoint3d.x, wPoint3d.y, wPoint3d.z));
    }

    int screeny(WPoint3d wPoint3d) {
        return this.screeny(this.transform1(wPoint3d.x, wPoint3d.y, wPoint3d.z));
    }

    int screenx(double d, double d2, double d3) {
        return this.screenx(this.transform0(d, d2, d3));
    }

    int screeny(double d, double d2, double d3) {
        return this.screeny(this.transform1(d, d2, d3));
    }

    void wLineTo(double d, double d2) {
        int n = this.screenx(d);
        int n2 = this.screeny(d2);
        this.myg.drawLine(this.curx, this.cury, n, n2);
        this.curx = n;
        this.cury = n2;
    }

    void wLineTo2(double d, double d2) {
        int n = this.screenx(d);
        int n2 = this.screeny(d2);
        Graphics2D graphics2D = (Graphics2D)this.myg;
        graphics2D.setStroke(new BasicStroke(2.0f));
        graphics2D.drawLine(this.curx, this.cury, n, n2);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.curx = n;
        this.cury = n2;
    }

    void wLineTo3(double d, double d2) {
        int n = this.screenx(d);
        int n2 = this.screeny(d2);
        Graphics2D graphics2D = (Graphics2D)this.myg;
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.drawLine(this.curx, this.cury, n, n2);
        graphics2D.setStroke(new BasicStroke(1.0f));
        this.curx = n;
        this.cury = n2;
    }

    void wLineTo3(WPoint3d wPoint3d) {
        this.transform2(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        this.wLineTo3(this.vtrans[0], this.vtrans[1]);
    }

    final void wMoveTo(double d, double d2) {
        this.curx = this.screenx(d);
        this.cury = this.screeny(d2);
    }

    void drawLines(int[] nArray, int n, int n2, double d) {
        int n3;
        if (d != 0.0) {
            int[] nArray2 = new int[nArray.length];
            double d2 = Math.cos(d);
            double d3 = Math.sin(d);
            n3 = nArray2.length;
            while ((n3 -= 2) >= 0) {
                nArray2[n3] = (int)(d2 * (double)nArray[n3] - d3 * (double)nArray[n3 + 1] + 40.5) - 40;
                nArray2[n3 + 1] = (int)(d3 * (double)nArray[n3] + d2 * (double)nArray[n3 + 1] + 40.5) - 40;
            }
            nArray = nArray2;
        }
        n3 = nArray.length;
        while ((n3 -= 4) >= 0) {
            this.myg.drawLine(n + nArray[n3], n2 + nArray[n3 + 1], n + nArray[n3 + 2], n2 + nArray[n3 + 3]);
        }
    }

    void setTransform(double d, double d2) {
        this.tmat0[0] = Math.cos(d2);
        this.tmat0[1] = -Math.sin(d2);
        this.tmat0[2] = 0.0;
        this.tmat1[0] = Math.cos(d) * Math.sin(d2);
        this.tmat1[1] = Math.cos(d2) * Math.cos(d);
        this.tmat1[2] = -Math.sin(d);
        this.tmat2[0] = Math.sin(d2) * Math.sin(d);
        this.tmat2[1] = Math.cos(d2) * Math.sin(d);
        this.tmat2[2] = Math.cos(d);
    }

    void transform(WPoint3d wPoint3d) {
        this.transform(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        wPoint3d.x = this.vtrans[0];
        wPoint3d.y = this.vtrans[1];
        wPoint3d.z = this.vtrans[2];
    }

    final void transform(double d, double d2, double d3) {
        this.vtrans[0] = this.tmat0[0] * d + this.tmat0[1] * d2 + this.tmat0[2] * d3;
        this.vtrans[1] = this.tmat1[0] * d + this.tmat1[1] * d2 + this.tmat1[2] * d3;
        this.vtrans[2] = this.tmat2[0] * d + this.tmat2[1] * d2 + this.tmat2[2] * d3;
    }

    final void transform2(double d, double d2, double d3) {
        this.vtrans[0] = this.tmat0[0] * d + this.tmat0[1] * d2 + this.tmat0[2] * d3;
        this.vtrans[1] = this.tmat1[0] * d + this.tmat1[1] * d2 + this.tmat1[2] * d3;
    }

    void transform2(WPoint3d wPoint3d) {
        this.transform2(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        wPoint3d.x = this.vtrans[0];
        wPoint3d.y = this.vtrans[1];
    }

    final double transform0(double d, double d2, double d3) {
        return this.tmat0[0] * d + this.tmat0[1] * d2 + this.tmat0[2] * d3;
    }

    final double transform1(double d, double d2, double d3) {
        return this.tmat1[0] * d + this.tmat1[1] * d2 + this.tmat1[2] * d3;
    }

    final double transform3(double d, double d2, double d3) {
        return this.tmat2[0] * d + this.tmat2[1] * d2 + this.tmat2[2] * d3;
    }

    void wLineTo(double d, double d2, double d3) {
        this.transform2(d, d2, d3);
        this.wLineTo(this.vtrans[0], this.vtrans[1]);
    }

    void wLineTo(WPoint3d wPoint3d) {
        this.transform2(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        this.wLineTo(this.vtrans[0], this.vtrans[1]);
    }

    void wLineTo2(double d, double d2, double d3) {
        this.transform2(d, d2, d3);
        this.wLineTo2(this.vtrans[0], this.vtrans[1]);
    }

    void wLineTo2(WPoint3d wPoint3d) {
        this.transform2(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        this.wLineTo2(this.vtrans[0], this.vtrans[1]);
    }

    void wMoveTo(double d, double d2, double d3) {
        this.transform2(d, d2, d3);
        this.wMoveTo(this.vtrans[0], this.vtrans[1]);
    }

    void wMoveTo(WPoint3d wPoint3d) {
        this.transform2(wPoint3d.x, wPoint3d.y, wPoint3d.z);
        this.wMoveTo(this.vtrans[0], this.vtrans[1]);
    }

    void wMoveTo(WPoint wPoint) {
        this.wMoveTo(wPoint.x, wPoint.y);
    }

    void wLineTo(WPoint wPoint) {
        this.wLineTo(wPoint.x, wPoint.y);
    }

    void arrow(double d, double d2, double d3, double d4, double d5, double d6) {
        this.transform2(d, d2, d3);
        double d7 = this.vtrans[0];
        double d8 = this.vtrans[1];
        this.transform2(d4, d5, d6);
        this.arrow(d7, d8, this.vtrans[0], this.vtrans[1]);
    }

    void trippleLine(int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)this.myg;
        Line2D.Double double_ = new Line2D.Double(n, n2, n3, n4);
        graphics2D.setStroke(new BasicStroke(3.0f));
        graphics2D.draw(double_);
        graphics2D.setStroke(new BasicStroke(1.0f));
    }

    void drawPolygon3(Polygon polygon) {
        int n = polygon.npoints;
        while (--n > 0) {
            this.trippleLine(polygon.xpoints[n - 1], polygon.ypoints[n - 1], polygon.xpoints[n], polygon.ypoints[n]);
        }
    }

    void fillPolygon(WPoint3d[] wPoint3dArray, int n) {
        Polygon polygon = new Polygon();
        if (wPoint3dArray.length < n) {
            n = wPoint3dArray.length;
        }
        for (int i = 0; i < n; ++i) {
            this.transform2(wPoint3dArray[i].x, wPoint3dArray[i].y, wPoint3dArray[i].z);
            polygon.addPoint(this.screenx(this.vtrans[0]), this.screeny(this.vtrans[1]));
        }
        this.myg.fillPolygon(polygon);
    }

    void drawCircle(double d, double d2, double d3) {
        int n = (int)(d3 * this.xfak + 0.5);
        this.myg.drawOval(this.screenx(d) - n, this.screeny(d2) - n, 2 * n, 2 * n);
    }

    void drawCircle(double d, double d2, int n) {
        this.myg.drawOval(this.screenx(d) - n, this.screeny(d2) - n, 2 * n + 1, 2 * n + 1);
    }

    void fillCircle(double d, double d2, double d3) {
        int n = (int)(d3 * this.xfak + 0.5);
        this.myg.fillOval(this.screenx(d) - n, this.screeny(d2) - n, 2 * n, 2 * n);
    }

    void fillCircle(double d, double d2, int n) {
        this.myg.fillOval(this.screenx(d) - n, this.screeny(d2) - n, 2 * n + 1, 2 * n + 1);
    }

    void fillCircle(double d, double d2, double d3, double d4) {
        int n = (int)(d4 * this.xfak + 0.5);
        this.transform2(d, d2, d3);
        this.myg.fillOval(this.screenx(this.vtrans[0]) - n, this.screeny(this.vtrans[1]) - n, 2 * n, 2 * n);
    }

    void arrow(double d, double d2, double d3, double d4) {
        this.arrow(d, d2, d3, d4, 0);
    }

    void arrow2(double d, double d2, double d3, double d4) {
        this.arrow2(d, d2, d3, d4, 0);
    }

    void arrow(double d, double d2, double d3, double d4, int n) {
        this.arrow(d, d2, d3, d4, n, true);
    }

    void arrow2(double d, double d2, double d3, double d4, int n) {
        this.arrow(d, d2, d3, d4, n, false);
    }

    void arrow(double d, double d2, double d3, double d4, int n, boolean bl) {
        double d5 = 0.4;
        double d6 = Math.sqrt(d3 * d3 + d4 * d4);
        if (d6 == 0.0) {
            return;
        }
        if (n != 0) {
            d -= d3;
            d2 -= d4;
        }
        this.wMoveTo(d, d2);
        this.wLineTo(d + d3, d2 + d4);
        d += d3;
        d2 += d4;
        d3 = -0.24 * d3;
        d4 = -0.24 * d4;
        double d7 = Math.abs(10.0 / (d6 * 0.24 * this.xfak));
        if (d7 < 1.0) {
            d3 *= d7;
            d4 *= d7;
        }
        double d8 = d + d3 + d5 * d4;
        double d9 = d2 + d4 - d5 * d3;
        double d10 = d + d3 - d5 * d4;
        double d11 = d2 + d4 + d5 * d3;
        if (bl) {
            Polygon polygon = new Polygon();
            polygon.addPoint(this.screenx(d), this.screeny(d2));
            polygon.addPoint(this.screenx(d8), this.screeny(d9));
            polygon.addPoint(this.screenx(d10), this.screeny(d11));
            polygon.addPoint(this.screenx(d), this.screeny(d2));
            this.myg.fillPolygon(polygon);
        } else {
            this.wMoveTo(d8, d9);
            this.wLineTo(d, d2);
            this.wLineTo(d10, d11);
        }
    }

    void arrow2(double d, double d2, double d3, double d4, double d5, double d6) {
        this.transform2(d, d2, d3);
        double d7 = this.vtrans[0];
        double d8 = this.vtrans[1];
        this.transform2(d4, d5, d6);
        this.arrow2(d7, d8, this.vtrans[0], this.vtrans[1]);
    }

    String doubleFormat(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        Object object = decimalFormat.format(d).toString();
        for (int i = ((String)object).length() - string.length(); i < 0; ++i) {
            object = " " + (String)object;
        }
        return ((String)object).replace(',', '.');
    }

    String labelStr(double d, double d2) {
        if (d2 > 10000.0 || d2 < 0.001) {
            return NumEdit.ef(d, 3);
        }
        if (d2 >= 1.0) {
            return this.doubleFormat(d, "#");
        }
        if (d2 >= 0.1) {
            return this.doubleFormat(d, "0.0");
        }
        if (d2 >= 0.01) {
            return this.doubleFormat(d, "0.00");
        }
        return this.doubleFormat(d, "0.000");
    }

    void ax_x() {
        Scales scales = new Scales(this.getwminx(), this.getwmaxx());
        double[] dArray = scales.getTics();
        double d = Math.abs(this.worldy(8) - this.worldy(0));
        int n = dArray.length;
        while (--n >= 0) {
            this.wMoveTo(dArray[n], 0.0);
            this.wLineTo(dArray[n], -d);
        }
        this.wMoveTo(this.getwminx(), 0.0);
        this.wLineTo(this.getwmaxx(), 0.0);
        double[] dArray2 = scales.getLabels();
        double d2 = scales.dLabel;
        n = dArray2.length;
        while (--n >= 0) {
            String string = this.labelStr(dArray2[n], d2);
            this.myg.drawString(string, this.screenx(dArray2[n]) + 2, this.screeny(0.0) + 12);
        }
    }

    void ax_y() {
        Scales scales = new Scales(this.getwminy(), this.getwmaxy());
        double[] dArray = scales.getTics();
        double d = this.worldx(8) - this.worldx(0);
        int n = dArray.length;
        while (--n >= 0) {
            this.wMoveTo(0.0, dArray[n]);
            this.wLineTo(-d, dArray[n]);
        }
        this.wMoveTo(0.0, this.getwminy());
        this.wLineTo(0.0, this.getwmaxy());
        double[] dArray2 = scales.getLabels();
        double d2 = scales.dLabel;
        if (dArray2.length == 0) {
            return;
        }
        int n2 = this.labelStr(dArray2[0], d2).trim().length();
        int n3 = this.labelStr(dArray2[dArray2.length - 1], d2).trim().length();
        if (n3 > n2) {
            n2 = n3;
        }
        int n4 = n2 <= 2 ? 16 : (n2 <= 3 ? 24 : 32);
        n = dArray2.length;
        while (--n >= 0) {
            String string = this.labelStr(dArray2[n], d2);
            this.myg.drawString(string, this.screenx(0.0) - n4, this.screeny(dArray2[n]) - 1);
        }
    }

    void axes() {
        if (this.getwminy() * this.getwmaxy() < 0.0 && this.getwminx() * this.getwmaxx() < 0.0) {
            this.ax_x();
            this.ax_y();
        } else {
            this.border_x();
            this.border_y();
        }
    }

    void axTitles(String string, String string2) {
        int n = this.screenx(this.getwmaxx()) - 10 - string.length() * 7;
        int n2 = this.screeny(0.0) + 20;
        this.myg.drawString(string, n, n2);
        n = this.screenx(0.0) + 10;
        n2 = this.screeny(this.getwmaxy()) + 20;
        this.myg.drawString(string2, n, n2);
    }

    void border_x() {
        Scales scales = new Scales(this.getwminx(), this.getwmaxx());
        double[] dArray = scales.getTics();
        double d = Math.abs(this.worldy(8) - this.worldy(0));
        double d2 = this.getwminy();
        int n = dArray.length;
        while (--n >= 0) {
            this.wMoveTo(dArray[n], d2);
            this.wLineTo(dArray[n], d2 + d);
        }
        this.wMoveTo(this.getwminx(), 0.0);
        this.wLineTo(this.getwmaxx(), 0.0);
        double[] dArray2 = scales.getLabels();
        double d3 = scales.dLabel;
        n = dArray2.length;
        while (--n >= 0) {
            String string = this.labelStr(dArray2[n], d3);
            this.myg.drawString(string, this.screenx(dArray2[n]) + 2, this.screeny(d2) - 9);
        }
    }

    void border_y() {
        Scales scales = new Scales(this.getwminy(), this.getwmaxy());
        double[] dArray = scales.getTics();
        double d = this.worldx(8) - this.worldx(0);
        double d2 = this.getwminx();
        int n = dArray.length;
        while (--n >= 0) {
            this.wMoveTo(d2, dArray[n]);
            this.wLineTo(d2 + d, dArray[n]);
        }
        this.wMoveTo(0.0, this.getwminy());
        this.wLineTo(0.0, this.getwmaxy());
        double[] dArray2 = scales.getLabels();
        double d3 = scales.dLabel;
        if (dArray2.length == 0) {
            return;
        }
        n = dArray2.length;
        while (--n >= 0) {
            String string = this.labelStr(dArray2[n], d3);
            this.myg.drawString(string, this.screenx(d2) + 2, this.screeny(dArray2[n]) - 3);
        }
    }

    void grid() {
        int n;
        Scales scales = new Scales(this.getwminy(), this.getwmaxy());
        double[] dArray = scales.getTics();
        Scales scales2 = new Scales(this.getwminx(), this.getwmaxx());
        double[] dArray2 = scales2.getTics();
        int n2 = dArray2.length;
        int n3 = dArray.length;
        double d = this.getwminy();
        double d2 = this.getwmaxy();
        for (n = 0; n < n2; ++n) {
            this.wMoveTo(dArray2[n], d);
            this.wLineTo(dArray2[n], d2);
        }
        d = this.getwminx();
        d2 = this.getwmaxx();
        for (n = 0; n < n3; ++n) {
            this.wMoveTo(d, dArray[n]);
            this.wLineTo(d2, dArray[n]);
        }
        this.wMoveTo(this.getwminx(), this.getwminy());
        this.wLineTo(this.getwmaxx(), this.getwminy());
        this.wLineTo(this.getwmaxx(), this.getwmaxy());
        this.wLineTo(this.getwminx(), this.getwmaxy());
        this.wLineTo(this.getwminx(), this.getwminy());
    }

    static double winkel(double d, double d2) {
        if (d2 > 1.0E-9) {
            return 1.5707963267948966 - Math.atan(d / d2);
        }
        if (d2 < -1.0E-9) {
            return 4.71238898038469 - Math.atan(d / d2);
        }
        if (d > 0.0) {
            return 0.0;
        }
        return Math.PI;
    }

    static Color newColor(int n, int n2, int n3) {
        Color color;
        int n4 = n << 16 | n2 << 8 | n3;
        int n5 = (n4 << 4) % 3331;
        int n6 = 0;
        while ((color = colorHashTable[n5]) != null) {
            if ((color.getRGB() & 0xFFFFFF) == n4) {
                return color;
            }
            if (++n5 >= 3331) {
                n5 = 0;
            }
            if (++n6 < 10) continue;
            n5 = (n4 << 4) % 3331;
            colorHashTable = new Color[3331];
        }
        GrPanel.colorHashTable[n5] = new Color(n4);
        return GrPanel.colorHashTable[n5];
    }

    static {
        GR_W = 600;
        GR_H = 400;
        GR_WH = GR_W / 2;
        GR_HH = GR_H / 2;
        scaleFactor = 0.85;
        angleX = 290;
        angleZ = 340;
        colorHashTable = new Color[3331];
        zmax = 0;
    }
}

