/*
 * Decompiled with CFR 0.152.
 */
class Ftree {
    static final int VAR = 30;
    static final int VAL = 31;
    static final int UMINUS = 32;
    static final int POWER = 33;
    static final int TIMES = 34;
    static final int DEVIDE = 35;
    static final int PLUS = 36;
    static final int MINUS = 37;
    static final int NOTREE = -1;
    static final int MISSINGBRACE = -2;
    static final int SYNTAXERROR = -3;
    static final int MISSINGOPERAND = -4;
    static final int UNKNOWNFUNCTION = -5;
    static final int STACKOVERFLOW = -6;
    static final int DIVBYZERO = -7;
    static final int NEGATIVERADIKANT = -8;
    static final int OUTOFRANGE = -9;
    char[] buf;
    int curr = 0;
    static int error;
    static final int MAXVARS = 512;
    static int varCnt;
    static FtreeVar[] vars;
    static FtreeVar stdVar;
    FtreeNode root = null;
    static String[] intrinsics;
    StringBuilder sb = new StringBuilder();

    Ftree(String string) {
        int n = string.length();
        this.buf = new char[n + 1];
        string.getChars(0, n, this.buf, 0);
        this.root = this.expression();
        if (this.buf[this.curr] != '\u0000') {
            error = -3;
        }
    }

    int lookup(String string) {
        int n = 0;
        int n2 = intrinsics.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            int n4 = string.compareTo(intrinsics[n3]);
            if (n4 < 0) {
                n2 = n3 - 1;
                continue;
            }
            if (n4 > 0) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    static int binary(String string, FtreeVar[] ftreeVarArray, int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n2 <= n3) {
            int n4 = n3 + n2 >> 1;
            int n5 = string.compareTo(ftreeVarArray[n4].name);
            if (n5 < 0) {
                n3 = n4 - 1;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return n4;
        }
        return -1 - n2;
    }

    static String errorText(int n) {
        String[] stringArray = new String[]{"kein Function-Tree", "fehlende Klammer", "Synatxfehler", "fehlender Operand", "unbekannte Funktion", "stack-overflow", "Division durch 0", "negativer Radikant"};
        int n2 = -n - 1;
        return n2 >= 0 && n2 < stringArray.length ? stringArray[n2] : "error " + n;
    }

    static String errorText() {
        return Ftree.errorText(error);
    }

    static boolean isVarOrFunc(int n) {
        return n == 30 || n < intrinsics.length;
    }

    static FtreeNode otherFactor(FtreeNode ftreeNode) {
        if (ftreeNode == null) {
            return null;
        }
        if (ftreeNode.op == 34) {
            if (Ftree.isVarOrFunc(ftreeNode.left.op)) {
                return ftreeNode.left;
            }
            if (Ftree.isVarOrFunc(ftreeNode.right.op)) {
                return ftreeNode.right;
            }
            FtreeNode ftreeNode2 = Ftree.otherFactor(ftreeNode.right);
            if (ftreeNode2 != null) {
                return ftreeNode2;
            }
            ftreeNode2 = Ftree.otherFactor(ftreeNode.left);
            if (ftreeNode2 != null) {
                return ftreeNode2;
            }
        }
        return null;
    }

    static boolean simplifyTree(FtreeNode ftreeNode) {
        if (ftreeNode == null) {
            return false;
        }
        if (ftreeNode.op == 31) {
            return true;
        }
        if (ftreeNode.op == 34) {
            for (int i = 1; i <= 2; ++i) {
                FtreeNode ftreeNode2;
                FtreeNode ftreeNode3;
                if (i == 1) {
                    ftreeNode3 = ftreeNode.left;
                    ftreeNode2 = ftreeNode.right;
                } else {
                    ftreeNode3 = ftreeNode.right;
                    ftreeNode2 = ftreeNode.left;
                }
                if (ftreeNode3.op != 31 || (ftreeNode2 = Ftree.otherFactor(ftreeNode2)) == null) continue;
                FtreeNode ftreeNode4 = new FtreeNode();
                ftreeNode4.copy(ftreeNode2);
                ftreeNode2.copy(ftreeNode3);
                ftreeNode3.copy(ftreeNode4);
            }
        }
        boolean bl = Ftree.simplifyTree(ftreeNode.left);
        boolean bl2 = Ftree.simplifyTree(ftreeNode.right);
        if (bl && (bl2 || ftreeNode.right == null)) {
            ftreeNode.val = Ftree.evalTree(ftreeNode);
            ftreeNode.op = 31;
            ftreeNode.right = null;
            ftreeNode.left = null;
            return true;
        }
        return false;
    }

    static final FtreeVar getVarFromPool(String string) {
        FtreeVar ftreeVar;
        FtreeVar ftreeVar2 = ftreeVar = varCnt < vars.length ? vars[varCnt] : null;
        if (ftreeVar != null) {
            ftreeVar.set(string);
            return ftreeVar;
        }
        return new FtreeVar(string);
    }

    static final boolean usesStdVar(FtreeNode ftreeNode) {
        if (ftreeNode == null) {
            return false;
        }
        if (ftreeNode.op == 30 && (ftreeNode.varPos == stdVar || Ftree.usesStdVar(ftreeNode.varPos.def))) {
            return true;
        }
        return Ftree.usesStdVar(ftreeNode.left) || Ftree.usesStdVar(ftreeNode.right);
    }

    static final void useFixedVars() {
        for (int i = 0; i < varCnt; ++i) {
            FtreeVar ftreeVar = vars[i];
            if (stdVar != null && (ftreeVar.def == null || Ftree.usesStdVar(ftreeVar.def))) continue;
            double d = Ftree.evalTree(ftreeVar.def);
            ftreeVar.set(d);
        }
    }

    static FtreeVar newVar(String string) {
        int n = Ftree.binary(string, vars, varCnt);
        if (n >= 0) {
            return vars[n];
        }
        if (varCnt == 512) {
            return null;
        }
        n = -1 - n;
        FtreeVar ftreeVar = Ftree.getVarFromPool(string);
        for (int i = varCnt; i > n; --i) {
            Ftree.vars[i] = vars[i - 1];
        }
        ++varCnt;
        Ftree.vars[n] = ftreeVar;
        return ftreeVar;
    }

    static void setStdVar(String string) {
        FtreeVar ftreeVar = Ftree.newVar(string);
        if (ftreeVar != null) {
            stdVar = ftreeVar;
        }
    }

    static void setVar(double d) {
        if (stdVar == null) {
            stdVar = Ftree.newVar("x");
        }
        if (stdVar != null) {
            stdVar.set(d);
        }
    }

    static double getVar() {
        if (stdVar == null) {
            stdVar = Ftree.newVar("x");
        }
        return Ftree.stdVar.val;
    }

    static final FtreeVar setVar(String string, double d) {
        FtreeVar ftreeVar = Ftree.newVar(string);
        if (ftreeVar != null) {
            ftreeVar.set(d);
        }
        return ftreeVar;
    }

    static FtreeVar setVar(String string, String string2) {
        if (string2.length() != 0) {
            FtreeVar ftreeVar = Ftree.newVar(string);
            FtreeNode ftreeNode = new Ftree((String)string2).root;
            if (ftreeNode != null && ftreeNode.op == 31) {
                ftreeVar.set(ftreeNode.val);
            } else {
                ftreeVar.set(ftreeNode);
            }
            return ftreeVar;
        }
        return null;
    }

    static void setVar(String string, FtreeNode ftreeNode) {
        FtreeVar ftreeVar = Ftree.newVar(string);
        ftreeVar.set(ftreeNode);
    }

    static double getVar(String string) {
        int n = Ftree.binary(string, vars, varCnt);
        if (n < 0) {
            return 0.0;
        }
        FtreeVar ftreeVar = vars[n];
        if (ftreeVar.def == null) {
            return ftreeVar.val;
        }
        try {
            return Ftree.evalTree(ftreeVar.def);
        }
        catch (StackOverflowError stackOverflowError) {
            error = -6;
            return 0.0;
        }
    }

    static int delVar(String string) {
        int n = Ftree.binary(string, vars, varCnt);
        if (n >= 0) {
            FtreeVar ftreeVar = vars[n];
            --varCnt;
            for (int i = n; i < varCnt; ++i) {
                Ftree.vars[i] = vars[i + 1];
            }
            Ftree.vars[Ftree.varCnt] = ftreeVar;
            return 0;
        }
        return -1;
    }

    static final void delAllVars() {
        stdVar = null;
        varCnt = 0;
    }

    static void delNotInitializedVars() {
        int n = varCnt;
        while (--n >= 0) {
            if (Ftree.vars[n].init) continue;
            Ftree.delVar(Ftree.vars[n].name);
        }
    }

    static String notInitializedVars() {
        Object object = "";
        for (int i = 0; i < varCnt; ++i) {
            if (vars[i] == null || Ftree.vars[i].init) continue;
            object = (String)object + Ftree.vars[i].name + " ";
        }
        return object;
    }

    final void skipwhite() {
        while (this.buf[this.curr] == ' ') {
            ++this.curr;
        }
    }

    final void advance() {
        ++this.curr;
        this.skipwhite();
    }

    static final boolean isdigit(char c) {
        return '0' <= c && c <= '9';
    }

    static boolean isalpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    static boolean isalnum(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    final FtreeNode toLeft(FtreeNode ftreeNode) {
        FtreeNode ftreeNode2 = new FtreeNode();
        ftreeNode2.left = ftreeNode;
        return ftreeNode2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    FtreeNode term() {
        this.skipwhite();
        char c = this.buf[this.curr];
        if (Ftree.isdigit(c) || c == '.') {
            this.sb.setLength(0);
            while (Ftree.isdigit(this.buf[this.curr]) || this.buf[this.curr] == '.') {
                this.sb.append(this.buf[this.curr++]);
                if (this.buf[this.curr] != 'e' && this.buf[this.curr] != 'E' || this.buf.length <= this.curr) continue;
                char c2 = this.buf[this.curr + 1];
                if (c2 == '+' || c2 == '-') {
                    this.sb.append(this.buf[this.curr++]);
                    this.sb.append(this.buf[this.curr++]);
                    continue;
                }
                if (!Ftree.isdigit(c2)) continue;
                this.sb.append(this.buf[this.curr++]);
            }
            this.skipwhite();
            FtreeNode ftreeNode = new FtreeNode();
            ftreeNode.op = 31;
            try {
                ftreeNode.val = Double.parseDouble(this.sb.toString());
                return ftreeNode;
            }
            catch (Exception exception) {
                ftreeNode.val = 0.0;
                error = -3;
            }
            return ftreeNode;
        }
        if (c == '(') {
            this.advance();
            var2_6 = this.expression();
            this.skipwhite();
            if (this.buf[this.curr] == ')') {
                this.advance();
                return var2_6;
            } else {
                error = -2;
            }
            return var2_6;
        } else if (c == '-') {
            this.advance();
            var2_6 = new FtreeNode();
            var2_6.op = 32;
            var2_6.left = this.power();
            if (var2_6.left == null) return var2_6;
            if (var2_6.left.op != 31) return var2_6;
            var2_6.op = 31;
            var2_6.val = -var2_6.left.val;
            var2_6.left = null;
            return var2_6;
        } else {
            if (c == '+') {
                this.advance();
                return this.power();
            }
            if (c == '\u0000') return null;
            this.sb.setLength(0);
            while (Ftree.isalnum(this.buf[this.curr])) {
                this.sb.append(this.buf[this.curr++]);
            }
            String string = this.sb.toString();
            if (string.length() == 0) {
                error = -4;
            }
            this.skipwhite();
            var2_6 = new FtreeNode();
            if (this.buf[this.curr] == '(') {
                this.advance();
                var2_6.op = this.lookup(string);
                this.skipwhite();
                var2_6.left = this.expression();
                if (this.buf[this.curr] == ',') {
                    this.advance();
                    var2_6.right = this.expression();
                }
                if (this.buf[this.curr] == ')') {
                    this.advance();
                } else {
                    error = -2;
                }
                if (var2_6.op != -1) return var2_6;
                error = -5;
                return var2_6;
            } else {
                if (string.equals("PI")) {
                    var2_6.op = 31;
                    var2_6.val = Math.PI;
                    return var2_6;
                }
                var2_6.varPos = Ftree.newVar(string);
                var2_6.op = 30;
                if (this.buf[this.curr] != '=') return var2_6;
                this.advance();
                Ftree.setVar(string, this.expression());
                return var2_6;
            }
        }
    }

    FtreeNode power() {
        FtreeNode ftreeNode = this.term();
        while (this.buf[this.curr] == '^') {
            this.advance();
            ftreeNode = this.toLeft(ftreeNode);
            ftreeNode.op = 33;
            ftreeNode.right = this.term();
            if (ftreeNode.right != null) continue;
            error = -4;
        }
        return ftreeNode;
    }

    FtreeNode product() {
        FtreeNode ftreeNode = this.power();
        while (this.buf[this.curr] == '*' || this.buf[this.curr] == '/') {
            char c = this.buf[this.curr];
            this.advance();
            ftreeNode = this.toLeft(ftreeNode);
            ftreeNode.op = c == '*' ? 34 : 35;
            ftreeNode.right = this.power();
            if (ftreeNode.right != null) continue;
            error = -4;
        }
        return ftreeNode;
    }

    FtreeNode expression() {
        FtreeNode ftreeNode = this.product();
        while (this.buf[this.curr] == '+' || this.buf[this.curr] == '-') {
            char c = this.buf[this.curr];
            this.advance();
            ftreeNode = this.toLeft(ftreeNode);
            ftreeNode.op = c == '+' ? 36 : 37;
            ftreeNode.right = this.product();
            if (ftreeNode.right != null) continue;
            error = -4;
        }
        return ftreeNode;
    }

    static double sign(double d) {
        return d < 0.0 ? -1.0 : (d > 0.0 ? 1.0 : 0.0);
    }

    static double cosh(double d) {
        return 0.5 * (Math.exp(d) + Math.exp(-d));
    }

    static double sinh(double d) {
        return 0.5 * (Math.exp(d) - Math.exp(-d));
    }

    static double tanh(double d) {
        return Ftree.sinh(d) / Ftree.cosh(d);
    }

    static double evalTree(FtreeNode ftreeNode) {
        if (ftreeNode == null) {
            error = -4;
            return 0.0;
        }
        switch (ftreeNode.op) {
            case 30: {
                return ftreeNode.varPos.def == null ? ftreeNode.varPos.val : Ftree.evalTree(ftreeNode.varPos.def);
            }
            case 31: {
                return ftreeNode.val;
            }
            case 32: {
                return -Ftree.evalTree(ftreeNode.left);
            }
            case 36: {
                return Ftree.evalTree(ftreeNode.left) + Ftree.evalTree(ftreeNode.right);
            }
            case 37: {
                return Ftree.evalTree(ftreeNode.left) - Ftree.evalTree(ftreeNode.right);
            }
            case 34: {
                return Ftree.evalTree(ftreeNode.left) * Ftree.evalTree(ftreeNode.right);
            }
            case 35: {
                double d = Ftree.evalTree(ftreeNode.right);
                if (d == 0.0) {
                    error = -7;
                    return 0.0;
                }
                return Ftree.evalTree(ftreeNode.left) / d;
            }
            case 0: {
                return Ftree.evalTree(ftreeNode.left) < 0.0 ? 0.0 : 1.0;
            }
            case 1: {
                return Math.abs(Ftree.evalTree(ftreeNode.left));
            }
            case 2: {
                return Math.acos(Ftree.evalTree(ftreeNode.left));
            }
            case 3: {
                return Math.asin(Ftree.evalTree(ftreeNode.left));
            }
            case 4: {
                return Math.atan(Ftree.evalTree(ftreeNode.left));
            }
            case 5: {
                return Math.cos(Ftree.evalTree(ftreeNode.left));
            }
            case 6: {
                return Ftree.cosh(Ftree.evalTree(ftreeNode.left));
            }
            case 7: {
                return Math.exp(Ftree.evalTree(ftreeNode.left));
            }
            case 8: {
                return Scales.fmod(Ftree.evalTree(ftreeNode.left), Ftree.evalTree(ftreeNode.right));
            }
            case 9: {
                return Math.log(Ftree.evalTree(ftreeNode.left)) / Math.log(10.0);
            }
            case 10: {
                return Math.log(Ftree.evalTree(ftreeNode.left));
            }
            case 11: {
                double d = Ftree.evalTree(ftreeNode.left);
                double d2 = Ftree.evalTree(ftreeNode.right);
                return d > d2 ? d : d2;
            }
            case 12: {
                double d = Ftree.evalTree(ftreeNode.left);
                double d3 = Ftree.evalTree(ftreeNode.right);
                return d < d3 ? d : d3;
            }
            case 13: 
            case 33: {
                return Math.pow(Ftree.evalTree(ftreeNode.left), Ftree.evalTree(ftreeNode.right));
            }
            case 14: {
                return Math.round(Ftree.evalTree(ftreeNode.left));
            }
            case 15: {
                return Ftree.sign(Ftree.evalTree(ftreeNode.left));
            }
            case 16: {
                return Math.sin(Ftree.evalTree(ftreeNode.left));
            }
            case 17: {
                return Ftree.sinh(Ftree.evalTree(ftreeNode.left));
            }
            case 18: {
                return Math.sqrt(Ftree.evalTree(ftreeNode.left));
            }
            case 19: {
                return Math.tan(Ftree.evalTree(ftreeNode.left));
            }
            case 20: {
                return Math.tanh(Ftree.evalTree(ftreeNode.left));
            }
        }
        return 0.0;
    }

    double evaluate() {
        if (this.root == null) {
            error = -1;
            return 0.0;
        }
        try {
            return Ftree.evalTree(this.root);
        }
        catch (StackOverflowError stackOverflowError) {
            error = -6;
            return 0.0;
        }
        catch (NumberFormatException numberFormatException) {
            error = -3;
            return 0.0;
        }
    }

    double evaluate(double d) {
        Ftree.setVar(d);
        return this.evaluate();
    }

    static double evaluate(String string) {
        if (string.length() == 0) {
            return 0.0;
        }
        Ftree ftree = new Ftree(string);
        if (ftree.buf[ftree.curr] != '\u0000') {
            error = -3;
        }
        return error == 0 ? ftree.evaluate() : 0.0;
    }

    static void resetStatus() {
        error = 0;
    }

    static int getStatus() {
        return error;
    }

    static {
        varCnt = 0;
        vars = new FtreeVar[512];
        stdVar = null;
        intrinsics = new String[]{"H", "abs", "acos", "asin", "atan", "cos", "cosh", "exp", "fmod", "lg", "ln", "max", "min", "pow", "round", "sign", "sin", "sinh", "sqrt", "tan", "tanh"};
    }
}

