/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class FplotPanel
extends GrPanel {
    String functionStr;
    String fsPrev = null;
    String[] flist = null;
    double[] x;
    int maxfunc = 8;
    double[][] y = new double[this.maxfunc][];
    boolean[][] ok = new boolean[this.maxfunc][];
    double fminy;
    double fmaxy;
    double fminx = -1.0;
    double fmaxx = 5.0;
    double fminxPrev;
    double fmaxxPrev;
    int nwerte;
    int nfunc = 0;
    static boolean hasColor = true;
    static boolean legendRight = true;
    static Color bgColor;
    static Color axColor;
    static Color gridColor;
    static FplotPanel fp;
    Color[] clist = new Color[]{Color.yellow, Color.red, Color.green, Color.blue, Color.cyan, Color.magenta, Color.orange, Color.pink};

    FplotPanel() {
        this.addMouseMotionListener(this);
        this.setBackground(bgColor);
        this.functionStr = "";
        fp = this;
        FplotPanel.initColors(true, true);
    }

    public static void initColors(boolean bl, boolean bl2) {
        hasColor = bl;
        legendRight = bl2;
        if (!bl) {
            bgColor = new Color(255, 255, 255);
            axColor = new Color(0, 0, 0);
            gridColor = new Color(0, 0, 0);
        } else {
            bgColor = new Color(111, 125, 137);
            axColor = new Color(195, 195, 195);
            gridColor = new Color(145, 145, 145);
        }
        fp.repaint();
    }

    String[] splitString(String string, char c) {
        String string2;
        int n;
        int n2 = 0;
        String[] stringArray = new String[16];
        while ((n = string.indexOf(c)) >= 0) {
            string2 = string.substring(0, n).trim();
            if (string2.length() > 0) {
                stringArray[n2++] = string2;
            }
            string = string.substring(n + 1);
        }
        string2 = string.trim();
        if (string2.length() > 0) {
            stringArray[n2++] = string2;
        }
        stringArray[n2] = null;
        return stringArray;
    }

    public String repairFalseProducts(String object) {
        for (int i = 1; i < ((String)object).length(); ++i) {
            char c;
            if (((String)object).charAt(i) != 'x' || '0' > (c = ((String)object).charAt(i - 1)) || c > '9') continue;
            object = ((String)object).substring(0, i) + "*" + ((String)object).substring(i);
        }
        return object;
    }

    int setupArrays() {
        int n;
        this.flist = this.splitString(this.functionStr, ';');
        Ftree.resetStatus();
        Ftree[] ftreeArray = new Ftree[this.maxfunc];
        this.nwerte = this.getSize().width;
        if (this.nwerte == 0) {
            this.nwerte = 600;
        }
        this.x = new double[this.nwerte];
        this.nfunc = 0;
        for (n = 0; n < this.maxfunc; ++n) {
            if (this.flist[n] == null) continue;
            this.y[n] = new double[this.nwerte];
            this.ok[n] = new boolean[this.nwerte];
            this.flist[n] = this.repairFalseProducts(this.flist[n]);
            ftreeArray[n] = new Ftree(this.flist[n]);
            this.nfunc = n + 1;
        }
        double d = this.fminx;
        double d2 = (this.fmaxx - this.fminx) / (double)(this.nwerte - 1);
        Ftree.setStdVar("x");
        for (int i = 0; i < this.nwerte; ++i) {
            this.x[i] = d;
            for (n = 0; n < this.nfunc; ++n) {
                this.y[n][i] = ftreeArray[n].evaluate(d);
                if (Double.isNaN(this.y[n][i])) {
                    this.ok[n][i] = false;
                    this.y[n][i] = 0.0;
                    continue;
                }
                this.ok[n][i] = true;
            }
            d += d2;
        }
        return Ftree.getStatus();
    }

    double maxInArray(double[][] dArray, int n) {
        double d = dArray[0][0];
        int n2 = n;
        while (--n2 >= 0) {
            double d2 = VectorSet.vsMax(this.y[n2]);
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    double minInArray(double[][] dArray, int n) {
        double d = dArray[0][0];
        int n2 = n;
        while (--n2 >= 0) {
            double d2 = VectorSet.vsMin(this.y[n2]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        return d;
    }

    void setminmax(double d, double d2, double d3, double d4) {
        double d5;
        this.fminx = d;
        this.fmaxx = d2;
        this.fminy = d3;
        this.fmaxy = d4;
        if (d != this.fminxPrev || d2 != this.fmaxxPrev || this.functionStr != this.fsPrev) {
            if (this.setupArrays() != 0) {
                Fplot.errorMsg("Fehler bei der Funktionsauswertung");
            }
            this.fminxPrev = d;
            this.fmaxxPrev = d2;
            this.fsPrev = this.functionStr;
        }
        if (!Fplot.ymaxDefined) {
            double d6 = this.fmaxy = this.y[0] != null ? this.maxInArray(this.y, this.nfunc) : 1.0;
        }
        if (!Fplot.yminDefined) {
            double d7 = this.fminy = this.y[0] != null ? this.minInArray(this.y, this.nfunc) : 0.0;
        }
        if ((d5 = this.fmaxy - this.fminy) < 1.0E-7) {
            d5 = 1.0;
        }
        this.fmaxy += 0.05 * d5;
        this.fminy -= 0.05 * d5;
    }

    double getxmax() {
        return this.fmaxx;
    }

    double getxmin() {
        return this.fminx;
    }

    void setFunction(String string) {
        if (!this.functionStr.equals(string)) {
            this.functionStr = string;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        int n;
        this.myg = graphics;
        scaleFactor = 1.0;
        this.setMinMax(this.fminx, this.fminy, this.fmaxx, this.fmaxy, 1);
        graphics.setColor(bgColor);
        int n2 = this.getSize().width;
        graphics.fillRect(0, 0, n2, this.getSize().height);
        graphics.setColor(gridColor);
        this.grid();
        graphics.setColor(axColor);
        this.axes();
        this.myg.setFont(new Font("MonoSpaced", 0, 15));
        int n3 = 0;
        for (n = 0; n < this.nfunc; ++n) {
            int n4 = this.flist[n].length();
            if (n4 <= n3) continue;
            n3 = n4;
        }
        n2 -= 4 + 9 * n3;
        if (!legendRight) {
            n2 = 10;
        }
        double d = this.getwmaxy();
        double d2 = this.getwminy();
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (n = 0; n < this.nfunc; ++n) {
            if (hasColor) {
                graphics.setColor(this.clist[n]);
            } else {
                graphics.setColor(Color.black);
            }
            double[] dArray = this.y[n];
            this.wMoveTo(this.x[0], dArray[0]);
            for (int i = 1; i < this.nwerte; ++i) {
                if (dArray[i] > d && dArray[i - 1] < d2 || dArray[i - 1] > d && dArray[i] < d2) {
                    this.wMoveTo(this.x[i], dArray[i]);
                    continue;
                }
                if (this.ok[n][i] && this.ok[n][i - 1]) {
                    if (hasColor) {
                        this.wLineTo(this.x[i], dArray[i]);
                        continue;
                    }
                    this.wLineTo2(this.x[i], dArray[i]);
                    continue;
                }
                if (!this.ok[n][i]) continue;
                this.wMoveTo(this.x[i], dArray[i]);
            }
            graphics.drawString(this.flist[n], n2, 12 + 15 * n);
        }
    }
}

