/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class DontExitFrame
extends JFrame
implements WindowListener,
ActionListener {
    static JFrame[] frameList = new JFrame[32];
    static String[] titleList = new String[32];
    public static final int SYSTEM_LAF = 0;
    public static final int OCEAN_LAF = 1;
    public static final int STEEL_LAF = 2;
    public static final int NIMBUS_LAF = 3;
    public static final int MOTIF_LAF = 4;
    public static final int WINCLASSIC_LAF = 5;
    public static final int GTK_LAF = 6;
    public int currStyle = 3;
    static String[] locations = new String[]{null, "javax.swing.plaf.metal.MetalLookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel", "javax.swing.plaf.nimbus.NimbusLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"};
    JMenuItem[] lafs = new JMenuItem[locations.length];
    ButtonGroup radiobuttonGroup = new ButtonGroup();
    private JMenuItem langDE = null;
    private JMenuItem langEN = null;
    private JMenuItem langES = null;
    private JMenuItem langFR = null;
    private JMenuItem help = null;
    LabelStore labelStore = null;
    String topic;
    JFrame jf = null;

    DontExitFrame() {
        boolean bl;
        Object object;
        this.addWindowListener(this);
        for (int i = 0; i < titleList.length && titleList[i] != null; ++i) {
            if (frameList[i] != null) continue;
            DontExitFrame.frameList[i] = this;
            break;
        }
        try {
            object = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("favicon.gif"));
            this.setIconImage(((ImageIcon)object).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Applications.mainFrame == null && (bl = ((String)(object = UIManager.getLookAndFeel().getClass().getName())).startsWith("javax"))) {
            this.selectLookAndFeel(this.currStyle);
        }
    }

    static boolean exists(String string) {
        if (!Applications.started) {
            return false;
        }
        return !DontExitFrame.addEntry(null, string);
    }

    private static boolean addEntry(JFrame jFrame, String string) {
        for (int i = 0; i < titleList.length && titleList[i] != null; ++i) {
            if (!titleList[i].equals(string)) continue;
            return false;
        }
        DontExitFrame.frameList[i] = jFrame;
        DontExitFrame.titleList[i] = string;
        return true;
    }

    private static void delEntry(JFrame jFrame) {
        for (int i = 0; i < frameList.length && frameList[i] != null; ++i) {
            if (frameList[i] != jFrame) continue;
            while (frameList[i] != null) {
                DontExitFrame.frameList[i] = frameList[i + 1];
                DontExitFrame.titleList[i] = titleList[i + 1];
                ++i;
            }
            return;
        }
    }

    void exit(int n) {
        if (Applications.started) {
            DontExitFrame dontExitFrame = this;
            try {
                dontExitFrame.dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
            DontExitFrame.delEntry(dontExitFrame);
        } else {
            System.exit(n);
        }
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.exit(0);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    JMenu lookMenu() {
        String[] stringArray = new String[]{"System", "Metal (Ocean)", "Metal (Steel)", "Nimbus", "Motif", "Windows Classic", "GTK"};
        JMenu jMenu = new JMenu("Look&Feel");
        for (int i = 0; i < this.lafs.length; ++i) {
            if (i == 5 && !this.isWindows() || i == 6 && (this.isWindows() || this.isMac())) continue;
            this.lafs[i] = new JRadioButtonMenuItem(stringArray[i], Applications.started ? false : i == this.currStyle);
            this.lafs[i].addActionListener(this);
            jMenu.add(this.lafs[i]);
            this.radiobuttonGroup.add(this.lafs[i]);
        }
        return jMenu;
    }

    public String getOsName() {
        String string = System.getProperty("os.name");
        return string;
    }

    public boolean isWindows() {
        return this.getOsName().toLowerCase().contains("windows");
    }

    public boolean isMac() {
        return this.getOsName().toLowerCase().startsWith("mac");
    }

    void selectLookAndFeel(int n) {
        DontExitFrame.selectLookAndFeel(n, this);
        this.currStyle = n;
    }

    static void selectLookAndFeel(int n, Component component) {
        try {
            String string = locations[n];
            if (string == null) {
                string = UIManager.getSystemLookAndFeelClassName();
            }
            if (n == 2) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            if (n == 1) {
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            }
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(component);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            unsupportedLookAndFeelException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public JMenu languageMenu(LabelStore labelStore) {
        this.labelStore = labelStore;
        JMenu jMenu = this.labelStore.newMenu("Sprache");
        this.langDE = this.labelStore.newMenuItem("Deutsch");
        jMenu.add(this.langDE);
        this.langEN = this.labelStore.newMenuItem("Englisch");
        jMenu.add(this.langEN);
        this.langFR = this.labelStore.newMenuItem("Franzoesisch");
        jMenu.add(this.langFR);
        this.langES = this.labelStore.newMenuItem("Spanisch");
        jMenu.add(this.langES);
        this.langDE.addActionListener(this);
        this.langES.addActionListener(this);
        this.langEN.addActionListener(this);
        this.langFR.addActionListener(this);
        return jMenu;
    }

    public JMenu helpMenu(LabelStore labelStore, String string) {
        JMenu jMenu;
        this.labelStore = labelStore;
        if (labelStore != null) {
            jMenu = this.labelStore.newMenu("Hilfe");
            this.help = this.labelStore.newMenuItem("Hilfe");
        } else {
            jMenu = new JMenu("Hilfe");
            this.help = new JMenuItem("Hilfe");
        }
        jMenu.add(this.help);
        this.help.addActionListener(this);
        this.topic = string;
        return jMenu;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.lafs.length;
        while (--n >= 0) {
            if (actionEvent.getSource() != this.lafs[n]) continue;
            this.selectLookAndFeel(n);
            return;
        }
        if (actionEvent.getSource() == this.help) {
            if (this.jf == null) {
                this.view(this.topic + ".html");
            } else {
                this.jf.toFront();
            }
            return;
        }
        if (this.langDE == null) {
            return;
        }
        if (actionEvent.getSource() == this.langDE) {
            myLocale.changeLocale("de");
        } else if (actionEvent.getSource() == this.langEN) {
            myLocale.changeLocale("en");
        } else if (actionEvent.getSource() == this.langES) {
            myLocale.changeLocale("es");
        } else if (actionEvent.getSource() == this.langFR) {
            myLocale.changeLocale("fr");
        } else {
            return;
        }
        this.labelStore.changeTexts();
    }

    public void view(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        jEditorPane.setEditorKit(hTMLEditorKit);
        StyleSheet styleSheet = hTMLEditorKit.getStyleSheet();
        styleSheet.addRule("body {color:#000; font-family:times; margin: 4px;}");
        styleSheet.addRule("h2 {color: #ff0000; background-color:#ffffff; font-size: 12px;}");
        styleSheet.addRule("h3 {color: #000000; background-color:#ffffff;}");
        String string2 = this.getText(string);
        Document document = hTMLEditorKit.createDefaultDocument();
        jEditorPane.setDocument(document);
        jEditorPane.setText(string2);
        jEditorPane.setCaretPosition(0);
        this.jf = new JFrame("");
        this.jf.getContentPane().add((Component)jScrollPane, "Center");
        this.jf.setSize(new Dimension(600, 600));
        this.jf.setLocationRelativeTo(null);
        this.jf.setVisible(true);
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                DontExitFrame.this.jf.dispose();
                DontExitFrame.this.jf = null;
            }
        };
        this.jf.addWindowListener(windowAdapter);
    }

    public String getText(String string) {
        String string2 = "." + myLocale.getMyLanguage();
        boolean bl = false;
        Object object = "";
        try {
            String string3;
            InputStream inputStream = this.getClass().getResourceAsStream("/" + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            while ((string3 = bufferedReader.readLine()) != null) {
                if (!string3.equals(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return object;
            }
            int n = 0;
            int n2 = 0;
            while ((string3 = bufferedReader.readLine()) != null && (string3.length() <= 0 || string3.charAt(0) != '.')) {
                object = (String)object + string3 + "\n";
                if (string3.length() > n2) {
                    n2 = string3.length();
                }
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public static int getAcc(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '~') continue;
            c = Character.toLowerCase(string.charAt(i + 1));
            switch (c) {
                case 'a': {
                    return 65;
                }
                case 'b': {
                    return 66;
                }
                case 'c': {
                    return 67;
                }
                case 'd': {
                    return 68;
                }
                case 'e': {
                    return 69;
                }
                case 'f': {
                    return 70;
                }
                case 'g': {
                    return 71;
                }
                case 'h': {
                    return 72;
                }
                case 'i': {
                    return 73;
                }
                case 'j': {
                    return 74;
                }
                case 'k': {
                    return 75;
                }
                case 'l': {
                    return 76;
                }
                case 'm': {
                    return 77;
                }
                case 'n': {
                    return 78;
                }
                case 'o': {
                    return 79;
                }
                case 'p': {
                    return 80;
                }
                case 'q': {
                    return 81;
                }
                case 'r': {
                    return 82;
                }
                case 's': {
                    return 83;
                }
                case 't': {
                    return 84;
                }
                case 'u': {
                    return 85;
                }
                case 'v': {
                    return 86;
                }
                case 'w': {
                    return 87;
                }
                case 'x': {
                    return 88;
                }
                case 'y': {
                    return 89;
                }
                case 'z': {
                    return 90;
                }
            }
        }
        return 0;
    }

    public static String rmTilde(String string) {
        Object object = "";
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '~') continue;
            object = (String)object + c;
        }
        return object;
    }
}

