/*
 * Decompiled with CFR 0.152.
 */
public class Delaunay {
    int nPunkte;
    static double[] x = null;
    static double[] y = null;
    RingElem[] adjaclist;
    final int MAXP = 128;
    int panz = 0;
    RingElem[] pool = new RingElem[128];
    double WMAX = 8.0;
    static double eps = 1.0E-9;
    static double _eps = -eps;
    static double eps2 = eps * eps;
    static double nvx;
    static double nvy;
    static double nvl;
    static int lasta;
    static int lastb;

    RingElem getFromPool() {
        if (this.panz == 0) {
            return new RingElem();
        }
        return this.pool[--this.panz];
    }

    void release(RingElem ringElem) {
        if (this.panz < 128) {
            this.pool[this.panz++] = ringElem;
        }
    }

    static double angle1(double d, double d2) {
        if (d2 > d) {
            if (d2 > -d) {
                return -1.0 - d / d2;
            }
            return 1.0 + d2 / d;
        }
        if (d2 < -d) {
            return 3.0 - d / d2;
        }
        return d2 / d - 3.0;
    }

    static boolean inArea(double d, double d2, double[] dArray, double[] dArray2, int n) {
        boolean bl = false;
        int n2 = 0;
        int n3 = n - 1;
        while (n2 < n) {
            if (dArray2[n2] > d2 != dArray2[n3] > d2 && d < (dArray[n3] - dArray[n2]) * (d2 - dArray2[n2]) / (dArray2[n3] - dArray2[n2]) + dArray[n2]) {
                bl = !bl;
            }
            n3 = n2++;
        }
        return bl;
    }

    final double vlen(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    final double vlen2(double d, double d2) {
        return d * d + d2 * d2;
    }

    final int first(int n) {
        return this.adjaclist[n].i;
    }

    final int pred(int n, int n2) {
        RingElem ringElem = this.adjaclist[n];
        while (ringElem.i != n2) {
            ringElem = ringElem.prev;
        }
        return ringElem.prev.i;
    }

    final int succ(int n, int n2) {
        RingElem ringElem = this.adjaclist[n];
        while (ringElem.i != n2) {
            ringElem = ringElem.next;
        }
        return ringElem.next.i;
    }

    void removeFromList(int n, int n2) {
        RingElem ringElem = this.adjaclist[n];
        if (ringElem != null) {
            RingElem ringElem2 = ringElem;
            while (ringElem.i != n2) {
                ringElem = ringElem.next;
                if (ringElem != ringElem2) continue;
                return;
            }
            if (this.adjaclist[n] == ringElem) {
                this.adjaclist[n] = ringElem == ringElem.next ? null : ringElem.prev;
            }
            ringElem.next.prev = ringElem.prev;
            ringElem.prev.next = ringElem.next;
            this.release(ringElem);
        }
    }

    boolean intoList(int n, int n2) {
        RingElem ringElem = this.adjaclist[n];
        if (ringElem != null) {
            RingElem ringElem2 = ringElem;
            double d = Delaunay.angle1(x[ringElem.i] - x[n], y[ringElem.i] - y[n]);
            double d2 = Delaunay.angle1(x[n2] - x[n], y[n2] - y[n]) - d;
            if (d2 < 0.0) {
                d2 += this.WMAX;
            }
            do {
                if (ringElem.i != n2) continue;
                return false;
            } while ((ringElem = ringElem.next) != ringElem2);
            double d3 = 0.0;
            while (d3 < d2 && (ringElem = ringElem.next) != ringElem2) {
                d3 = Delaunay.angle1(x[ringElem.i] - x[n], y[ringElem.i] - y[n]) - d;
                if (!(d3 < 0.0)) continue;
                d3 += this.WMAX;
            }
            RingElem ringElem3 = this.getFromPool();
            ringElem3.i = n2;
            ringElem3.next = ringElem;
            ringElem3.prev = ringElem.prev;
            ringElem.prev = ringElem3;
            ringElem3.prev.next = ringElem3;
        } else {
            RingElem ringElem4 = this.getFromPool();
            ringElem4.i = n2;
            ringElem4.prev = ringElem4;
            ringElem4.next = ringElem4;
            this.adjaclist[n] = ringElem4;
        }
        return true;
    }

    final boolean insert(int n, int n2) {
        return this.intoList(n2, n) && this.intoList(n, n2);
    }

    final void delete(int n, int n2) {
        this.removeFromList(n, n2);
        this.removeFromList(n2, n);
    }

    int triaBinFind(Dreieck[] dreieckArray, int n, int n2, int n3, int n4) {
        int n5 = n - 1;
        int n6 = 0;
        while (n5 >= n6) {
            int n7 = n5 + n6 >> 1;
            Dreieck dreieck = dreieckArray[n7];
            if (n2 < dreieck.a) {
                n5 = n7 - 1;
                continue;
            }
            if (n2 > dreieck.a) {
                n6 = n7 + 1;
                continue;
            }
            if (n3 < dreieck.b) {
                n5 = n7 - 1;
                continue;
            }
            if (n3 > dreieck.b) {
                n6 = n7 + 1;
                continue;
            }
            if (n4 < dreieck.c) {
                n5 = n7 - 1;
                continue;
            }
            if (n4 > dreieck.c) {
                n6 = n7 + 1;
                continue;
            }
            return -1;
        }
        return n6;
    }

    /*
     * Unable to fully structure code
     */
    int addTria(Dreieck[] var1_1, int[] var2_2, int var3_3, int var4_4, int var5_5, int var6_6) {
        block16: {
            var14_7 = new double[]{0.05, 0.95};
            if (var5_5 < var4_4 && var5_5 < var6_6) {
                var8_8 = var4_4;
                var4_4 = var5_5;
                var5_5 = var6_6;
                var6_6 = var8_8;
            } else if (var6_6 < var4_4 && var6_6 < var5_5) {
                var8_8 = var4_4;
                var4_4 = var6_6;
                var6_6 = var5_5;
                var5_5 = var8_8;
            }
            var7_9 = this.triaBinFind(var1_1, var2_2[0], var4_4, var5_5, var6_6);
            if (var7_9 < 0) {
                return 0;
            }
            if (var4_4 >= var3_3) break block16;
            var15_10 = 1;
            if (var5_5 >= var3_3 || var6_6 >= var3_3) ** GOTO lbl-1000
            var16_11 = var5_5 < var6_6 ? var5_5 : var6_6;
            v0 = var17_13 = var5_5 < var6_6 ? var6_6 : var5_5;
            if (var16_11 == var4_4 + 1 && var17_13 == var4_4 + 2 || var16_11 == var4_4 + 1 && var17_13 == var3_3 - 1 || var16_11 == var3_3 - 2 && var17_13 == var3_3 - 1) {
                var10_14 = (Delaunay.x[var4_4] + Delaunay.x[var5_5] + Delaunay.x[var6_6]) * 0.33333333;
                var12_15 = (Delaunay.y[var4_4] + Delaunay.y[var5_5] + Delaunay.y[var6_6]) * 0.33333333;
                if (!Delaunay.inArea(var10_14, var12_15, Delaunay.x, Delaunay.y, var3_3)) {
                    return 0;
                }
            } else lbl-1000:
            // 2 sources

            {
                if (var6_6 >= var3_3 && var5_5 >= var3_3) {
                    for (var9_16 = 0; var15_10 != 0 && var9_16 < var14_7.length; ++var9_16) {
                        var16_12 = var14_7[var9_16];
                        var10_14 = var16_12 * Delaunay.x[var4_4] + (1.0 - var16_12) * Delaunay.x[var5_5];
                        var12_15 = var16_12 * Delaunay.y[var4_4] + (1.0 - var16_12) * Delaunay.y[var5_5];
                        var15_10 = (int)Delaunay.inArea(var10_14, var12_15, Delaunay.x, Delaunay.y, var3_3);
                    }
                } else {
                    var16_11 = var4_4 + 1 < var3_3 ? var4_4 + 1 : 0;
                    v1 = var17_13 = var4_4 != 0 ? var4_4 - 1 : var3_3 - 1;
                    if (var5_5 != var16_11 && var5_5 != var17_13) {
                        for (var9_16 = 0; var15_10 != 0 && var9_16 < var14_7.length; ++var9_16) {
                            var18_17 = var14_7[var9_16];
                            var10_14 = var18_17 * Delaunay.x[var4_4] + (1.0 - var18_17) * Delaunay.x[var5_5];
                            var12_15 = var18_17 * Delaunay.y[var4_4] + (1.0 - var18_17) * Delaunay.y[var5_5];
                            var15_10 = (int)Delaunay.inArea(var10_14, var12_15, Delaunay.x, Delaunay.y, var3_3);
                        }
                    }
                    if (var6_6 != var16_11 && var6_6 != var17_13) {
                        for (var9_16 = 0; var15_10 != 0 && var9_16 < var14_7.length; ++var9_16) {
                            var18_17 = var14_7[var9_16];
                            var10_14 = var18_17 * Delaunay.x[var4_4] + (1.0 - var18_17) * Delaunay.x[var6_6];
                            var12_15 = var18_17 * Delaunay.y[var4_4] + (1.0 - var18_17) * Delaunay.y[var6_6];
                            var15_10 = (int)Delaunay.inArea(var10_14, var12_15, Delaunay.x, Delaunay.y, var3_3);
                        }
                    }
                }
                if (var15_10 == 0) {
                    return 0;
                }
            }
        }
        for (var15_10 = var2_2[0]; var15_10 > var7_9; --var15_10) {
            var1_1[var15_10] = var1_1[var15_10 - 1];
        }
        var1_1[var7_9] = new Dreieck(var4_4, var5_5, var6_6);
        var2_2[0] = var2_2[0] + 1;
        return 1;
    }

    boolean isRechtsDreh(int n, int n2, int n3) {
        return (x[n2] - x[n]) * (y[n3] - y[n]) - (x[n3] - x[n]) * (y[n2] - y[n]) < 0.0;
    }

    void generateTriangles(int n, int n2, int[] nArray, Dreieck[] dreieckArray) {
        for (int i = 0; i < n; ++i) {
            int n3;
            int n4 = n3 = this.first(i);
            int n5 = this.succ(i, n4);
            do {
                if (i < n5 && i < n4 && this.isRechtsDreh(i, n5, n4)) {
                    this.addTria(dreieckArray, nArray, n2, i, n5, n4);
                }
                n4 = n5;
                n5 = this.succ(i, n4);
            } while (n4 != n3);
        }
    }

    boolean isLeftOf(int n, int n2, int n3) {
        if (n2 != lasta || n3 != lastb) {
            lasta = n2;
            lastb = n3;
            nvx = y[n3] - y[n2];
            nvy = x[n2] - x[n3];
            nvl = Math.sqrt(nvx * nvx + nvy * nvy);
        }
        return nvx * (x[n] - x[n2]) + nvy * (y[n] - y[n2]) < _eps * nvl;
    }

    boolean isRightOf(int n, int n2, int n3) {
        if (n2 != lasta || n3 != lastb) {
            lasta = n2;
            lastb = n3;
            nvx = y[n3] - y[n2];
            nvy = x[n2] - x[n3];
            nvl = Math.sqrt(nvx * nvx + nvy * nvy);
        }
        return nvx * (x[n] - x[n2]) + nvy * (y[n] - y[n2]) > eps * nvl;
    }

    boolean qtest(int n, int n2, int n3, int n4) {
        if (n2 == n4 || n == n4 || n3 == n4) {
            return true;
        }
        double d = x[n3] - x[n2];
        double d2 = y[n2] - y[n];
        double d3 = y[n2] - y[n3];
        double d4 = x[n] - x[n2];
        double d5 = d * d2 - d3 * d4;
        if (d5 < eps && d5 > _eps) {
            return false;
        }
        double d6 = 0.5 * (x[n2] + x[n]);
        double d7 = 0.5 * (x[n] - x[n3]);
        double d8 = 0.5 * (y[n2] + y[n]);
        double d9 = 0.5 * (y[n] - y[n3]);
        double d10 = (d9 * d3 - d7 * d) / d5;
        return this.vlen2((d6 += d2 * d10) - x[n4], (d8 += d4 * d10) - y[n4]) + eps > this.vlen2(d6 - x[n], d8 - y[n]);
    }

    boolean kolinear(int n, int n2, int n3, int n4) {
        double d = x[n] - x[n2];
        double d2 = y[n] - y[n2];
        double d3 = x[n3] - x[n4];
        double d4 = y[n3] - y[n4];
        double d5 = this.vlen(d, d2);
        double d6 = this.vlen(d3, d4);
        if (d5 > 0.0) {
            d /= d5;
            d2 /= d5;
        }
        if (d6 > 0.0) {
            d3 /= d6;
            d4 /= d6;
        }
        if (this.vlen2(d - d3, d2 - d4) > eps2) {
            return false;
        }
        d3 = x[n] - x[n4];
        d4 = y[n] - y[n4];
        d6 = this.vlen(d3, d4);
        if (d6 > 0.0) {
            d3 /= d6;
            d4 /= d6;
        }
        return this.vlen2(d - d3, d2 - d4) < eps2;
    }

    void merge(int n, int n2, int n3, int n4) {
        int n5 = n;
        int n6 = n2;
        while (n5 != n6 && (n5 != n3 || n6 != n4)) {
            int n7;
            boolean bl = false;
            boolean bl2 = false;
            if (!this.insert(n5, n6)) break;
            int n8 = this.pred(n6, n5);
            if (this.isLeftOf(n8, n5, n6)) {
                int n9 = this.pred(n6, n8);
                while (!this.qtest(n8, n5, n6, n9)) {
                    this.delete(n6, n8);
                    n8 = n9;
                    n9 = this.pred(n6, n8);
                }
            } else {
                bl = true;
            }
            if (this.isRightOf(n7 = this.succ(n5, n6), n6, n5)) {
                int n10 = this.succ(n5, n7);
                while (!this.qtest(n5, n6, n7, n10)) {
                    this.delete(n5, n7);
                    n7 = n10;
                    n10 = this.succ(n5, n7);
                }
            } else {
                bl2 = true;
            }
            if (bl) {
                n5 = n7;
                continue;
            }
            if (bl2) {
                n6 = n8;
                continue;
            }
            if (this.qtest(n5, n6, n8, n7)) {
                n6 = n8;
                continue;
            }
            n5 = n7;
        }
        this.insert(n3, n4);
    }

    void updateHull(int n) {
        RingElem ringElem;
        RingElem ringElem2 = null;
        RingElem ringElem3 = ringElem = this.adjaclist[n];
        double d = this.WMAX;
        do {
            double d2;
            if (!((d2 = Delaunay.angle1(x[ringElem3.i] - x[n], y[ringElem3.i] - y[n])) < d)) continue;
            d = d2;
            ringElem2 = ringElem3;
        } while ((ringElem3 = ringElem3.next) != ringElem);
        ringElem = ringElem2;
        this.adjaclist[n] = ringElem2;
        int n2 = ringElem.i;
        int n3 = n;
        do {
            ringElem3 = this.adjaclist[n2];
            while (ringElem3.i != n3) {
                ringElem3 = ringElem3.next;
            }
            this.adjaclist[n2] = ringElem3.next;
            n3 = n2;
        } while ((n2 = this.adjaclist[n2].i) != n);
    }

    void hull(int n, int n2, int[] nArray) {
        int n3;
        int n4 = n;
        int n5 = n2;
        int n6 = this.first(n5);
        int n7 = this.first(n4);
        int n8 = this.pred(n4, n7);
        while (true) {
            if (this.isRightOf(n6, n4, n5)) {
                n3 = this.succ(n6, n5);
                n5 = n6;
                n6 = n3;
                continue;
            }
            if (!this.isRightOf(n8, n4, n5)) break;
            n3 = this.pred(n8, n4);
            n4 = n8;
            n8 = n3;
        }
        nArray[0] = n4;
        nArray[1] = n5;
        n4 = n;
        n5 = n2;
        n7 = this.first(n5);
        n6 = this.pred(n5, n7);
        n8 = this.first(n4);
        while (true) {
            if (this.isLeftOf(n6, n4, n5)) {
                n3 = this.pred(n6, n5);
                n5 = n6;
                n6 = n3;
                continue;
            }
            if (!this.isLeftOf(n8, n4, n5)) break;
            n3 = this.succ(n8, n4);
            n4 = n8;
            n8 = n3;
        }
        nArray[2] = n4;
        nArray[3] = n5;
    }

    void DelaunayTriangulate(int n, int n2) {
        int[] nArray = new int[4];
        if (Math.abs(x[n2] - x[n]) < eps) {
            nArray[0] = n;
            while (nArray[0] < n2) {
                this.insert(nArray[0], nArray[0] + 1);
                nArray[0] = nArray[0] + 1;
            }
            return;
        }
        if (n2 - n > 2) {
            int n3 = n + (n2 - n) / 2;
            this.DelaunayTriangulate(n, n3);
            this.DelaunayTriangulate(n3 + 1, n2);
            this.hull(n3, n3 + 1, nArray);
            this.merge(nArray[0], nArray[1], nArray[2], nArray[3]);
            this.updateHull(n2);
        } else if (n2 - n == 2) {
            this.insert(n, n + 1);
            this.insert(n + 1, n2);
            if (!this.kolinear(n, n + 1, n, n2)) {
                this.insert(n, n2);
            }
            this.updateHull(n2);
        } else {
            this.insert(n, n2);
        }
    }

    void sortPoints(double[] dArray, double[] dArray2, int[] nArray, int n, int n2) {
        if (n < n2) {
            int n3 = n;
            int n4 = n2;
            int n5 = (n3 + n4) / 2;
            double d = dArray[n5];
            double d2 = dArray2[n5];
            while (true) {
                if (eps < d - dArray[n3] || Math.abs(dArray[n3] - d) < eps && dArray2[n3] < d2) {
                    ++n3;
                    continue;
                }
                while (_eps > d - dArray[n4] || Math.abs(dArray[n4] - d) < eps && dArray2[n4] > d2) {
                    --n4;
                }
                if (n3 > n4) break;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                double d3 = dArray[n3];
                dArray[n3] = dArray[n4];
                dArray[n4] = d3;
                d3 = dArray2[n3];
                dArray2[n3++] = dArray2[n4];
                dArray2[n4--] = d3;
                if (n3 > n4) break;
            }
            this.sortPoints(dArray, dArray2, nArray, n, n4);
            this.sortPoints(dArray, dArray2, nArray, n3, n2);
        }
    }

    void permute(double[] dArray, double[] dArray2, int[] nArray, int n) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            RingElem ringElem = this.adjaclist[n2];
            if (ringElem == null) continue;
            RingElem ringElem2 = ringElem;
            do {
                ringElem.i = nArray[ringElem.i];
            } while ((ringElem = ringElem.next) != ringElem2);
        }
        for (n2 = 0; n2 < n; ++n2) {
            while (nArray[n2] != n2) {
                int n3 = nArray[n2];
                double d = dArray[n2];
                dArray[n2] = dArray[n3];
                dArray[n3] = d;
                d = dArray2[n2];
                dArray2[n2] = dArray2[n3];
                dArray2[n3] = d;
                RingElem ringElem = this.adjaclist[n2];
                this.adjaclist[n2] = this.adjaclist[n3];
                this.adjaclist[n3] = ringElem;
                nArray[n2] = nArray[n3];
                nArray[n3] = n3;
            }
        }
    }

    int triangulate(double[] dArray, double[] dArray2, int n, int n2, Dreieck[] dreieckArray) {
        int n3;
        int[] nArray = new int[]{0};
        int[] nArray2 = new int[n];
        if (n < 3) {
            return 0;
        }
        x = dArray;
        y = dArray2;
        this.nPunkte = n;
        this.adjaclist = new RingElem[n];
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n3] = n3;
        }
        this.sortPoints(x, y, nArray2, 0, n - 1);
        this.DelaunayTriangulate(0, n - 1);
        if (n2 != 0) {
            this.permute(x, y, nArray2, n);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            RingElem ringElem;
            int n4 = n3 != 0 ? n3 - 1 : n2 - 1;
            boolean bl = false;
            RingElem ringElem2 = ringElem = this.adjaclist[n3];
            do {
                if (ringElem.i != n4) continue;
                bl = true;
                break;
            } while ((ringElem = ringElem.next) != ringElem2);
            if (bl) continue;
            this.insert(n3, n4);
            System.out.println("Randkante zu Fuss generiert");
        }
        this.generateTriangles(n, n2, nArray, dreieckArray);
        this.checkBadTriangles(n, n2, nArray[0], dreieckArray);
        return nArray[0];
    }

    void checkBadTriangles(int n, int n2, int n3, Dreieck[] dreieckArray) {
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (dreieckArray[i].a >= n2 || dreieckArray[i].b >= n2 || dreieckArray[i].c >= n2) continue;
            int n8 = dreieckArray[i].a;
            if (dreieckArray[i].c < dreieckArray[i].b) {
                n7 = dreieckArray[i].b;
                n6 = dreieckArray[i].c;
            } else {
                n6 = dreieckArray[i].b;
                n7 = dreieckArray[i].c;
            }
            if (n7 - n8 != 2 && (n8 != 0 || n7 != n2 - 1) || (n5 = this.findByNodes(n3, dreieckArray, i, n8, n6, n7)) <= 0) continue;
            int n9 = n4 = dreieckArray[n5].c > dreieckArray[n5].b ? dreieckArray[n5].c : dreieckArray[n5].b;
            if (n4 < n2) continue;
            if (n7 == dreieckArray[i].c) {
                dreieckArray[i].c = n4;
            } else {
                dreieckArray[i].b = n4;
            }
            dreieckArray[n5].a = n7 - n8 == 2 ? n6 : n8;
        }
    }

    int findByNodes(int n, Dreieck[] dreieckArray, int n2, int n3, int n4, int n5) {
        if (n5 - n3 != 2) {
            n3 = n4 < n5 ? n4 : (n5 = n4);
        }
        for (int i = 0; i < n; ++i) {
            if (i == n2 || dreieckArray[i].a != n3 || dreieckArray[i].b != n5 && dreieckArray[i].c != n5) continue;
            return i;
        }
        return -1;
    }

    class RingElem {
        RingElem next;
        RingElem prev;
        int i;

        RingElem() {
        }
    }
}

