/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

class BeamEigendynamicsSimulation
extends GrPanel
implements Runnable {
    Thread simuThread = null;
    boolean isRunning = false;
    static double t;
    static double dt;
    int enr = 1;
    int typ = 1;
    int errPos = nseg / 2;
    double C1;
    double C2;
    double C3;
    double C4;
    double lambda;
    double Omega;
    boolean isContinuum = true;
    static double beamLength;
    static double beamEI;
    double beamRho = 1.0;
    double beamA = 1.0;
    static int nseg;
    static double cmax;
    static double[] ew;
    static double[][] ev;
    static double[] currentForm;
    static double[] xcoord;
    static int nsp;
    static double[] xsp;
    static double[] ysp;
    int a = 6;
    int b = 8;
    int[] lines_fest = new int[]{0, 0, this.a, this.b, 0, 0, -this.a, this.b, this.a + 3, this.b, -this.a - 3, this.b, -this.a - 6, this.b + 3, -this.a - 3, this.b, -this.a - 3, this.b + 3, -this.a, this.b, -this.a, this.b + 3, -this.a + 3, this.b, -this.a + 3, this.b + 3, -this.a + 6, this.b, -this.a + 6, this.b + 3, -this.a + 9, this.b, -this.a + 9, this.b + 3, -this.a + 12, this.b, -this.a + 12, this.b + 3, -this.a + 15, this.b};
    int[] lines_einspan = new int[]{0, this.a, 0, -this.a, 0, this.a, -5, this.a - 5, 0, this.a - 3, -5, this.a - 8, 0, this.a - 6, -5, this.a - 11, 0, this.a - 9, -5, this.a - 14};
    Color bkground = new Color(111, 125, 137);

    BeamEigendynamicsSimulation(boolean bl) {
        this.beamCoordInit();
        this.getConstants();
        if (!bl) {
            this.setupForm(this.errPos, Math.PI * 2 * (double)this.enr);
        }
    }

    public void init() {
        if (!this.isRunning) {
            BeamEigendynamicsSimulation.initData();
            this.simuThread = new Thread(this);
            this.simuThread.start();
        }
    }

    static void initData() {
        t = 0.0;
        dt = 0.05;
    }

    void timer() {
        t += dt;
    }

    @Override
    public void run() {
        this.isRunning = true;
        while (this.isRunning) {
            try {
                this.timer();
                this.repaint();
                Thread.sleep((int)(dt * 1000.0));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stop() {
        t = 0.0;
        this.isRunning = false;
    }

    void setupTyp(int n) {
        if (n != this.typ) {
            t = 0.0;
        }
        if (n > 0) {
            this.typ = n;
        }
        if (this.isContinuum) {
            this.getConstants();
        } else {
            this.setupForm(this.errPos, Math.PI * 2 * (double)this.enr);
        }
        ((BeamEigendynamicsPanel)this.getParent()).eigenformNr.setText("" + this.enr);
    }

    void setupModell(int n, int n2) {
        if (n != this.typ) {
            t = 0.0;
        }
        if (n > 0) {
            this.typ = n;
        }
        this.enr = n2;
        if (this.enr < 1) {
            this.enr = 1;
        }
        if (this.isContinuum) {
            if (this.enr > 10) {
                this.enr = 10;
            }
            this.getConstants();
        } else {
            this.setupForm(this.errPos, Math.PI * 2 * (double)this.enr);
        }
        ((BeamEigendynamicsPanel)this.getParent()).eigenformNr.setText("" + this.enr);
    }

    void getConstants() {
        double[][] dArray = new double[3][3];
        double[] dArray2 = new double[3];
        int n = this.enr;
        if (this.typ == 1) {
            this.lambda = n == 1 ? 1.8751 : ((double)n - 0.5) * Math.PI;
            dArray[0][1] = 1.0;
            dArray[1][0] = 1.0;
            dArray[1][2] = 1.0;
            dArray[2][0] = Math.sinh(this.lambda);
            dArray[2][1] = Math.cosh(this.lambda);
            dArray[2][2] = -Math.sin(this.lambda);
            dArray2[0] = -1.0;
            dArray2[2] = Math.cos(this.lambda);
        } else if (this.typ == 3) {
            this.lambda = n == 1 ? 4.73 : ((double)n + 0.5) * Math.PI;
            dArray[0][1] = 1.0;
            dArray[1][0] = 1.0;
            dArray[1][2] = 1.0;
            dArray[2][0] = Math.sinh(this.lambda);
            dArray[2][1] = Math.cosh(this.lambda);
            dArray[2][2] = Math.sin(this.lambda);
            dArray2[0] = -1.0;
            dArray2[2] = -Math.cos(this.lambda);
        } else if (this.typ == 4) {
            this.lambda = n == 1 ? 4.73 : ((double)n + 0.5) * Math.PI;
            dArray[0][1] = 1.0;
            dArray[1][0] = 1.0;
            dArray[1][2] = -1.0;
            dArray[2][0] = Math.sinh(this.lambda);
            dArray[2][1] = Math.cosh(this.lambda);
            dArray[2][2] = -Math.sin(this.lambda);
            dArray2[0] = 1.0;
            dArray2[2] = Math.cos(this.lambda);
        } else if (this.typ == 5) {
            this.lambda = n == 1 ? 3.972 : ((double)n + 0.25) * Math.PI;
            dArray[0][1] = 1.0;
            dArray[1][0] = 1.0;
            dArray[1][2] = 1.0;
            dArray[2][0] = Math.sinh(this.lambda);
            dArray[2][1] = Math.cosh(this.lambda);
            dArray[2][2] = Math.sin(this.lambda);
            dArray2[0] = -1.0;
            dArray2[2] = -Math.cos(this.lambda);
        } else if (this.typ == 6) {
            this.lambda = n == 1 ? 3.972 : ((double)n + 0.25) * Math.PI;
            dArray[0][1] = 1.0;
            dArray[1][0] = 1.0;
            dArray[1][2] = -1.0;
            dArray[2][0] = Math.sinh(this.lambda);
            dArray[2][1] = Math.cosh(this.lambda);
            dArray[2][2] = Math.sin(this.lambda);
            dArray2[0] = 1.0;
            dArray2[2] = -Math.cos(this.lambda);
        } else {
            if (this.typ == 2) {
                this.lambda = (double)n * Math.PI;
                this.C4 = 0.0;
                this.C2 = 0.0;
                this.C1 = 0.0;
                this.C3 = 1.0;
                this.lambda /= beamLength;
                return;
            }
            return;
        }
        this.lambda /= beamLength;
        Gauss.solve(dArray, dArray2, 3);
        this.C1 = dArray2[0];
        this.C2 = dArray2[1];
        this.C3 = dArray2[2];
        this.C4 = 1.0;
    }

    void setupForm(int n, double d) {
        int n2;
        double d2 = d * d;
        int n3 = 0;
        this.einflusszahlen();
        double[] dArray = new double[ew.length];
        if (this.typ == 1 || this.typ == 2 || this.typ == 5 || this.typ == 3) {
            --n;
        }
        for (n2 = 0; n2 < ew.length; ++n2) {
            dArray[n2] = ev[n][n2] / (ew[n2] - d2) * 400.0;
        }
        for (n2 = 0; n2 < currentForm.length; ++n2) {
            BeamEigendynamicsSimulation.currentForm[n2] = 0.0;
        }
        int n4 = 0;
        int n5 = nseg;
        switch (this.typ) {
            case 1: {
                n4 = 1;
                break;
            }
            case 2: {
                n4 = 1;
                --n5;
                break;
            }
            case 3: {
                n4 = 1;
                --n5;
                break;
            }
            case 5: {
                n4 = 1;
                --n5;
                break;
            }
            case 4: {
                ++n5;
            }
        }
        for (n2 = 0; n2 < n5; ++n2) {
            for (int i = 0; i < dArray.length; ++i) {
                int n6 = n2 + n4;
                currentForm[n6] = currentForm[n6] + dArray[i] * ev[n2][i];
            }
        }
        if (BeamEigendynamicsPanel.fixedFaktor) {
            cmax = 1.0;
        } else {
            cmax = VectorSet.vsAbsMax(currentForm);
            cmax = 1.0 / (cmax * 5.0);
        }
        n2 = 0;
        while (n2 < currentForm.length) {
            int n7 = n2++;
            currentForm[n7] = currentForm[n7] * cmax;
        }
        if (this.typ == 1) {
            n3 = 1;
        }
        if (this.typ == 5) {
            n3 = 1;
        }
        if (this.typ == 3) {
            n3 = 3;
        }
        Splines.spline(xcoord, currentForm, xcoord.length, xsp, ysp, nsp, n3);
    }

    void drawForm() {
        int n;
        double d = 0.005;
        double d2 = Math.cos(1.5 * t);
        this.myg.setColor(Color.white);
        this.wMoveTo(xsp[0], d2 * ysp[0]);
        for (n = 1; n < xsp.length; ++n) {
            this.wLineTo(xsp[n], d2 * ysp[n]);
        }
        this.wMoveTo(xcoord[0], d2 * currentForm[0]);
        this.fillCircle(xcoord[0], d2 * currentForm[0], d);
        for (n = 1; n < xcoord.length; ++n) {
            double d3 = d2 * currentForm[n];
            this.wMoveTo(xcoord[n], d3);
            this.fillCircle(xcoord[n], d3, d);
            if (n != this.errPos) continue;
            this.myg.setColor(Color.red);
            this.arrow(xcoord[n], d3, 0.0, 0.1 * d2);
            this.myg.setColor(Color.white);
        }
    }

    void beamCoordInit() {
        double d = 1.0 / (double)nseg;
        for (int i = 0; i < xcoord.length; ++i) {
            BeamEigendynamicsSimulation.xcoord[i] = (double)i * d;
        }
    }

    void einflusszahlen() {
        double d;
        int n;
        int n2;
        double d2 = beamEI;
        double d3 = beamLength;
        double d4 = beamLength * this.beamA * this.beamRho;
        double d5 = d4 / (double)nseg;
        double d6 = 0.1;
        if (this.typ == 1 || this.typ == 6) {
            n2 = nseg;
        } else if (this.typ == 4) {
            n2 = nseg + 1;
        } else if (this.typ == 2 || this.typ == 5 || this.typ == 3) {
            n2 = nseg - 1;
        } else {
            return;
        }
        double[][] dArray = new double[n2][n2];
        double[][] dArray2 = new double[n2][n2];
        ew = new double[n2];
        ev = new double[n2][n2];
        this.beamCoordInit();
        if (this.typ == 1) {
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = n == n2 - 1 ? 0.5 * d5 : d5;
                var15_11 = xcoord[n + 1] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10 + 1] * d3;
                    dArray[n][var2_10] = (var17_12 * Math.pow(var15_11, 2.0) / 2.0 - Math.pow(var15_11, 3.0) / 6.0) / d2;
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
            }
        } else if (this.typ == 2) {
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = d5;
                var15_11 = xcoord[n + 1] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10 + 1] * d3;
                    dArray[n][var2_10] = var17_12 * Math.pow(d3 - var17_12, 2.0) / (6.0 * d2) * ((1.0 + d3 / (d3 - var17_12)) * var15_11 / d3 - Math.pow(var15_11, 3.0) / var17_12 / (d3 - var17_12) / d3);
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
            }
        } else if (this.typ == 3) {
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = d5;
                var15_11 = xcoord[n + 1] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10 + 1] * d3;
                    dArray[n][var2_10] = d3 * Math.pow(d3 - var17_12, 2.0) / (6.0 * d2) * (3.0 * var17_12 / d3 * Math.pow(var15_11 / d3, 2.0) - (1.0 + 2.0 * var17_12 / d3) * Math.pow(var15_11 / d3, 3.0));
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
            }
        } else if (this.typ == 4) {
            var21_13 = d6;
            d = d6;
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = n == 0 || n == n2 - 1 ? 0.5 * d5 : d5;
                var15_11 = xcoord[n] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10] * d3;
                    dArray[n][var2_10] = var2_10 == 0 || var2_10 == n2 - 1 || n == 0 || n == n2 - 1 ? 0.0 : var17_12 * Math.pow(d3 - var17_12, 2.0) / (6.0 * d2) * ((1.0 + d3 / (d3 - var17_12)) * var15_11 / d3 - Math.pow(var15_11, 3.0) / var17_12 / (d3 - var17_12) / d3);
                    double[] dArray3 = dArray[n];
                    int n3 = var2_10;
                    dArray3[n3] = dArray3[n3] + ((d3 - var17_12) / (var21_13 * d3) + var15_11 / d3 * (var17_12 / (d * d3) - (d3 - var17_12) / (var21_13 * d3)));
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
            }
        } else if (this.typ == 5) {
            var21_13 = Math.pow(d3, 3.0) / (3.0 * d2);
            double[] dArray4 = new double[n2];
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = d5;
                var15_11 = xcoord[n + 1] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10 + 1] * d3;
                    dArray[n][var2_10] = (var17_12 * Math.pow(var15_11, 2.0) / 2.0 - Math.pow(var15_11, 3.0) / 6.0) / d2;
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
                dArray4[n] = (d3 * Math.pow(var15_11, 2.0) / 2.0 - Math.pow(var15_11, 3.0) / 6.0) / d2;
            }
            for (n = 0; n < n2; ++n) {
                for (var2_10 = 0; var2_10 < n2; ++var2_10) {
                    double[] dArray5 = dArray[n];
                    int n4 = var2_10;
                    dArray5[n4] = dArray5[n4] - dArray4[n] * dArray4[var2_10] / var21_13;
                }
            }
        } else if (this.typ == 6) {
            for (n = 0; n < n2; ++n) {
                dArray2[n][n] = n == 0 ? 0.5 * d5 : d5;
                var15_11 = xcoord[n] * d3;
                for (var2_10 = n; var2_10 < n2; ++var2_10) {
                    var17_12 = xcoord[var2_10] * d3;
                    dArray[n][var2_10] = var2_10 == 0 || n == 0 ? 0.0 : var17_12 * Math.pow(d3 - var17_12, 2.0) / (6.0 * d2) * ((1.0 + d3 / (d3 - var17_12)) * var15_11 / d3 - Math.pow(var15_11, 3.0) / (var17_12 * (d3 - var17_12) * d3));
                    double[] dArray6 = dArray[n];
                    int n5 = var2_10;
                    dArray6[n5] = dArray6[n5] + (d3 - var17_12) / (d3 * d6) * (d3 - var15_11);
                    dArray[var2_10][n] = dArray[n][var2_10];
                }
            }
        }
        int n6 = Gauss.invert(dArray, n2);
        if (this.typ == 6) {
            double[] dArray7 = dArray[0];
            dArray7[0] = dArray7[0] - d6;
        }
        if (this.typ == 4) {
            double[] dArray8 = dArray[0];
            dArray8[0] = dArray8[0] - d6;
            double[] dArray9 = dArray[n2 - 1];
            int n7 = n2 - 1;
            dArray9[n7] = dArray9[n7] - d6;
        }
        if (n6 == 0) {
            n6 = Jacobi.allgEWP(dArray, dArray2, ew, ev);
        }
        String string = myLocale.getString("Eigenfrequenzen") + ": ";
        for (n = 0; n < 10; ++n) {
            int n8 = ew.length - 1 - n;
            if (this.typ == 6) {
                --n8;
            }
            if (this.typ == 4) {
                n8 -= 2;
            }
            if (n8 < 0) break;
            d = Math.sqrt(ew[n8]) / (Math.PI * 2);
            string = string + "f" + (n + 1) + "=" + NumEdit.toPrecision(d, 3) + "  ";
        }
        this.statusMsg(string);
    }

    static double[][] pseudoInverse(double[][] dArray) {
        int n;
        double[][] dArray2;
        boolean bl = false;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        double[][] dArray3 = VectorSet.transpose(dArray);
        if (n2 < n3) {
            dArray2 = VectorSet.mamu(dArray, dArray3);
            bl = true;
        } else {
            dArray2 = VectorSet.mamu(dArray3, dArray);
            n2 = n3;
        }
        double d = 1.0E12;
        for (n = 0; n < n2; ++n) {
            if (dArray2[n][n] == 0.0 || !(d > dArray2[n][n])) continue;
            d = dArray2[n][n];
        }
        if (d == 0.0) {
            return new double[dArray[0].length][dArray.length];
        }
        d *= 1.0E-12;
        double[][] dArray4 = new double[n2][n2];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            double d2;
            for (n = i; n < n2; ++n) {
                d2 = 0.0;
                for (int j = 0; j < n4; ++j) {
                    d2 += dArray4[n][j] * dArray4[i][j];
                }
                dArray4[n][n4] = dArray2[n][i] - d2;
            }
            if (!(dArray4[i][n4] > d)) continue;
            double d3 = Math.sqrt(dArray4[i][n4]);
            dArray4[i][n4] = d3;
            d2 = d3;
            for (n = i + 1; n < n2; ++n) {
                double[] dArray5 = dArray4[n];
                int n5 = n4;
                dArray5[n5] = dArray5[n5] / d2;
            }
            ++n4;
        }
        double[][] dArray6 = VectorSet.transpose(dArray4);
        double[][] dArray7 = VectorSet.mamu(dArray6, dArray4);
        Gauss.invert(dArray7, dArray7.length);
        dArray7 = VectorSet.mamu(dArray7, dArray7);
        dArray7 = VectorSet.mamu(dArray4, dArray7);
        dArray7 = VectorSet.mamu(dArray7, dArray6);
        return bl ? VectorSet.mamu(dArray3, dArray7) : VectorSet.mamu(dArray7, dArray3);
    }

    void statusMsg(String string) {
        if (BeamEigendynamicsPanel.dm != null) {
            BeamEigendynamicsPanel.dm.statusMsg(string);
        }
    }

    double form(double d) {
        double d2 = d * this.lambda;
        return this.C1 * Math.sinh(d2) + this.C2 * Math.cosh(d2) + this.C3 * Math.sin(d2) + this.C4 * Math.cos(d2);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = 80;
        double d = 1.0;
        double d2 = d / (double)n;
        this.myg = graphics;
        if (this.isContinuum) {
            this.setMinMax(0.0, -5.0, d, 5.0, 1);
        } else {
            this.setMinMax(0.0, -0.5, d, 0.5, 1);
        }
        this.myg.setColor(this.bkground);
        this.myg.fillRect(0, 0, this.getSize().width, this.getSize().height);
        this.myg.setColor(new Color(66, 66, 66));
        this.wMoveTo(0.0, 0.0);
        this.wLineTo(d, 0.0);
        this.myg.setColor(Color.white);
        if (this.typ == 1 || this.typ == 5 || this.typ == 3) {
            this.drawLines(this.lines_einspan, this.screenx(0.0), this.screeny(0.0), 0.0);
        } else if (this.typ == 2) {
            this.drawLines(this.lines_fest, this.screenx(0.0), this.screeny(0.0), 0.0);
        }
        if (this.typ == 2 || this.typ == 5 || this.typ == 6) {
            this.drawLines(this.lines_fest, this.screenx(d), this.screeny(0.0), 0.0);
        } else if (this.typ == 3) {
            this.drawLines(this.lines_einspan, this.screenx(d), this.screeny(0.0), Math.PI);
        }
        ((Graphics2D)this.myg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.isContinuum) {
            this.Omega = this.lambda * this.lambda * Math.sqrt(beamEI / (this.beamRho * this.beamA));
            double d3 = Math.cos(1.5 * t);
            double d4 = 0.0;
            this.wMoveTo(d4, d3 * this.form(0.0));
            for (int i = 0; i < n; ++i) {
                this.wLineTo(d4 += d2, d3 * this.form(d4 * beamLength));
            }
            this.myg.drawString("f=" + NumEdit.toFixed(this.Omega * 0.5 / Math.PI, 2) + " Hz", 100, 100);
        } else {
            this.drawForm();
            this.myg.drawString(myLocale.getString("Skalierungsfaktor") + ": " + NumEdit.toPrecision(cmax, 3), 100, 100);
        }
    }

    static {
        beamLength = 1.0;
        beamEI = 100.0;
        nseg = 24;
        cmax = 0.0;
        ew = null;
        currentForm = new double[nseg + 1];
        xcoord = new double[nseg + 1];
        nsp = 3 * nseg;
        xsp = new double[nsp];
        ysp = new double[nsp];
    }
}

