/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.OceanTheme;

public class Applications
extends JPanel
implements ItemListener,
ActionListener,
KeyListener {
    String[] looks = new String[]{"System look", "Metal Ocean look", "Metal Steel look", "Nimbus look", "Motif look", "Windows Classic look", "GTK look"};
    String[] locations = new String[]{null, "javax.swing.plaf.metal.MetalLookAndFeel", "javax.swing.plaf.metal.MetalLookAndFeel", "javax.swing.plaf.nimbus.NimbusLookAndFeel", "com.sun.java.swing.plaf.motif.MotifLookAndFeel", "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel"};
    JComboBox<String> combobox = new JComboBox();
    JRadioButton[] buttons = new JRadioButton[this.looks.length];
    JTextField msgField = new JTextField();
    static boolean started = false;
    static JFrame mainFrame = null;
    static boolean noLafChange = false;
    int currLaf = 3;
    String mark = "x";
    String[][] classes = new String[][]{{"BeamEigendynamics", this.mark}, {"CenterOfRotation", null}, {"Forces", null}, {"Fplot", null}, {"InternalForces", this.mark}, {"KinematicCurves", this.mark}, {"Laplace", this.mark}, {"LavalRotor", null}, {"LinearSolver", this.mark}, {"MatrixEigenValue", this.mark}, {"PlaneBeamFEM", this.mark}, {"PlaneBeamVibFEM", this.mark}, {"PlaneStressFEM", this.mark}, {"PlateVibration", this.mark}, {"RigidBodies", this.mark}, {"SpringMass", this.mark}, {"Trajectory", null}, {"Tribok", null}, {"Truss3d", this.mark}};
    boolean doNothing = false;

    public void changeLookAndFeel(boolean bl) {
        if (noLafChange) {
            return;
        }
        int n = this.looks.length;
        while (--n >= 0) {
            if (!this.buttons[n].isSelected()) continue;
            this.setLookAndFeel(n);
            break;
        }
        if (bl) {
            this.updateWindows();
        }
    }

    public void setLookAndFeel(int n) {
        this.currLaf = n;
        try {
            String string = this.locations[n];
            if (string == null) {
                string = UIManager.getSystemLookAndFeelClassName();
            }
            if (n == 2) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            if (n == 1) {
                MetalLookAndFeel.setCurrentTheme(new OceanTheme());
            }
            UIManager.setLookAndFeel(string);
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            this.errorMsg("" + unsupportedLookAndFeelException);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.errorMsg("" + classNotFoundException);
        }
    }

    public String getOsName() {
        return System.getProperty("os.name");
    }

    public boolean isWindows() {
        return this.getOsName().toLowerCase().contains("windows");
    }

    public boolean isMac() {
        return this.getOsName().toLowerCase().startsWith("mac");
    }

    public void init() {
        int n;
        JPanel jPanel = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        started = true;
        this.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createRaisedBevelBorder());
        JLabel jLabel = new JLabel(myLocale.getString("Application") + ":");
        jLabel.setFont(new Font("Dialog", 0, 12));
        jPanel2.add(jLabel);
        jPanel2.add(this.combobox);
        jPanel2.setBackground(new Color(190, 190, 210));
        this.add((Component)jPanel2, "North");
        this.add((Component)jPanel, "Center");
        this.add((Component)this.msgField, "South");
        jPanel.setLayout(new GridLayout(0, 1));
        for (n = 0; n < this.looks.length; ++n) {
            this.buttons[n] = new JRadioButton(this.looks[n], n == this.currLaf);
            this.buttons[n].setFont(new Font("Dialog", 0, 12));
            if (n == 5 && !this.isWindows() || n == 6 && (this.isWindows() || this.isMac())) continue;
            jPanel.add(this.buttons[n]);
            buttonGroup.add(this.buttons[n]);
            this.buttons[n].addItemListener(this);
        }
        n = this.getLocale().getLanguage().equals("de") ? 1 : 0;
        this.combobox.addItem("");
        for (int i = 0; i < this.classes.length; ++i) {
            if (n == 0 && this.classes[i][1] == null) continue;
            this.combobox.addItem(this.classes[i][0]);
        }
        this.combobox.addItemListener(this);
        this.combobox.setFont(new Font("Dialog", 0, 12));
        this.combobox.addActionListener(this);
        this.combobox.addKeyListener(this);
        this.msgField.setEditable(false);
    }

    public void errorMsg(String string) {
        if (string.length() > 0) {
            this.msgField.setForeground(GrPanel.newColor(255, 0, 0));
        }
        this.msgField.setText(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.errorMsg("");
        if (itemEvent.getSource() != this.combobox) {
            noLafChange = false;
            this.changeLookAndFeel(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this.combobox.getSelectedIndex();
        String string = this.combobox.getItemAt(n);
        if (this.doNothing || string.length() == 0) {
            return;
        }
        try {
            this.errorMsg("");
            this.changeLookAndFeel(false);
            String[] stringArray = new String[]{"" + (int)(100.0 + Math.random() * 100.0), "" + (int)(100.0 + Math.random() * 100.0)};
            Method method = Class.forName(string).getMethod("main", stringArray.getClass());
            method.invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            this.errorMsg("" + exception);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                this.doNothing = false;
                this.actionPerformed(null);
                break;
            }
            case 32: {
                this.combobox.showPopup();
                break;
            }
            default: {
                this.doNothing = true;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.doNothing = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void updateWindows() {
        Window[] windowArray = JFrame.getWindows();
        int n = windowArray.length;
        while (--n >= 0) {
            if (!windowArray[n].isShowing()) continue;
            SwingUtilities.updateComponentTreeUI(windowArray[n]);
        }
    }

    public static int openWindowsCnt(Window[] windowArray) {
        int n = 0;
        int n2 = windowArray.length;
        while (--n2 >= 0) {
            if (!windowArray[n2].isShowing()) continue;
            ++n;
        }
        return n;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        mainFrame = new JFrame();
        final Applications applications = new Applications();
        applications.init();
        mainFrame.setContentPane(applications);
        mainFrame.pack();
        mainFrame.setTitle("Applications");
        mainFrame.setSize(440, 350);
        mainFrame.setVisible(true);
        mainFrame.setDefaultCloseOperation(0);
        try {
            object = new ImageIcon(ClassLoader.getSystemClassLoader().getResource("favicon.gif"));
            mainFrame.setIconImage(((ImageIcon)object).getImage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Applications.openWindowsCnt(JFrame.getWindows()) > 1 && JOptionPane.showConfirmDialog(mainFrame, myLocale.getString("AlleFensterWerdenGeschlossen"), myLocale.getString("Wirklich"), 0, 3) != 0) {
                    return;
                }
                System.exit(0);
            }
        };
        mainFrame.addWindowListener((WindowListener)object);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = UIManager.getLookAndFeel().getClass().getName();
                noLafChange = !string.startsWith("javax");
                applications.changeLookAndFeel(true);
            }
        });
    }
}

